/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.ByteArray;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;

public class RegionInstance
extends FieldInstance {
    private static final long serialVersionUID = 1L;
    private BigInteger address;
    private BigInteger size;
    private boolean isAllocatable;
    private ByteArray byteArray;
    private transient InstancePath instancePath;

    protected RegionInstance(RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, BigInteger runtimeId, Scenario scenario) {
        super(rfField, rfFieldType, arraySize, arrayItemIndex, runtimeId, scenario);
    }

    public void initRegion(BigInteger address, BigInteger size, boolean isAllocatable) {
        this.address = address;
        this.size = size;
        this.isAllocatable = isAllocatable;
        this.byteArray = new ByteArray(size.intValueExact());
    }

    @Override
    public void setParentInstance(InstancesContainer parentInstance) {
        super.setParentInstance(parentInstance);
        this.instancePath = null;
    }

    public ByteArray getByteArray() {
        return this.byteArray;
    }

    public void setByteArray(ByteArray byteArray) {
        this.byteArray = byteArray;
    }

    public BigInteger getLowerAddress() {
        return this.address;
    }

    public BigInteger getUpperAddress() {
        return this.address.add(this.size).subtract(BigInteger.ONE);
    }

    public BigInteger getSize() {
        return this.size;
    }

    public boolean isAllocatable() {
        return this.isAllocatable;
    }

    @Override
    public ActionInstance getParentActionInstance() {
        return null;
    }

    @Override
    public InstancePath getInstancePath() {
        if (this.instancePath != null) {
            return this.instancePath;
        }
        ComponentInstance parentComponentInstance = this.getParentComponentInstance();
        this.instancePath = new InstancePath(parentComponentInstance == null ? null : parentComponentInstance.getInstancePath(), this.isArrayItem(), this);
        return this.instancePath;
    }

    @Override
    public InstancePath getHierarchicalPath() {
        return this.getInstancePath();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public Expression.Value getVariableValue() {
        return Expression.Value.from(this, this.address, BigInteger.ZERO, this.size, true);
    }

    public Expression.Value.HndlValue getRegionHandle(BigInteger offset) {
        return Expression.Value.from(this, this.address, offset, this.size, true);
    }

    public BigInteger nextOpaqueAddress() {
        return this.address.add(this.size);
    }

    public final void getFullAllocatableDomain(ComponentInstance.AllocatableRegions allocatableRegions, InstancesContainer claimInstance) {
        Solver solver = this.scenario.getSolver();
        int debugLevel = solver.CONFIG_DEBUG_LEVEL;
        try {
            solver.CONFIG_DEBUG_LEVEL = 0;
            FieldInstance claimTraitInstance = claimInstance.getFieldInstance("trait");
            FieldInstance regionTraitInstance = this.getFieldInstance("trait");
            if (claimTraitInstance.getRfFieldType() != regionTraitInstance.getRfFieldType()) {
                return;
            }
            LinkedHashMap<String, InstancesContainer.GeneratedVar> variableSolverMap = new LinkedHashMap<String, InstancesContainer.GeneratedVar>();
            Model model = new Model(() -> ((IProgressMonitor)solver.getMonitor()).isCanceled(), this.scenario.stringVariableMapping);
            IntVariable claimTrait = claimTraitInstance.getVariable(model, null, claimTraitInstance.getHierarchicalPath(), variableSolverMap, false);
            IntVariable regionTrait = regionTraitInstance.getVariable(model, null, regionTraitInstance.getHierarchicalPath(), variableSolverMap, false);
            claimTrait.eq(regionTrait).post();
            if (!model.getSolver().findFirst()) {
                return;
            }
            allocatableRegions.regionInstances.add(this);
            IntDomain regionDomain = new IntDomain(this.getLowerAddress(), this.getUpperAddress());
            for (IntDomain.IntSubDomain subDomain : allocatableRegions.allocatableDomain.getSubDomains()) {
                if (!(regionDomain = regionDomain.remove(subDomain.getLowerBound(), subDomain.getUpperBound())).isEmpty()) continue;
                return;
            }
            for (IntDomain.IntSubDomain subDomain : regionDomain.getSubDomains()) {
                allocatableRegions.allocatableDomain.addSubdomain(subDomain.getLowerBound(), subDomain.getUpperBound());
            }
            allocatableRegions.allocatableDomain.subDomainsSort();
            allocatableRegions.allocatableDomain.updateBounds();
        }
        finally {
            solver.CONFIG_DEBUG_LEVEL = debugLevel;
        }
    }

    public Expression.Value readBytes(int nofBytes, BigInteger address) {
        int indexOffset = address.subtract(this.address).intValueExact();
        byte[] dataBytes = new byte[nofBytes];
        int i = 0;
        while (i < nofBytes) {
            dataBytes[i] = this.byteArray.get(indexOffset + i);
            ++i;
        }
        return Expression.Value.from(new BigInteger(dataBytes), nofBytes * 8, false);
    }

    public void writeBytes(int nofBytes, BigInteger address, Expression.Value data) {
        int indexOffset = address.subtract(this.address).intValueExact();
        byte[] dataBytes = data.getIntValue().toByteArray();
        int padding = Math.max(0, nofBytes - dataBytes.length);
        int truncate = Math.max(0, dataBytes.length - nofBytes);
        int i = 0;
        while (i < nofBytes) {
            byte writeByte = i + truncate < dataBytes.length ? dataBytes[i + truncate] : (byte)0;
            this.byteArray.put(indexOffset + i + padding, writeByte);
            ++i;
        }
    }
}

