/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.csp.constraints.AbstractConstraint;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.solver.string.IStringMapping;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ActivityDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.BindDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ConstraintDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.NestedBlockContext;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.SchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.SolverProblem;
import ro.amiq.pssdt.model.reflection.elaboration.StringVariableMapping;
import ro.amiq.pssdt.model.reflection.elaboration.TypeInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.ByteArrayOutputStream;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.SolverConsole;
import ro.amiq.pssdt.model.reflection.elaboration.util.Stack;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public final class Scenario
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int solverRemainingOptions;
    protected int actionInstanceTraversalIndex;
    protected int uniqueTypeId;
    protected ISchedulingInstance rootAction;
    protected ComponentInstance rootComponent;
    protected List<ActionInstance> actionInstances = new ArrayList<ActionInstance>();
    protected List<InstancesContainer> restorableInstances = new ArrayList<InstancesContainer>();
    protected List<ActionInstance> schedulingInstances = new ArrayList<ActionInstance>();
    protected ISchedulerProxy scheduler = new SchedulerProxy(this);
    protected int inferenceCount;
    protected Stack<NestedBlockContext> contextStack = new Stack();
    protected Map<ActionInstance, List<ConstraintDescriptor>> inlineConstraintDescriptors = new IdentityHashMap<ActionInstance, List<ConstraintDescriptor>>();
    protected Stack<ActivityDescriptor> activityDescriptors = new Stack();
    protected Map<ActionInstance, List<BindDescriptor.PortBindDescriptor>> portBindDescriptors = new IdentityHashMap<ActionInstance, List<BindDescriptor.PortBindDescriptor>>();
    protected Stack<TraceElement> stackTrace = new Stack();
    protected Stack<RepeatId> repeatIdStack = new Stack();
    protected IStringMapping stringVariableMapping = new StringVariableMapping();
    protected Map<ActionInstance, Set<ActionInstance>> connectedActionInstances = new IdentityHashMap<ActionInstance, Set<ActionInstance>>();
    protected Map<ISchedulingInstance, List<InstancesContainer>> allocatedHandles = new IdentityHashMap<ISchedulingInstance, List<InstancesContainer>>();
    protected Map<ActionInstance, InstancesContainer> executorAssignments = new IdentityHashMap<ActionInstance, InstancesContainer>();
    protected transient Map<RfNamedElement, List<ConstraintDescriptor>> constraintDescriptors = new IdentityHashMap<RfNamedElement, List<ConstraintDescriptor>>();
    protected transient Map<RfNamedElement, Map<String, Expression>> dynamicConstraintDescriptors = new IdentityHashMap<RfNamedElement, Map<String, Expression>>();
    protected transient Map<RfStruct, List<ConstraintDescriptor.ExecStmtDescriptor>> execStmtDescriptors = new IdentityHashMap<RfStruct, List<ConstraintDescriptor.ExecStmtDescriptor>>();
    protected transient Map<RfStruct, List<BindDescriptor.PoolBindDescriptor>> poolBindDescriptors = new IdentityHashMap<RfStruct, List<BindDescriptor.PoolBindDescriptor>>();
    protected transient Solver solver;
    protected transient List<SolverProblem> problemsLogger;
    protected transient Stack<Set<RfField>> traversedActionHandlesStack = new Stack();
    protected transient Set<InstancesContainer> proceduralRandVariables;
    protected int repeatGlobalId = -1;
    protected BigInteger runtimeGlobalId = BigInteger.ONE;
    protected transient List<Expression.ExpressionError> solverExpressionsErrors;
    protected transient boolean isTargetExec;

    public Scenario(Solver solver) {
        this.solver = solver;
        this.actionInstanceTraversalIndex = 0;
    }

    public final void clean() {
        this.repeatGlobalId = -1;
        this.runtimeGlobalId = BigInteger.ONE;
        this.isTargetExec = false;
        this.actionInstanceTraversalIndex = 0;
        this.uniqueTypeId = 0;
        this.rootAction = null;
        this.rootComponent = null;
        this.actionInstances.clear();
        this.restorableInstances.clear();
        this.schedulingInstances.clear();
        this.scheduler = null;
        this.inferenceCount = 0;
        this.contextStack.clear();
        this.inlineConstraintDescriptors.clear();
        this.activityDescriptors.clear();
        this.constraintDescriptors.clear();
        this.dynamicConstraintDescriptors.clear();
        this.poolBindDescriptors.clear();
        this.portBindDescriptors.clear();
        this.repeatIdStack.clear();
        this.connectedActionInstances.clear();
        this.allocatedHandles.clear();
        this.executorAssignments.clear();
        this.execStmtDescriptors.clear();
        this.stackTrace.clear();
        this.solver = null;
        this.problemsLogger = null;
        this.traversedActionHandlesStack.clear();
        this.solverExpressionsErrors = null;
        this.proceduralRandVariables = null;
    }

    public final void lightClean() {
        this.repeatGlobalId = -1;
        this.runtimeGlobalId = BigInteger.ONE;
        this.uniqueTypeId = 0;
        this.contextStack.clear();
        this.inlineConstraintDescriptors.clear();
        this.activityDescriptors.clear();
        this.portBindDescriptors.clear();
        this.stackTrace.clear();
        this.repeatIdStack.clear();
        this.stringVariableMapping = null;
        this.connectedActionInstances.clear();
        this.constraintDescriptors.clear();
        this.dynamicConstraintDescriptors.clear();
        this.poolBindDescriptors.clear();
        this.problemsLogger = null;
        this.traversedActionHandlesStack.clear();
        this.solverExpressionsErrors = null;
        this.proceduralRandVariables = null;
    }

    public final void addActionInstance(ActionInstance actionInstance) {
        actionInstance.instanceIndex = this.actionInstances.size();
        this.actionInstances.add(actionInstance);
    }

    public final void removeActionInstance(ActionInstance actionInstance) {
        this.actionInstances.remove(actionInstance);
    }

    public final ActionInstance getActionInstance(int index) {
        return this.actionInstances.get(index);
    }

    public final void addSchedulingInstance(ActionInstance actionInstance) {
        actionInstance.instanceIndex = this.schedulingInstances.size();
        this.schedulingInstances.add(actionInstance);
    }

    public final void removeSchedulingInstance(ActionInstance actionInstance) {
        this.schedulingInstances.remove(actionInstance);
    }

    public final ActionInstance getSchedulingInstance(int index) {
        return this.schedulingInstances.get(index);
    }

    public final boolean isBefore(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject()) {
            return true;
        }
        if (a2.isInitialStateObject()) {
            return false;
        }
        return this.scheduler.isBefore(a1, a2);
    }

    public final boolean isParallel(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject() || a2.isInitialStateObject()) {
            return false;
        }
        return this.scheduler.isParallel(a1, a2);
    }

    public final boolean canScheduleBefore(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject()) {
            return true;
        }
        if (a2.isInitialStateObject()) {
            return false;
        }
        return this.scheduler.canScheduleBefore(a1, a2);
    }

    public final boolean canScheduleParallel(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject() || a2.isInitialStateObject()) {
            return false;
        }
        return this.scheduler.canScheduleParallel(a1, a2);
    }

    public final boolean canScheduleSequential(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject() || a2.isInitialStateObject()) {
            return true;
        }
        return this.scheduler.canScheduleSequential(a1, a2);
    }

    public final void scheduleBefore(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject() || a2.isInitialStateObject()) {
            return;
        }
        this.scheduler.scheduleBefore(a1, a2);
    }

    public final void scheduleParallel(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject() || a2.isInitialStateObject()) {
            return;
        }
        this.scheduler.scheduleParallel(a1, a2);
    }

    public final void scheduleSequential(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject() || a2.isInitialStateObject()) {
            return;
        }
        this.scheduler.scheduleSequential(a1, a2);
    }

    public final void scheduleSchedule(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject() || a2.isInitialStateObject()) {
            return;
        }
        this.scheduler.scheduleSchedule(a1, a2);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int key;
        out.defaultWriteObject();
        out.writeInt(this.poolBindDescriptors.size());
        for (Map.Entry<RfStruct, List<BindDescriptor.PoolBindDescriptor>> entry : this.poolBindDescriptors.entrySet()) {
            key = ScenarioUtils.getKeyOfRf(entry.getKey());
            out.writeInt(key);
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.execStmtDescriptors.size());
        for (Map.Entry<RfStruct, List<Serializable>> entry : this.execStmtDescriptors.entrySet()) {
            key = ScenarioUtils.getKeyOfRf(entry.getKey());
            out.writeInt(key);
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.constraintDescriptors.size());
        for (Map.Entry<RfNamedElement, List<Serializable>> entry : this.constraintDescriptors.entrySet()) {
            key = ScenarioUtils.getKeyOfRf(entry.getKey());
            out.writeInt(key);
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.dynamicConstraintDescriptors.size());
        for (Map.Entry<RfNamedElement, Object> entry : this.dynamicConstraintDescriptors.entrySet()) {
            key = ScenarioUtils.getKeyOfRf(entry.getKey());
            out.writeInt(key);
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.traversedActionHandlesStack.size());
        for (Set set : this.traversedActionHandlesStack) {
            out.writeInt(set.size());
            for (RfField uninitRfActionHandle : set) {
                int key2 = ScenarioUtils.getKeyOfRf(uninitRfActionHandle);
                out.writeInt(key2);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        RfNamedElement rfNamedElement;
        Object value;
        RfStruct rfStruct;
        int key;
        in.defaultReadObject();
        int size = in.readInt();
        this.poolBindDescriptors = new IdentityHashMap<RfStruct, List<BindDescriptor.PoolBindDescriptor>>(size);
        int i = 0;
        while (i < size) {
            key = in.readInt();
            rfStruct = (RfStruct)ScenarioUtils.getRfOfKey(key);
            value = (List)in.readObject();
            this.poolBindDescriptors.put(rfStruct, (List<BindDescriptor.PoolBindDescriptor>)value);
            ++i;
        }
        size = in.readInt();
        this.execStmtDescriptors = new IdentityHashMap<RfStruct, List<ConstraintDescriptor.ExecStmtDescriptor>>(size);
        i = 0;
        while (i < size) {
            key = in.readInt();
            rfStruct = (RfStruct)ScenarioUtils.getRfOfKey(key);
            value = (List)in.readObject();
            this.execStmtDescriptors.put(rfStruct, (List<ConstraintDescriptor.ExecStmtDescriptor>)value);
            ++i;
        }
        size = in.readInt();
        this.constraintDescriptors = new IdentityHashMap<RfNamedElement, List<ConstraintDescriptor>>(size);
        i = 0;
        while (i < size) {
            key = in.readInt();
            rfNamedElement = ScenarioUtils.getRfOfKey(key);
            value = (List)in.readObject();
            this.constraintDescriptors.put(rfNamedElement, (List<ConstraintDescriptor>)value);
            ++i;
        }
        size = in.readInt();
        this.dynamicConstraintDescriptors = new IdentityHashMap<RfNamedElement, Map<String, Expression>>(size);
        i = 0;
        while (i < size) {
            key = in.readInt();
            rfNamedElement = ScenarioUtils.getRfOfKey(key);
            value = (Map)in.readObject();
            this.dynamicConstraintDescriptors.put(rfNamedElement, (Map<String, Expression>)value);
            ++i;
        }
        size = in.readInt();
        this.traversedActionHandlesStack = new Stack();
        i = 0;
        while (i < size) {
            int size2 = in.readInt();
            HashSet<RfField> uninitRfActionHandles = new HashSet<RfField>();
            int j = 0;
            while (j < size2) {
                int key2 = in.readInt();
                RfField rfActionHandle = (RfField)ScenarioUtils.getRfOfKey(key2);
                uninitRfActionHandles.add(rfActionHandle);
                ++j;
            }
            this.traversedActionHandlesStack.push(uninitRfActionHandles);
            ++i;
        }
    }

    public final LightSnapshot saveState() {
        LightSnapshot snapshot = new LightSnapshot(this.actionInstances.size(), this.schedulingInstances.size());
        snapshot.actionInstancesState = new ArrayList<ActionInstance>(this.actionInstances);
        snapshot.schedulingInstancesState = new ArrayList<ActionInstance>(this.schedulingInstances);
        snapshot.scheduler = this.scheduler.copy();
        int i = 0;
        while (i < this.actionInstances.size()) {
            snapshot.setActionInstanceState(i, this.actionInstances.get(i));
            ++i;
        }
        i = 0;
        while (i < this.schedulingInstances.size()) {
            snapshot.setSchedulingInstanceState(i, this.schedulingInstances.get(i));
            ++i;
        }
        return snapshot;
    }

    public final void restoreState(LightSnapshot snapshot) {
        this.actionInstances = new ArrayList<ActionInstance>(snapshot.actionInstancesState);
        this.schedulingInstances = new ArrayList<ActionInstance>(snapshot.schedulingInstancesState);
        this.scheduler = snapshot.scheduler.copy();
        int i = 0;
        while (i < this.actionInstances.size()) {
            snapshot.restoreActionInstanceState(i, this.actionInstances.get(i));
            ++i;
        }
        i = 0;
        while (i < this.schedulingInstances.size()) {
            snapshot.restoreSchedulingInstanceState(i, this.schedulingInstances.get(i));
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    public final Snapshot snapshot() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Snapshot snapshot;
                ObjectOutputStream out;
                ByteArrayOutputStream barray;
                block18: {
                    block17: {
                        barray = new ByteArrayOutputStream();
                        out = new ObjectOutputStream(barray);
                        out.writeObject(this);
                        snapshot = new Snapshot(barray.getByteArray(), barray.getSize());
                        if (out == null) break block17;
                        out.close();
                    }
                    if (barray == null) break block18;
                    barray.close();
                }
                return snapshot;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (barray != null) {
                                barray.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static final Scenario restore(Snapshot serialData, Solver solver) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                Scenario scenario;
                ObjectInputStream in;
                ByteArrayInputStream barray;
                block18: {
                    block17: {
                        barray = new ByteArrayInputStream(serialData.buf, 0, serialData.count);
                        in = new ObjectInputStream(barray);
                        Scenario result = (Scenario)in.readObject();
                        result.setSolver(solver);
                        scenario = result;
                        if (in == null) break block17;
                        in.close();
                    }
                    if (barray == null) break block18;
                    barray.close();
                }
                return scenario;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (barray != null) {
                                barray.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public final ActionInstance getTreeRoot() {
        if (this.rootAction == null) {
            return new ActionInstance("Scenario could not be generated due to errors (see error log)", -1, Solver.DEFAULT_RUNTIME_ID, null, null, this);
        }
        return (ActionInstance)((Object)this.rootAction);
    }

    protected <T> T pickCandidate(List<T> connectCandidates) {
        return this.solver.pickCandidate(connectCandidates);
    }

    public final int pickIndex(int size) {
        return this.solver.pickIndex(size);
    }

    public final Solver getSolver() {
        return this.solver;
    }

    public final void setSolver(Solver solver) {
        this.solver = solver;
    }

    public final void applyConstraints(Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Set<InstancesContainer> alreadyVisited, ActionInstance actionInstance, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap) {
        LinkedHashSet<DescriptorContainer> descriptorContainers = new LinkedHashSet<DescriptorContainer>();
        ConstraintsContainer constraints = this.collectConstraints(actionInstance, alreadyVisited);
        Map<String, FieldInstance> fieldInstances = actionInstance.getFieldInstances();
        this.recursiveCollectConstraints(model, variableSolverMap, alreadyVisited, fieldInstances, descriptorContainers, cspToReadableTextMap);
        this.collectConstraints(actionInstance, constraints, descriptorContainers);
        IdentityHashMap<Variable, Expression.CspConstraint> cspDefaultConstraintsMap = new IdentityHashMap<Variable, Expression.CspConstraint>();
        for (DescriptorContainer descriptorContainer : descriptorContainers) {
            descriptorContainer.constraintDescriptor.apply(this, model, variableSolverMap, descriptorContainer.instanceScope, descriptorContainer.descriptorScope, cspDefaultConstraintsMap, cspToReadableTextMap);
        }
    }

    public void applyConstraints(Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Set<InstancesContainer> alreadyVisited, Map<String, FieldInstance> fieldInstances, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap) {
        LinkedHashSet<DescriptorContainer> descriptorContainers = new LinkedHashSet<DescriptorContainer>();
        this.recursiveCollectConstraints(model, variableSolverMap, alreadyVisited, fieldInstances, descriptorContainers, cspToReadableTextMap);
        IdentityHashMap<Variable, Expression.CspConstraint> cspDefaultConstraintsMap = new IdentityHashMap<Variable, Expression.CspConstraint>();
        for (DescriptorContainer descriptorContainer : descriptorContainers) {
            descriptorContainer.constraintDescriptor.apply(this, model, variableSolverMap, descriptorContainer.instanceScope, descriptorContainer.descriptorScope, cspDefaultConstraintsMap, cspToReadableTextMap);
        }
    }

    private void collectConstraints(ConstraintsContainer result, ActionInstance actionInstance, int maxTraversalIndex, Set<InstancesContainer> alreadyVisited) {
        if (alreadyVisited.contains(actionInstance)) {
            return;
        }
        alreadyVisited.add(actionInstance);
        this.collectInstanceTypeConstraints(result, actionInstance);
        List<ConstraintDescriptor> constraints = this.inlineConstraintDescriptors.get(actionInstance);
        if (constraints != null && !constraints.isEmpty()) {
            for (ConstraintDescriptor constraint : constraints) {
                constraint.setMaxTraversalIndex(maxTraversalIndex);
                result.addConstraint(-1, actionInstance, constraint);
            }
        }
    }

    private ConstraintsContainer collectConstraints(ActionInstance actionInstance, Set<InstancesContainer> alreadyVisited) {
        ConstraintsContainer result = new ConstraintsContainer();
        int maxTraversalIndex = actionInstance.getTraversalIndex();
        ActionInstance instanceScope = actionInstance;
        while (!alreadyVisited.contains(instanceScope)) {
            this.solver.checkInterrupted();
            this.collectConstraints(result, instanceScope, maxTraversalIndex, alreadyVisited);
            if ((instanceScope = instanceScope.getParentActionInstance()) != null) continue;
        }
        return result;
    }

    private void collectConstraints(InstancesContainer currentInstanceScope, ConstraintsContainer constraints, Set<DescriptorContainer> descriptorContainers) {
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        for (Map.Entry<InstancesContainer, List<ConstraintDescriptor>> constraintsInScopeEntry : constraints.entrySet()) {
            InstancesContainer constraintDescriptorScope = constraintsInScopeEntry.getKey();
            List<ConstraintDescriptor> constraintsInScope = constraintsInScopeEntry.getValue();
            for (ConstraintDescriptor constraintDescriptor : constraintsInScope) {
                descriptorContainers.add(new DescriptorContainer(constraintDescriptor, currentInstanceScope, constraintDescriptorScope));
            }
        }
    }

    private void recursiveCollectConstraints(Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Set<InstancesContainer> alreadyVisited, Map<String, FieldInstance> fieldInstances, Set<DescriptorContainer> descriptorContainers, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap) {
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return;
        }
        block0: for (FieldInstance fieldInstance : fieldInstances.values()) {
            List<PortInstance> list;
            if (alreadyVisited.contains(fieldInstance)) continue;
            List<PortInstance> binds = fieldInstance.getBinds();
            if (binds != null && !binds.isEmpty()) {
                for (FieldInstance fieldInstance2 : binds) {
                    if (alreadyVisited.contains(fieldInstance2)) continue block0;
                }
            }
            if ((list = fieldInstance.getHierarchicalBinds(FieldInstance.HierarchicalBindKind.BOTH)) != null && !list.isEmpty()) {
                for (FieldInstance fieldInstance3 : list) {
                    if (alreadyVisited.contains(fieldInstance3)) continue block0;
                }
            }
            alreadyVisited.add(fieldInstance);
            if (!fieldInstance.isPort() && !fieldInstance.isRand() || fieldInstance.isActionHandle()) continue;
            ConstraintsContainer constraints = new ConstraintsContainer();
            this.collectInstanceTypeConstraints(constraints, fieldInstance);
            Map<String, FieldInstance> map = fieldInstance.getFieldInstances();
            this.recursiveCollectConstraints(model, variableSolverMap, alreadyVisited, map, descriptorContainers, cspToReadableTextMap);
            this.collectConstraints(fieldInstance, constraints, descriptorContainers);
        }
    }

    private void collectInstanceTypeConstraints(ConstraintsContainer result, InstancesContainer instanceScope) {
        if (instanceScope.typeInstance == null || !(instanceScope.typeInstance.rfInstanceType instanceof RfStruct)) {
            return;
        }
        RfStruct rfStructType = (RfStruct)instanceScope.typeInstance.rfInstanceType;
        do {
            this.solver.checkInterrupted();
            Set<String> shadowedConstraintNames = result.getShadowedConstraintNames();
            List<ConstraintDescriptor> constraints = this.constraintDescriptors.get(rfStructType);
            if (constraints == null || constraints.isEmpty()) continue;
            int i = 0;
            while (i < constraints.size()) {
                ConstraintDescriptor constraint = constraints.get(i);
                String constraintName = constraint.name;
                if (constraintName == null || !shadowedConstraintNames.contains(constraintName)) {
                    result.addConstraint(i, instanceScope, constraint);
                }
                ++i;
            }
        } while ((rfStructType = (RfStruct)rfStructType.getParent()) != null);
    }

    protected void applyInitialStateObjectConstraints(FieldInstance fieldInstance, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap) {
        ConstraintsContainer constraints = new ConstraintsContainer();
        this.collectInstanceTypeConstraints(constraints, fieldInstance);
        LinkedHashSet<DescriptorContainer> descriptorContainers = new LinkedHashSet<DescriptorContainer>();
        this.collectConstraints(fieldInstance, constraints, descriptorContainers);
        IdentityHashMap<Variable, Expression.CspConstraint> cspDefaultConstraintsMap = new IdentityHashMap<Variable, Expression.CspConstraint>();
        for (DescriptorContainer descriptorContainer : descriptorContainers) {
            descriptorContainer.constraintDescriptor.apply(this, model, variableSolverMap, descriptorContainer.instanceScope, descriptorContainer.descriptorScope, cspDefaultConstraintsMap, cspToReadableTextMap);
        }
    }

    public final TypeInstance createTypeInstance(InstancesContainer holderInstance, boolean isRef, RfNamedElement rfInstanceType) {
        if (rfInstanceType == null) {
            return null;
        }
        TypeInstance typeInstance = TypeInstance.create(holderInstance, rfInstanceType, isRef, this.uniqueTypeId, this);
        ++this.uniqueTypeId;
        return typeInstance;
    }

    public final void initSolverExpressionsErrors() {
        this.solverExpressionsErrors = new ArrayList<Expression.ExpressionError>();
    }

    public final void addSolverExpressionsErrors(List<Expression.ExpressionError> errors) {
        this.solverExpressionsErrors.addAll(errors);
    }

    public final void printSolverExpressionsErrors() {
        if (this.solverExpressionsErrors == null) {
            return;
        }
        for (Expression.ExpressionError solverExpressionsError : this.solverExpressionsErrors) {
            solverExpressionsError.logMessage();
        }
    }

    public final void logProblem(SolverProblem.Severity severity, String message, LineInfo lineInfo, ParserPath parserPath) {
        if (this.problemsLogger == null) {
            this.problemsLogger = new ArrayList<SolverProblem>();
        }
        this.problemsLogger.add(new SolverProblem(severity, message, lineInfo, parserPath));
    }

    public final void printProblems(SolverConsole console) {
        if (this.problemsLogger == null || this.problemsLogger.isEmpty()) {
            return;
        }
        for (SolverProblem problem : this.problemsLogger) {
            console.print(problem.message);
        }
    }

    public final int markProblems() {
        return this.problemsLogger == null ? 0 : this.problemsLogger.size();
    }

    /*
     * Unable to fully structure code
     */
    public final void restoreProblems(int mark) {
        if (mark != 0) ** GOTO lbl6
        this.problemsLogger = null;
        return;
lbl-1000:
        // 1 sources

        {
            this.problemsLogger.remove(this.problemsLogger.size() - 1);
lbl6:
            // 2 sources

            ** while (mark > this.problemsLogger.size())
        }
lbl7:
        // 1 sources

    }

    public final void addRecoverableInstance(InstancesContainer instance) {
        if (instance instanceof ComponentInstance && ((ComponentInstance)instance).isPure()) {
            return;
        }
        instance.instanceIndex = this.restorableInstances.size();
        this.restorableInstances.add(instance);
    }

    public final PoolItem restore(PoolItem oldInstance) {
        return (PoolItem)this.restorableInstances.get(oldInstance.instanceIndex);
    }

    public final PortInstance restore(PortInstance oldInstance) {
        return (PortInstance)this.restorableInstances.get(oldInstance.instanceIndex);
    }

    public final ComponentInstance restore(ComponentInstance oldInstance) {
        if (oldInstance.isPure()) {
            return oldInstance;
        }
        return (ComponentInstance)this.restorableInstances.get(oldInstance.instanceIndex);
    }

    public final ActionInstance restore(ActionInstance oldInstance) {
        if (oldInstance instanceof ISchedulingInstance) {
            return this.schedulingInstances.get(oldInstance.getInstanceIndex());
        }
        return this.actionInstances.get(oldInstance.getInstanceIndex());
    }

    public final void pushActivityDescriptor(ActivityDescriptor currActivityDescriptor) {
        this.activityDescriptors.push(currActivityDescriptor);
    }

    public final void push0ActivityDescriptor(ActivityDescriptor currActivityDescriptor) {
        this.activityDescriptors.push0(currActivityDescriptor);
    }

    public final ActivityDescriptor popActivityDescriptor() {
        if (this.activityDescriptors.isEmpty()) {
            return null;
        }
        return this.activityDescriptors.pop();
    }

    public final ActivityDescriptor peekActivityDescriptor() {
        if (this.activityDescriptors.isEmpty()) {
            return null;
        }
        return this.activityDescriptors.peek();
    }

    public final boolean hasActivityDescriptors() {
        return !this.activityDescriptors.isEmpty();
    }

    public final ComponentInstance getComponentInstance(int componentInstanceIndex) {
        return (ComponentInstance)this.restorableInstances.get(componentInstanceIndex);
    }

    public final void pushSymbolCallContext(NestedBlockContext context) {
        this.contextStack.push(context);
    }

    public final NestedBlockContext popSymbolCallContext() {
        return this.contextStack.pop();
    }

    public final NestedBlockContext getSymbolCallContext() {
        if (this.contextStack.isEmpty()) {
            return null;
        }
        return this.contextStack.peek();
    }

    public final List<BindDescriptor.PortBindDescriptor> getPortBindDescriptors(ActionInstance actionInstance) {
        ArrayList<BindDescriptor.PortBindDescriptor> bindDescriptors = new ArrayList<BindDescriptor.PortBindDescriptor>();
        do {
            List<BindDescriptor.PortBindDescriptor> binds;
            if ((binds = this.portBindDescriptors.get(actionInstance)) == null || binds.isEmpty()) continue;
            bindDescriptors.addAll(binds);
        } while ((actionInstance = actionInstance.getParentActionInstance()) != null);
        return bindDescriptors;
    }

    public final ExecDescriptors getExecDescriptors(RfStruct rfStructType, ExecBlockKind execKind) {
        if (rfStructType == null) {
            return null;
        }
        ExecDescriptors result = new ExecDescriptors(rfStructType, new ArrayList<ConstraintDescriptor.ExecStmtDescriptor>());
        do {
            List<ConstraintDescriptor.ExecStmtDescriptor> descriptors;
            if ((descriptors = this.execStmtDescriptors.get(rfStructType)) == null || descriptors.isEmpty()) continue;
            for (ConstraintDescriptor.ExecStmtDescriptor descriptor : descriptors) {
                if (descriptor.getExecKind() != execKind) continue;
                result.descriptors.add(descriptor);
                result.rfStructType = rfStructType;
            }
            if (result.descriptors.isEmpty()) continue;
            return result;
        } while ((rfStructType = (RfStruct)rfStructType.getParent()) != null);
        return null;
    }

    public final String printStackTrace() {
        StringBuilder result = new StringBuilder();
        HashSet<String> alreadyPrinted = new HashSet<String>();
        ListIterator<TraceElement> iterator = this.stackTrace.listIterator(this.stackTrace.size());
        while (iterator.hasPrevious()) {
            String traceElementText = iterator.previous().toString();
            if (alreadyPrinted.contains(traceElementText)) continue;
            alreadyPrinted.add(traceElementText);
            result.append(traceElementText);
        }
        return result.toString();
    }

    public final void addTraversedActionHandle(RfField rfActionHandle) {
        if (this.traversedActionHandlesStack.isEmpty()) {
            return;
        }
        this.traversedActionHandlesStack.peek().add(rfActionHandle);
    }

    public final void removeTraversedActionHandle(RfField rfActionHandle) {
        this.peekTraversedActionHandles().remove(rfActionHandle);
    }

    public final boolean isUninitActionHandle(RfNamedElement rfActionHandle) {
        if (!(rfActionHandle instanceof RfField)) {
            return false;
        }
        Set<RfField> traversedActionHandles = this.peekTraversedActionHandles();
        if (traversedActionHandles.contains(rfActionHandle)) {
            return false;
        }
        return ((RfField)rfActionHandle).isActionHandle();
    }

    public final Set<RfField> getTraversedActionHandle(boolean createWorkingCopy) {
        if (createWorkingCopy) {
            Set<RfField> workingCopy = Collections.newSetFromMap(new IdentityHashMap());
            workingCopy.addAll(this.peekTraversedActionHandles());
            return workingCopy;
        }
        return this.peekTraversedActionHandles();
    }

    public final void pushTraversedActionHandles(Set<RfField> traversedActionHandles) {
        this.traversedActionHandlesStack.push(traversedActionHandles);
    }

    public final Set<RfField> peekTraversedActionHandles() {
        if (this.traversedActionHandlesStack.isEmpty()) {
            return Collections.emptySet();
        }
        return this.traversedActionHandlesStack.peek();
    }

    public final void popTraversedActionHandles() {
        this.traversedActionHandlesStack.pop();
    }

    public final void pushRepeatId() {
        this.repeatIdStack.push(new RepeatId(-1));
    }

    public final void incrementRepeatId() {
        this.repeatIdStack.peek().repeatId = ++this.repeatGlobalId;
    }

    public final int peekRepeatId() {
        if (this.repeatIdStack.isEmpty()) {
            return -1;
        }
        return this.repeatIdStack.peek().repeatId;
    }

    public final void popRepeatId() {
        this.repeatIdStack.pop();
    }

    public final void postConnectConstraint(FieldInstance fieldInstance1, FieldInstance fieldInstance2) {
        ActionInstance parentActionInstance1 = fieldInstance1.getParentActionInstance();
        if (parentActionInstance1 == null) {
            return;
        }
        ActionInstance parentActionInstance2 = fieldInstance2.getParentActionInstance();
        if (parentActionInstance2 == null) {
            return;
        }
        Set<ActionInstance> instances = this.connectedActionInstances.get(parentActionInstance1);
        if (instances == null) {
            instances = Collections.newSetFromMap(new IdentityHashMap());
            this.connectedActionInstances.put(parentActionInstance1, instances);
        }
        instances.add(parentActionInstance2);
        instances = this.connectedActionInstances.get(parentActionInstance2);
        if (instances == null) {
            instances = Collections.newSetFromMap(new IdentityHashMap());
            this.connectedActionInstances.put(parentActionInstance2, instances);
        }
        instances.add(parentActionInstance1);
    }

    public final List<ActionInstance> getConnectedActions(FieldInstance ... fieldInstances) {
        Set<ActionInstance> connectedInstances = Utils.popReusableSet(ActionInstance.class);
        Set<ActionInstance> visited = Utils.popReusableSet(ActionInstance.class);
        try {
            FieldInstance[] fieldInstanceArray = fieldInstances;
            int n = fieldInstances.length;
            int n2 = 0;
            while (n2 < n) {
                FieldInstance fieldInstance = fieldInstanceArray[n2];
                ActionInstance parentActionInstance = fieldInstance.getParentActionInstance();
                if (parentActionInstance != null) {
                    connectedInstances.add(parentActionInstance);
                    this.collectConnectedActions(visited, connectedInstances, parentActionInstance);
                }
                ++n2;
            }
            ArrayList<ActionInstance> result = new ArrayList<ActionInstance>(connectedInstances);
            Collections.sort(result, (o1, o2) -> o1.instanceIndex - o2.instanceIndex);
            ArrayList<ActionInstance> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.pushReusableSet(visited);
            Utils.pushReusableSet(connectedInstances);
        }
    }

    public final List<ActionInstance> getConnectedActions(ActionInstance ... actionInstances) {
        Set<ActionInstance> connectedInstances = Utils.popReusableSet(ActionInstance.class);
        Set<ActionInstance> visited = Utils.popReusableSet(ActionInstance.class);
        try {
            ActionInstance[] actionInstanceArray = actionInstances;
            int n = actionInstances.length;
            int n2 = 0;
            while (n2 < n) {
                ActionInstance actionInstance = actionInstanceArray[n2];
                if (actionInstance != null) {
                    connectedInstances.add(actionInstance);
                    this.collectConnectedActions(visited, connectedInstances, actionInstance);
                }
                ++n2;
            }
            ArrayList<ActionInstance> result = new ArrayList<ActionInstance>(connectedInstances);
            Collections.sort(result, (o1, o2) -> o1.instanceIndex - o2.instanceIndex);
            ArrayList<ActionInstance> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.pushReusableSet(visited);
            Utils.pushReusableSet(connectedInstances);
        }
    }

    private void collectConnectedActions(Set<ActionInstance> visited, Set<ActionInstance> result, ActionInstance actionInstance) {
        if (visited.contains(actionInstance)) {
            return;
        }
        visited.add(actionInstance);
        Set<ActionInstance> instances = this.connectedActionInstances.get(actionInstance);
        if (instances == null) {
            return;
        }
        for (ActionInstance connectedInstance : instances) {
            result.add(connectedInstance);
            this.collectConnectedActions(visited, result, connectedInstance);
        }
    }

    public final BigInteger getNextRuntimeId(BigInteger runtimeId) {
        this.runtimeGlobalId = this.runtimeGlobalId.shiftLeft(1);
        return this.runtimeGlobalId.or(runtimeId);
    }

    public final void setInferredActionAnchor(ActionInstance inferredActionInstance, ActionInstance anchorActionInstance) {
    }

    public final void debugBeginEvaluate(Expression expression, InstancesContainer currentInstanceScope) {
        this.solver.debugBeginEvaluate(expression, currentInstanceScope);
    }

    public final void debugFinishEvaluate(Expression expression, InstancesContainer currentInstanceScope) {
        this.solver.debugFinishEvaluate(expression, currentInstanceScope);
    }

    public final void alloc(InstancesContainer claimInstance) {
        ISchedulingInstance anchorInstance = this.getAllocAnchorInstance(claimInstance);
        List<InstancesContainer> claimInstances = this.allocatedHandles.get(anchorInstance);
        if (claimInstances == null) {
            claimInstances = new ArrayList<InstancesContainer>();
            this.allocatedHandles.put(anchorInstance, claimInstances);
        }
        claimInstances.add(claimInstance);
    }

    /*
     * Unable to fully structure code
     */
    private final ISchedulingInstance getAllocAnchorInstance(InstancesContainer instance) {
        v0 = parentActionInstance = instance instanceof ActionInstance != false ? (ActionInstance)instance : instance.getParentActionInstance();
        if (parentActionInstance == null) {
            return null;
        }
        parentActionInstance = parentActionInstance.parentActionInstance;
        if (parentActionInstance != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            parentActionInstance = parentActionInstance.parentActionInstance;
lbl8:
            // 2 sources

            ** while (parentActionInstance instanceof ActionInstance.SequenceActionInstance && parentActionInstance.parentActionInstance instanceof ActionInstance.SequenceActionInstance)
        }
lbl9:
        // 2 sources

        while (!(parentActionInstance instanceof ActionInstance.SequenceActionInstance) && !(parentActionInstance.parentActionInstance instanceof ActionInstance.SequenceActionInstance)) {
            parentActionInstance = parentActionInstance.parentActionInstance;
        }
        if (parentActionInstance instanceof ISchedulingInstance) {
            return (ISchedulingInstance)parentActionInstance;
        }
        return null;
    }

    public final void free(ISchedulingInstance anchorInstance) {
        ISchedulingInstance parentAnchorInstance;
        List<InstancesContainer> claimInstances = this.allocatedHandles.remove(anchorInstance);
        if (claimInstances == null || claimInstances.isEmpty()) {
            return;
        }
        if (anchorInstance instanceof ActionInstance.SequenceActionInstance && (parentAnchorInstance = this.getAllocAnchorInstance((InstancesContainer)((Object)anchorInstance))) != null) {
            List<InstancesContainer> parentClaimList = this.allocatedHandles.get(parentAnchorInstance);
            if (parentClaimList == null) {
                parentClaimList = new ArrayList<InstancesContainer>();
                this.allocatedHandles.put(parentAnchorInstance, parentClaimList);
            }
            parentClaimList.addAll(claimInstances);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void removeAllocatedRegions(ComponentInstance.AllocatableRegions allocatableRegions, ActionInstance actionInstance) {
        if (!allocatableRegions.allocatableDomain.isEmpty()) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            if (actionInstance.isSequenceActionInstance() || (claimInstances = this.allocatedHandles.get(anchorInstance = (ISchedulingInstance)actionInstance)) == null || claimInstances.isEmpty()) continue;
            for (InstancesContainer claimInstance : claimInstances) {
                if (!Solver.inSameRuntime(actionInstance, claimInstance) || !allocatableRegions.regionInstances.contains((handleValue = (Expression.Value.HndlValue)claimInstance.getVariableValue()).getRegion())) continue;
                allocatableRegions.allocatableDomain = allocatableRegions.allocatableDomain.remove(handleValue.getLowerAddress(), handleValue.getUpperAddress());
            }
lbl8:
            // 3 sources

            ** while ((actionInstance = (ActionInstance)this.getAllocAnchorInstance((InstancesContainer)actionInstance)) instanceof ISchedulingInstance)
        }
lbl9:
        // 1 sources

    }

    public void clearProceduralRand() {
        if (this.proceduralRandVariables == null) {
            return;
        }
        this.proceduralRandVariables.clear();
    }

    public void addProceduralRand(InstancesContainer instanceContainer) {
        if (this.proceduralRandVariables == null) {
            this.proceduralRandVariables = Collections.newSetFromMap(new IdentityHashMap());
        }
        this.proceduralRandVariables.add(instanceContainer);
    }

    public boolean isProceduralRand(InstancesContainer instanceContainer) {
        if (this.proceduralRandVariables == null) {
            return false;
        }
        return this.proceduralRandVariables.contains(instanceContainer);
    }

    private static final class ConstraintsContainer {
        private Map<InstancesContainer, List<ConstraintDescriptor>> constraintsInScopeMap = new LinkedHashMap<InstancesContainer, List<ConstraintDescriptor>>();
        private Set<String> shadowedConstraintNames = new HashSet<String>();

        private ConstraintsContainer() {
        }

        public final void addConstraint(int index, InstancesContainer instanceScope, ConstraintDescriptor constraint) {
            if (constraint == null) {
                return;
            }
            List<ConstraintDescriptor> constraintsInScope = this.constraintsInScopeMap.get(instanceScope);
            if (constraintsInScope == null) {
                constraintsInScope = new LinkedList<ConstraintDescriptor>();
                this.constraintsInScopeMap.put(instanceScope, constraintsInScope);
            }
            if (constraint.name != null) {
                this.shadowedConstraintNames.add(constraint.name);
            }
            if (index == -1) {
                constraintsInScope.add(constraint);
            } else {
                constraintsInScope.add(index, constraint);
            }
        }

        public final boolean isEmpty() {
            return this.constraintsInScopeMap.isEmpty();
        }

        public final Set<Map.Entry<InstancesContainer, List<ConstraintDescriptor>>> entrySet() {
            return this.constraintsInScopeMap.entrySet();
        }

        public final Set<String> getShadowedConstraintNames() {
            return new HashSet<String>(this.shadowedConstraintNames);
        }
    }

    private static final class DescriptorContainer {
        private ConstraintDescriptor constraintDescriptor;
        private InstancesContainer instanceScope;
        private InstancesContainer descriptorScope;

        public DescriptorContainer(ConstraintDescriptor constraintDescriptor, InstancesContainer instanceScope, InstancesContainer descriptorScope) {
            this.constraintDescriptor = constraintDescriptor;
            this.instanceScope = instanceScope;
            this.descriptorScope = descriptorScope;
        }
    }

    static final class ExecDescriptors {
        protected RfStruct rfStructType;
        protected List<ConstraintDescriptor.ExecStmtDescriptor> descriptors;

        public ExecDescriptors(RfStruct rfStructType, List<ConstraintDescriptor.ExecStmtDescriptor> descriptors) {
            this.rfStructType = rfStructType;
            this.descriptors = descriptors;
        }
    }

    static final class LightSnapshot {
        private List<ActionInstance>[] actionInstancesChildrenState;
        private ActionInstance[] actionInstancesParentState;
        private List<ActionInstance> actionInstancesState;
        private List<ActionInstance>[] schedulingInstancesChildrenState;
        private ActionInstance[] schedulingInstancesParentState;
        private List<ActionInstance> schedulingInstancesState;
        private ISchedulerProxy scheduler;

        private LightSnapshot(int actionInstancesSize, int schedulingInstancesSize) {
            this.actionInstancesChildrenState = new List[actionInstancesSize];
            this.actionInstancesParentState = new ActionInstance[actionInstancesSize];
            this.schedulingInstancesChildrenState = new List[schedulingInstancesSize];
            this.schedulingInstancesParentState = new ActionInstance[schedulingInstancesSize];
        }

        private void setActionInstanceState(int i, ActionInstance actionInstance) {
            this.actionInstancesChildrenState[i] = Utils.copy(actionInstance.childrenActionInstances);
            this.actionInstancesParentState[i] = actionInstance.parentActionInstance;
        }

        private void setSchedulingInstanceState(int i, ActionInstance actionInstance) {
            this.schedulingInstancesChildrenState[i] = Utils.copy(actionInstance.childrenActionInstances);
            this.schedulingInstancesParentState[i] = actionInstance.parentActionInstance;
        }

        private void restoreActionInstanceState(int i, ActionInstance actionInstance) {
            actionInstance.childrenActionInstances = Utils.copy(this.actionInstancesChildrenState[i]);
            actionInstance.parentActionInstance = this.actionInstancesParentState[i];
        }

        private void restoreSchedulingInstanceState(int i, ActionInstance actionInstance) {
            actionInstance.childrenActionInstances = Utils.copy(this.schedulingInstancesChildrenState[i]);
            actionInstance.parentActionInstance = this.schedulingInstancesParentState[i];
        }
    }

    static final class RepeatId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected int repeatId;

        public RepeatId(int repeatId) {
            this.repeatId = repeatId;
        }
    }

    static final class Snapshot {
        private byte[] buf;
        private int count;

        public Snapshot(byte[] buf, int count) {
            this.buf = buf;
            this.count = count;
        }
    }

    public static final class TraceElement
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int line;
        private ParserPath parserPath;

        public TraceElement(int line, ParserPath parserPath) {
            this.line = line;
            this.parserPath = parserPath;
        }

        public final String toString() {
            return Utils.append("\n    ", "at line ", this.line, " in ", this.parserPath.path);
        }
    }
}

