/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.SchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;

public class Scheduler
implements ISchedulerProxy,
Serializable {
    private static final long serialVersionUID = 1L;
    private Scenario scenario;
    private Node[] nodes = new Node[16];
    private int nodesSize;
    private transient Scheduler workingCopy;

    public Scheduler(Scenario scenario) {
        this.scenario = scenario;
    }

    private final Node createNode(int instanceIndex) {
        if (instanceIndex >= this.nodes.length) {
            this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + 16);
        }
        if (instanceIndex < this.nodes.length && this.nodes[instanceIndex] != null) {
            return this.nodes[instanceIndex];
        }
        this.nodesSize = Math.max(this.nodesSize, instanceIndex + 1);
        this.nodes[instanceIndex] = new Node(this, instanceIndex);
        return this.nodes[instanceIndex];
    }

    @Override
    public final boolean isBefore(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        return this.isBefore(a1.instanceIndex, a2.instanceIndex);
    }

    private final boolean isBefore(int index1, int index2) {
        Node n1 = this.nodes[index1];
        Node n2 = this.nodes[index2];
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.isBefore(n2);
    }

    private final boolean allowsBefore(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return true;
        }
        if (this.isParallel(index1, index2) || this.isBefore(index2, index1)) {
            return false;
        }
        try {
            if (this.workingCopy == null) {
                this.workingCopy = this.copy();
            }
            this.workingCopy.scheduleBefore(index1, index2);
        }
        catch (SchedulerProxy.SchedulingException schedulingException) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean canScheduleBefore(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        try {
            this.workingCopy = null;
            if (!this.allowsBefore(index1, index2)) {
                return false;
            }
            int i = 0;
            while (i < this.nodesSize) {
                ActionInstance ai;
                if (!(i != index1 && !this.isParallel(index1, i) || (ai = this.scenario.getActionInstance(i)).isSkipCompound() || ai.isParentInstanceOf(a1))) {
                    int j = 0;
                    while (j < this.nodesSize) {
                        ActionInstance aj;
                        if (!(j != index2 && !this.isParallel(index2, j) || (aj = this.scenario.getActionInstance(j)).isSkipCompound() || ai.isParentInstanceOf(aj))) {
                            List<ActionInstance> children1 = this.getChildrenOfCompound(ai);
                            List<ActionInstance> children2 = this.getChildrenOfCompound(aj);
                            if (!children1.isEmpty() && !children2.isEmpty()) {
                                for (ActionInstance child1 : children1) {
                                    for (ActionInstance child2 : children2) {
                                        if (child1 == ai && child2 == aj || this.allowsBefore(child1.instanceIndex, child2.instanceIndex)) continue;
                                        return false;
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        finally {
            this.workingCopy = null;
        }
        return true;
    }

    private final List<ActionInstance> getChildrenOfCompound(ActionInstance ai) {
        ArrayList<ActionInstance> children = new ArrayList<ActionInstance>();
        InstanceVisitor<ActionInstance> visitor = instance -> {
            if (instance instanceof ISchedulingInstance) {
                return true;
            }
            children.add((ActionInstance)instance);
            return true;
        };
        ai.accept(visitor);
        return children;
    }

    @Override
    public final void scheduleBefore(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' before '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        this.scheduleBefore(index1, index2);
    }

    private final void scheduleBefore(int index1, int index2) {
        Node n1 = this.createNode(index1);
        Node n2 = this.createNode(index2);
        n1.setBefore(n2, true);
    }

    @Override
    public final boolean canInsertBefore(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameStrictRuntime(a1, a2)) {
            return false;
        }
        boolean isOrphan1 = a1.isOrphan();
        boolean isOrphan2 = a2.isOrphan();
        if (!isOrphan1 && !isOrphan2) {
            throw new SchedulerProxy.SchedulingException("Insertion not allowed");
        }
        if (!this.canScheduleBefore(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        int i = 0;
        while (i < this.nodesSize) {
            ActionInstance ai;
            if (i != index1 && i != index2 && !(ai = this.scenario.getActionInstance(i)).isSkipCompound()) {
                boolean isOrphan3 = ai.isOrphan();
                if (isOrphan1 && this.isBefore(i, index2) && this.isBefore(index1, i)) {
                    return false;
                }
                if (isOrphan2 && this.isBefore(index1, i) && this.isBefore(i, index2)) {
                    return false;
                }
                if (isOrphan1 && !isOrphan3 && this.isParallel(i, index1)) {
                    return false;
                }
                if (isOrphan2 && !isOrphan3 && this.isParallel(i, index2)) {
                    return false;
                }
                if (isOrphan1 && this.isParallel(i, index2) && ai.isParentInstanceOf(a2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public final void insertBefore(ActionInstance a1, ActionInstance a2) {
        this.scheduleBefore(a1, a2);
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        int i = 0;
        while (i < this.nodesSize) {
            ActionInstance ai;
            if (i != index1 && i != index2 && !(ai = this.scenario.getActionInstance(i)).isOrphan() && this.isBefore(i, index2) && !this.isParallel(i, index1)) {
                this.scheduleBefore(ai, a1);
            }
            ++i;
        }
    }

    @Override
    public final boolean isParallel(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        return this.isParallel(a1.instanceIndex, a2.instanceIndex);
    }

    private final boolean isParallel(int index1, int index2) {
        Node n1 = this.nodes[index1];
        Node n2 = this.nodes[index2];
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.isParallel(n2);
    }

    private final boolean allowsParallel(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return true;
        }
        if (this.isBefore(index1, index2) || this.isBefore(index2, index1) || this.isSequential(index1, index2)) {
            return false;
        }
        try {
            if (this.workingCopy == null) {
                this.workingCopy = this.copy();
            }
            this.workingCopy.scheduleParallel(index1, index2);
        }
        catch (SchedulerProxy.SchedulingException schedulingException) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean canScheduleParallel(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        try {
            this.workingCopy = null;
            if (!this.allowsParallel(index1, index2)) {
                return false;
            }
            int i = 0;
            while (i < this.nodesSize) {
                if (i == index1 || this.isParallel(index1, i)) {
                    int j = 0;
                    while (j < this.nodesSize) {
                        if ((j == index2 || this.isParallel(index2, j)) && !this.allowsParallel(i, j)) {
                            return false;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        finally {
            this.workingCopy = null;
        }
        return true;
    }

    @Override
    public final void scheduleParallel(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' in parallel with '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        this.scheduleParallel(index1, index2);
    }

    private final void scheduleParallel(int index1, int index2) {
        Node n1 = this.createNode(index1);
        Node n2 = this.createNode(index2);
        n1.setParallel(n2, true);
    }

    @Override
    public final boolean canInsertParallel(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameStrictRuntime(a1, a2)) {
            return false;
        }
        boolean isOrphan1 = a1.isOrphan();
        boolean isOrphan2 = a2.isOrphan();
        if (!isOrphan1 && !isOrphan2) {
            throw new SchedulerProxy.SchedulingException("Insertion not allowed");
        }
        if (!this.canScheduleParallel(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        int i = 0;
        while (i < this.nodesSize) {
            ActionInstance ai;
            if (i != index1 && i != index2 && !(ai = this.scenario.getActionInstance(i)).isSkipCompound()) {
                if ((this.isBefore(index1, i) || this.isParallel(index1, i)) && this.isBefore(i, index2)) {
                    return false;
                }
                if ((this.isBefore(index2, i) || this.isParallel(index2, i)) && this.isBefore(i, index1)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public final void insertParallel(ActionInstance a1, ActionInstance a2) {
        this.scheduleParallel(a1, a2);
    }

    public final boolean canScheduleSchedule(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        return !this.isParallel(index1, index2) && !this.isBefore(index1, index2) && !this.isBefore(index2, index1);
    }

    @Override
    public final void scheduleSchedule(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' relative to '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        Node n1 = this.createNode(index1);
        Node n2 = this.createNode(index2);
        n1.setSchedule(n2);
    }

    private final boolean allowsSequential(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return true;
        }
        if (this.isParallel(index1, index2)) {
            return false;
        }
        try {
            if (this.workingCopy == null) {
                this.workingCopy = this.copy();
            }
            this.workingCopy.scheduleSequential(index1, index2);
        }
        catch (SchedulerProxy.SchedulingException schedulingException) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean canScheduleSequential(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        if (a1.instanceIndex < 0 || a2.instanceIndex < 0) {
            return true;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        try {
            this.workingCopy = null;
            if (!this.allowsSequential(index1, index2)) {
                return false;
            }
        }
        finally {
            this.workingCopy = null;
        }
        return true;
    }

    private final boolean isSequential(int index1, int index2) {
        Node n1 = this.nodes[index1];
        Node n2 = this.nodes[index2];
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.isSequential(n2);
    }

    @Override
    public final void scheduleSequential(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' sequential with '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        this.scheduleSequential(index1, index2);
    }

    private final void scheduleSequential(int index1, int index2) {
        Node n1 = this.createNode(index1);
        Node n2 = this.createNode(index2);
        n1.setSequence(n2, true);
    }

    @Override
    public Scheduler copy() {
        Scheduler schedulerCopy = new Scheduler(this.scenario);
        schedulerCopy.nodes = new Node[this.nodes.length];
        schedulerCopy.nodesSize = this.nodesSize;
        int i = 0;
        while (i < this.nodesSize) {
            schedulerCopy.nodes[i] = this.nodes[i] == null ? null : this.nodes[i].copy(schedulerCopy);
            ++i;
        }
        return schedulerCopy;
    }

    @Override
    public boolean hasTemporalDependency(ActionInstance a1, List<ActionInstance> concurentActions, List<ActionInstance> parallelActions) {
        Node n2;
        Node n1;
        int index2;
        int index1;
        for (ActionInstance a2 : concurentActions) {
            if (!Solver.inSameRuntime(a1, a2)) continue;
            index1 = a1.instanceIndex;
            index2 = a2.instanceIndex;
            n1 = this.createNode(index1);
            if (!n1.hasTemporalDependency(n2 = this.createNode(index2))) continue;
            return true;
        }
        for (ActionInstance a2 : parallelActions) {
            if (!Solver.inSameRuntime(a1, a2)) continue;
            index1 = a1.instanceIndex;
            index2 = a2.instanceIndex;
            n1 = this.createNode(index1);
            if (!n1.isDependent(n2 = this.createNode(index2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void scheduleDependency(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' sequential with '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        Node n1 = this.createNode(index1);
        Node n2 = this.createNode(index2);
        n1.setDependency(n2);
    }

    private static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int index;
        private BitSet before;
        private BitSet after;
        private BitSet parallel;
        private BitSet sequence;
        private BitSet schedule;
        private BitSet dependency;
        private Scheduler scheduler;

        private Node(Scheduler scheduler, int index) {
            this.index = index;
            this.scheduler = scheduler;
        }

        public final void setParallel(Node n, boolean isSetRecursive) {
            if (this.isBefore(n)) {
                throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' in parallel with '" + this.scheduler.scenario.getActionInstance(n.index) + "' because '" + this.scheduler.scenario.getActionInstance(this.index) + "' is before '" + this.scheduler.scenario.getActionInstance(n.index) + "'");
            }
            if (n.isBefore(this)) {
                throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' in parallel with '" + this.scheduler.scenario.getActionInstance(n.index) + "' because '" + this.scheduler.scenario.getActionInstance(n.index) + "' is before '" + this.scheduler.scenario.getActionInstance(this.index) + "'");
            }
            if (this.isSequential(n) || n.isSequential(this)) {
                throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' in parallel with '" + this.scheduler.scenario.getActionInstance(n.index) + "' because '" + this.scheduler.scenario.getActionInstance(n.index) + "' is sequential with '" + this.scheduler.scenario.getActionInstance(this.index) + "'");
            }
            int i = 0;
            while (isSetRecursive && i < this.scheduler.nodesSize) {
                if (n.after != null && n.after.get(i)) {
                    this.setBefore(this.scheduler.nodes[i], false);
                }
                if (this.after != null && this.after.get(i)) {
                    n.setBefore(this.scheduler.nodes[i], false);
                }
                if (n.sequence != null && n.sequence.get(i)) {
                    this.setSequence(this.scheduler.nodes[i], false);
                }
                if (this.sequence != null && this.sequence.get(i)) {
                    n.setSequence(this.scheduler.nodes[i], false);
                }
                if (n.parallel != null && n.parallel.get(i)) {
                    this.setParallel(this.scheduler.nodes[i], false);
                }
                if (this.parallel != null && this.parallel.get(i)) {
                    n.setParallel(this.scheduler.nodes[i], false);
                }
                ++i;
            }
            if (this.parallel == null) {
                this.parallel = new BitSet();
            }
            if (n.parallel == null) {
                n.parallel = new BitSet();
            }
            this.parallel.set(n.index);
            n.parallel.set(this.index);
            this.parallel.or(n.parallel);
            n.parallel.or(this.parallel);
            if (this.before == null && n.before != null) {
                this.before = new BitSet();
            }
            if (n.before == null && this.before != null) {
                n.before = new BitSet();
            }
            if (this.before != null && n.before != null) {
                this.before.or(n.before);
                n.before.or(this.before);
            }
            if (this.after == null && n.after != null) {
                this.after = new BitSet();
            }
            if (n.after == null && this.after != null) {
                n.after = new BitSet();
            }
            if (this.after != null && n.after != null) {
                this.after.or(n.after);
                n.after.or(this.after);
            }
            if (this.sequence == null && n.sequence != null) {
                this.sequence = new BitSet();
            }
            if (n.sequence == null && this.sequence != null) {
                n.sequence = new BitSet();
            }
            if (this.sequence != null && n.sequence != null) {
                this.sequence.or(n.sequence);
                n.sequence.or(this.sequence);
            }
            this.checkConsistency();
            n.checkConsistency();
        }

        private final void checkConsistency() {
            BitSet parallelCopy;
            if (this.parallel != null && this.before != null) {
                parallelCopy = BitSet.valueOf(this.parallel.toLongArray());
                parallelCopy.and(this.before);
                if (!parallelCopy.isEmpty()) {
                    int index2 = parallelCopy.nextSetBit(0);
                    throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' in parallel with '" + this.scheduler.scenario.getActionInstance(index2) + "' because '" + this.scheduler.scenario.getActionInstance(index2) + "' is before '" + this.scheduler.scenario.getActionInstance(this.index) + "'");
                }
            }
            if (this.parallel != null && this.after != null) {
                parallelCopy = BitSet.valueOf(this.parallel.toLongArray());
                parallelCopy.and(this.after);
                if (!parallelCopy.isEmpty()) {
                    int index2 = parallelCopy.nextSetBit(0);
                    throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' in parallel with '" + this.scheduler.scenario.getActionInstance(index2) + "' because '" + this.scheduler.scenario.getActionInstance(this.index) + "' is before '" + this.scheduler.scenario.getActionInstance(index2) + "'");
                }
            }
            if (this.before != null && this.after != null) {
                BitSet beforeCopy = BitSet.valueOf(this.before.toLongArray());
                beforeCopy.and(this.after);
                if (!beforeCopy.isEmpty()) {
                    int index2 = beforeCopy.nextSetBit(0);
                    throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' before '" + this.scheduler.scenario.getActionInstance(index2) + "' because '" + this.scheduler.scenario.getActionInstance(index2) + "' is before '" + this.scheduler.scenario.getActionInstance(this.index) + "'");
                }
            }
            if (this.parallel != null && this.sequence != null) {
                parallelCopy = BitSet.valueOf(this.parallel.toLongArray());
                parallelCopy.and(this.sequence);
                if (!parallelCopy.isEmpty()) {
                    int index2 = parallelCopy.nextSetBit(0);
                    throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' in parallel with '" + this.scheduler.scenario.getActionInstance(index2) + "' because '" + this.scheduler.scenario.getActionInstance(index2) + "' is sequential with '" + this.scheduler.scenario.getActionInstance(this.index) + "'");
                }
            }
        }

        public final void setBefore(Node n, boolean isSetRecursive) {
            if (n.isBefore(this)) {
                throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' before '" + this.scheduler.scenario.getActionInstance(n.index) + "' because '" + this.scheduler.scenario.getActionInstance(n.index) + "' is before '" + this.scheduler.scenario.getActionInstance(this.index) + "'");
            }
            if (this.isParallel(n) || n.isParallel(this)) {
                throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' before '" + this.scheduler.scenario.getActionInstance(n.index) + "' because '" + this.scheduler.scenario.getActionInstance(this.index) + "' is in parallel with '" + this.scheduler.scenario.getActionInstance(n.index) + "'");
            }
            if (this.before != null || n.after != null || this.parallel != null || n.parallel != null) {
                int i = 0;
                while (isSetRecursive && i < this.scheduler.nodesSize) {
                    if (this.before != null && this.before.get(i)) {
                        this.scheduler.nodes[i].setBefore(n, false);
                    }
                    if (n.after != null && n.after.get(i)) {
                        this.setBefore(this.scheduler.nodes[i], false);
                    }
                    if (this.parallel != null && this.parallel.get(i)) {
                        this.scheduler.nodes[i].setBefore(n, false);
                    }
                    if (n.parallel != null && n.parallel.get(i)) {
                        this.setBefore(this.scheduler.nodes[i], false);
                    }
                    ++i;
                }
            }
            if (n.before == null) {
                n.before = new BitSet();
            }
            if (this.after == null) {
                this.after = new BitSet();
            }
            n.before.set(this.index);
            this.after.set(n.index);
            if (this.before != null) {
                n.before.or(this.before);
            }
            if (this.parallel != null) {
                n.before.or(this.parallel);
            }
            if (n.after != null) {
                this.after.or(n.after);
            }
            if (n.parallel != null) {
                this.after.or(n.parallel);
            }
            this.checkConsistency();
            n.checkConsistency();
        }

        public final void setSequence(Node n, boolean isSetRecursive) {
            if (this.isParallel(n) || n.isParallel(this)) {
                throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scheduler.scenario.getActionInstance(this.index) + "' sequential with '" + this.scheduler.scenario.getActionInstance(n.index) + "' because '" + this.scheduler.scenario.getActionInstance(this.index) + "' is in parallel with '" + this.scheduler.scenario.getActionInstance(n.index) + "'");
            }
            if (this.parallel != null) {
                int i = this.parallel.nextSetBit(0);
                while (isSetRecursive && i >= 0 && i < this.scheduler.nodesSize) {
                    this.scheduler.nodes[i].setSequence(n, false);
                    i = this.parallel.nextSetBit(i + 1);
                }
            }
            if (n.sequence == null) {
                n.sequence = new BitSet();
            }
            if (this.sequence == null) {
                this.sequence = new BitSet();
            }
            n.sequence.set(this.index);
            this.sequence.set(n.index);
            if (this.parallel != null) {
                n.sequence.or(this.parallel);
            }
            if (n.parallel != null) {
                this.sequence.or(n.parallel);
            }
            this.checkConsistency();
            n.checkConsistency();
        }

        public final void setSchedule(Node n) {
            if (n.schedule == null) {
                n.schedule = new BitSet();
            }
            if (this.schedule == null) {
                this.schedule = new BitSet();
            }
            n.schedule.set(this.index);
            this.schedule.set(n.index);
        }

        public final void setDependency(Node n) {
            if (n.dependency == null) {
                n.dependency = new BitSet();
            }
            if (this.dependency == null) {
                this.dependency = new BitSet();
            }
            n.dependency.set(this.index);
            this.dependency.set(n.index);
        }

        public final boolean isBefore(Node n) {
            return n.before != null && n.before.get(this.index) || this.after != null && this.after.get(n.index);
        }

        public final boolean isParallel(Node n) {
            return n.parallel != null && n.parallel.get(this.index) || this.parallel != null && this.parallel.get(n.index);
        }

        public final boolean isSequential(Node n) {
            return n.sequence != null && n.sequence.get(this.index) || this.sequence != null && this.sequence.get(n.index);
        }

        public final boolean isSchedule(Node n) {
            return n.schedule != null && n.schedule.get(this.index) || this.schedule != null && this.schedule.get(n.index);
        }

        public final boolean isDependent(Node n) {
            return n.dependency != null && n.dependency.get(this.index) || this.dependency != null && this.dependency.get(n.index);
        }

        public final boolean hasTemporalDependency(Node n) {
            return this.isBefore(n) || n.isBefore(this) || this.isParallel(n) || this.isSequential(n) || this.isSchedule(n);
        }

        public final Node copy(Scheduler scheduler) {
            Node n = new Node(scheduler, this.index);
            n.before = this.before == null ? null : BitSet.valueOf(this.before.toLongArray());
            n.after = this.after == null ? null : BitSet.valueOf(this.after.toLongArray());
            n.parallel = this.parallel == null ? null : BitSet.valueOf(this.parallel.toLongArray());
            n.sequence = this.sequence == null ? null : BitSet.valueOf(this.sequence.toLongArray());
            n.schedule = this.schedule == null ? null : BitSet.valueOf(this.schedule.toLongArray());
            n.dependency = this.dependency == null ? null : BitSet.valueOf(this.dependency.toLongArray());
            return n;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("'").append(this.scheduler.scenario.getActionInstance(this.index).toString()).append("'").append("\n");
            sb.append("   before: ").append("\n");
            this.toStringAppend(sb, this.before);
            sb.append("   after: ").append("\n");
            this.toStringAppend(sb, this.after);
            sb.append("   parallel: ").append("\n");
            this.toStringAppend(sb, this.parallel);
            sb.append("   sequence: ").append("\n");
            this.toStringAppend(sb, this.sequence);
            sb.append("   schedule: ").append("\n");
            this.toStringAppend(sb, this.schedule);
            return sb.toString();
        }

        private final void toStringAppend(StringBuilder sb, BitSet bs) {
            if (bs == null) {
                return;
            }
            int i = bs.length();
            while ((i = bs.previousSetBit(i - 1)) >= 0) {
                sb.append("      '").append(this.scheduler.scenario.getActionInstance(i).toString()).append("'").append("\n");
            }
        }
    }
}

