/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.SchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.SquareByteMatrix;

@Deprecated
public class SchedulingMatrix
implements ISchedulerProxy,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte BEFORE = 1;
    private static final byte PARALLEL = 2;
    private static final byte SEQUENTIAL = 4;
    private static final byte SCHEDULE = 8;
    private static final byte DEPENDENCY = 16;
    private SquareByteMatrix matrix = new SquareByteMatrix();
    private Scenario scenario;

    public SchedulingMatrix(Scenario scenario) {
        this.scenario = scenario;
    }

    private final boolean set(int index1, int index2, byte value, boolean isCheckOnly) {
        boolean set_a1_parallel_a2;
        byte prevValue = this.matrix.get(index1, index2);
        if (!isCheckOnly) {
            this.matrix.set(index1, index2, (byte)(value | prevValue));
        }
        byte v12 = value;
        byte v21 = this.matrix.fastGet(index2, index1);
        boolean is_a1_before_a2 = (v12 & 1) == 1;
        boolean is_a2_before_a1 = (v21 & 1) == 1;
        boolean is_a1_sequential_a2 = (v12 & 4) == 4 || (v21 & 4) == 4;
        boolean is_a1_parallel_a2 = (v12 & 2) == 2 || (v21 & 2) == 2;
        boolean set_a1_before_a2 = (value & 1) == 1;
        boolean set_a1_sequential_a2 = (value & 4) == 4;
        boolean bl = set_a1_parallel_a2 = (value & 2) == 2;
        if (set_a1_before_a2 && is_a2_before_a1) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scenario.getActionInstance(index1) + "' before '" + this.scenario.getActionInstance(index2) + "' because '" + this.scenario.getActionInstance(index2) + "' is before '" + this.scenario.getActionInstance(index1) + "'");
        }
        if (set_a1_before_a2 && is_a1_parallel_a2) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scenario.getActionInstance(index1) + "' before '" + this.scenario.getActionInstance(index2) + "' because '" + this.scenario.getActionInstance(index1) + "' is in parallel with '" + this.scenario.getActionInstance(index2) + "'");
        }
        if (set_a1_sequential_a2 && is_a1_parallel_a2) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scenario.getActionInstance(index1) + "' sequential with '" + this.scenario.getActionInstance(index2) + "' because '" + this.scenario.getActionInstance(index1) + "' is in parallel with '" + this.scenario.getActionInstance(index2) + "'");
        }
        if (set_a1_parallel_a2 && is_a1_before_a2) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scenario.getActionInstance(index1) + "' in parallel with '" + this.scenario.getActionInstance(index2) + "' because '" + this.scenario.getActionInstance(index1) + "' is before '" + this.scenario.getActionInstance(index2) + "'");
        }
        if (set_a1_parallel_a2 && is_a2_before_a1) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scenario.getActionInstance(index1) + "' in parallel with '" + this.scenario.getActionInstance(index2) + "' because '" + this.scenario.getActionInstance(index2) + "' is before '" + this.scenario.getActionInstance(index1) + "'");
        }
        if (set_a1_parallel_a2 && is_a1_sequential_a2) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + this.scenario.getActionInstance(index1) + "' in parallel with '" + this.scenario.getActionInstance(index2) + "' because '" + this.scenario.getActionInstance(index2) + "' is sequential with '" + this.scenario.getActionInstance(index1) + "'");
        }
        return (value & prevValue) == 0;
    }

    @Override
    public final boolean isBefore(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        return this.isBefore(a1.instanceIndex, a2.instanceIndex);
    }

    private final boolean isBefore(int index1, int index2) {
        boolean is_a1_before_a2;
        byte v21;
        byte v12 = this.matrix.get(index1, index2);
        boolean is_parallel = ((v12 | (v21 = this.matrix.get(index2, index1))) & 2) == 2;
        boolean bl = is_a1_before_a2 = (v12 & 1) == 1;
        return !is_parallel && is_a1_before_a2;
    }

    private final boolean allowsBefore(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return true;
        }
        if (this.isParallel(index1, index2) || this.isBefore(index2, index1)) {
            return false;
        }
        try {
            this.scheduleBefore(index1, index2, true);
        }
        catch (SchedulerProxy.SchedulingException schedulingException) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean canScheduleBefore(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        if (!this.allowsBefore(index1, index2)) {
            return false;
        }
        int i = 0;
        while (i < this.matrix.getLength()) {
            ActionInstance ai;
            if (!(i != index1 && !this.isParallel(index1, i) || (ai = this.scenario.getActionInstance(i)).isSkipCompound() || ai.isParentInstanceOf(a1))) {
                int j = 0;
                while (j < this.matrix.getLength()) {
                    ActionInstance aj;
                    if ((j == index2 || this.isParallel(index2, j)) && !(aj = this.scenario.getActionInstance(j)).isSkipCompound()) {
                        List<ActionInstance> children1 = this.getChildrenOfCompound(ai);
                        List<ActionInstance> children2 = this.getChildrenOfCompound(aj);
                        if (!children1.isEmpty() && !children2.isEmpty()) {
                            for (ActionInstance child1 : children1) {
                                for (ActionInstance child2 : children2) {
                                    if (child1 == ai && child2 == aj || this.allowsBefore(child1.instanceIndex, child2.instanceIndex)) continue;
                                    return false;
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private final List<ActionInstance> getChildrenOfCompound(ActionInstance ai) {
        ArrayList<ActionInstance> children = new ArrayList<ActionInstance>();
        InstanceVisitor<ActionInstance> visitor = instance -> {
            if (instance instanceof ISchedulingInstance) {
                return true;
            }
            children.add((ActionInstance)instance);
            return true;
        };
        ai.accept(visitor);
        return children;
    }

    @Override
    public final void scheduleBefore(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' before '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        this.scheduleBefore(index1, index2, false);
    }

    private final void scheduleBefore(int index1, int index2, boolean isCheckOnly) {
        boolean isModified = this.set(index1, index2, (byte)1, isCheckOnly);
        int length = this.matrix.getLength();
        while (isModified) {
            isModified = false;
            int i = 0;
            while (i < length) {
                if (i == index1 || this.isParallel(i, index1) || this.isBefore(i, index1)) {
                    int j = 0;
                    while (j < length) {
                        if (j == index2 || this.isParallel(j, index2) || this.isBefore(index2, j)) {
                            isModified |= this.set(i, j, (byte)1, isCheckOnly);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (isCheckOnly) break;
        }
    }

    @Override
    public final boolean canInsertBefore(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameStrictRuntime(a1, a2)) {
            return false;
        }
        boolean isOrphan1 = a1.isOrphan();
        boolean isOrphan2 = a2.isOrphan();
        if (!isOrphan1 && !isOrphan2) {
            throw new SchedulerProxy.SchedulingException("Insertion not allowed");
        }
        if (!this.canScheduleBefore(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        int i = 0;
        while (i < this.matrix.getLength()) {
            ActionInstance ai;
            if (i != index1 && i != index2 && !(ai = this.scenario.getActionInstance(i)).isSkipCompound()) {
                boolean isOrphan3 = ai.isOrphan();
                if (isOrphan1 && this.isBefore(i, index2) && this.isBefore(index1, i)) {
                    return false;
                }
                if (isOrphan2 && this.isBefore(index1, i) && this.isBefore(i, index2)) {
                    return false;
                }
                if (isOrphan1 && !isOrphan3 && this.isParallel(i, index1)) {
                    return false;
                }
                if (isOrphan2 && !isOrphan3 && this.isParallel(i, index2)) {
                    return false;
                }
                if (isOrphan1 && this.isParallel(i, index2) && ai.isParentInstanceOf(a2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public final void insertBefore(ActionInstance a1, ActionInstance a2) {
        this.scheduleBefore(a1, a2);
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        int i = 0;
        while (i < this.matrix.getLength()) {
            ActionInstance ai;
            if (i != index1 && i != index2 && !(ai = this.scenario.getActionInstance(i)).isOrphan() && this.isBefore(i, index2) && !this.isParallel(i, index1)) {
                this.scheduleBefore(ai, a1);
            }
            ++i;
        }
    }

    @Override
    public final boolean isParallel(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        return this.isParallel(a1.instanceIndex, a2.instanceIndex);
    }

    private final boolean isParallel(int index1, int index2) {
        boolean is_a2_before_a1;
        byte v21;
        byte v12 = this.matrix.get(index1, index2);
        boolean is_parallel = ((v12 | (v21 = this.matrix.get(index2, index1))) & 2) == 2;
        boolean is_a1_before_a2 = (v12 & 1) == 1;
        boolean bl = is_a2_before_a1 = (v21 & 1) == 1;
        return is_parallel && !is_a1_before_a2 && !is_a2_before_a1;
    }

    private final boolean allowsParallel(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return true;
        }
        if (this.isBefore(index1, index2) || this.isBefore(index2, index1) || this.isSequential(index1, index2)) {
            return false;
        }
        try {
            this.scheduleParallel(index1, index2, true);
        }
        catch (SchedulerProxy.SchedulingException schedulingException) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean canScheduleParallel(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        if (!this.allowsParallel(index1, index2)) {
            return false;
        }
        int i = 0;
        while (i < this.matrix.getLength()) {
            if (i == index1 || this.isParallel(index1, i)) {
                int j = 0;
                while (j < this.matrix.getLength()) {
                    if ((j == index2 || this.isParallel(index2, j)) && !this.allowsParallel(i, j)) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public final void scheduleParallel(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' in parallel with '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        this.scheduleParallel(index1, index2, false);
    }

    private final void scheduleParallel(int index1, int index2, boolean isCheckOnly) {
        boolean isModified = this.set(index1, index2, (byte)2, isCheckOnly);
        isModified |= this.set(index2, index1, (byte)2, isCheckOnly);
        int length = this.matrix.getLength();
        while (isModified) {
            isModified = false;
            int i = 0;
            while (i < length) {
                boolean isSequential1;
                boolean isParallel1 = i == index1 || this.isParallel(i, index1);
                boolean isBefore1 = !isParallel1 && this.isBefore(i, index1);
                boolean isAfter1 = !isParallel1 && this.isBefore(index1, i);
                boolean bl = isSequential1 = !isParallel1 && this.isSequential(i, index1);
                if (isParallel1 || isBefore1 || isAfter1 || isSequential1) {
                    int j = 0;
                    while (j < length) {
                        boolean isSequential2;
                        boolean isParallel2 = j == index2 || this.isParallel(j, index2);
                        boolean isBefore2 = !isParallel2 && this.isBefore(index2, j);
                        boolean isAfter2 = !isParallel2 && this.isBefore(j, index2);
                        boolean bl2 = isSequential2 = !isParallel2 && this.isSequential(j, index2);
                        if (isParallel2 || isBefore2 || isAfter2 || isSequential2) {
                            if (isParallel1 && isParallel2) {
                                isModified |= this.set(i, j, (byte)2, isCheckOnly);
                            }
                            if (isParallel1 && isBefore2) {
                                isModified |= this.set(i, j, (byte)1, isCheckOnly);
                            }
                            if (isBefore1 && isParallel2) {
                                isModified |= this.set(i, j, (byte)1, isCheckOnly);
                            }
                            if (isBefore1 && isBefore2) {
                                isModified |= this.set(i, j, (byte)1, isCheckOnly);
                            }
                            if (isParallel1 && isAfter2) {
                                isModified |= this.set(j, i, (byte)1, isCheckOnly);
                            }
                            if (isAfter1 && isParallel2) {
                                isModified |= this.set(j, i, (byte)1, isCheckOnly);
                            }
                            if (isAfter1 && isAfter2) {
                                isModified |= this.set(j, i, (byte)1, isCheckOnly);
                            }
                            if (isParallel1 && isSequential2) {
                                isModified |= this.set(i, j, (byte)4, isCheckOnly);
                            }
                            if (isSequential1 && isParallel2) {
                                isModified |= this.set(i, j, (byte)4, isCheckOnly);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (isCheckOnly) break;
        }
    }

    @Override
    public final boolean canInsertParallel(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameStrictRuntime(a1, a2)) {
            return false;
        }
        boolean isOrphan1 = a1.isOrphan();
        boolean isOrphan2 = a2.isOrphan();
        if (!isOrphan1 && !isOrphan2) {
            throw new SchedulerProxy.SchedulingException("Insertion not allowed");
        }
        if (!this.canScheduleParallel(a1, a2)) {
            return false;
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        int i = 0;
        while (i < this.matrix.getLength()) {
            ActionInstance ai;
            if (i != index1 && i != index2 && !(ai = this.scenario.getActionInstance(i)).isSkipCompound()) {
                if ((this.isBefore(index1, i) || this.isParallel(index1, i)) && this.isBefore(i, index2)) {
                    return false;
                }
                if ((this.isBefore(index2, i) || this.isParallel(index2, i)) && this.isBefore(i, index1)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public final void insertParallel(ActionInstance a1, ActionInstance a2) {
        this.scheduleParallel(a1, a2);
    }

    public final boolean canScheduleSchedule(ActionInstance a1, ActionInstance a2) {
        boolean is_a2_before_a1;
        byte v21;
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        byte v12 = this.matrix.get(a1.instanceIndex, a2.instanceIndex);
        boolean is_parallel = ((v12 | (v21 = this.matrix.get(a2.instanceIndex, a1.instanceIndex))) & 2) == 2;
        boolean is_a1_before_a2 = (v12 & 1) == 1;
        boolean bl = is_a2_before_a1 = (v12 & 1) == 1;
        return !is_parallel && !is_a1_before_a2 && !is_a2_before_a1;
    }

    @Override
    public final void scheduleSchedule(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' relative to '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        this.set(index1, index2, (byte)8, false);
        this.set(index2, index1, (byte)8, false);
    }

    @Override
    public final boolean canScheduleSequential(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            return false;
        }
        if (a1.instanceIndex < 0 || a2.instanceIndex < 0) {
            return true;
        }
        byte v12 = this.matrix.get(a1.instanceIndex, a2.instanceIndex);
        byte v21 = this.matrix.get(a2.instanceIndex, a1.instanceIndex);
        boolean is_a2_parallel_a1 = (v21 & 2) == 2;
        boolean is_a1_parallel_a2 = (v12 & 2) == 2;
        boolean is_parallel = is_a1_parallel_a2 || is_a2_parallel_a1;
        return !is_parallel;
    }

    private final boolean isSequential(int index1, int index2) {
        boolean is_sequential;
        byte v21;
        byte v12 = this.matrix.get(index1, index2);
        boolean is_parallel = ((v12 | (v21 = this.matrix.get(index2, index1))) & 2) == 2;
        boolean bl = is_sequential = ((v12 | v21) & 4) == 4;
        return !is_parallel && is_sequential;
    }

    @Override
    public final void scheduleSequential(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' sequential with '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        if (index1 == index2) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule me <-> me");
        }
        boolean isModified = this.set(index1, index2, (byte)4, false);
        isModified |= this.set(index2, index1, (byte)4, false);
        while (isModified) {
            isModified = false;
            int i = 0;
            while (i < this.matrix.getLength()) {
                if (i == index1 || this.isParallel(i, index1)) {
                    int j = 0;
                    while (j < this.matrix.getLength()) {
                        if (j == index2 || this.isParallel(j, index2)) {
                            isModified |= this.set(i, j, (byte)4, false);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public SchedulingMatrix copy() {
        SchedulingMatrix schedulingMatrixCopy = new SchedulingMatrix(this.scenario);
        schedulingMatrixCopy.matrix = this.matrix.createCopy();
        return schedulingMatrixCopy;
    }

    @Override
    public final void scheduleDependency(ActionInstance a1, ActionInstance a2) {
        if (!Solver.inSameRuntime(a1, a2)) {
            throw new SchedulerProxy.SchedulingException("Cannot schedule '" + a1 + "' relative to '" + a2 + "' because not in the same runtime");
        }
        int index1 = a1.instanceIndex;
        int index2 = a2.instanceIndex;
        this.set(index1, index2, (byte)16, false);
        this.set(index2, index1, (byte)16, false);
    }

    @Override
    public boolean hasTemporalDependency(ActionInstance a1, List<ActionInstance> concurentActions, List<ActionInstance> parallelActions) {
        byte v21;
        byte v12;
        for (ActionInstance a2 : concurentActions) {
            if (!Solver.inSameRuntime(a1, a2)) continue;
            v12 = this.matrix.get(a1.instanceIndex, a2.instanceIndex);
            v21 = this.matrix.get(a2.instanceIndex, a1.instanceIndex);
            if (v12 == 0 && v21 == 0) continue;
            return true;
        }
        for (ActionInstance a2 : parallelActions) {
            if (!Solver.inSameRuntime(a1, a2)) continue;
            v12 = this.matrix.get(a1.instanceIndex, a2.instanceIndex);
            v21 = this.matrix.get(a2.instanceIndex, a1.instanceIndex);
            if ((v12 & 0x10) != 16 && (v21 & 0x10) != 16) continue;
            return true;
        }
        return false;
    }
}

