/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import antlr.collections.AST;
import java.io.File;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.csp.constraints.AbstractConstraint;
import ro.amiq.dvt.csp.constraints.Equals;
import ro.amiq.dvt.csp.constraints.IntConstraint;
import ro.amiq.dvt.csp.constraints.LessEquals;
import ro.amiq.dvt.csp.constraints.LessThan;
import ro.amiq.dvt.csp.constraints.NotEquals;
import ro.amiq.dvt.csp.solver.AbstractSolver;
import ro.amiq.dvt.csp.solver.IExternValidator;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.externaltools.compilescript.FreemarkerConsoleViewer;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.pssdt.model.PSSFileInfo;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ActivityDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.BindDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ConstraintDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.CoverageDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.CoverageModel;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.FieldPoolItemCandidate;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Pool;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.SchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.SolverProblem;
import ro.amiq.pssdt.model.reflection.elaboration.StaticFieldInstances;
import ro.amiq.pssdt.model.reflection.elaboration.debug.SolverDebugger;
import ro.amiq.pssdt.model.reflection.elaboration.foreign.ForeignJavaCompiler;
import ro.amiq.pssdt.model.reflection.elaboration.target.TargetCodeGen;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.RfFieldWrapper;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.SolverConsole;
import ro.amiq.pssdt.model.reflection.elaboration.util.SolverConsoleRegistry;
import ro.amiq.pssdt.model.reflection.elaboration.util.SolverOptions;
import ro.amiq.pssdt.model.reflection.elaboration.util.Stack;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.ModelWalker;

public class Solver {
    public static final BigInteger DEFAULT_RUNTIME_ID = BigInteger.ONE;
    private int fileDescriptor;
    private Map<Integer, RandomAccessFile> fileDescriptors;
    private IProgressMonitor monitor;
    private SolverConsole console;
    private Random random1;
    private Random random2;
    private Random random3;
    private Random random4;
    private Random random5;
    private Scenario scenario;
    private RfProject rfProject;
    private Set<String> reportedMessages;
    private long seed;
    private int canceledQueries;
    private boolean cachedIsCanceled;
    private int pureComponentInstanceIndex = 10000000;
    private RfField rfComponentInstance;
    private List<RfActionCacheEntry> rfAvailableActionsCache;
    private long startTime;
    private String diagramName;
    private StaticFieldInstances staticFieldInstancesHolder;
    private Map<RfCovergroup, Expression.ListExpression> coverageDeclarations;
    private Map<PureFunction, Expression.Value> pureFunctionsCachedResults;
    private Map<RfNamedElement, List<CoverageDescriptor>> coverageDescriptorsMap;
    private Map<Integer, List<ComponentInstance>> pureComponentInstances;
    protected int CONFIG_DEBUG_LEVEL;
    protected int CONFIG_INFERENCE_LIMIT;
    protected int CONFIG_REPEAT_LIMIT;
    protected int CONFIG_SOLUTION_COST;
    protected int CONFIG_PRINT_RADIX;
    protected String CONFIG_TARGET_FILE_PREFIX;
    protected String CONFIG_TARGET_FILE_DIR;
    protected String CONFIG_TARGET_LANGUAGE;
    protected IPath CONFIG_TARGET_TEMPLATE_DIR;
    protected boolean CONFIG_ENABLE_COVERAGE;
    private final ForeignJavaCompiler javaCompiler = ForeignJavaCompiler.INSTANCE;
    private Object foreignInstance;
    private final Map<String, List<String>> targetCodeMap = new HashMap<String, List<String>>();
    protected SolverOptions remainingOptions;
    protected RfPredefinedType stringType;
    protected RfPredefinedType intType;
    protected RfPredefinedType voidType;
    private SolverDebugger debugger;
    private boolean isSolverDone;
    private Runnable notifyUIRunnable;
    private boolean isDisableDebug;
    private boolean isDisablePrint;

    public void setSolverDone(boolean isSolverDone) {
        this.isSolverDone = isSolverDone;
    }

    public boolean isSolverDone() {
        return this.isSolverDone;
    }

    public void setDisablePrint(boolean isDisablePrint) {
        this.isDisablePrint = isDisablePrint;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private boolean isBuildCanceled() {
        if (!DVTPlugin.getDefault().collect().c(this.rfProject.getProject(), "F707373")) {
            return true;
        }
        if (this.monitor == null) {
            return false;
        }
        return this.monitor.isCanceled();
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void checkInterrupted() {
        if (this.canceledQueries % 1000 == 0) {
            this.cachedIsCanceled = this.isBuildCanceled();
        }
        if (this.canceledQueries % 2371 == 0 && !DVTPlugin.getDefault().collect().c(this.rfProject.getProject(), "F707373")) {
            this.cachedIsCanceled = true;
        }
        ++this.canceledQueries;
        if (this.cachedIsCanceled) {
            this.print("*** Error: Interupted process");
            this.init();
            throw new InterruptException();
        }
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public void init() {
        ScenarioUtils.clear();
        ScenarioUtils.setSolver(this);
        this.targetCodeMap.clear();
        this.remainingOptions = new SolverOptions();
        this.cachedIsCanceled = false;
        this.reportedMessages = new HashSet<String>();
        this.rfAvailableActionsCache = null;
        this.staticFieldInstancesHolder = new StaticFieldInstances();
        this.coverageDeclarations = new HashMap<RfCovergroup, Expression.ListExpression>();
        this.coverageDescriptorsMap = new HashMap<RfNamedElement, List<CoverageDescriptor>>();
        this.pureComponentInstances = new HashMap<Integer, List<ComponentInstance>>();
        this.pureFunctionsCachedResults = new HashMap<PureFunction, Expression.Value>();
        this.fileDescriptors = new HashMap<Integer, RandomAccessFile>();
        if (this.scenario != null) {
            this.scenario.clean();
        }
        this.scenario = new Scenario(this);
        CoverageModel.INSTANCE.init();
        if (this.debugger != null) {
            this.debugger.terminate();
        }
        this.debugger = null;
    }

    public void createModel(RfProject rfProject) {
        try {
            IProject project = rfProject.getProject();
            this.isSolverDone = false;
            this.CONFIG_DEBUG_LEVEL = BuildConfigManager.getPssSolverDebugLevel((IProject)project);
            this.CONFIG_INFERENCE_LIMIT = BuildConfigManager.getPssSolverMaxInferenceLimit((IProject)project);
            this.CONFIG_REPEAT_LIMIT = BuildConfigManager.getPssSolverMaxRepeatLimit((IProject)project);
            this.CONFIG_SOLUTION_COST = BuildConfigManager.getPssSolverSolutionCost((IProject)project);
            this.CONFIG_TARGET_FILE_PREFIX = BuildConfigManager.getPssSolverTargetFilePrefix((IProject)project);
            this.CONFIG_TARGET_FILE_DIR = BuildConfigManager.getPssSolverTargetFileDir((IProject)project);
            this.CONFIG_TARGET_LANGUAGE = BuildConfigManager.getPssSolverTargetLanguage((IProject)project);
            this.CONFIG_PRINT_RADIX = BuildConfigManager.getPssSolverPrintRadix((IProject)project);
            this.CONFIG_ENABLE_COVERAGE = BuildConfigManager.getPssEnableCoverage((IProject)project);
            String targetTemplateDir = BuildConfigManager.getPssSolverTargetTemplateDir((IProject)project);
            if (targetTemplateDir == null || targetTemplateDir.isEmpty()) {
                this.CONFIG_TARGET_TEMPLATE_DIR = null;
            } else {
                this.CONFIG_TARGET_TEMPLATE_DIR = Path.fromOSString((String)targetTemplateDir);
                if (!this.CONFIG_TARGET_TEMPLATE_DIR.isAbsolute()) {
                    this.CONFIG_TARGET_TEMPLATE_DIR = project.getLocation().append(targetTemplateDir);
                }
            }
            this.init();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener(event -> {
                try {
                    DVTFileUtils.getInstance().manageLinkedResourceCreation(event.getDelta(), "DVT Auto-Linked");
                    IResource resource = event.getResource();
                    if (resource instanceof IProject && (event.getType() == 2 || event.getType() == 4)) {
                        try {
                            this.init();
                            this.scenario = null;
                        }
                        catch (Exception e1) {
                            DVTLogger.INSTANCE.logError((Throwable)e1);
                        }
                    }
                }
                catch (Exception e2) {
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
            });
            this.rfAvailableActionsCache = null;
            this.rfProject = rfProject;
            this.stringType = rfProject.getPredefinedType("string");
            this.intType = rfProject.getPredefinedType("int");
            this.voidType = rfProject.getPredefinedType("void");
            this.console = SolverConsoleRegistry.getConsole(project);
            Collection<PSSFileInfo> fileInfos = rfProject.getFileInfos();
            if (fileInfos == null) {
                return;
            }
            Set visited = Collections.newSetFromMap(new IdentityHashMap());
            for (PSSFileInfo info : fileInfos) {
                ParserPath parserPath = info.getParserPath();
                RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
                if (visited.contains(fileDef)) {
                    this.print(Utils.append("*** Warning: Ignore duplicate file '", parserPath, "'"));
                    continue;
                }
                visited.add(fileDef);
                this.checkInterrupted();
                AST ast = info.getAST();
                ModelWalker modelWalker = new ModelWalker(this, parserPath);
                modelWalker.model(ast);
                List<AST> templateInstanceASTs = fileDef.getTemplateInstanceASTs();
                for (AST ast2 : templateInstanceASTs) {
                    modelWalker.reparse_template_instance(ast2);
                }
            }
        }
        catch (EvaluationException e) {
            this.console.print(e.getErrorMessage(this.scenario, -1, null));
        }
        catch (InterruptException e) {
            throw e;
        }
        catch (Exception e) {
            ScenarioUtils.printInternalError(rfProject);
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
    }

    public void notifyUIRunnable(Runnable notifyUIRunnable) {
        this.notifyUIRunnable = notifyUIRunnable;
    }

    public String getDiagramName() {
        if (this.scenario.rootAction == null) {
            return Utils.append("[", this.rfProject.getProject().getName(), ": Scenario could not be generated due to errors (see error log)]");
        }
        return this.diagramName;
    }

    /*
     * Exception decompiling
     */
    public void setRootAction(RfField rfInstance, RfStruct rootComponent, RfStruct rootAction, Long keepSeedValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final int random(int min, int max) {
        if (max == Integer.MAX_VALUE) {
            return min + this.random3.nextInt();
        }
        return min + this.random3.nextInt(max - min + 1);
    }

    public final SolverDebugger getDebugger() {
        return this.debugger;
    }

    private final String toString(List<String> content) {
        StringBuilder result = new StringBuilder();
        for (String chunk : content) {
            result.append("\n").append(chunk);
        }
        return result.toString();
    }

    protected final void traverseFirstLevel(ActionInstance actionInstance) {
        boolean isCompoundAction = false;
        try {
            if (actionInstance.isTraversed()) {
                this.print("*** Error: Internal error TFL_1");
                throw new InterruptException();
            }
            actionInstance.setTraversalIndex(++this.scenario.actionInstanceTraversalIndex);
            ActionInstance parentActionInstance = actionInstance;
            while ((parentActionInstance = parentActionInstance.getParentActionInstance()) != null) {
                parentActionInstance.setTraversalIndex(++this.scenario.actionInstanceTraversalIndex);
            }
            RfStruct rfAction = actionInstance.getRfAction();
            List<RfDefElement> activityLayers = rfAction.getActivities();
            if (activityLayers == null || activityLayers.isEmpty()) {
                return;
            }
            ArrayList<ActivityContainer> activityContainers = new ArrayList<ActivityContainer>(activityLayers.size());
            for (RfDefElement activityLayer : activityLayers) {
                this.checkInterrupted();
                AST nodeAST = activityLayer.getNodeAST();
                if (nodeAST == null) continue;
                activityContainers.add(new ActivityContainer(nodeAST, activityLayer.getParserPath()));
            }
            ActionInstance parentActionInstance2 = actionInstance;
            if (activityContainers.size() > 1) {
                parentActionInstance2 = new ActionInstance.ScheduleActionInstance("[schedule]", actionInstance.runtimeId, this.scenario);
                actionInstance.addChildAction(parentActionInstance2);
            }
            for (ActivityContainer activityContainer : activityContainers) {
                this.checkInterrupted();
                ActionInstance.SequenceActionInstance sequenceActionInstance = new ActionInstance.SequenceActionInstance("[sequence]", actionInstance.runtimeId, this.scenario);
                parentActionInstance2.addChildAction(sequenceActionInstance);
                this.pushActivityDescriptor(new ActivityDescriptor.RemoveEmptyBlockDescriptor(this, sequenceActionInstance, -1, null));
                ModelWalker modelWalker = new ModelWalker(this, activityContainer.parserPath);
                modelWalker.addConstraintDescriptors(activityContainer.activityAST, sequenceActionInstance, false);
                modelWalker.addActivityDescriptors(activityContainer.activityAST, sequenceActionInstance, false);
                isCompoundAction = true;
            }
        }
        finally {
            actionInstance.solve();
            if (isCompoundAction) {
                actionInstance.postSolve();
            }
        }
    }

    private void resolveScheduleActivities(Runnable runnable) {
        ArrayList schedulingInstances = new ArrayList();
        InstanceVisitor<ActionInstance> visitor = candidate -> {
            this.checkInterrupted();
            if (candidate instanceof ActionInstance.ScheduleActionInstance) {
                ActionInstance parentActionInstance = candidate;
                while ((parentActionInstance = parentActionInstance.parentActionInstance) != null) {
                    if (!(parentActionInstance instanceof ActionInstance.ScheduleActionInstance)) continue;
                    return true;
                }
                schedulingInstances.add((ActionInstance.ScheduleActionInstance)candidate);
            }
            return true;
        };
        ((ActionInstance)((Object)this.scenario.rootAction)).accept(visitor);
        block2: for (ActionInstance.ScheduleActionInstance candidate2 : schedulingInstances) {
            this.checkInterrupted();
            candidate2 = (ActionInstance.ScheduleActionInstance)this.scenario.restore(candidate2);
            ActionInstance holderActionInstance = new ActionInstance.SequenceActionInstance("[sequence]", candidate2.runtimeId, this.scenario);
            ActionInstance parentActionInstance = null;
            List<ActionInstance> childrenActionInstances = candidate2.parentActionInstance.childrenActionInstances;
            int index = childrenActionInstances.indexOf(candidate2);
            childrenActionInstances.set(index, holderActionInstance);
            parentActionInstance = candidate2.parentActionInstance;
            List<ActionInstance> children = Solver.getChildrenRecursive(candidate2);
            if (children == null || children.isEmpty()) continue;
            ArrayList<InstanceIndex> scheduleIndexes = new ArrayList<InstanceIndex>();
            for (ActionInstance actionInstance : children) {
                this.checkInterrupted();
                actionInstance.parentActionInstance = null;
                scheduleIndexes.add(new InstanceIndex(actionInstance));
            }
            Collections.shuffle(scheduleIndexes, this.random1);
            ArrayList firstIndexOptions = new ArrayList(scheduleIndexes);
            int shuffleCount = 1;
            while (true) {
                Scenario.LightSnapshot snapshot = this.scenario.saveState();
                try {
                    ArrayList<InstanceIndex> scheduleIndexesCopy = new ArrayList<InstanceIndex>(scheduleIndexes);
                    holderActionInstance = this.scenario.restore(holderActionInstance);
                    int firstOrphanActionIndex = this.pickIndex(firstIndexOptions.size());
                    InstanceIndex instanceIndex = (InstanceIndex)firstIndexOptions.remove(firstOrphanActionIndex);
                    ActionInstance actionInstance = instanceIndex.getActionInstance(this.scenario);
                    scheduleIndexesCopy.remove(firstOrphanActionIndex);
                    holderActionInstance.addChildAction(actionInstance);
                    holderActionInstance.parentActionInstance = this.scenario.restore(parentActionInstance);
                    this.printDebug1(Utils.append("*** Info: Scheduling start action '", actionInstance, "'"));
                    this.insertOrphanAction(scheduleIndexesCopy, runnable, new AtomicInteger(0));
                    continue block2;
                }
                catch (SchedulerProxy.SchedulingException | SolverException e) {
                    if (firstIndexOptions.isEmpty()) {
                        if (shuffleCount < 10) {
                            Collections.shuffle(scheduleIndexes, this.random1);
                            firstIndexOptions = new ArrayList(scheduleIndexes);
                            ++shuffleCount;
                            this.printDebug1("*** Info: Re-shuffle scheduling actions");
                        } else {
                            throw e;
                        }
                    }
                    this.scenario.restoreState(snapshot);
                    this.printDebug1("*** Info: Backtracking (chose different scheduling start action)");
                    continue;
                }
                break;
            }
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    protected static final List<ActionInstance> getChildrenRecursive(ActionInstance actionInstance) {
        ArrayList<ActionInstance> children = new ArrayList<ActionInstance>();
        InstanceVisitor<ActionInstance> visitor = instance -> {
            if (instance instanceof ISchedulingInstance) {
                return true;
            }
            if (instance.isCompound()) {
                instance.setSkipCompound();
                return true;
            }
            children.add((ActionInstance)instance);
            return true;
        };
        actionInstance.accept(visitor);
        return children;
    }

    protected final String getActionInstanceName(String name, int index, RfStruct rfAction) {
        if ("[symbol]".equals(name)) {
            return Utils.append("[s_", index, ":", rfAction.getElabName(), "]");
        }
        if ("[anonymous]".equals(name)) {
            return Utils.append("[a_", index, ":", rfAction.getElabName(), "]");
        }
        if ("[inferred]".equals(name)) {
            return Utils.append("[i_", index, ":", rfAction.getElabName(), "]");
        }
        return name;
    }

    private final List<ComponentInstance> getComponentInstances(RfStruct rfComponent) {
        ArrayList<ComponentInstance> result = new ArrayList<ComponentInstance>();
        InstanceVisitor<ComponentInstance> visitor = instance -> {
            this.checkInterrupted();
            if (this.rfComponentInstance == instance.getRfField()) {
                result.clear();
                result.add((ComponentInstance)instance);
                return false;
            }
            if (rfComponent == instance.getRfComponent()) {
                result.add((ComponentInstance)instance);
            }
            return true;
        };
        this.scenario.rootComponent.accept(visitor);
        return result;
    }

    private final void insertInferredActions() {
        LinkedHashSet<InstanceIndex> inferredIndexes = new LinkedHashSet<InstanceIndex>();
        for (ActionInstance actionInstance : this.scenario.actionInstances) {
            this.checkInterrupted();
            if (actionInstance.parentActionInstance != null) continue;
            inferredIndexes.add(new InstanceIndex(actionInstance));
        }
        this.insertOrphanAction(inferredIndexes, null, new AtomicInteger(0));
    }

    private final void insertOrphanAction(Collection<InstanceIndex> orphanIndexes, Runnable runnable, AtomicInteger solutionCost) {
        ArrayList sortedOrphanIndexes = null;
        HashMap<InstanceIndex, ArrayList<InsertionOption>> orphanIndexesOptions = new HashMap<InstanceIndex, ArrayList<InsertionOption>>();
        boolean hasRemainingOrphans = false;
        for (InstanceIndex orphanActionIndex : orphanIndexes) {
            this.checkInterrupted();
            ActionInstance orphanActionInstance = orphanActionIndex.getActionInstance(this.scenario);
            if (!orphanActionInstance.isOrphan()) continue;
            hasRemainingOrphans = true;
            ArrayList<InsertionOption> insertionOptions = new ArrayList<InsertionOption>();
            this.collectInsertionOptions(insertionOptions, orphanActionInstance);
            if (insertionOptions.isEmpty()) continue;
            orphanIndexesOptions.put(orphanActionIndex, insertionOptions);
        }
        if (orphanIndexesOptions.isEmpty()) {
            if (hasRemainingOrphans) {
                throw new SolverException(Utils.append("Cannot insert orphan actions"));
            }
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        sortedOrphanIndexes = new ArrayList(orphanIndexesOptions.entrySet());
        sortedOrphanIndexes.sort((o1, o2) -> ((List)o1.getValue()).size() - ((List)o2.getValue()).size());
        Map.Entry indexEntry = Utils.first(sortedOrphanIndexes);
        InstanceIndex orphanActionIndex = (InstanceIndex)indexEntry.getKey();
        List insertionOptions = (List)indexEntry.getValue();
        ActionInstance orphanActionInstance = orphanActionIndex.getActionInstance(this.scenario);
        if (insertionOptions.isEmpty()) {
            this.logError(Utils.append("*** Error: Cannot insert orphan action '", orphanActionInstance, "'"));
            throw new SolverException();
        }
        this.scenario.lightClean();
        Scenario.LightSnapshot snapshot = insertionOptions.size() > 1 ? this.scenario.saveState() : null;
        while (true) {
            this.checkInterrupted();
            try {
                if (insertionOptions.isEmpty()) {
                    throw new SolverException();
                }
                int insertionOptionIndex = this.pickIndex(insertionOptions.size());
                InsertionOption insertionOption = (InsertionOption)insertionOptions.remove(insertionOptionIndex);
                int actionIndex = insertionOption.actionIndex;
                ActionInstance actionInstance = this.scenario.getActionInstance(actionIndex);
                SchedulingKind schedulingKind = insertionOption.schedulingKind;
                switch (schedulingKind) {
                    case PARALLEL: {
                        this.printDebug1(Utils.append("*** Info: Insert '", orphanActionInstance, "' in parallel with '", actionInstance, "'"));
                        orphanActionInstance.insertParallel(actionInstance);
                        break;
                    }
                    case BEFORE: {
                        this.printDebug1(Utils.append("*** Info: Insert '", orphanActionInstance, "' before '", actionInstance, "'"));
                        orphanActionInstance.insertBefore(actionInstance, false);
                        break;
                    }
                    case AFTER: {
                        this.printDebug1(Utils.append("*** Info: Insert '", orphanActionInstance, "' after '", actionInstance, "'"));
                        orphanActionInstance.insertBefore(actionInstance, true);
                        break;
                    }
                }
                this.checkResourcePoolSchedulingConsistency();
                solutionCost.incrementAndGet();
                this.insertOrphanAction(orphanIndexes, runnable, solutionCost);
            }
            catch (SchedulerProxy.SchedulingException | SolverException runtimeException) {
                if (solutionCost.get() > this.CONFIG_SOLUTION_COST && this.remainingOptions.hasRemainingOptions()) {
                    throw new SolverException();
                }
                if (insertionOptions.isEmpty()) {
                    this.printDebug1(Utils.append("*** Warning: Cannot insert orphan action '", orphanActionInstance, "'"));
                    throw new SolverException(Utils.append("Cannot insert orphan action '", orphanActionInstance, "'"));
                }
                this.scenario.restoreState(snapshot);
                orphanActionInstance = orphanActionIndex.getActionInstance(this.scenario);
                this.printDebug1(Utils.append("*** Info: Backtracking (chose different scheduling for '", orphanActionInstance, "')"));
                continue;
            }
            break;
        }
    }

    private final void collectInsertionOptions(List<InsertionOption> insertionOptions, ActionInstance orphanActionInstance) {
        for (ActionInstance actionInstance : this.scenario.actionInstances) {
            this.checkInterrupted();
            if (actionInstance == orphanActionInstance || actionInstance.isSkipCompound() || actionInstance.isCompound() || actionInstance.isOrphan()) continue;
            int index = actionInstance.getInstanceIndex();
            boolean isParallel = this.isParallel(orphanActionInstance, actionInstance);
            if (isParallel) {
                insertionOptions.clear();
                insertionOptions.add(new InsertionOption(SchedulingKind.PARALLEL, index));
                break;
            }
            if (this.canInsertParallel(orphanActionInstance, actionInstance)) {
                insertionOptions.add(new InsertionOption(SchedulingKind.PARALLEL, index));
            }
            ActionInstance parentActionInstance = null;
            ActionInstance tempParentActionInstance = actionInstance.getParentActionInstance();
            while (tempParentActionInstance != null && this.isParallel(actionInstance, tempParentActionInstance)) {
                parentActionInstance = tempParentActionInstance;
                tempParentActionInstance = tempParentActionInstance.getParentActionInstance();
            }
            if (parentActionInstance != null && this.canInsertBefore(orphanActionInstance, parentActionInstance)) {
                insertionOptions.add(new InsertionOption(SchedulingKind.BEFORE, parentActionInstance.getInstanceIndex()));
            } else if (parentActionInstance == null && this.canInsertBefore(orphanActionInstance, actionInstance)) {
                insertionOptions.add(new InsertionOption(SchedulingKind.BEFORE, index));
            }
            if (!this.canInsertBefore(actionInstance, orphanActionInstance)) continue;
            insertionOptions.add(new InsertionOption(SchedulingKind.AFTER, index));
        }
    }

    private final boolean canInsertBefore(ActionInstance a1, ActionInstance a2) {
        ArrayList<ActionInstance> concurentActions1 = new ArrayList<ActionInstance>();
        ArrayList<ActionInstance> parallelActions1 = new ArrayList<ActionInstance>();
        a1.collectConcurrentActions(concurentActions1, parallelActions1, null);
        if (this.scenario.scheduler.hasTemporalDependency(a2, concurentActions1, parallelActions1)) {
            return false;
        }
        ArrayList<ActionInstance> concurentActions2 = new ArrayList<ActionInstance>();
        ArrayList<ActionInstance> parallelActions2 = new ArrayList<ActionInstance>();
        a2.collectConcurrentActions(concurentActions2, parallelActions2, null);
        if (this.scenario.scheduler.hasTemporalDependency(a1, concurentActions2, parallelActions2)) {
            return false;
        }
        boolean[] canInsertBefore = new boolean[]{this.scenario.scheduler.canInsertBefore(a1, a2)};
        if (!canInsertBefore[0]) {
            return false;
        }
        InstanceVisitor<ComponentInstance> visitor = componentInstance -> {
            this.checkInterrupted();
            blArray[0] = canInsertBefore[0] & componentInstance.canInsertBefore(a1, a2);
            return true;
        };
        this.scenario.rootComponent.accept(visitor);
        return canInsertBefore[0];
    }

    private final boolean canInsertParallel(ActionInstance a1, ActionInstance a2) {
        if (a1.isInitialStateObject() || a2.isInitialStateObject()) {
            return false;
        }
        if (!this.scenario.scheduler.canInsertParallel(a1, a2)) {
            return false;
        }
        ArrayList<ActionInstance> concurentActions1 = new ArrayList<ActionInstance>();
        ArrayList<ActionInstance> parallelActions1 = new ArrayList<ActionInstance>();
        a1.collectConcurrentActions(concurentActions1, parallelActions1, null);
        if (this.scenario.scheduler.hasTemporalDependency(a2, concurentActions1, parallelActions1)) {
            return false;
        }
        ArrayList<ActionInstance> concurentActions2 = new ArrayList<ActionInstance>();
        ArrayList<ActionInstance> parallelActions2 = new ArrayList<ActionInstance>();
        a2.collectConcurrentActions(concurentActions2, parallelActions2, null);
        return !this.scenario.scheduler.hasTemporalDependency(a1, concurentActions2, parallelActions2);
    }

    protected final void checkResourcePoolSchedulingConsistency() {
        InstanceVisitor<ComponentInstance> visitor = componentInstance -> {
            this.checkInterrupted();
            componentInstance.checkResourcePoolSchedulingConsistency();
            return true;
        };
        this.scenario.rootComponent.accept(visitor);
    }

    protected final void collectStateObjectPools(List<Pool> poolCandidates) {
        InstanceVisitor<ComponentInstance> visitor = componentInstance -> {
            this.checkInterrupted();
            componentInstance.collectStateObjectPools(poolCandidates);
            return true;
        };
        this.scenario.rootComponent.accept(visitor);
    }

    protected boolean checkConnectConstraint(boolean logContradiction, boolean isStoreResult, PortInstance ... portInstances) {
        ArrayList<InstancesContainer.RestoreConnect> restoreConnects = new ArrayList<InstancesContainer.RestoreConnect>(portInstances.length - 1);
        PortInstance lastPortInstance = portInstances[portInstances.length - 1];
        int i = 0;
        while (i < portInstances.length - 1) {
            PortInstance portInstance = portInstances[i];
            InstancesContainer.RestoreConnect restoreConnect = InstancesContainer.connect(portInstance, lastPortInstance);
            restoreConnects.add(restoreConnect);
            ++i;
        }
        List<ActionInstance> actionInstances = this.scenario.getConnectedActions(portInstances);
        PortInstance[] portInstanceArray = portInstances;
        int n = portInstances.length;
        int restoreConnect = 0;
        while (restoreConnect < n) {
            PortInstance fieldInstance = portInstanceArray[restoreConnect];
            ActionInstance actionInstance = fieldInstance.getParentActionInstance();
            if (actionInstance == null) {
                fieldInstance.preSolve();
            } else {
                actionInstance.preSolve();
            }
            ++restoreConnect;
        }
        boolean hasSolution = this.solveConstraints(false, false, logContradiction, isStoreResult, actionInstances.toArray(new ActionInstance[actionInstances.size()]));
        int i2 = restoreConnects.size() - 1;
        while (i2 >= 0) {
            InstancesContainer.disconnect((InstancesContainer.RestoreConnect)restoreConnects.get(i2));
            --i2;
        }
        return hasSolution;
    }

    protected boolean checkConnectConstraint(boolean reportSolution, boolean reportContradiction, boolean logContradiction, ActionInstance ... actionInstances) {
        List<ActionInstance> dependentActionInstances = this.scenario.getConnectedActions(actionInstances);
        for (ActionInstance actionInstance : dependentActionInstances) {
            actionInstance.preSolve();
        }
        return this.solveConstraints(reportSolution, reportContradiction, logContradiction, true, dependentActionInstances.toArray(new ActionInstance[dependentActionInstances.size()]));
    }

    protected final boolean solveConstraints(boolean reportSolution, boolean reportContradiction, boolean logContradiction, boolean isStoreResult, ActionInstance ... actionInstances) {
        this.scenario.initSolverExpressionsErrors();
        Model model = new Model(() -> ((IProgressMonitor)this.monitor).isCanceled(), this.scenario.stringVariableMapping);
        LinkedHashMap<String, InstancesContainer.GeneratedVar> variableSolverMap = new LinkedHashMap<String, InstancesContainer.GeneratedVar>();
        IdentityHashMap<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap = new IdentityHashMap<AbstractConstraint, ConstraintDescriptor.Text>();
        long seed = Long.MAX_VALUE;
        Set<InstancesContainer> alreadyVisited = Utils.popReusableSet(InstancesContainer.class);
        try {
            ActionInstance[] actionInstanceArray = actionInstances;
            int n = actionInstances.length;
            int n2 = 0;
            while (n2 < n) {
                ActionInstance actionInstance = actionInstanceArray[n2];
                if (actionInstance != null) {
                    Stack<String> varNameStack = new Stack<String>();
                    varNameStack.push(actionInstance.getHierarchicalPath().toString());
                    this.declareVariables(varNameStack, actionInstance, model, variableSolverMap);
                    seed = Math.min(seed, actionInstance.seed);
                    this.scenario.applyConstraints(model, variableSolverMap, alreadyVisited, actionInstance, cspToReadableTextMap);
                }
                ++n2;
            }
        }
        finally {
            Utils.pushReusableSet(alreadyVisited);
        }
        this.printDebug2("*** Info: Check constraints ...");
        List cspConstraints = model.getConstraints();
        if (this.CONFIG_DEBUG_LEVEL > 1 && !cspConstraints.isEmpty()) {
            HashSet<String> alreadyPrinted = new HashSet<String>();
            for (AbstractConstraint cspConstraint : cspConstraints) {
                String text;
                ConstraintDescriptor.Text constraintAsText = (ConstraintDescriptor.Text)cspToReadableTextMap.get(cspConstraint);
                if (constraintAsText == null || alreadyPrinted.contains(text = constraintAsText.lazyText.toString())) continue;
                alreadyPrinted.add(text);
                this.print(Utils.append("\u2007   ", text));
            }
        }
        boolean hasSolution = this.cspSolve(reportSolution, reportContradiction, logContradiction, isStoreResult, model, variableSolverMap, cspToReadableTextMap, seed);
        this.scenario.printSolverExpressionsErrors();
        return hasSolution;
    }

    public boolean cspSolve(boolean reportSolution, boolean reportContradiction, boolean logContradiction, boolean isStoreResult, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, long seed) {
        model.getSolver().getOptions().setSeed(seed);
        model.getSolver().setCustomValidator((IExternValidator)new SolverCustomValidator(cspToReadableTextMap));
        boolean hasSolution = model.getSolver().findFirst();
        if (model.getSolver().getErrorMessage() != null) {
            this.print(Utils.append("*** Warning: ", model.getSolver().getErrorMessage()));
        }
        if (hasSolution) {
            if (isStoreResult) {
                for (InstancesContainer.GeneratedVar generatedVar : variableSolverMap.values()) {
                    generatedVar.storeValue(this.scenario);
                }
            }
            if (this.CONFIG_DEBUG_LEVEL > 1 || reportSolution) {
                this.reportSolution(variableSolverMap);
            }
            this.reportIgnoredSoft(model, cspToReadableTextMap);
        } else if (this.CONFIG_DEBUG_LEVEL > 1 || reportContradiction || logContradiction) {
            this.reportContradiction(model, logContradiction, variableSolverMap, cspToReadableTextMap);
        }
        return hasSolution;
    }

    private final void applyExecDescriptors(ExecBlockKind execKind) {
        switch (execKind) {
            case RUN_START: 
            case RUN_END: {
                for (ActionInstance actionInstance : this.scenario.actionInstances) {
                    actionInstance.applyExecDescriptors(null, null, execKind, actionInstance.getRfAction());
                }
                break;
            }
            case BODY: {
                try {
                    InstanceVisitor<ActionInstance> visitor = candidate -> {
                        candidate.targetCode(ExecBlockKind.HEADER);
                        candidate.targetCode(ExecBlockKind.DECLARATION);
                        candidate.targetCode(ExecBlockKind.FILE);
                        candidate.targetCode(ExecBlockKind.BODY);
                        return true;
                    };
                    ((ActionInstance)((Object)this.scenario.rootAction)).accept(visitor);
                    ActionInstance rootActionInstance = (ActionInstance)((Object)this.scenario.rootAction);
                    String bodyTargetCode = rootActionInstance.getTargetCode(this.CONFIG_TARGET_LANGUAGE, this.CONFIG_TARGET_TEMPLATE_DIR);
                    this.putTargetCode(ExecBlockKind.BODY.toString(), bodyTargetCode);
                }
                catch (Exception e) {
                    ScenarioUtils.printInternalError(this.rfProject);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                break;
            }
        }
    }

    protected static String getTargetCode(String templateFileName, IPath externTemplateDirLocation, Object targetModel) {
        try {
            return TargetCodeGen.INSTANCE.getContent(templateFileName, externTemplateDirLocation, targetModel);
        }
        catch (Exception e) {
            FreemarkerConsoleViewer.INSTANCE.print(e.getMessage(), null);
            return "";
        }
    }

    protected final boolean solveInitialStateObjectConstraints(FieldInstance fieldInstance, boolean reportContradiction, boolean reportSolution, long seed) {
        this.scenario.initSolverExpressionsErrors();
        Model model = new Model(() -> ((IProgressMonitor)this.monitor).isCanceled(), this.scenario.stringVariableMapping);
        LinkedHashMap<String, InstancesContainer.GeneratedVar> variableSolverMap = new LinkedHashMap<String, InstancesContainer.GeneratedVar>();
        IdentityHashMap<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap = new IdentityHashMap<AbstractConstraint, ConstraintDescriptor.Text>();
        Stack<String> varNameStack = new Stack<String>();
        varNameStack.push(fieldInstance.getHierarchicalPath().toString());
        this.declareVariables(varNameStack, fieldInstance, model, variableSolverMap);
        this.scenario.applyInitialStateObjectConstraints(fieldInstance, model, variableSolverMap, cspToReadableTextMap);
        List cspConstraints = model.getConstraints();
        if (this.CONFIG_DEBUG_LEVEL > 1 && !cspConstraints.isEmpty()) {
            HashSet<String> alreadyPrinted = new HashSet<String>();
            for (AbstractConstraint cspConstraint : cspConstraints) {
                String text;
                ConstraintDescriptor.Text constraintAsText = (ConstraintDescriptor.Text)cspToReadableTextMap.get(cspConstraint);
                if (constraintAsText == null || alreadyPrinted.contains(text = constraintAsText.lazyText.toString())) continue;
                alreadyPrinted.add(text);
                this.print(Utils.append("\u2007   ", text));
            }
        }
        model.getSolver().getOptions().setSeed(seed);
        boolean hasSolution = model.getSolver().findFirst();
        if (hasSolution) {
            for (InstancesContainer.GeneratedVar generatedVar : variableSolverMap.values()) {
                generatedVar.storeValue(this.scenario);
            }
            if (this.CONFIG_DEBUG_LEVEL > 1 || reportSolution) {
                this.reportSolution(variableSolverMap);
            }
            this.reportIgnoredSoft(model, cspToReadableTextMap);
        } else if (this.CONFIG_DEBUG_LEVEL > 1 || reportContradiction) {
            this.reportContradiction(model, false, variableSolverMap, cspToReadableTextMap);
        }
        this.scenario.printSolverExpressionsErrors();
        return hasSolution;
    }

    private final void declareVariables(Stack<String> varNameStack, InstancesContainer instancesContainer, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap) {
        Map<String, FieldInstance> fieldInstances = instancesContainer.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            RfField rfField = instancesContainer.getRfField();
            if (Utils.isRand(rfField)) {
                RfNamedElement rfInstanceType;
                String name = instancesContainer.getDiagramName();
                if (rfField instanceof RfPredefinedField && "initial".equals(name)) {
                    return;
                }
                if (instancesContainer instanceof FieldInstance && ((FieldInstance)instancesContainer).getParentInstance() instanceof FieldInstance && (rfInstanceType = ((FieldInstance)((FieldInstance)instancesContainer).getParentInstance()).getRfFieldType()) instanceof RfCollectionType && ("size".equals(name) || "sum".equals(name))) {
                    return;
                }
                StringBuilder varName = new StringBuilder(varNameStack.getFirst());
                ListIterator<String> iterator = varNameStack.listIterator(1);
                while (iterator.hasNext()) {
                    varName.append(".").append(iterator.next());
                }
                if (!variableSolverMap.containsKey(varName.toString())) {
                    if (model == null) {
                        instancesContainer.getVariable(varName.toString(), variableSolverMap);
                    } else {
                        instancesContainer.getVariable(model, varName.toString(), instancesContainer.getHierarchicalPath(), variableSolverMap, false);
                    }
                }
            }
            return;
        }
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if (fieldInstance instanceof PortInstance.StatePrevPortInstance || fieldInstance.isUniqueIdField() || Expression.Value.isReference(fieldInstance.variableValue)) continue;
            String restoreArrayName = varNameStack.peek();
            boolean isArrayItem = fieldInstance.isArrayItem();
            if (isArrayItem) {
                String arrayItemName = Utils.append(restoreArrayName, "[", fieldInstance.arrayItemIndex, "]");
                varNameStack.pop();
                varNameStack.push(arrayItemName);
            } else {
                varNameStack.push(fieldInstance.getDiagramName());
            }
            this.declareVariables(varNameStack, fieldInstance, model, variableSolverMap);
            varNameStack.pop();
            if (!isArrayItem) continue;
            varNameStack.push(restoreArrayName);
        }
    }

    private final void reportFinalSolution() {
        try {
            LinkedHashMap<String, InstancesContainer.GeneratedVar> variableSolverMap = new LinkedHashMap<String, InstancesContainer.GeneratedVar>();
            InstanceVisitor<ActionInstance> visitor = candidate -> {
                this.checkInterrupted();
                if (candidate instanceof ISchedulingInstance) {
                    return true;
                }
                Stack<String> varNameStack = new Stack<String>();
                varNameStack.push(candidate.getHierarchicalPath().toString());
                this.declareVariables(varNameStack, (InstancesContainer)candidate, null, (Map<String, InstancesContainer.GeneratedVar>)variableSolverMap);
                return true;
            };
            ((ActionInstance)((Object)this.scenario.rootAction)).accept(visitor);
            this.reportSolution(variableSolverMap);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private final void reportSolution(Map<String, InstancesContainer.GeneratedVar> variableSolverMap) {
        try {
            if (!variableSolverMap.isEmpty()) {
                this.print("*** Info: Solution found ...");
            }
            ArrayList<String> variableNames = new ArrayList<String>(variableSolverMap.keySet());
            StringBuilder message = new StringBuilder();
            int size = variableNames.size();
            int i = 0;
            while (i < size) {
                String variableValue;
                RfNamedElement arrayItemType;
                String varName = (String)variableNames.get(i);
                InstancesContainer.GeneratedVar generatedVar = variableSolverMap.get(varName);
                if (!(generatedVar.instance == null || generatedVar.instance.getRfField().isIndex() || generatedVar.instance.isStructType() || !generatedVar.instance.isRand() && generatedVar.instance.isEnumType() || generatedVar.instance.isCollectionType() && ((arrayItemType = Utils.getArrayItemType((RfCollectionType)generatedVar.instance.getRfFieldType())) instanceof RfStruct || arrayItemType instanceof RfCollectionType) || varName.equals(variableValue = generatedVar.toStringVariableValue()))) {
                    if (message.length() > 0) {
                        message.append("\n");
                    }
                    message.append("\u2007   ").append(varName).append(" = ").append(variableValue);
                }
                ++i;
            }
            if (message.length() > 0) {
                this.print(message.toString());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected final void reportIgnoredSoft(Model model, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap) {
        ro.amiq.dvt.csp.solver.Solver solver = model.getSolver();
        List cspConstraintsIgnored = solver.getIgnoredSoftConstraints(cspToReadableTextMap.keySet());
        if (cspConstraintsIgnored.isEmpty()) {
            return;
        }
        HashSet<String> alreadyPrinted = new HashSet<String>();
        ArrayList<String> constraintMessages = new ArrayList<String>();
        LinkedHashSet<String> lineFileMessages = new LinkedHashSet<String>();
        for (AbstractConstraint cspConstraint : cspConstraintsIgnored) {
            String text;
            ConstraintDescriptor.Text constraintAsText = cspToReadableTextMap.get(cspConstraint);
            if (constraintAsText == null || alreadyPrinted.contains(text = constraintAsText.lazyText.toString())) continue;
            alreadyPrinted.add(text);
            constraintMessages.add(Utils.append("    ", text));
            lineFileMessages.add(Utils.append("    ", "at line ", constraintAsText.line, " in ", constraintAsText.parserPath));
        }
        StringBuilder message = new StringBuilder();
        message.append("*** Warning: Ignored soft constraints ...");
        for (String constraintMessage : constraintMessages) {
            message.append("\n").append(constraintMessage);
        }
        for (String lineFileMessage : lineFileMessages) {
            message.append("\n").append(lineFileMessage);
        }
        this.print(message.toString(), true);
        solver.reset();
    }

    protected final void reportContradiction(Model model, boolean logContradiction, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap) {
        InstancesContainer.GeneratedVar generatedVar;
        RfDefElement declaration;
        ro.amiq.dvt.csp.solver.Solver solver = model.getSolver();
        List cspConstraintsContradiction = solver.getContradiction(cspToReadableTextMap.keySet());
        if (cspConstraintsContradiction.isEmpty()) {
            return;
        }
        HashSet<String> alreadyPrinted = new HashSet<String>();
        ArrayList<String> constraintMessages = new ArrayList<String>();
        ArrayList<String> lineFileMessages = new ArrayList<String>();
        Variable variableDeclaration = null;
        for (AbstractConstraint cspConstraint : cspConstraintsContradiction) {
            String text;
            ConstraintDescriptor.Text constraintAsText = cspToReadableTextMap.get(cspConstraint);
            if (variableDeclaration == null && (cspConstraint instanceof Equals || cspConstraint instanceof NotEquals || cspConstraint instanceof LessThan || cspConstraint instanceof LessEquals)) {
                Variable variable = variableDeclaration = cspConstraint.getVariables()[0].isAnonymous() ? cspConstraint.getVariables()[1] : cspConstraint.getVariables()[0];
            }
            if (constraintAsText == null || alreadyPrinted.contains(text = constraintAsText.lazyText.toString())) continue;
            alreadyPrinted.add(text);
            constraintMessages.add(Utils.append("    ", text));
            if (constraintAsText.parserPath == null) continue;
            lineFileMessages.add(Utils.append("    ", "at line ", constraintAsText.line, " in ", constraintAsText.parserPath));
        }
        if (constraintMessages.size() == 1 && variableDeclaration != null && (declaration = ScenarioUtils.getDeclaration(generatedVar = variableSolverMap.get(variableDeclaration.getName()))) != null) {
            constraintMessages.add(0, Utils.append("    ", "var ", variableDeclaration.getName(), generatedVar.inDeclarationDomain));
            lineFileMessages.add(0, Utils.append("    ", "at line ", declaration.getStartLine(), " in ", declaration.getParserPath()));
        }
        if (constraintMessages.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("*** Error: Constraints contradiction ...");
        for (String constraintMessage : constraintMessages) {
            message.append("\n").append(constraintMessage);
        }
        for (String lineFileMessage : lineFileMessages) {
            message.append("\n").append(lineFileMessage);
        }
        if (logContradiction) {
            this.scenario.logProblem(SolverProblem.Severity.ERROR, message.toString(), null, null);
        } else {
            this.print(message.toString());
        }
        solver.reset();
    }

    protected final void postConnectConstraints(PortInstance portInstance1, PortInstance portInstance2) {
        InstancesContainer.connect(portInstance1, portInstance2);
        this.scenario.postConnectConstraint(portInstance1, portInstance2);
        ActionInstance parentActionInstance1 = portInstance1.getParentActionInstance();
        ActionInstance parentActionInstance2 = portInstance2.getParentActionInstance();
        if (parentActionInstance1 == null || parentActionInstance2 == null || parentActionInstance1.isCompoundAction() || parentActionInstance2.isCompoundAction()) {
            portInstance1.setCurrentSolveState(ExecBlockKind.SOLVE_COMPOUND);
            portInstance2.setCurrentSolveState(ExecBlockKind.SOLVE_COMPOUND);
        }
    }

    protected final <T> T pickCandidate(List<T> connectCandidates) {
        int size = connectCandidates.size();
        int index = this.pickIndex(size);
        return connectCandidates.get(index);
    }

    public final int pickIndex(int size) {
        return size == 0 ? 0 : Math.abs(this.random1.nextInt() % size);
    }

    public final int pickIndex(int size, Random random) {
        return size == 0 ? 0 : random.nextInt(size);
    }

    public final void addBindDescriptor(RfStruct rfComponent, Expression.Hid fieldHierarchical1, Expression.Hid fieldHierarchical2, int line, ParserPath parserPath) {
        if (rfComponent.getClass() == RfTemplateStruct.class) {
            return;
        }
        List<BindDescriptor.PoolBindDescriptor> binds = this.scenario.poolBindDescriptors.get(rfComponent);
        if (binds == null) {
            binds = new ArrayList<BindDescriptor.PoolBindDescriptor>();
            this.scenario.poolBindDescriptors.put(rfComponent, binds);
        }
        binds.add(new BindDescriptor.PoolBindDescriptor(rfComponent, fieldHierarchical1, fieldHierarchical2, line, parserPath));
    }

    public final void addBindDescriptor(ActionInstance actionInstance, Expression.Hid fieldHierarchical1, Expression.Hid fieldHierarchical2, int line, ParserPath parserPath) {
        List<BindDescriptor.PortBindDescriptor> binds = this.scenario.portBindDescriptors.get(actionInstance);
        if (binds == null) {
            binds = new ArrayList<BindDescriptor.PortBindDescriptor>();
            this.scenario.portBindDescriptors.put(actionInstance, binds);
        }
        binds.add(new BindDescriptor.PortBindDescriptor(actionInstance, fieldHierarchical1, fieldHierarchical2, line, parserPath));
    }

    public final void addConstraintDescriptor(ActionInstance actionInstance, String constraintName, Expression expr, boolean isInline) {
        List<ConstraintDescriptor> inlineConstraints = this.scenario.inlineConstraintDescriptors.get(actionInstance);
        if (inlineConstraints == null) {
            inlineConstraints = new ArrayList<ConstraintDescriptor>();
            this.scenario.inlineConstraintDescriptors.put(actionInstance, inlineConstraints);
        }
        inlineConstraints.add(new ConstraintDescriptor(constraintName, expr, isInline, -1, false));
    }

    public void addConstraintDescriptor(RfNamedElement enclosingScope, String constraintName, Expression expr, boolean isInline) {
        RfNamedElement wrappedElement;
        RfField rfField;
        if (enclosingScope.getClass() == RfTemplateStruct.class) {
            return;
        }
        List<ConstraintDescriptor> constraints = this.scenario.constraintDescriptors.get(enclosingScope);
        if (constraints == null) {
            constraints = new ArrayList<ConstraintDescriptor>();
            this.scenario.constraintDescriptors.put(enclosingScope, constraints);
        }
        if (expr instanceof Expression.Hid && (rfField = ((Expression.Hid)expr).getLastField()) instanceof RfFieldWrapper && (wrappedElement = ((RfFieldWrapper)rfField).getWrappedElement()) instanceof RfBlock && ((RfBlock)wrappedElement).isConstraint()) {
            List<ConstraintDescriptor> refConstraints = this.scenario.constraintDescriptors.get(wrappedElement.getEnclosingScope());
            if (refConstraints != null) {
                constraints.addAll(refConstraints);
            }
            return;
        }
        constraints.add(new ConstraintDescriptor(constraintName, expr, isInline, -1, false));
    }

    public void addConstraintDescriptor(RfNamedElement enclosingScope, ConstraintDescriptor constraintDescriptor) {
        List<ConstraintDescriptor> constraints = this.scenario.constraintDescriptors.get(enclosingScope);
        if (constraints == null) {
            constraints = new ArrayList<ConstraintDescriptor>();
            this.scenario.constraintDescriptors.put(enclosingScope, constraints);
        }
        constraints.add(constraintDescriptor);
    }

    public void addDynamicConstraintDescriptor(RfNamedElement enclosingScope, String constraintName, Expression expr) {
        if (enclosingScope.getClass() == RfTemplateStruct.class) {
            return;
        }
        Map<String, Expression> constraints = this.scenario.dynamicConstraintDescriptors.get(enclosingScope);
        if (constraints == null) {
            constraints = new HashMap<String, Expression>();
            this.scenario.dynamicConstraintDescriptors.put(enclosingScope, constraints);
        }
        constraints.put(constraintName, expr);
    }

    public void useDynamicConstraintDescriptor(ActionInstance actionInstance, String constraintName) {
        RfStruct rfStructScope;
        RfStruct rfParentStructScope = rfStructScope = actionInstance instanceof ISchedulingInstance ? actionInstance.getParentActionInstance().getRfAction() : actionInstance.getRfAction();
        do {
            Expression expression;
            Map<String, Expression> constraints;
            if ((constraints = this.scenario.dynamicConstraintDescriptors.get(rfParentStructScope)) == null || (expression = constraints.get(constraintName)) == null) continue;
            this.addConstraintDescriptor(rfStructScope, constraintName, expression, false);
            break;
        } while ((rfParentStructScope = (RfStruct)rfParentStructScope.getParent()) != null);
    }

    private Pool getPoolCandidate(PortInstance portInstance1, PortInstance portInstance2, boolean reportNoPoolError) {
        Pool poolCandidate;
        Pool explicitExplicitPool = null;
        Pool explicitDefaultPool = null;
        Pool defaultExplicitPool = null;
        Pool defaultDefaultPool = null;
        Pool[] defaultBindPoolResult = new Pool[1];
        Pool[] explicitBindPoolResult = new Pool[1];
        this.collectPoolBindCandidates(defaultBindPoolResult, explicitBindPoolResult, portInstance1.getParentComponentInstance(), portInstance1);
        explicitExplicitPool = explicitBindPoolResult[0];
        explicitDefaultPool = explicitBindPoolResult[0];
        defaultExplicitPool = defaultBindPoolResult[0];
        defaultDefaultPool = defaultBindPoolResult[0];
        if (portInstance2 != null) {
            defaultBindPoolResult = new Pool[1];
            explicitBindPoolResult = new Pool[1];
            this.collectPoolBindCandidates(defaultBindPoolResult, explicitBindPoolResult, portInstance2.getParentComponentInstance(), portInstance2);
            explicitExplicitPool = explicitExplicitPool != null && explicitExplicitPool == explicitBindPoolResult[0] ? explicitExplicitPool : null;
            defaultExplicitPool = defaultExplicitPool != null && defaultExplicitPool == explicitBindPoolResult[0] ? defaultExplicitPool : null;
            explicitDefaultPool = explicitDefaultPool != null && explicitDefaultPool == defaultBindPoolResult[0] ? explicitDefaultPool : null;
            Pool pool = defaultDefaultPool = defaultDefaultPool != null && defaultDefaultPool == defaultBindPoolResult[0] ? defaultDefaultPool : null;
        }
        if ((poolCandidate = explicitExplicitPool) == null) {
            poolCandidate = explicitDefaultPool;
        }
        if (poolCandidate == null) {
            poolCandidate = defaultExplicitPool;
        }
        if (poolCandidate == null) {
            poolCandidate = defaultDefaultPool;
        }
        if (poolCandidate == null) {
            if (reportNoPoolError) {
                boolean isInferred;
                if (portInstance2 == null) {
                    this.logError(Utils.append("*** Error: No pool candidates in order to satisfy connection of '", portInstance1, "'"));
                } else {
                    this.logError(Utils.append("*** Error: No pool candidates in order to satisfy connection of '", portInstance1, "' with '", portInstance2, "'"));
                }
                boolean bl = isInferred = portInstance1.isInferred() || portInstance2 != null && portInstance2.isInferred();
                if (isInferred) {
                    throw new SolverException();
                }
                throw new NoPoolCandidatesException();
            }
            return null;
        }
        return poolCandidate;
    }

    private void collectResourcePoolItems(Collection<PoolItem> result, PortInstance fieldInstance) {
        int mark = this.scenario.markProblems();
        Pool poolCandidate = this.getPoolCandidate(fieldInstance, null, true);
        Map<String, FieldInstance> poolItems = poolCandidate.getPoolItems();
        ActionInstance parentActionInstance1 = fieldInstance.getParentActionInstance();
        ISchedulerProxy prevScheduler = this.scenario.scheduler;
        try {
            this.scenario.scheduler = this.scenario.scheduler.copy();
            block3: for (FieldInstance poolItem : poolItems.values()) {
                boolean solutionFound;
                this.checkInterrupted();
                List<PortInstance> connectedFieldInstances = poolItem.getBinds();
                if (connectedFieldInstances != null && !connectedFieldInstances.isEmpty()) {
                    for (PortInstance connected : connectedFieldInstances) {
                        this.checkInterrupted();
                        if (!Solver.inSameRuntime(connected, fieldInstance) || !connected.isLock() && !fieldInstance.isLock()) continue;
                        ActionInstance parentActionInstance2 = connected.getParentActionInstance();
                        if (parentActionInstance2.isParentInstanceOf(parentActionInstance1) || !connected.canScheduleSequential(fieldInstance)) continue block3;
                        parentActionInstance1.scheduleSequential(parentActionInstance2);
                    }
                }
                if (!(solutionFound = this.checkConnectConstraint(true, false, fieldInstance, (PortInstance)poolItem))) continue;
                result.add((PoolItem)poolItem);
            }
        }
        finally {
            this.scenario.scheduler = prevScheduler;
        }
        if (result.isEmpty()) {
            this.logError(Utils.append("*** Error: All pool item candidates are used, cannot satisfy connection of '", fieldInstance, "'"));
            throw new SolverException();
        }
        this.scenario.restoreProblems(mark);
    }

    protected final boolean checkResourceConnectConstraints(PortInstance fieldInstance, PortInstance poolItem) {
        List<PortInstance> connectedFieldInstances = poolItem.getBinds();
        if (connectedFieldInstances != null && !connectedFieldInstances.isEmpty()) {
            ExecBlockKind currentSolveState = poolItem.getCurrentSolveState();
            try {
                poolItem.setCurrentSolveState(ExecBlockKind.SOLVE_REUSE_VALUE);
                if (this.checkConnectConstraint(false, true, fieldInstance, poolItem)) {
                    return true;
                }
            }
            finally {
                poolItem.setCurrentSolveState(currentSolveState);
            }
        }
        ArrayList<PortInstance> allPoolItemResourceBinds = new ArrayList<PortInstance>();
        allPoolItemResourceBinds.add(fieldInstance);
        if (connectedFieldInstances != null && !connectedFieldInstances.isEmpty()) {
            allPoolItemResourceBinds.addAll(connectedFieldInstances);
        }
        allPoolItemResourceBinds.add(poolItem);
        return this.checkConnectConstraint(true, true, allPoolItemResourceBinds.toArray(new PortInstance[allPoolItemResourceBinds.size()]));
    }

    private void collectPoolBindCandidates(Pool[] defaultBindPoolResult, Pool[] explicitBindPoolResult, ComponentInstance parentComponentInstance, FieldInstance fieldInstance) {
        if (parentComponentInstance == null) {
            return;
        }
        if (fieldInstance.isInitialStateObject()) {
            explicitBindPoolResult[0] = ((Pool.InitialStateActionInstance)fieldInstance.getParentActionInstance()).getPoolInstance();
            return;
        }
        List<BindDescriptor.PoolBindDescriptor> bindDescriptors = this.scenario.poolBindDescriptors.get(parentComponentInstance.getRfComponent());
        if (bindDescriptors == null || bindDescriptors.isEmpty()) {
            this.collectPoolBindCandidates(defaultBindPoolResult, explicitBindPoolResult, parentComponentInstance.getParentComponentInstance(), fieldInstance);
            return;
        }
        IdentityHashMap<Pool, BindDescriptor.PoolBindDescriptor> localDefaultBindDescriptors = new IdentityHashMap<Pool, BindDescriptor.PoolBindDescriptor>();
        IdentityHashMap<Pool, BindDescriptor.PoolBindDescriptor> localExplicitBindDescriptors = new IdentityHashMap<Pool, BindDescriptor.PoolBindDescriptor>();
        for (BindDescriptor.PoolBindDescriptor bindDescriptor : bindDescriptors) {
            boolean canBind;
            this.checkInterrupted();
            Pool pool = bindDescriptor.getPoolInstance(this.scenario, parentComponentInstance);
            if (pool == null || pool.getRfPoolType() != fieldInstance.getRfFieldType() || !(canBind = bindDescriptor.canBind(fieldInstance))) continue;
            boolean isDefault = bindDescriptor.isDefault();
            if (isDefault) {
                localDefaultBindDescriptors.put(pool, bindDescriptor);
                defaultBindPoolResult[0] = pool;
            } else {
                localExplicitBindDescriptors.put(pool, bindDescriptor);
                explicitBindPoolResult[0] = pool;
            }
            if (localDefaultBindDescriptors.size() > 1) {
                StringBuilder message = new StringBuilder("*** Error: Conflicting default bindings for '").append(fieldInstance).append("'");
                for (BindDescriptor.PoolBindDescriptor descriptor : localDefaultBindDescriptors.values()) {
                    message.append("\n    ").append("at line ").append(descriptor.getLine()).append(" in ").append(descriptor.getParserPath().path);
                }
                this.print(message.toString());
                throw new InterruptException();
            }
            if (localExplicitBindDescriptors.size() <= 1) continue;
            StringBuilder message = new StringBuilder("*** Error: Conflicting explicit bindings for '").append(fieldInstance).append("'");
            for (BindDescriptor.PoolBindDescriptor descriptor : localExplicitBindDescriptors.values()) {
                message.append("\n    ").append("at line ").append(descriptor.getLine()).append(" in ").append(descriptor.getParserPath().path);
            }
            this.print(message.toString());
            throw new InterruptException();
        }
        this.collectPoolBindCandidates(defaultBindPoolResult, explicitBindPoolResult, parentComponentInstance.getParentComponentInstance(), fieldInstance);
    }

    public static StructKind getStructKind(RfNamedElement rfAssocType) {
        RfStruct structType = Solver.getBaseStructType(rfAssocType);
        return structType == null ? StructKind.STRUCT : structType.getStructKind();
    }

    public static boolean isBufferType(RfNamedElement rfAssocType) {
        RfStruct structType = Solver.getBaseStructType(rfAssocType);
        return structType != null && structType.getStructKind() == StructKind.BUFFER;
    }

    public static boolean isStreamType(RfNamedElement rfAssocType) {
        RfStruct structType = Solver.getBaseStructType(rfAssocType);
        return structType != null && structType.getStructKind() == StructKind.STREAM;
    }

    public static boolean isStateType(RfNamedElement rfAssocType) {
        RfStruct structType = Solver.getBaseStructType(rfAssocType);
        return structType != null && structType.getStructKind() == StructKind.STATE;
    }

    public static boolean isResourceType(RfNamedElement rfAssocType) {
        RfStruct structType = Solver.getBaseStructType(rfAssocType);
        return structType != null && structType.getStructKind() == StructKind.RESOURCE;
    }

    public static RfStruct getBaseStructType(RfNamedElement rfAssocType) {
        while (rfAssocType instanceof RfTypeAlias || rfAssocType instanceof RfCollectionType) {
            rfAssocType = rfAssocType instanceof RfCollectionType ? Utils.getArrayItemType((RfCollectionType)rfAssocType) : Utils.getAssociatedType((IRfAssociatedType)((Object)rfAssocType));
        }
        if (rfAssocType instanceof RfStruct) {
            return (RfStruct)rfAssocType;
        }
        return null;
    }

    private final void generateSeed(Long keepSeedValue) {
        this.seed = keepSeedValue == null ? System.currentTimeMillis() % 100000L : keepSeedValue;
        this.random1 = new Random(this.seed);
        this.random2 = new Random(this.seed);
        this.random3 = new Random(this.seed);
        this.random4 = new Random(this.seed);
        this.random5 = new Random(this.seed);
    }

    public final Random getListShuffleRandom(long seed) {
        this.random4.setSeed(seed);
        return this.random4;
    }

    public final Random getUrandomRandom() {
        return this.random5;
    }

    public final long getSeed() {
        return this.seed;
    }

    public static boolean equals(RfNamedElement rfAssocType1, RfNamedElement rfAssocType2) {
        if (rfAssocType1 == rfAssocType2) {
            return true;
        }
        if ((rfAssocType1 = SemanticUtils.unwrap(rfAssocType1, true, true)) == (rfAssocType2 = SemanticUtils.unwrap(rfAssocType2, true, true))) {
            return true;
        }
        if (rfAssocType1 instanceof RfCollectionType && rfAssocType2 instanceof RfCollectionType) {
            int arrayDim2;
            RfCollectionType arrayType1 = (RfCollectionType)rfAssocType1;
            RfCollectionType arrayType2 = (RfCollectionType)rfAssocType2;
            int arrayDim1 = arrayType1.getAssociatedTypeArrayDimAsInteger();
            if (arrayDim1 != (arrayDim2 = arrayType2.getAssociatedTypeArrayDimAsInteger())) {
                return false;
            }
            return arrayType1.getAssociatedBaseType().equals(arrayType2.getAssociatedType());
        }
        return false;
    }

    public final boolean isBefore(ActionInstance a1, ActionInstance a2) {
        return this.scenario.scheduler.isBefore(a1, a2);
    }

    public final boolean isParallel(ActionInstance a1, ActionInstance a2) {
        return this.scenario.scheduler.isParallel(a1, a2);
    }

    public final Scenario internalGetSolverData() {
        return this.scenario;
    }

    public final ActionInstance getTreeRoot() {
        return this.scenario.getTreeRoot();
    }

    public final boolean evalIfElse(ActionInstance actionInstance, Expression expr) {
        List<ConstraintDescriptor> constraints = this.scenario.inlineConstraintDescriptors.get(actionInstance);
        if (constraints == null) {
            constraints = new ArrayList<ConstraintDescriptor>();
            this.scenario.inlineConstraintDescriptors.put(actionInstance, constraints);
        }
        boolean isIfBranch = false;
        ConstraintDescriptor.TestConstraintDescriptor constraintDescriptor = new ConstraintDescriptor.TestConstraintDescriptor(this.scenario.actionInstanceTraversalIndex, expr);
        try {
            constraints.add(constraintDescriptor);
            boolean hasSolution = this.solveConstraints(true, false, false, true, actionInstance);
            if (hasSolution) {
                isIfBranch = constraintDescriptor.isTrue();
            }
        }
        finally {
            constraints.remove(constraintDescriptor);
        }
        return isIfBranch;
    }

    public final int evalRepeat(ActionInstance actionInstance, Expression expr) {
        List<ConstraintDescriptor> constraints = this.scenario.inlineConstraintDescriptors.get(actionInstance);
        if (constraints == null) {
            constraints = new ArrayList<ConstraintDescriptor>();
            this.scenario.inlineConstraintDescriptors.put(actionInstance, constraints);
        }
        int nofRepeats = 0;
        ConstraintDescriptor.ValueConstraintDescriptor constraintDescriptor = new ConstraintDescriptor.ValueConstraintDescriptor(this.scenario.actionInstanceTraversalIndex, expr);
        try {
            constraints.add(constraintDescriptor);
            this.solveConstraints(true, false, false, true, actionInstance);
            nofRepeats = constraintDescriptor.getValue().intValueExact();
        }
        finally {
            constraints.remove(constraintDescriptor);
        }
        if (nofRepeats < 0) {
            this.logError(Utils.append("*** Error: Negative ", nofRepeats, " repeat count not allowed"));
            throw new SolverException();
        }
        if (nofRepeats > this.CONFIG_REPEAT_LIMIT) {
            this.logWarning(Utils.append("*** Warning: Repeat count ", nofRepeats, " exceeds ", this.CONFIG_REPEAT_LIMIT, ". Limited to ", this.CONFIG_REPEAT_LIMIT, "."));
            nofRepeats = this.CONFIG_REPEAT_LIMIT;
        }
        return nofRepeats;
    }

    public final int evalForeach(InstancesContainer currentInstanceScope, Expression expression, boolean isConstraint, int line, ParserPath parserPath) {
        if (!(expression instanceof Expression.Hid || expression instanceof Expression.IntExpression || expression instanceof Expression.Arith)) {
            throw new EvaluationException(Utils.append("Unsupported foreach expression '", expression, "'"), line, parserPath);
        }
        if (currentInstanceScope == null) {
            Expression.Hid hidExpr = (Expression.Hid)expression;
            RfField rfField = hidExpr.ids.get(hidExpr.ids.size() - 1).getRfField();
            if (isConstraint && rfField.isContainerType() && !rfField.isFixedSizeArray()) {
                ScenarioUtils.printError(Utils.append("Unsupported constraint foreach iterating on non-fixed size array expression '", expression, "'"), false, line, parserPath);
            }
            return rfField.getAssociatedTypeArrayDimAsInteger();
        }
        List<Expression.ExprAndDep<Expression.Value>> value = expression.evaluate(this.scenario, currentInstanceScope);
        if (value == null || value.size() != 1) {
            throw new EvaluationException(Utils.append("Cannot evaluate '", expression.toString(false), "' expression"), line, parserPath);
        }
        int nofRepeats = 0;
        if (Expression.Value.isInteger((Expression.Value)value.get((int)0).expr)) {
            nofRepeats = ((Expression.Value)value.get((int)0).expr).getIntValue().intValueExact();
        } else if (Expression.Value.isReference((Expression.Value)value.get((int)0).expr) && ((Expression.Value)value.get((int)0).expr).getRefValue().isCollectionType()) {
            nofRepeats = ((Expression.Value)value.get((int)0).expr).getRefValue().arraySize;
        }
        return nofRepeats;
    }

    public final void print(String message) {
        if (this.isDisablePrint) {
            return;
        }
        this.console.print(message);
    }

    public final void print(int severity, String message) {
        if (this.isDisablePrint) {
            return;
        }
        this.console.print(Utils.append(severity <= 1 ? "*** Info: " : (severity <= 2 ? "*** Warning: " : "*** Error: "), message));
    }

    public final void print(String message, boolean reportOnce) {
        if (this.isDisablePrint) {
            return;
        }
        if (reportOnce && this.reportedMessages.contains(message)) {
            return;
        }
        this.reportedMessages.add(message);
        this.console.print(message);
    }

    public final void logError(String message) {
        if (this.isDisablePrint) {
            return;
        }
        if (this.CONFIG_DEBUG_LEVEL >= 1) {
            this.console.print(message);
        } else {
            this.scenario.logProblem(SolverProblem.Severity.ERROR, message, null, null);
        }
    }

    public final void logWarning(String message) {
        if (this.isDisablePrint) {
            return;
        }
        if (this.CONFIG_DEBUG_LEVEL >= 1) {
            this.console.print(message);
        } else {
            this.scenario.logProblem(SolverProblem.Severity.WARNING, message, null, null);
        }
    }

    private final void printProblems() {
        if (this.isDisablePrint) {
            return;
        }
        this.scenario.printProblems(this.console);
    }

    public final void printDebug1(String message) {
        if (this.isDisablePrint) {
            return;
        }
        if (this.CONFIG_DEBUG_LEVEL >= 1) {
            this.console.print(message);
        }
    }

    public final void printDebug2(String message) {
        if (this.isDisablePrint) {
            return;
        }
        if (this.CONFIG_DEBUG_LEVEL >= 2) {
            this.console.print(message);
        }
    }

    public final void scheduleParallel(RfStruct rfStructScope, Expression.Hid expr1, Expression.Hid expr2, boolean isSoft, int line, ParserPath parserPath) {
        Expression.Scheduling expr = new Expression.Scheduling(Expression.Scheduling.Operator.PARALLEL, expr1, expr2, isSoft, line, parserPath);
        this.addConstraintDescriptor(rfStructScope, null, (Expression)expr, false);
    }

    public final void scheduleParallel(ActionInstance actionInstance, Expression.Hid expr1, Expression.Hid expr2, boolean isSoft, int line, ParserPath parserPath) {
        Expression.Scheduling expr = new Expression.Scheduling(Expression.Scheduling.Operator.PARALLEL, expr1, expr2, isSoft, line, parserPath);
        this.addConstraintDescriptor(actionInstance, null, (Expression)expr, false);
    }

    public final void scheduleBefore(RfStruct rfStructScope, Expression.Hid expr1, Expression.Hid expr2, boolean isSoft, int line, ParserPath parserPath) {
        Expression.Scheduling expr = new Expression.Scheduling(Expression.Scheduling.Operator.BEFORE, expr1, expr2, isSoft, line, parserPath);
        this.addConstraintDescriptor(rfStructScope, null, (Expression)expr, false);
    }

    public final void scheduleBefore(ActionInstance actionInstance, Expression.Hid expr1, Expression.Hid expr2, boolean isSoft, int line, ParserPath parserPath) {
        Expression.Scheduling expr = new Expression.Scheduling(Expression.Scheduling.Operator.BEFORE, expr1, expr2, isSoft, line, parserPath);
        this.addConstraintDescriptor(actionInstance, null, (Expression)expr, false);
    }

    public RfProject getRfProject() {
        return this.rfProject;
    }

    public final ActivityDescriptor popActivityDescriptor() {
        return this.scenario.popActivityDescriptor();
    }

    public final ActivityDescriptor peekActivityDescriptor() {
        return this.scenario.peekActivityDescriptor();
    }

    public final void pushActivityDescriptor(ActivityDescriptor activityDescriptor) {
        activityDescriptor.pushActivityDescriptor(this.scenario);
    }

    public final void push0ActivityDescriptor(ActivityDescriptor activityDescriptor) {
        activityDescriptor.push0ActivityDescriptor(this.scenario);
    }

    public final boolean hasActivityDescriptors() {
        return this.scenario.hasActivityDescriptors();
    }

    public final void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public void collectPoolConnectCandidates(Collection<PortInstance> connectCandidates, PortInstance portInstance) {
        ActionInstance actionInstance = portInstance.getParentActionInstance();
        Pool poolInstance = this.getPoolCandidate(portInstance, null, true);
        ActionInstance parentActionInstance = actionInstance;
        while ((parentActionInstance = parentActionInstance.getParentActionInstance()) != null) {
            List<PortInstance> portInstances = parentActionInstance.getPortInstances();
            for (PortInstance portInstanceCandidate : portInstances) {
                boolean solutionFound;
                Pool poolInstanceCandidate;
                if (!portInstance.canHierarchicallyBindTo(portInstanceCandidate).isOK() || poolInstance != (poolInstanceCandidate = this.getPoolCandidate(portInstanceCandidate, null, true)) || !(solutionFound = this.checkConnectConstraint(true, true, portInstanceCandidate, portInstance))) continue;
                connectCandidates.add(portInstanceCandidate);
            }
        }
        if (!connectCandidates.isEmpty()) {
            return;
        }
        if (portInstance.isLockOrShare()) {
            ArrayList<PoolItem> poolItemCandidates = new ArrayList<PoolItem>();
            this.collectResourcePoolItems(poolItemCandidates, portInstance);
            for (PoolItem poolItemCandidate : poolItemCandidates) {
                connectCandidates.add(poolItemCandidate);
            }
        } else {
            PoolItem poolItemCandidate;
            Pool poolCandidate = this.getPoolCandidate(portInstance, null, true);
            poolItemCandidate = (PoolItem)Utils.first(poolCandidate.getPoolItems());
            connectCandidates.add(poolItemCandidate);
        }
    }

    public void collectConnectFieldInstanceCandidates(Collection<PortInstance> connectCandidates, PortInstance portInstance) {
        if (portInstance.isState()) {
            if (portInstance.isOutput()) {
                return;
            }
            Pool poolCandidate = this.getPoolCandidate(portInstance, null, false);
            if (poolCandidate == null) {
                return;
            }
            PortInstance initialStateObject = poolCandidate.getInitialStateObject();
            connectCandidates.add(initialStateObject);
            PortInstance outputPortBefore = portInstance.getStateOutputPortBefore();
            if (outputPortBefore != null && outputPortBefore != initialStateObject) {
                connectCandidates.add(outputPortBefore);
            }
            return;
        }
        Set<ActionInstance> hierarchicalInstances = portInstance.getParentActionInstance().getHierarchicalInstances();
        for (ActionInstance actionInstance : this.scenario.actionInstances) {
            this.checkInterrupted();
            if (hierarchicalInstances.contains(actionInstance)) continue;
            List<PortInstance> portInstances = actionInstance.getPortInstances();
            for (PortInstance portCandidate : portInstances) {
                Pool poolCandidate;
                if (!portCandidate.canBindTo(portInstance, false) || (poolCandidate = this.getPoolCandidate(portCandidate, portInstance, false)) == null) continue;
                connectCandidates.add(portCandidate);
            }
        }
    }

    protected void connectUsingPortBindDescriptors(ActionInstance actionInstance, PortInstance portInstance) {
        ActionInstance parentActionInstance = actionInstance.getParentActionInstance();
        if (parentActionInstance == null) {
            return;
        }
        List<BindDescriptor.PortBindDescriptor> bindDescriptors = this.scenario.getPortBindDescriptors(portInstance.getParentActionInstance());
        if (bindDescriptors == null || bindDescriptors.isEmpty()) {
            return;
        }
        for (BindDescriptor.PortBindDescriptor bindDescriptor : bindDescriptors) {
            if (!bindDescriptor.validBindDescriptor()) {
                this.print("*** Error: Internal error BED_1");
                return;
            }
            List<InstancesContainer> fieldInstances1 = null;
            List<InstancesContainer> fieldInstances2 = null;
            if (bindDescriptor.isHierarchicalBind()) {
                Pool poolCandidate2;
                fieldInstances2 = bindDescriptor.getInstancesHid2(this.scenario);
                if (fieldInstances2 == null || !fieldInstances2.contains(portInstance)) continue;
                fieldInstances1 = bindDescriptor.getInstancesHid1(this.scenario);
                if (fieldInstances1 == null || fieldInstances1.size() != 1 || !(fieldInstances1.get(0) instanceof FieldInstance)) {
                    this.print("*** Error: Internal error BED_2");
                    return;
                }
                PortInstance compoundActionPortInstance = (PortInstance)fieldInstances1.get(0);
                FieldInstance.Status bindCheckStatus = portInstance.canHierarchicallyBindTo(compoundActionPortInstance);
                if (!bindCheckStatus.isOK()) {
                    ScenarioUtils.printError(Utils.append("Cannot hierarchically bind '", portInstance, "' and '", compoundActionPortInstance, "' (", bindCheckStatus.getFailReason(), ")"), false, bindDescriptor.getLine(), bindDescriptor.getParserPath());
                    throw new SolverException();
                }
                Pool poolCandidate1 = this.getPoolCandidate(portInstance, null, true);
                if (poolCandidate1 != (poolCandidate2 = this.getPoolCandidate(compoundActionPortInstance, null, true))) {
                    ScenarioUtils.printError(Utils.append("Cannot hierarchically bind '", portInstance, "' and '", compoundActionPortInstance, "' (the ports are not statically bound to the same pool)"), false, bindDescriptor.getLine(), bindDescriptor.getParserPath());
                    throw new SolverException();
                }
                if (!this.checkConnectConstraint(true, true, portInstance, compoundActionPortInstance)) {
                    ScenarioUtils.printError(Utils.append("Conflicting explicit bind between '", portInstance, "' and '", compoundActionPortInstance, "'"), false, bindDescriptor.getLine(), bindDescriptor.getParserPath());
                    throw new SolverException();
                }
                portInstance.connectHierarchicalTo(compoundActionPortInstance);
                this.postConnectConstraints(portInstance, compoundActionPortInstance);
                continue;
            }
            fieldInstances1 = bindDescriptor.getInstancesHid1(this.scenario);
            if (fieldInstances1 == null || (fieldInstances2 = bindDescriptor.getInstancesHid2(this.scenario)) == null || !fieldInstances1.contains(portInstance) && !fieldInstances2.contains(portInstance)) continue;
            for (InstancesContainer fieldInstance1 : fieldInstances1) {
                for (InstancesContainer fieldInstance2 : fieldInstances2) {
                    if (Utils.isVacuous(fieldInstance1.getParentActionInstance(), fieldInstance2.getParentActionInstance())) continue;
                    PortInstance portInstance1 = (PortInstance)fieldInstance1;
                    PortInstance portInstance2 = (PortInstance)fieldInstance2;
                    if (!this.checkConnectConstraint(true, true, portInstance1, portInstance2)) {
                        ScenarioUtils.printError(Utils.append("Conflicting explicit bind between '", portInstance1, "' and '", portInstance2, "'"), false, bindDescriptor.getLine(), bindDescriptor.getParserPath());
                        throw new SolverException();
                    }
                    portInstance1.connectTo(portInstance2);
                    this.postConnectConstraints(portInstance1, portInstance2);
                }
            }
        }
    }

    public void addExecDescriptor(RfStruct rfStructType, ExecBlockKind execKind, String text, Expression expr, boolean target) {
        if (rfStructType.getClass() == RfTemplateStruct.class) {
            return;
        }
        List<ConstraintDescriptor.ExecStmtDescriptor> execDescriptors = this.scenario.execStmtDescriptors.get(rfStructType);
        if (execDescriptors == null) {
            execDescriptors = new ArrayList<ConstraintDescriptor.ExecStmtDescriptor>();
            this.scenario.execStmtDescriptors.put(rfStructType, execDescriptors);
        }
        execDescriptors.add(target ? new ConstraintDescriptor.TargetExecStmtDescriptor(execKind, text, expr) : new ConstraintDescriptor.ExecStmtDescriptor(execKind, expr));
    }

    public void addTraversedActionHandle(RfField rfActionHandle, ActionInstance parentActionInstance, int line, ParserPath parserPath) {
        if (!this.scenario.traversedActionHandlesStack.isEmpty() && this.scenario.traversedActionHandlesStack.peek().contains(rfActionHandle)) {
            int i = this.scenario.actionInstances.size() - 1;
            while (i >= 0) {
                ActionInstance parentActionInstance2;
                ActionInstance parentActionInstance1;
                ActionInstance actionInstance = this.scenario.actionInstances.get(i);
                if (actionInstance != parentActionInstance && actionInstance.getRfField() == rfActionHandle && (parentActionInstance1 = parentActionInstance.getParentActionInstance()) == (parentActionInstance2 = actionInstance.getParentActionInstance())) {
                    ScenarioUtils.printError(Utils.append("Action-handle '", rfActionHandle.getElabName(), "' is already traversed in this scope"), false, line, parserPath);
                    throw new InterruptException();
                }
                --i;
            }
        }
        this.scenario.addTraversedActionHandle(rfActionHandle);
    }

    public void removeTraversedActionHandle(RfField rfActionHandle) {
        this.scenario.removeTraversedActionHandle(rfActionHandle);
    }

    public boolean isUninitActionHandle(RfNamedElement rfActionHandle) {
        return this.scenario.isUninitActionHandle(rfActionHandle);
    }

    public Set<RfField> getTraversedActionHandle(boolean createWorkingCopy) {
        return this.scenario.getTraversedActionHandle(createWorkingCopy);
    }

    public void reportAlreadyTraversed(RfField rfActionHandle, int line, ParserPath parserPath) {
    }

    public void pushTraversedActionHandles(Set<RfField> traversedActionHandles) {
        this.scenario.pushTraversedActionHandles(traversedActionHandles);
    }

    public void popTraversedActionHandles() {
        this.scenario.popTraversedActionHandles();
    }

    private final void compileForeignJavaImplementation() {
        try {
            IProject project = this.rfProject.getProject();
            File classPathDir = project.getLocation().append("java").toFile();
            File javaFile = project.getLocation().append("java").append("external_methods.java").toFile();
            if (!javaFile.exists()) {
                return;
            }
            this.print("*** Info: Compile external Java methods implementation ...");
            HashMap<String, String> classes = new HashMap<String, String>();
            boolean[] nothingToCompile = new boolean[1];
            classes.put("external_methods", DVTFileUtils.getInstance().readFileContent(javaFile));
            this.javaCompiler.doCompile(classes, nothingToCompile, classPathDir);
            this.javaCompiler.printErrors(project, null);
            Class<?> foreignJava = this.javaCompiler.getClassLoader().loadClass("ro.amiq.pssdt.debug.foreign.java.external_methods");
            this.foreignInstance = foreignJava == null ? null : foreignJava.newInstance();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public final Object invokeMethod(String methodName, Class<?>[] parameterTypes, Object[] parameterValues) {
        if (this.foreignInstance == null) {
            return null;
        }
        PrintStream outputStream = System.out;
        PrintStream errorStream = System.err;
        try {
            System.setOut(this.console.getPrintStream());
            System.setErr(this.console.getPrintStream());
            Method method = this.foreignInstance.getClass().getMethod(methodName, parameterTypes);
            Object object = method.invoke(this.foreignInstance, parameterValues);
            return object;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            this.print(Utils.append("*** Error: Foreign function '", methodName, "' is not defined (check the number of arguments match, and the type of each argument is 'Value')"));
            throw new InterruptException();
        }
        catch (InvocationTargetException e) {
            DVTLogger.INSTANCE.logError(e.getTargetException());
            throw new InterruptException();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            throw new InterruptException();
        }
        finally {
            System.setOut(outputStream);
            System.setErr(errorStream);
        }
    }

    public boolean hasForeignEvaluator() {
        return this.foreignInstance != null;
    }

    public void putTargetCode(String key, String targetCode) {
        if (targetCode == null || targetCode.isEmpty()) {
            return;
        }
        List<String> targetTextBuffer = this.targetCodeMap.get(key);
        if (targetTextBuffer == null) {
            targetTextBuffer = new ArrayList<String>();
            this.targetCodeMap.put(key, targetTextBuffer);
        }
        if (ExecBlockKind.DECLARATION.toString().equals(key)) {
            if (!targetTextBuffer.contains(targetCode = targetCode.trim())) {
                targetTextBuffer.add(targetCode);
            }
        } else {
            targetTextBuffer.add(targetCode);
        }
    }

    public void updateRemainingOptions(int nofPrevOptions) {
        this.scenario.solverRemainingOptions += Math.max(nofPrevOptions - 1, 0);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final List<InferenceSolution> collectInferenceCandidates(PortInstance portCandidate, boolean allowsCompoundActions) {
        instanceIndex = this.scenario.actionInstances.size();
        prevScheduler = this.scenario.scheduler;
        restoreConnects = new ArrayList<InstancesContainer.RestoreConnect>();
        try {
            block13: {
                block12: {
                    bestSolutions = new ArrayList<InferenceSolution>();
                    actionInstances = new Stack<ActionInstance>();
                    this.scenario.scheduler = this.scenario.scheduler.copy();
                    if (!portCandidate.isState()) break block12;
                    if (!portCandidate.isInput()) {
                        throw new UnsupportedOperationException();
                    }
                    outputPorts = portCandidate.getStateOutputPortBeforeCandidates();
                    parallelInputPorts = portCandidate.getStateParallelInputPorts();
                    var11_11 = parallelInputPorts.iterator();
                    if (true) ** GOTO lbl23
                }
                i = 1;
                if (true) ** GOTO lbl45
                do {
                    parallelInputPort = var11_11.next();
                    actionInstances.push(parallelInputPort.getParentActionInstance());
                    restoreConnects.add(InstancesContainer.connect(parallelInputPort, portCandidate));
lbl23:
                    // 2 sources

                } while (var11_11.hasNext());
                i = 1;
                while (i < this.CONFIG_INFERENCE_LIMIT / 5) {
                    inferenceConnects = new Stack<InferenceConnect>();
                    for (PortInstance outputPort : outputPorts) {
                        this.minPathBnBSearch(portCandidate, outputPort, actionInstances, inferenceConnects, i, bestSolutions, allowsCompoundActions);
                    }
                    if (!bestSolutions.isEmpty()) break;
                    ++i;
                }
                for (PortInstance parallelInputPort : parallelInputPorts) {
                    if (!parallelInputPort.requiresBind(portCandidate.runtimeId)) continue;
                    for (InferenceSolution inferenceSolution : bestSolutions) {
                        inferenceConnect = inferenceSolution.inferenceConnects.get(0);
                        inferenceSolution.inferenceConnects.add(0, new InferenceConnect(parallelInputPort, inferenceConnect.fieldInstance2, inferenceConnect.poolItem));
                    }
                }
                break block13;
                do {
                    this.minPathBnBSearch(portCandidate, actionInstances, new Stack<InferenceConnect>(), i, bestSolutions, allowsCompoundActions);
                    if (!bestSolutions.isEmpty()) break;
                    ++i;
lbl45:
                    // 2 sources

                } while (i < this.CONFIG_INFERENCE_LIMIT / 5);
            }
            var16_18 = bestSolutions;
            return var16_18;
        }
        finally {
            i = this.scenario.actionInstances.size() - 1;
            ** while (i >= instanceIndex)
        }
lbl-1000:
        // 1 sources

        {
            actionInstance = this.scenario.actionInstances.remove(i);
            actionInstance.instanceIndex = -1;
            --i;
            continue;
        }
lbl56:
        // 1 sources

        i = restoreConnects.size() - 1;
        while (i >= 0) {
            InstancesContainer.disconnect((InstancesContainer.RestoreConnect)restoreConnects.get(i));
            --i;
        }
        this.scenario.scheduler = prevScheduler;
        return var16_18;
    }

    public int solutionCost(List<InferenceSolution> bestSolutions) {
        if (bestSolutions.isEmpty()) {
            return this.CONFIG_INFERENCE_LIMIT / 5;
        }
        return Utils.last(bestSolutions).inferenceConnects.size();
    }

    private final void minPathBnBSearch(PortInstance inputPort, PortInstance outputPort, Stack<ActionInstance> actionInstances, Stack<InferenceConnect> inferenceConnects, int fixedSolutionCost, List<InferenceSolution> bestSolutions, boolean allowsCompoundActions) {
        int bestSolutionCost = Math.min(fixedSolutionCost, this.solutionCost(bestSolutions));
        int currSolutionCost = inferenceConnects.size();
        if (currSolutionCost + 1 > bestSolutionCost) {
            return;
        }
        try {
            actionInstances.push(inputPort.getParentActionInstance());
            Pool poolCandidate = this.getPoolCandidate(inputPort, outputPort, false);
            if (poolCandidate == null) {
                return;
            }
            if (!inputPort.canBindTo(outputPort, true)) {
                return;
            }
            PoolItem poolItemCandidate = (PoolItem)Utils.first(poolCandidate.getPoolItems());
            actionInstances.push(outputPort.getParentActionInstance());
            InferenceConnect inferenceConnect = new InferenceConnect(inputPort, outputPort, poolItemCandidate);
            InstancesContainer.RestoreConnect restoreConnect = InstancesContainer.connect(inputPort, outputPort);
            boolean solutionFound = this.checkConnectConstraint(false, false, false, this.toArray(actionInstances));
            InstancesContainer.disconnect(restoreConnect);
            actionInstances.pop();
            if (solutionFound) {
                inferenceConnects.push(inferenceConnect);
                if (bestSolutionCost == ++currSolutionCost) {
                    bestSolutions.add(new InferenceSolution(inferenceConnects));
                } else if (bestSolutionCost > currSolutionCost) {
                    bestSolutions.clear();
                    bestSolutions.add(new InferenceSolution(inferenceConnects));
                }
                inferenceConnects.pop();
                return;
            }
            if (currSolutionCost + 1 >= bestSolutionCost) {
                return;
            }
            ArrayList<FieldPoolItemCandidate> connectCandidates = new ArrayList<FieldPoolItemCandidate>();
            this.collectInferenceCandidates(connectCandidates, inputPort, allowsCompoundActions);
            List<Integer> indexes = Utils.getIndexesList(connectCandidates);
            while (!indexes.isEmpty()) {
                int pickIndex = this.pickIndex(indexes.size(), this.random2);
                int candidateIndex = indexes.remove(pickIndex);
                FieldPoolItemCandidate fieldPoolItemCandidate = (FieldPoolItemCandidate)connectCandidates.get(candidateIndex);
                PortInstance fieldInstanceCandidate = fieldPoolItemCandidate.getPortInstance(this.scenario);
                PoolItem poolItemCandidate2 = fieldPoolItemCandidate.getPoolItem(this.scenario);
                actionInstances.push(fieldInstanceCandidate.getParentActionInstance());
                InferenceConnect inferenceConnect2 = new InferenceConnect(inputPort, fieldInstanceCandidate, poolItemCandidate2);
                InstancesContainer.RestoreConnect restoreConnect2 = InstancesContainer.connect(inputPort, fieldInstanceCandidate);
                inferenceConnects.push(inferenceConnect2);
                boolean solutionFound2 = this.checkConnectConstraint(false, false, false, this.toArray(actionInstances));
                if (solutionFound2) {
                    this.minPathBnBSearch(fieldInstanceCandidate.getPairPort(), outputPort, actionInstances, inferenceConnects, fixedSolutionCost, bestSolutions, allowsCompoundActions);
                }
                inferenceConnects.pop();
                InstancesContainer.disconnect(restoreConnect2);
                actionInstances.pop();
            }
        }
        finally {
            actionInstances.pop();
        }
    }

    private final void minPathBnBSearch(PortInstance portCandidate, Stack<ActionInstance> actionInstances, Stack<InferenceConnect> inferenceConnects, int fixedSolutionCost, List<InferenceSolution> bestSolutions, boolean allowsCompoundActions) {
        int bestSolutionCost = Math.min(fixedSolutionCost, this.solutionCost(bestSolutions));
        int currSolutionCost = inferenceConnects.size();
        if (portCandidate == null || !portCandidate.requiresBind(portCandidate.runtimeId)) {
            if (bestSolutionCost < currSolutionCost) {
                return;
            }
            if (bestSolutionCost > currSolutionCost) {
                bestSolutions.clear();
            }
            bestSolutions.add(new InferenceSolution(inferenceConnects));
            return;
        }
        if (currSolutionCost + 1 > bestSolutionCost) {
            return;
        }
        try {
            ActionInstance parentActionInstance = portCandidate.getParentActionInstance();
            actionInstances.push(parentActionInstance);
            ArrayList<FieldPoolItemCandidate> connectCandidates = new ArrayList<FieldPoolItemCandidate>();
            this.collectInferenceCandidates(connectCandidates, portCandidate, allowsCompoundActions);
            List<Integer> indexes = Utils.getIndexesList(connectCandidates);
            while (!indexes.isEmpty()) {
                int pickIndex = this.pickIndex(indexes.size(), this.random2);
                int candidateIndex = indexes.remove(pickIndex);
                FieldPoolItemCandidate fieldPoolItemCandidate = (FieldPoolItemCandidate)connectCandidates.get(candidateIndex);
                PortInstance fieldInstanceCandidate = fieldPoolItemCandidate.getPortInstance(this.scenario);
                PoolItem poolItemCandidate = fieldPoolItemCandidate.getPoolItem(this.scenario);
                ActionInstance parentActionInstanceCandidate = fieldInstanceCandidate.getParentActionInstance();
                if (connectCandidates.size() == 1 && parentActionInstanceCandidate.getRfAction() == parentActionInstance.getRfAction()) {
                    return;
                }
                actionInstances.push(parentActionInstanceCandidate);
                InferenceConnect inferenceConnect = new InferenceConnect(portCandidate, fieldInstanceCandidate, poolItemCandidate);
                InstancesContainer.RestoreConnect restoreConnect = InstancesContainer.connect(portCandidate, fieldInstanceCandidate);
                inferenceConnects.push(inferenceConnect);
                boolean solutionFound = this.checkConnectConstraint(false, false, false, this.toArray(actionInstances));
                if (solutionFound) {
                    this.minPathBnBSearch(fieldInstanceCandidate.getPairPort(), actionInstances, inferenceConnects, fixedSolutionCost, bestSolutions, allowsCompoundActions);
                }
                inferenceConnects.pop();
                InstancesContainer.disconnect(restoreConnect);
                actionInstances.pop();
            }
        }
        finally {
            actionInstances.pop();
        }
    }

    private ActionInstance[] toArray(Stack<ActionInstance> actionInstances) {
        LinkedHashSet<ActionInstance> result = new LinkedHashSet<ActionInstance>(actionInstances);
        return result.toArray(new ActionInstance[result.size()]);
    }

    private final List<RfActionCacheEntry> getAllInferenceAvailableCandidates() {
        if (this.rfAvailableActionsCache != null) {
            return this.rfAvailableActionsCache;
        }
        this.rfAvailableActionsCache = new ArrayList<RfActionCacheEntry>();
        Set<RfStruct> alreadyVisited = Utils.popReusableSet(RfStruct.class);
        InstanceVisitor<ComponentInstance> visitor = componentInstance -> {
            List<RfNamedElement> rfActions = componentInstance.getRfComponent().getLocalMembers(null, SemanticUtils.MEMBER_ACTIONS);
            if (rfActions == null || rfActions.isEmpty()) {
                return true;
            }
            for (RfNamedElement rfAction : rfActions) {
                Collection<RfNamedElement> rfFields;
                this.checkInterrupted();
                if (!(rfAction instanceof RfStruct) || ((RfStruct)rfAction).getStructKind() != StructKind.ACTION || alreadyVisited.contains(rfAction) || (rfFields = rfAction.getMembersForElab(null, Collections.singleton(RfField.class), new IRfElementFilter(){

                    public boolean validElement(IRfNamedElement candidate) {
                        if (!(candidate instanceof RfField)) {
                            return false;
                        }
                        return ((RfField)candidate).isInput() || ((RfField)candidate).isOutput();
                    }

                    public boolean allowEnumElement() {
                        return false;
                    }

                    public int resultMaxSize() {
                        return 0;
                    }
                })) == null || rfFields.isEmpty()) continue;
                this.rfAvailableActionsCache.add(new RfActionCacheEntry((RfStruct)rfAction, rfFields, componentInstance.instanceIndex));
            }
            return true;
        };
        try {
            this.scenario.rootComponent.accept(visitor);
        }
        finally {
            Utils.pushReusableSet(alreadyVisited);
        }
        return this.rfAvailableActionsCache;
    }

    private final void collectInferenceCandidates(List<FieldPoolItemCandidate> connectCandidates, PortInstance fieldInstance, boolean allowsCompoundActions) {
        List<RfActionCacheEntry> inferenceAvailableCandidates = this.getAllInferenceAvailableCandidates();
        for (RfActionCacheEntry rfActionElement : inferenceAvailableCandidates) {
            if (rfActionElement.isCompoundAction && !allowsCompoundActions || !rfActionElement.isInferenceCandidateFor(fieldInstance)) continue;
            this.collectInferenceCandidate(connectCandidates, fieldInstance, rfActionElement.rfAction, this.scenario.getComponentInstance(rfActionElement.componentInstanceIndex));
        }
        if (connectCandidates.isEmpty()) {
            return;
        }
        ArrayList<FieldPoolItemCandidate> filteredPoolConnectCandidates = new ArrayList<FieldPoolItemCandidate>(connectCandidates.size());
        for (FieldPoolItemCandidate connectCandidate : connectCandidates) {
            if (!connectCandidate.hasPool()) continue;
            filteredPoolConnectCandidates.add(connectCandidate);
        }
        connectCandidates.clear();
        connectCandidates.addAll(filteredPoolConnectCandidates);
        if (connectCandidates.isEmpty()) {
            this.logError(Utils.append("*** Error: No pool candidates in order to satisfy connection of '", fieldInstance, "'"));
            throw new SolverException();
        }
    }

    private void collectInferenceCandidate(List<FieldPoolItemCandidate> connectCandidates, PortInstance portInstance, RfStruct rfAction, ComponentInstance componentInstance) {
        int instanceIndex = this.scenario.actionInstances.size();
        String instanceName = this.getActionInstanceName("[inferred]", instanceIndex, rfAction);
        ActionInstance inferredActionInstance = new ActionInstance(instanceName, instanceIndex, DEFAULT_RUNTIME_ID, rfAction, componentInstance, this.scenario);
        inferredActionInstance.arraySize = this.scenario.peekRepeatId();
        inferredActionInstance.runtimeId = portInstance.getRuntimeId();
        inferredActionInstance.seed = portInstance.getParentActionInstance().seed + componentInstance.seed;
        inferredActionInstance.setInferred(true);
        this.scenario.addActionInstance(inferredActionInstance);
        List<PortInstance> portInstances = inferredActionInstance.getPortInstances();
        for (PortInstance portCandidate : portInstances) {
            this.checkInterrupted();
            if (!portCandidate.canBindTo(portInstance, true)) continue;
            Pool poolCandidate = this.getPoolCandidate(portCandidate, portInstance, false);
            PoolItem poolItemCandidate = poolCandidate == null ? null : (PoolItem)Utils.first(poolCandidate.getPoolItems());
            connectCandidates.add(new FieldPoolItemCandidate(portCandidate, poolItemCandidate, -1));
        }
    }

    protected boolean checkConnectConstraint(List<InferenceConnect> inferenceConnects, Stack<ActionInstance> actionInstances, int index) {
        if (index == inferenceConnects.size()) {
            ActionInstance[] uniqueActionInstances;
            ActionInstance[] actionInstanceArray = uniqueActionInstances = this.toArray(actionInstances);
            int n = uniqueActionInstances.length;
            int n2 = 0;
            while (n2 < n) {
                ActionInstance actionInstance = actionInstanceArray[n2];
                actionInstance.preSolve();
                ++n2;
            }
            boolean solutionFound = this.solveConstraints(false, false, false, true, uniqueActionInstances);
            return solutionFound;
        }
        InferenceConnect inferenceConnect = inferenceConnects.get(index);
        actionInstances.push(inferenceConnect.fieldInstance1.getParentActionInstance());
        actionInstances.push(inferenceConnect.fieldInstance2.getParentActionInstance());
        InstancesContainer.RestoreConnect restoreConnect = InstancesContainer.connect(inferenceConnect.fieldInstance1, inferenceConnect.fieldInstance2);
        boolean solutionFound = this.checkConnectConstraint(inferenceConnects, actionInstances, ++index);
        InstancesContainer.disconnect(restoreConnect);
        actionInstances.pop();
        actionInstances.pop();
        return solutionFound;
    }

    public void throwUnsupportedOpertation(String message, int line, ParserPath parserPath) {
        ScenarioUtils.printError(message, true, line, parserPath);
        throw new InterruptException();
    }

    public static final boolean inSameRuntime(InstancesContainer instance1, InstancesContainer instance2) {
        if (instance1.runtimeId == instance2.runtimeId) {
            return true;
        }
        if (instance1.runtimeId.equals(instance2.runtimeId)) {
            return true;
        }
        BigInteger commRuntimeId = instance1.runtimeId.and(instance2.runtimeId);
        return commRuntimeId.equals(instance1.runtimeId) || commRuntimeId.equals(instance2.runtimeId);
    }

    public static final boolean inSameStrictRuntime(InstancesContainer instance1, InstancesContainer instance2) {
        if (instance1.runtimeId == instance2.runtimeId) {
            return true;
        }
        return instance1.runtimeId.equals(instance2.runtimeId);
    }

    public int radix() {
        return this.CONFIG_PRINT_RADIX;
    }

    public FieldInstance getStaticFieldInstance(InstancesContainer instance) {
        return this.staticFieldInstancesHolder.getStaticFieldInstance(instance, this.scenario);
    }

    public void addCoverageDescriptor(RfNamedElement enclosingScope, CoverageDescriptor coverageDescriptor) {
        List<CoverageDescriptor> coverageDescriptors = this.coverageDescriptorsMap.get(enclosingScope);
        if (coverageDescriptors == null) {
            coverageDescriptors = new ArrayList<CoverageDescriptor>();
            this.coverageDescriptorsMap.put(enclosingScope, coverageDescriptors);
        }
        coverageDescriptors.add(coverageDescriptor);
    }

    private final void applyCoverageDescriptors() {
        try {
            for (ActionInstance actionInstance : this.scenario.actionInstances) {
                this.applyCoverageDescriptors(actionInstance);
            }
        }
        catch (Exception exception) {}
    }

    private final void applyCoverageDescriptors(InstancesContainer instance) {
        Map<String, FieldInstance> fieldInstances;
        RfNamedElement rfElement = instance.getRfFieldType();
        List<CoverageDescriptor> coverageDescriptors = this.coverageDescriptorsMap.get(rfElement);
        if (coverageDescriptors != null && !coverageDescriptors.isEmpty()) {
            for (CoverageDescriptor coverageDescriptor : coverageDescriptors) {
                coverageDescriptor.apply(this.scenario, instance);
            }
        }
        if ((fieldInstances = instance.getFieldInstances()) == null) {
            return;
        }
        for (InstancesContainer instancesContainer : fieldInstances.values()) {
            this.applyCoverageDescriptors(instancesContainer);
        }
    }

    public void addCoverageDeclaration(RfNamedElement enclosingScope, RfCovergroup rfCovergroup, Expression.ListExpression result) {
        if (enclosingScope.getClass() == RfTemplateStruct.class) {
            return;
        }
        this.coverageDeclarations.put(rfCovergroup, result);
    }

    public Expression.ListExpression getCoverageDeclaration(RfCovergroup rfCovergroup) {
        return this.coverageDeclarations.get(rfCovergroup);
    }

    public CoverageModel getCovergeModel() {
        return CoverageModel.INSTANCE;
    }

    public void debugBeginEvaluate(Expression expression, InstancesContainer currentInstanceScope) {
        if (this.debugger != null) {
            this.debugger.debugBeginEvaluate(expression, currentInstanceScope);
        }
    }

    public void debugFinishEvaluate(Expression expression, InstancesContainer currentInstanceScope) {
        if (this.debugger != null) {
            this.debugger.debugFinishEvaluate(expression, currentInstanceScope);
        }
    }

    public void setDisableDebug(boolean isDisableDebug) {
        this.isDisableDebug = isDisableDebug;
    }

    public Expression.Value getPureFunctionCachedResult(RfMethod rfMethod, List<Expression.Value> parameterValues) {
        if (this.debugger != null && this.debugger.hasLineBreakpoint(rfMethod)) {
            return null;
        }
        return this.pureFunctionsCachedResults.get(new PureFunction(rfMethod, parameterValues));
    }

    public void setPureFunctionCachedResult(RfMethod rfMethod, List<Expression.Value> parameterValues, Expression.Value resultValue) {
        this.pureFunctionsCachedResults.put(new PureFunction(rfMethod, parameterValues), resultValue);
    }

    public final void addPureComponentInstance(int instanceIndex, ComponentInstance componentInstance) {
        List<ComponentInstance> componentInstances = this.pureComponentInstances.get(instanceIndex);
        if (componentInstances == null) {
            componentInstances = new ArrayList<ComponentInstance>();
            this.pureComponentInstances.put(instanceIndex, componentInstances);
        }
        componentInstance.instanceIndex = this.pureComponentInstanceIndex++;
        componentInstances.add(componentInstance);
    }

    public final List<ComponentInstance> getPureComponentInstance(int instanceIndex) {
        return this.pureComponentInstances.get(instanceIndex);
    }

    public final int getFileDescriptor(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            return -1;
        }
        ++this.fileDescriptor;
        this.fileDescriptors.put(this.fileDescriptor, randomAccessFile);
        return this.fileDescriptor;
    }

    public RandomAccessFile getFile(int fileDescriptor) {
        return this.fileDescriptors.get(fileDescriptor);
    }

    public RandomAccessFile removeFile(int fileDescriptor) {
        return this.fileDescriptors.remove(fileDescriptor);
    }

    private void closeFiles() {
        for (RandomAccessFile file : this.fileDescriptors.values()) {
            try {
                file.close();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private static class ActivityContainer {
        private ParserPath parserPath;
        private AST activityAST;

        public ActivityContainer(AST activityAST, ParserPath parserPath) {
            this.activityAST = activityAST;
            this.parserPath = parserPath;
        }
    }

    public static class EvaluationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        protected final Scenario.TraceElement traceElement;

        public EvaluationException(String message, int line, ParserPath parserPath) {
            super(message);
            this.traceElement = new Scenario.TraceElement(line, parserPath);
        }

        public EvaluationException(String message, RfDefElement rfDefElement) {
            super(message);
            this.traceElement = rfDefElement == null ? null : new Scenario.TraceElement(rfDefElement.getStartLine(), rfDefElement.getParserPath());
        }

        public EvaluationException(String message) {
            super(message);
            this.traceElement = null;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }

        @Override
        public String getMessage() {
            return Utils.append("*** Error: ", super.getMessage());
        }

        public String getErrorMessage(Scenario scenario, int line, ParserPath parserPath) {
            String traceElementText;
            StringBuilder result = new StringBuilder("*** Error: ").append(super.getMessage());
            HashSet<String> alreadyPrinted = new HashSet<String>();
            if (this.traceElement != null && !alreadyPrinted.contains(traceElementText = this.traceElement.toString())) {
                alreadyPrinted.add(traceElementText);
                result.append(traceElementText);
            }
            if (line >= 0 && parserPath != null && !alreadyPrinted.contains(traceElementText = new Scenario.TraceElement(line, parserPath).toString())) {
                alreadyPrinted.add(traceElementText);
                result.append(traceElementText);
            }
            ListIterator<Scenario.TraceElement> iterator = scenario.stackTrace.listIterator(scenario.stackTrace.size());
            while (iterator.hasPrevious()) {
                String traceElementText2 = iterator.previous().toString();
                if (alreadyPrinted.contains(traceElementText2)) continue;
                alreadyPrinted.add(traceElementText2);
                result.append(traceElementText2);
            }
            return result.toString();
        }
    }

    public static class GoToLevelException
    extends SolverException {
        private static final long serialVersionUID = 1L;
        private int depthLevel;

        public GoToLevelException(int level) {
            this.depthLevel = level;
        }

        public int getDepthLevel() {
            return this.depthLevel;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class InferenceConnect
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected PortInstance fieldInstance1;
        protected PortInstance fieldInstance2;
        protected PoolItem poolItem;

        public InferenceConnect(PortInstance fieldInstance1, PortInstance fieldInstance2, PoolItem poolItem) {
            this.fieldInstance1 = fieldInstance1;
            this.fieldInstance2 = fieldInstance2;
            this.poolItem = poolItem;
        }
    }

    public static class InferenceSolution
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected List<InferenceConnect> inferenceConnects = new ArrayList<InferenceConnect>();

        public InferenceSolution(Stack<InferenceConnect> solutionActionInstances) {
            this.inferenceConnects.addAll(solutionActionInstances);
        }
    }

    class InsertInferredActionsRunnable
    implements Runnable {
        boolean isExecuted;

        InsertInferredActionsRunnable() {
        }

        @Override
        public final void run() {
            if (this.isExecuted) {
                return;
            }
            Solver.this.insertInferredActions();
            this.isExecuted = true;
        }
    }

    private static final class InsertionOption {
        private int actionIndex;
        private SchedulingKind schedulingKind;

        public InsertionOption(SchedulingKind schedulingKind, int actionIndex) {
            this.actionIndex = actionIndex;
            this.schedulingKind = schedulingKind;
        }
    }

    private static final class InstanceIndex {
        private int index;
        private boolean isSchedulingInstance;

        public InstanceIndex(ActionInstance actionInstance) {
            this.index = actionInstance.instanceIndex;
            this.isSchedulingInstance = actionInstance instanceof ISchedulingInstance;
        }

        public ActionInstance getActionInstance(Scenario scenario) {
            if (this.isSchedulingInstance) {
                return scenario.schedulingInstances.get(this.index);
            }
            return scenario.actionInstances.get(this.index);
        }

        public int hashCode() {
            int result = this.index;
            if (this.isSchedulingInstance) {
                result = 31 * result + 1231;
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceIndex other = (InstanceIndex)obj;
            if (this.index != other.index) {
                return false;
            }
            return this.isSchedulingInstance == other.isSchedulingInstance;
        }
    }

    public static class InterruptException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class NoInferringCandidatesException
    extends SolverException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class NoPoolCandidatesException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class NullRefException
    extends EvaluationException {
        private static final long serialVersionUID = 1L;

        public NullRefException(String message) {
            super(message);
        }
    }

    private static class PureFunction {
        private RfMethod rfMethod;
        private List<Expression.Value> parameterValues;

        public PureFunction(RfMethod rfMethod, List<Expression.Value> parameterValues) {
            this.rfMethod = rfMethod;
            this.parameterValues = parameterValues;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.rfMethod.hashCode();
            result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PureFunction other = (PureFunction)obj;
            if (this.rfMethod != other.rfMethod) {
                return false;
            }
            return !(this.parameterValues == null ? other.parameterValues != null : !this.parameterValues.equals(other.parameterValues));
        }
    }

    private static class RfActionCacheEntry {
        private RfStruct rfAction;
        private boolean isCompoundAction;
        private Map<RfNamedElement, Direction> inputOutputFieldTypes;
        private int componentInstanceIndex;

        public RfActionCacheEntry(RfStruct rfAction, Collection<RfNamedElement> rfFields, int componentInstanceIndex) {
            this.rfAction = rfAction;
            this.isCompoundAction = rfAction.isCompoundAction();
            this.componentInstanceIndex = componentInstanceIndex;
            this.inputOutputFieldTypes = new IdentityHashMap<RfNamedElement, Direction>();
            for (RfNamedElement rfField : rfFields) {
                RfStruct rfAssocType = Solver.getBaseStructType(((RfField)rfField).getAssociatedBaseType());
                Direction direction = this.inputOutputFieldTypes.get(rfAssocType);
                if (direction == null) {
                    this.inputOutputFieldTypes.put(rfAssocType, ((RfField)rfField).isInput() ? Direction.IN : Direction.OUT);
                    continue;
                }
                if (direction == Direction.IN && ((RfField)rfField).isOutput()) {
                    this.inputOutputFieldTypes.put(rfAssocType, Direction.IN_OUT);
                    continue;
                }
                if (direction != Direction.OUT || !((RfField)rfField).isInput()) continue;
                this.inputOutputFieldTypes.put(rfAssocType, Direction.IN_OUT);
            }
        }

        public boolean isInferenceCandidateFor(FieldInstance fieldInstance) {
            Direction direction = this.inputOutputFieldTypes.get(fieldInstance.getRfFieldType());
            if (direction == null) {
                return false;
            }
            return direction == Direction.IN_OUT || direction == Direction.IN && fieldInstance.isOutput() || direction == Direction.OUT && fieldInstance.isInput();
        }

        private static enum Direction {
            IN,
            OUT,
            IN_OUT;

        }
    }

    public static enum SchedulingKind {
        BEFORE,
        AFTER,
        PARALLEL;

    }

    public static class SkipEvaluationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    private static class SolverCustomValidator
    implements IExternValidator {
        private Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap;

        public SolverCustomValidator(Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap) {
            this.cspToReadableTextMap = cspToReadableTextMap;
        }

        public boolean validate(Model model) {
            List constraints = model.getConstraints();
            if (constraints == null) {
                return false;
            }
            boolean result = false;
            for (AbstractConstraint constraint : constraints) {
                IDomain domain;
                Variable rhs;
                if (constraint.isDisabled() || !(constraint instanceof IntConstraint)) continue;
                IntConstraint.Operator operator = ((IntConstraint)constraint).getOperator();
                if (operator == IntConstraint.Operator.SL || operator == IntConstraint.Operator.SR) {
                    rhs = ((IntConstraint)constraint).getVariables()[2];
                    if (rhs.getDomain().getUpperBound().compareTo(BigInteger.ZERO) < 0) {
                        model.getSolver().addContradictionCandidate(constraint, true);
                        List cspConstraints = model.getSolver().getContradiction(this.cspToReadableTextMap.keySet());
                        ConstraintDescriptor.Text constraintAsText = this.cspToReadableTextMap.get(Utils.last(cspConstraints));
                        if (constraintAsText == null) continue;
                        if (rhs.isInstantiated()) {
                            ScenarioUtils.printError(Utils.append("Negative right hand side shift operand ", rhs.value(), " is not allowed"), true, constraintAsText.line, constraintAsText.parserPath);
                            continue;
                        }
                        ScenarioUtils.printError(Utils.append("Negative right hand side shift operand ", rhs.getDomain(), " is not allowed"), true, constraintAsText.line, constraintAsText.parserPath);
                        continue;
                    }
                    domain = rhs.getDomain();
                    domain = domain.intersect((IDomain)new IntDomain(BigInteger.ZERO, domain.getUpperBound()));
                    rhs.setDomain(domain);
                    result = true;
                    continue;
                }
                if (operator == IntConstraint.Operator.POW) {
                    rhs = ((IntConstraint)constraint).getVariables()[2];
                    if (rhs.getDomain().getUpperBound().compareTo(BigInteger.ZERO) >= 0) continue;
                    Variable lhs = ((IntConstraint)constraint).getVariables()[1];
                    IDomain domain2 = lhs.getDomain().remove(BigInteger.ZERO);
                    lhs.setDomain(domain2);
                    if (domain2.isEmpty()) {
                        model.getSolver().addContradictionCandidate(constraint, true);
                        List cspConstraints = model.getSolver().getContradiction(this.cspToReadableTextMap.keySet());
                        ConstraintDescriptor.Text constraintAsText = this.cspToReadableTextMap.get(Utils.last(cspConstraints));
                        if (constraintAsText == null) continue;
                        ScenarioUtils.printError("Divide by zero is undefined", true, constraintAsText.line, constraintAsText.parserPath);
                        model.getSolver().reset();
                        throw new AbstractSolver.InterruptSolverException();
                    }
                    result = true;
                    continue;
                }
                if (operator != IntConstraint.Operator.DIV && operator != IntConstraint.Operator.MOD) continue;
                rhs = ((IntConstraint)constraint).getVariables()[2];
                domain = rhs.getDomain().remove(BigInteger.ZERO);
                rhs.setDomain(domain);
                if (domain.isEmpty()) {
                    model.getSolver().addContradictionCandidate(constraint, true);
                    List cspConstraints = model.getSolver().getContradiction(this.cspToReadableTextMap.keySet());
                    ConstraintDescriptor.Text constraintAsText = this.cspToReadableTextMap.get(Utils.last(cspConstraints));
                    if (constraintAsText == null) continue;
                    ScenarioUtils.printError("Divide by zero is undefined", true, constraintAsText.line, constraintAsText.parserPath);
                    model.getSolver().reset();
                    throw new AbstractSolver.InterruptSolverException();
                }
                result = true;
            }
            return result;
        }
    }

    public static class SolverException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SolverException() {
        }

        public SolverException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

