/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.util.IdentityHashMap;
import java.util.Map;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class StaticFieldInstances {
    private Map<RfField, FieldInstance> staticInstancesMap = new IdentityHashMap<RfField, FieldInstance>();
    private InstancesContainer staticInstancesScope;

    public FieldInstance getStaticFieldInstance(InstancesContainer instance, Scenario scenario) {
        RfField rfField = instance.getRfField();
        FieldInstance staticFieldInstance = this.staticInstancesMap.get(rfField);
        if (staticFieldInstance == null) {
            if (this.staticInstancesScope == null) {
                this.staticInstancesScope = FieldInstance.create(new RfField("[global scope]", new DataType("")), scenario.solver.voidType, false, -1, -1, Solver.DEFAULT_RUNTIME_ID, scenario);
            }
            staticFieldInstance = this.staticInstancesScope.createFieldInstance(new IdentityHashMap<RfNamedElement, InstancesContainer>(), null, rfField, Utils.getAssociatedType(rfField), rfField.getDataType().getArrayDimAsInteger(), -1, true, true);
            this.staticInstancesMap.put(rfField, staticFieldInstance);
        } else {
            this.staticInstancesScope.addChildFieldInstance(ScenarioUtils.getDeduplicateName(rfField), staticFieldInstance, true);
        }
        FieldInstance fieldInstance = this.staticInstancesScope.getFieldInstance(instance);
        return fieldInstance;
    }
}

