/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.DummyFieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public class TypeInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int uniqueId;
    protected Map<String, FieldInstance> fieldInstances;
    protected ListContainer<InstancesContainer> references;
    protected TypeKind typeCategory;
    protected ExecBlockKind currentSolveState;
    protected Scenario scenario;
    protected transient RfNamedElement rfInstanceType;

    public static TypeInstance create(InstancesContainer holderInstance, RfNamedElement rfInstanceType, boolean isRef, int uniqueId, Scenario scenario) {
        if (isRef) {
            return new RefTypeInstance(holderInstance, rfInstanceType, scenario);
        }
        return new TypeInstance(holderInstance, rfInstanceType, uniqueId, scenario);
    }

    private TypeInstance(InstancesContainer holderInstance, RfNamedElement rfInstanceType, int uniqueId, Scenario scenario) {
        Assert.isTrue((!(rfInstanceType instanceof RfField) ? 1 : 0) != 0);
        this.rfInstanceType = rfInstanceType;
        this.uniqueId = uniqueId;
        this.scenario = scenario;
        this.typeCategory = Utils.getTypeKind(rfInstanceType);
        this.currentSolveState = ExecBlockKind.NONE;
        this.addReference(holderInstance);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int key = ScenarioUtils.getKeyOfRf(this.rfInstanceType);
        out.writeInt(key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int key = in.readInt();
        this.rfInstanceType = ScenarioUtils.getRfOfKey(key);
    }

    public void addReference(InstancesContainer instance) {
        this.references = OptimizedUtils.listContainerAdd(this.references, (Object)instance);
    }

    public void removeReference(InstancesContainer instance) {
        if (this.references instanceof List && this.references.size() > 2 && Utils.last((List)this.references) == instance) {
            ((List)this.references).remove(this.references.size() - 1);
            return;
        }
        this.references = OptimizedUtils.listContainerRemove(this.references, (Object)instance);
    }

    public List<InstancesContainer> getReferences() {
        return OptimizedUtils.asList(this.references, (boolean)false);
    }

    public void addChildFieldInstance(String instanceName, FieldInstance fieldInstance, boolean isAllowDuplicate) {
        this.addReferenceChildFieldInstance(instanceName != null ? instanceName : fieldInstance.getName(), fieldInstance, isAllowDuplicate);
        fieldInstance.setParentInstance((InstancesContainer)this.references.get(0));
    }

    public void addReferenceChildFieldInstance(String referenceName, FieldInstance fieldInstance, boolean isAllowDuplicate) {
        if (this.fieldInstances == null) {
            this.fieldInstances = new LinkedHashMap<String, FieldInstance>();
        }
        if (!isAllowDuplicate && this.fieldInstances.containsKey(referenceName)) {
            throw new Solver.EvaluationException("Internal error DUP_1");
        }
        this.fieldInstances.put(referenceName, fieldInstance);
    }

    public void setFieldInstances(Map<String, FieldInstance> fieldInstances) {
        this.fieldInstances = fieldInstances;
    }

    public Map<String, FieldInstance> getFieldInstances() {
        return this.fieldInstances;
    }

    public void clean() {
        this.fieldInstances = null;
    }

    public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance, boolean hasPrevStateField, BigInteger runtimeId) {
        if (this.rfInstanceType == null) {
            return;
        }
        Collection<RfNamedElement> rfFields = this.rfInstanceType.getMembersForElab(null, SemanticUtils.MEMBER_FIELDS, hasPrevStateField ? null : Utils.STATE_PREV_VARIABLE_FILTER);
        if (rfFields == null || rfFields.isEmpty()) {
            return;
        }
        HashMap<RfStruct, FieldInstance> stateInputs = new HashMap<RfStruct, FieldInstance>();
        HashMap<RfStruct, FieldInstance> stateOutputs = new HashMap<RfStruct, FieldInstance>();
        boolean isPacked = this.rfInstanceType instanceof RfStruct && ((RfStruct)this.rfInstanceType).isPacked();
        for (RfNamedElement rfNamedElement : rfFields) {
            boolean isActionHandle;
            if (rfNamedElement.isStatic() || rfNamedElement.isPredefined() && "prev".equals(rfNamedElement.getName())) continue;
            boolean isComponentInstance = this.rfInstanceType.isComponent();
            FieldModifier fieldModifier = ((RfField)rfNamedElement).getFieldModifier();
            boolean isActionPort = this.isActionHandle() && (fieldModifier == FieldModifier.INPUT || fieldModifier == FieldModifier.OUTPUT || fieldModifier == FieldModifier.LOCK || fieldModifier == FieldModifier.SHARE);
            boolean isRandomField = Utils.isRand((RfField)rfNamedElement);
            String name = ScenarioUtils.getDeduplicateName(rfNamedElement);
            boolean isSpecialField = rfNamedElement instanceof RfPredefinedField && ("initial".equals(name) || "thread".equals(name));
            if (!isRandomField && !(isSpecialField |= this.rfInstanceType instanceof RfCollectionType && ("size".equals(name) || "sum".equals(name)))) {
                isSpecialField |= "trait".equals(name) && this.rfInstanceType.isCoreLibInstanceOf("addr_region_s", "transparent_addr_region_s");
                isSpecialField |= "size".equals(name) && this.rfInstanceType.isCoreLibInstanceOf("addr_region_base_s");
                isSpecialField |= "addr".equals(name) && this.rfInstanceType.isCoreLibInstanceOf("transparent_addr_region_s");
                isSpecialField |= "hndl".equals(name) && this.rfInstanceType.isCoreLibInstanceOf("sized_addr_handle_s");
            }
            boolean isConstraintExprUsed = rfNamedElement.isConstraintUsed();
            RfNamedElement rfFieldType = Utils.getAssociatedType((RfField)rfNamedElement);
            if (!(isPacked || isComponentInstance || isActionPort || isRandomField || isSpecialField || isConstraintExprUsed)) {
                if (isRandomField || !Utils.isAddressClaimInstance(rfFieldType) && !Utils.isExecutorClaimInstance(rfFieldType)) continue;
                ScenarioUtils.printWarning(Utils.append("Non-random claim instance '", this.references.get(0), ".", rfNamedElement.getElabName(), "' ignored by the solver"), true, rfNamedElement.getDeclaration());
                continue;
            }
            RfNamedElement rfEnclosingScope = rfNamedElement.getEnclosingScope(RfStruct.class);
            RfNamedElement rfFieldBaseType = Utils.getBaseElementType(rfFieldType);
            boolean bl = isActionHandle = rfFieldBaseType instanceof RfStruct && ((RfStruct)rfFieldBaseType).isAction(false) && rfEnclosingScope instanceof RfStruct && ((RfStruct)rfEnclosingScope).isAction(false) && (!(rfFieldType instanceof RfCollectionType) || ((RfCollectionType)rfFieldType).getCollectionKind() == DataType.CollectionKind.ARRAY);
            if (isActionHandle) continue;
            int arraySize = Utils.getAssociatedTypeArrayDim((RfField)rfNamedElement);
            FieldInstance fieldInstance = this.createFieldInstance(backPointersMap, null, (RfField)rfNamedElement, rfFieldType, arraySize, -1, isVariableInstance, false, runtimeId);
            if (!(rfFieldBaseType instanceof RfStruct) || ((RfStruct)rfFieldBaseType).getStructKind() != StructKind.STATE) continue;
            if (fieldModifier == FieldModifier.INPUT) {
                stateInputs.put((RfStruct)rfFieldBaseType, fieldInstance);
                continue;
            }
            if (fieldModifier != FieldModifier.OUTPUT || "[initial state object]".equals(rfNamedElement.getName())) continue;
            stateOutputs.put((RfStruct)rfFieldBaseType, fieldInstance);
        }
        for (Map.Entry entry : stateOutputs.entrySet()) {
            RfStruct rfFieldType = (RfStruct)entry.getKey();
            FieldInstance outputFieldInstance = (FieldInstance)entry.getValue();
            FieldInstance inputFieldInstance = (FieldInstance)stateInputs.get(rfFieldType);
            if (inputFieldInstance == null) {
                RfField rfFieldDummy = new RfField(Utils.append(outputFieldInstance.getDiagramName(), ".prev"), outputFieldInstance.getRfField().getDataType());
                rfFieldDummy.setFieldModifier(FieldModifier.INPUT);
                rfFieldDummy.setAssociatedType(rfFieldType);
                inputFieldInstance = this.createFieldInstance(backPointersMap, null, rfFieldDummy, rfFieldType, -1, -1, isVariableInstance, false, runtimeId);
                stateInputs.put(rfFieldType, inputFieldInstance);
            }
            PortInstance.StatePrevPortInstance fieldInstance = new PortInstance.StatePrevPortInstance("prev", (PortInstance)inputFieldInstance);
            outputFieldInstance.typeInstance.addChildFieldInstance(null, fieldInstance, false);
        }
        backPointersMap.put(this.rfInstanceType, (InstancesContainer)this.references.get(0));
    }

    public boolean isActionHandle() {
        return this.rfInstanceType instanceof RfStruct && ((RfStruct)this.rfInstanceType).isAction(false);
    }

    public boolean isActionHandleArray() {
        if (this.rfInstanceType instanceof RfCollectionType) {
            RfNamedElement rfInstanceItemType = Utils.getArrayItemType((RfCollectionType)this.rfInstanceType);
            return rfInstanceItemType instanceof RfStruct && ((RfStruct)rfInstanceItemType).isAction(false);
        }
        return false;
    }

    public boolean isArray() {
        return this.rfInstanceType instanceof RfCollectionType;
    }

    public FieldInstance createRefFieldInstance(String nameOverride, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, boolean isVariableInstance, BigInteger runtimeId) {
        FieldInstance fieldInstance = FieldInstance.create(rfField, rfFieldType, isVariableInstance, arraySize, arrayItemIndex, runtimeId, null);
        this.addChildFieldInstance(nameOverride, fieldInstance, false);
        fieldInstance.scenario = this.scenario;
        fieldInstance.typeInstance = new RefTypeInstance(fieldInstance, rfFieldType, this.scenario);
        return fieldInstance;
    }

    public FieldInstance createFieldInstance(Map<RfNamedElement, InstancesContainer> backPointersMap, String instanceName, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, boolean isVariableInstance, boolean isAllowDuplicate, BigInteger runtimeId) {
        FieldInstance fieldInstance = FieldInstance.create(rfField, rfFieldType, isVariableInstance, arraySize, arrayItemIndex, runtimeId, this.scenario);
        this.addChildFieldInstance(instanceName, fieldInstance, isAllowDuplicate);
        if (fieldInstance.isRefTypeInstance()) {
            return fieldInstance;
        }
        if (rfFieldType instanceof RfEnumType) {
            fieldInstance.initVariableValue();
            return fieldInstance;
        }
        InstancesContainer backPointer = backPointersMap.get(rfFieldType);
        if (backPointer != null) {
            ScenarioUtils.printError(Utils.append("Infinite recursion detected for '", rfFieldType.getElabName(), "' instantiation"), true, rfField.getDeclaration());
            throw new Solver.InterruptException();
        }
        backPointersMap.put(rfFieldType, fieldInstance);
        fieldInstance.createSubInstances(backPointersMap, isVariableInstance);
        backPointersMap.remove(rfFieldType, fieldInstance);
        if (fieldInstance.isCollectionType()) {
            fieldInstance.arraySize = 0;
            RfNamedElement rfItemFieldType = Utils.getAssociatedType((RfCollectionType)rfFieldType);
            int itemFieldArraySize = rfItemFieldType instanceof RfCollectionType ? Utils.getAssociatedTypeArrayDim((RfCollectionType)rfItemFieldType) : -1;
            RfField rfItemField = rfField;
            if (arrayItemIndex >= 0) {
                String itemFieldName = Utils.append(rfField.getName(), "[", arrayItemIndex, "]");
                rfItemField = new RfField(itemFieldName, ((RfCollectionType)rfFieldType).getDataType().getValueDataType());
                rfItemField.setAssociatedType(rfItemFieldType);
                rfItemField.setEnclosingScope(rfField.getEnclosingScope());
                rfItemField.setFieldModifier(rfField.getFieldModifier());
            }
            int i = 0;
            while (i < arraySize) {
                fieldInstance.createFieldInstance(backPointersMap, null, rfItemField, rfItemFieldType, itemFieldArraySize, i, isVariableInstance);
                ++i;
            }
            fieldInstance.arraySize = arraySize;
        }
        fieldInstance.initVariableValue();
        return fieldInstance;
    }

    public FieldInstance getFieldInstance(InstancesContainer instance) {
        if (this.fieldInstances == null || this.fieldInstances.isEmpty()) {
            return null;
        }
        boolean isArrayItem = instance.isArrayItem();
        RfField rfField = instance.getRfField();
        boolean isCoverpoint = rfField != null && rfField.isCoverpoint();
        String name = isCoverpoint ? "cp@" + instance.name : instance.name;
        FieldInstance fieldInstance = this.fieldInstances.get(name);
        if (fieldInstance == null) {
            return null;
        }
        if (!isArrayItem) {
            return fieldInstance;
        }
        if (fieldInstance.isMapType() && instance instanceof DummyFieldInstance && ((DummyFieldInstance)instance).getMapItemKey() != null) {
            return fieldInstance.getMapItem(((DummyFieldInstance)instance).getMapItemKey());
        }
        if (instance.arrayItemIndex >= fieldInstance.arraySize) {
            throw new Solver.EvaluationException(Utils.append("Index ", instance.arrayItemIndex, " is out of bounds (", fieldInstance.typeInstance.typeCategory.toString().toLowerCase(), " size is ", Math.max(0, fieldInstance.arraySize), ")"));
        }
        return fieldInstance.getFieldInstance(instance.arrayItemIndex);
    }

    public FieldInstance getFieldInstance(int arrayItemIndex) {
        if (this.fieldInstances == null || this.fieldInstances.isEmpty()) {
            return null;
        }
        FieldInstance fieldInstance = this.fieldInstances.get(Utils.append("[", arrayItemIndex, "]"));
        if (fieldInstance != null) {
            return fieldInstance;
        }
        for (FieldInstance itemFieldInstance : this.fieldInstances.values()) {
            if (itemFieldInstance.arrayItemIndex != arrayItemIndex) continue;
            return itemFieldInstance;
        }
        return null;
    }

    public FieldInstance getFieldInstance(String instanceName) {
        if (this.fieldInstances == null || this.fieldInstances.isEmpty()) {
            return null;
        }
        return this.fieldInstances.get(instanceName);
    }

    protected void createUniqueId(BigInteger runtimeId) {
        if (!(this.rfInstanceType instanceof RfStruct) && !(this.rfInstanceType instanceof RfCollectionType)) {
            return;
        }
        RfPredefinedType rfInstanceIdFieldType = this.scenario.getSolver().intType;
        DataType dataType = new DataType("int").set(31, 0, false);
        RfField rfInstanceIdField = new RfField("[unique_id]", dataType);
        rfInstanceIdField.setAssociatedType(rfInstanceIdFieldType);
        dataType.setInitialValue(Integer.toString(this.uniqueId), null, new BitVectorInt(false, 31, 0).setValue(BigInteger.valueOf(this.uniqueId)));
        FieldInstance instanceId = FieldInstance.create(rfInstanceIdField, rfInstanceIdFieldType, false, -1, -1, runtimeId, this.scenario);
        this.addChildFieldInstance(null, instanceId, false);
    }

    public boolean isBooleanType() {
        return this.typeCategory == TypeKind.BOOL;
    }

    public boolean isStringType() {
        return this.typeCategory == TypeKind.STRING;
    }

    public boolean isEnumType() {
        return this.typeCategory == TypeKind.ENUM;
    }

    public boolean isStructType() {
        return this.typeCategory == TypeKind.STRUCT;
    }

    public boolean isStructType(StructKind structKind) {
        return this.rfInstanceType instanceof RfStruct && (structKind == null || ((RfStruct)this.rfInstanceType).getStructKind() == structKind);
    }

    public boolean isCollectionType() {
        return this.typeCategory == TypeKind.ARRAY || this.typeCategory == TypeKind.LIST || this.typeCategory == TypeKind.MAP || this.typeCategory == TypeKind.SET;
    }

    public boolean isArrayType() {
        return this.typeCategory == TypeKind.ARRAY;
    }

    public boolean isListType() {
        return this.typeCategory == TypeKind.LIST;
    }

    public boolean isMapType() {
        return this.typeCategory == TypeKind.MAP;
    }

    public boolean isSetType() {
        return this.typeCategory == TypeKind.SET;
    }

    public boolean isVectorType() {
        return this.typeCategory == TypeKind.ARRAY || this.typeCategory == TypeKind.LIST;
    }

    public boolean isUintType() {
        return this.typeCategory == TypeKind.UINT;
    }

    public boolean isIntType() {
        return this.typeCategory == TypeKind.INT;
    }

    public boolean isHandleType() {
        return this.typeCategory == TypeKind.UINT && "chandle".equals(this.rfInstanceType.getName());
    }

    public static class RefTypeInstance
    extends TypeInstance {
        private static final long serialVersionUID = 1L;

        private RefTypeInstance(InstancesContainer holderInstance, RfNamedElement rfInstanceType, Scenario scenario) {
            super(holderInstance, rfInstanceType, -1, scenario);
        }

        @Override
        public FieldInstance getFieldInstance(InstancesContainer instance) {
            throw new Solver.EvaluationException("Null pointer exception");
        }

        @Override
        public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance, boolean hasPrevStateField, BigInteger runtimeId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isActionHandle() {
            return false;
        }

        @Override
        public boolean isActionHandleArray() {
            return false;
        }

        @Override
        public FieldInstance createFieldInstance(Map<RfNamedElement, InstancesContainer> backPointersMap, String instanceName, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, boolean isVariableInstance, boolean isAllowDuplicate, BigInteger runtimeId) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum TypeKind {
        BOOL,
        ENUM,
        INT,
        UINT,
        STRING,
        STRUCT,
        ARRAY,
        LIST,
        MAP,
        SET;

    }
}

