/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.coverage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTColoredView;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.IDVTViewContributor;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.pssdt.model.reflection.elaboration.CoverageModel;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.CoverageViewCommon;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.CoverageViewContributor;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.CoverageViewInput;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.CoverageViewInputConfigurator;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class CoverageView
extends CoverageViewCommon
implements IUpdateJobImpl {
    private final UpdateJob fUpdateJob;
    static final Color COLOR_ERRORS = new Color((Device)Display.getDefault(), new RGB(159, 63, 63));
    static final Color COLOR_FAILURES = new Color((Device)Display.getDefault(), new RGB(54, 108, 154));
    static final Color COLOR_PASSED = new Color((Device)Display.getDefault(), new RGB(95, 191, 95));
    static final Color COLOR_WAITING = new Color((Device)Display.getDefault(), new RGB(238, 238, 238));
    private Label fInfo;
    private Tree fTree;
    private TreeViewContentProvider lazyContentProvider;
    private SortByTypeAction fSortByTypeAction;
    private AbstractFilteredView.CollapseAllAction fCollapseAllAction;
    private AbstractFilteredView.ExpandAllAction fExpandAllAction;
    private int fNrTotalCoverGroups;
    private int fNrNotFilteredCoverGroups;
    private int fNrTotalCoverItems;
    private int fNrNotFilteredCoverItems;
    private List<IDVTElementWrapper> fElements;
    private CoverageViewContributor coverageViewContributor = new CoverageViewContributor();
    private Label fContentFiltersLabel;
    private boolean fHasGUIFilteredElements;
    private Image fContentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image fContentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);

    public CoverageView() {
        this.fUpdateJob = new UpdateJob("Update Scenario Coverage View", (IUpdateJobImpl)this);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fExpandLevel = -2;
    }

    public void customCreatePartControl(Composite parent) {
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite labelComposite = new Composite(parent, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fContentFiltersLabel = new Label(labelComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.fContentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
        } else {
            this.fContentFiltersLabel.setImage(this.fContentFiltersEnabledIcon);
        }
        this.fContentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fContentFiltersLabel.setToolTipText("Content Filters matched!");
        this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
        this.fInfo = new Label(labelComposite, 16384);
        this.fInfo.setLayoutData((Object)new GridData(768));
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: hierarchical name");
        Composite composite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        composite.setLayoutData((Object)compositeGridData);
        composite.setLayout((Layout)new FillLayout(256));
        this.createToolbar(parent);
        this.fTree = new Tree(composite, 268436260);
        this.fTree.setHeaderVisible(true);
        TreeColumn fill = new TreeColumn(this.fTree, 16384);
        fill.setText("Fill");
        fill.setWidth(35);
        TreeColumn covergroups = new TreeColumn(this.fTree, 16384);
        covergroups.setText("Coverpoint");
        covergroups.setWidth(300);
        TreeColumn percentage = new TreeColumn(this.fTree, 16384);
        percentage.setText("Coverage");
        percentage.setWidth(150);
        TreeColumn coverage = new TreeColumn(this.fTree, 16384);
        coverage.setWidth(200);
        TreeColumn comments = new TreeColumn(this.fTree, 16384);
        comments.setText("Comment");
        comments.setWidth(300);
        this.lazyContentProvider = new TreeViewContentProvider(this.fTree, this.coverageViewContributor.getLabelProvider(null));
        Menu coverageMenu = new Menu((Control)this.fTree);
        this.fTree.setMenu(coverageMenu);
        int[] nArray = new int[5];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[4] = 4;
        this.fTree.setColumnOrder(nArray);
        this.fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CoverageView.this.gotoSelectedElement("default-tree");
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.installContextMenuAndSelectionListener((Control)this.fTree);
        this.fTree.addListener(13, event -> {
            if (event.detail == 32) {
                TreeItem treeItem = (TreeItem)event.item;
                TreeItem parentItem = treeItem.getParentItem();
                if (parentItem != null) {
                    this.unwrapCoverageInstanceElement((Widget)treeItem).enableFill(treeItem.getChecked());
                    boolean isParentChecked = this.unwrapCoverageInstanceElement((Widget)parentItem).isEnableFill();
                    parentItem.setChecked(isParentChecked);
                } else {
                    TreeItem[] items = !treeItem.getExpanded() ? new TreeItem[]{} : treeItem.getItems();
                    boolean isChecked = treeItem.getChecked();
                    TreeItem[] treeItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem childItem = treeItemArray[n2];
                        childItem.setChecked(isChecked);
                        ++n2;
                    }
                    this.unwrapCoverageInstanceElement((Widget)treeItem).enableFill(isChecked);
                }
            }
        });
        this.fTree.addListener(42, event -> {
            if (event.index == 3 && event.item.getData() instanceof DVTTreeElementWrapper) {
                int coveragePercent = (int)this.unwrapCoverageInstanceElement(event.item).coverInfo().getPercent();
                GC gc = event.gc;
                int width = 200;
                int passedWidth = 2 * coveragePercent;
                int waitingWidth = width - passedWidth;
                gc.setBackground(COLOR_PASSED);
                gc.fillRectangle(event.x, event.y, passedWidth, event.height);
                gc.setBackground(COLOR_WAITING);
                gc.fillRectangle(event.x + passedWidth, event.y, waitingWidth, event.height);
                Rectangle rect = new Rectangle(event.x, event.y, width, event.height);
                gc.drawRectangle(rect);
            }
            if (event.index == 0 && event.item.getData() instanceof DVTTreeElementWrapper) {
                boolean isEnableFill = this.unwrapCoverageInstanceElement(event.item).isEnableFill();
                ((TreeItem)event.item).setChecked(isEnableFill);
            }
        });
    }

    private CoverageModel.ICoverageInstanceElement unwrapCoverageInstanceElement(Widget treeItem) {
        return (CoverageModel.ICoverageInstanceElement)((DVTTreeElementWrapper)treeItem.getData()).getRfElement();
    }

    private void createToolbar(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        this.fCollapseAllAction = new AbstractFilteredView.CollapseAllAction((AbstractFilteredView)this);
        this.fExpandAllAction = new AbstractFilteredView.ExpandAllAction((AbstractFilteredView)this);
        this.fSortByTypeAction = new SortByTypeAction();
        tbm.add((IAction)this.fSortByTypeAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fExpandAllAction);
        tbm.add((IAction)this.fCollapseAllAction);
    }

    public void update(BuildEvents updateEvent) {
        try {
            if (this.fTree == null) {
                return;
            }
            IProject project = this.getProject();
            if (project == null || project != null && !project.isAccessible() || !Utils.hasDvtNature((IProject)project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            this.lazyContentProvider.setInput(new ArrayList(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            this.fHasGUIFilteredElements = false;
            this.fUpdateJob.cancel();
            this.fUpdateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.resetElementCount();
            this.fElements = new ArrayList<IDVTElementWrapper>();
            boolean firstElemSelected = false;
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            IProject project = this.getProject();
            CoverageViewInput input = this.coverageViewContributor.getInput(new CoverageViewInputConfigurator(project, this.getSearchSegments("default-filter"), this.getSearchStrictness("default-filter"), ViewsUtils.hasMoreThanOneDVTNature((IProject)project), PrefConst.getCoverageViewSortByType(), updateJob));
            List<IDVTElementWrapper> origElems = input.getElements();
            if (!firstElemSelected && !origElems.isEmpty()) {
                firstElemSelected = ViewsUtils.selectFirstElement((IDVTViewContributor)this.coverageViewContributor, (StringMatcher)this.getLightStringMatcher(), origElems);
            }
            this.fElements.addAll(origElems);
            this.fNrTotalCoverGroups += input.getTotalCoverGroups();
            this.fNrNotFilteredCoverGroups += input.getNotFilteredCoverGroups();
            this.fNrTotalCoverItems += input.getTotalCoverItems();
            this.fNrNotFilteredCoverItems += input.getNotFilteredCoverItems();
            this.fHasGUIFilteredElements = this.fHasGUIFilteredElements || input.hasGUIFilteredElements();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateGuiPart(UpdateJob updateJob) {
        try {
            IProject project = this.getProject();
            if (this.lazyContentProvider != null && this.fElements != null && this.fInfo != null && project != null) {
                StringMatcher sm = this.getStringMatcher("default-filter");
                if (this.fElements.isEmpty()) {
                    if (sm != null && !sm.getPattern().isEmpty()) {
                        this.lazyContentProvider.setInput(new ArrayList(NO_MATCHES_FOUND), this.fExpandLevel);
                    } else if (this.fHasGUIFilteredElements) {
                        this.lazyContentProvider.setInput(new ArrayList(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
                    } else {
                        this.lazyContentProvider.setInput(new ArrayList(NO_DATA_MESSAGE), this.fExpandLevel);
                    }
                } else {
                    this.lazyContentProvider.setInput(this.fElements, this.fExpandLevel);
                }
                StringBuilder infoText = new StringBuilder();
                infoText.append("[").append(project.getName()).append("]").append("[");
                if (this.fNrTotalCoverGroups == this.fNrNotFilteredCoverGroups) {
                    infoText.append(this.fNrTotalCoverGroups);
                } else {
                    infoText.append(this.fNrNotFilteredCoverGroups).append("/").append(this.fNrTotalCoverGroups);
                }
                infoText.append(ViewsUtilsCommon.getUnitName((String)"cover group", (int)this.fNrTotalCoverGroups, (String)" ", (String)"")).append("][");
                if (this.fNrTotalCoverItems == this.fNrNotFilteredCoverItems) {
                    infoText.append(this.fNrTotalCoverItems);
                } else {
                    infoText.append(this.fNrNotFilteredCoverItems).append("/").append(this.fNrTotalCoverItems);
                }
                infoText.append(ViewsUtilsCommon.getUnitName((String)"cover item", (int)this.fNrTotalCoverItems, (String)" ", (String)"")).append("]");
                this.fInfo.setText(infoText.toString());
                ProjectColorUtils.setFgBg((IDVTColoredView)this, (String)project.getName());
                if (EclipseUtils.isAtLeastEclipse419()) {
                    this.fContentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
                }
                this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private StringMatcher getLightStringMatcher() {
        StringMatcher currentStringMatcher = this.getStringMatcher("default-filter");
        if (currentStringMatcher == null) {
            return null;
        }
        String currentPattern = currentStringMatcher.getPattern().replace("//", "");
        if (!currentPattern.contains("/")) {
            return new StringMatcher(currentPattern, true, false);
        }
        String[] parts = currentPattern.split("/");
        String newPattern = parts[parts.length - 1];
        if (!newPattern.startsWith("*")) {
            newPattern = "*" + newPattern;
        }
        return new StringMatcher(newPattern, true, false);
    }

    public void dispose() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.dispose();
        }
        if (this.fInfo != null && !this.fInfo.isDisposed()) {
            this.fInfo.dispose();
        }
        if (this.fContentFiltersLabel != null && !this.fContentFiltersLabel.isDisposed()) {
            this.fContentFiltersLabel.dispose();
        }
        this.fTree = null;
        this.fInfo = null;
        this.lazyContentProvider = null;
        this.fContentFiltersLabel = null;
        super.dispose();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper wrapper = this.getSelectedWrapper(treeId);
        if (wrapper == null) {
            return;
        }
        if (!(wrapper instanceof DVTTreeElementWrapper)) {
            return;
        }
        CoverageModel.ICoverageInstanceElement element = (CoverageModel.ICoverageInstanceElement)((DVTTreeElementWrapper)wrapper).getRfElement();
        if (element == null) {
            return;
        }
        IProject project = this.getProject();
        RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(element.getRfElement(), project, null, null);
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.fTree.setRedraw(false);
            this.update(null);
            this.fTree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Tree getTree(String treeId) {
        return this.fTree;
    }

    public Object getTreeRootElement(String treeId) {
        return this.fTree.getData();
    }

    public DVTBaseLabelProvider getLabelProvider() {
        return this.coverageViewContributor.getLabelProvider(null);
    }

    public String prepareText(String textFilterId, String text) {
        if (!(text.trim().length() == 0 || text.endsWith("//") && text.endsWith("/"))) {
            text = String.valueOf(text) + "//";
        }
        return text;
    }

    public void refreshSelection(IResource resource) {
    }

    private void resetElementCount() {
        this.fNrTotalCoverGroups = 0;
        this.fNrNotFilteredCoverGroups = 0;
        this.fNrTotalCoverItems = 0;
        this.fNrNotFilteredCoverItems = 0;
    }

    public void clean() {
        this.fUpdateJob.cancel();
        this.resetElementCount();
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !Utils.hasDvtNature((IProject)project)) {
            this.fInfo.setText("[no DVT Project or file selected]");
            ProjectColorUtils.setFgBg((IDVTColoredView)this, null);
            this.lazyContentProvider.setInput(new ArrayList(INPUT_SELECT_PROJECT_OR_FILE), this.fExpandLevel);
            this.fContentFiltersLabel.setEnabled(false);
        } else {
            this.fInfo.setText("[" + project.getName() + "][" + this.fNrTotalCoverGroups + " cover groups]");
            ProjectColorUtils.setFgBg((IDVTColoredView)this, (String)project.getName());
            this.lazyContentProvider.setInput(new ArrayList(NO_DATA_MESSAGE), this.fExpandLevel);
            if (EclipseUtils.isAtLeastEclipse419()) {
                this.fContentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
            }
            this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
        }
    }

    public TreeViewContentProvider getExpandableContentProvider() {
        return this.lazyContentProvider;
    }

    public Control getControlToColorBg() {
        return this.fInfo.getParent();
    }

    public Control getControlToColorFg() {
        return this.fInfo;
    }

    class SortByTypeAction
    extends Action {
        public SortByTypeAction() {
            super("Category Sort", 2);
            this.setDescription("Sort by Category");
            this.setToolTipText("Sort Elements by Category");
            this.setImageDescriptor(DVTImages.CATEGORY_SORT);
            this.setChecked(PrefConst.getCoverageViewSortByType());
        }

        public void run() {
            PrefConst.setCoverageViewSortByType((boolean)this.isChecked());
            CoverageView.this.update(null);
        }
    }
}

