/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.coverage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.elaboration.CoverageModel;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.CoverageViewInput;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.CoverageViewInputConfigurator;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.CoverageViewLabelProvider;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.ICoverageViewContributor;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class CoverageViewContributor
implements ICoverageViewContributor {
    private CoverageViewLabelProvider fLabelProvider = new CoverageViewLabelProvider();
    private int fNrTotalCoverGroups;
    private int fNrNotFilteredCoverGroups;
    private int fNrTotalCoverItems;
    private int fNrNotFilteredCoverItems;
    private boolean fHasGUIFilteredElements;

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        Object rfElement = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)rfElement;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (object == null || !(object instanceof RfNamedElement)) {
                return;
            }
            RfNamedElement element = (RfNamedElement)object;
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(element, project, null, null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public CoverageViewInput getInput(CoverageViewInputConfigurator inputSourceConfigurator) {
        this.fNrTotalCoverGroups = 0;
        this.fNrNotFilteredCoverGroups = 0;
        this.fNrTotalCoverItems = 0;
        this.fNrNotFilteredCoverItems = 0;
        this.fHasGUIFilteredElements = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!(inputSourceConfigurator.getSource() instanceof IProject)) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, elements, this.fHasGUIFilteredElements);
            }
            IProject project = (IProject)inputSourceConfigurator.getSource();
            if (!project.isAccessible() || !project.hasNature("ro.amiq.pssdt.pssnature")) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, elements, this.fHasGUIFilteredElements);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, elements, this.fHasGUIFilteredElements);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, elements, this.fHasGUIFilteredElements);
            }
            List<IDVTElementWrapper> wrappers = this.toWrappers(rfProject, inputSourceConfigurator.getSearchSegments(), inputSourceConfigurator.getSearchStrictness(), inputSourceConfigurator.getUpdateJob());
            if (wrappers == null || wrappers.isEmpty()) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, elements, this.fHasGUIFilteredElements);
            }
            this.internalSort(wrappers, inputSourceConfigurator.isSortByType());
            elements.addAll(wrappers);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, elements, this.fHasGUIFilteredElements);
    }

    private List<IDVTElementWrapper> toWrappers(RfProject rfProject, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        DVTTreeElementWrapper childWrapper;
        DVTTreeElementWrapper wrapper;
        CoverageModel coverageModel = ScenarioUtils.getCovergeModel();
        if (coverageModel == null) {
            return Collections.emptyList();
        }
        ArrayList<DVTTreeElementWrapper> wrappers = new ArrayList<DVTTreeElementWrapper>();
        for (CoverageModel.CoverpointInstance coverpointInstance : coverageModel.getPerScopeCoverpoints()) {
            wrapper = new DVTTreeElementWrapper((Object)coverpointInstance);
            wrappers.add(wrapper);
            for (CoverageModel.BinInstance bin : coverpointInstance.getBins()) {
                childWrapper = new DVTTreeElementWrapper((Object)bin);
                wrapper.addChild((IDVTElementWrapper)childWrapper);
            }
        }
        for (CoverageModel.CoverpointInstance coverpointInstance : coverageModel.getPerInstanceCoverpoints()) {
            wrapper = new DVTTreeElementWrapper((Object)coverpointInstance);
            wrappers.add(wrapper);
            for (CoverageModel.BinInstance bin : coverpointInstance.getBins()) {
                childWrapper = new DVTTreeElementWrapper((Object)bin);
                wrapper.addChild((IDVTElementWrapper)childWrapper);
            }
        }
        DVTTreeElementWrapper noLibsRoot = new DVTTreeElementWrapper((Object)"");
        noLibsRoot.addChildren(wrappers);
        this.countCoverGorupsAndItems((IDVTElementWrapper)noLibsRoot, true);
        ViewsUtils.hierarchicalSearch((IDVTElementWrapper)noLibsRoot, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness);
        this.countCoverGorupsAndItems((IDVTElementWrapper)noLibsRoot, false);
        return noLibsRoot.getChildren();
    }

    private void countCoverGorupsAndItems(IDVTElementWrapper root, boolean total) {
        if (root == null) {
            return;
        }
        if (!root.hasChildren()) {
            return;
        }
        if (root.getRfElement() instanceof CoverageModel.CoverpointInstance) {
            return;
        }
        List children = root.getChildren();
        if (children == null) {
            return;
        }
        HashSet<String> covergroups = new HashSet<String>();
        for (IDVTElementWrapper child : children) {
            CoverageModel.CoverpointInstance coverpoint = (CoverageModel.CoverpointInstance)child.getRfElement();
            int coverpointNameIndex = coverpoint.getName().lastIndexOf(46);
            covergroups.add(coverpoint.getName().substring(0, coverpointNameIndex));
        }
        if (total) {
            this.fNrTotalCoverGroups = covergroups.size();
            this.fNrTotalCoverItems += children.size();
        } else {
            this.fNrNotFilteredCoverGroups = covergroups.size();
            this.fNrNotFilteredCoverItems += children.size();
        }
        for (IDVTElementWrapper child : children) {
            this.countCoverGorupsAndItems(child, total);
        }
    }

    private void internalSort(List<IDVTElementWrapper> wrappers, boolean sortByType) {
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfCovergroup || rfElement instanceof RfField) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element)) || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getColumnText(element, 1));
        }
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }
}

