/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.debug;

import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.debug.core.launching.DebugLaunchUtils;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.pssdt.model.debug.core.EvalDebugTarget;
import ro.amiq.pssdt.model.debug.core.EvalDebugThread;
import ro.amiq.pssdt.model.debug.core.EvalDebugValue;
import ro.amiq.pssdt.model.debug.core.EvalDebugVariable;
import ro.amiq.pssdt.model.debug.core.EvalStackFrame;
import ro.amiq.pssdt.model.debug.core.IEvalDebugManager;
import ro.amiq.pssdt.model.debug.core.IRfDebugElement;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfExecBlock;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.MethodCallContext;
import ro.amiq.pssdt.model.reflection.elaboration.NestedBlockContext;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.ModelWalker;
import ro.amiq.pssdt.parser.PSSCompiler;
import ro.amiq.pssdt.parser.PSSFileInstance;
import ro.amiq.pssdt.parser.SemanticWalker;
import ro.amiq.pssdt.parser.utils.BitVectorInt;
import ro.amiq.pssdt.ui.editor.PSSFileEditorInput;

public class SolverDebugger
implements IBreakpointManagerListener,
IBreakpointListener,
ISourceLocator,
ISourcePresentation,
IEvalDebugManager {
    private static final String PSS_DEBUG_LAUNCH_CONFIGURATION_ID = "ro.amiq.pssdt.model.reflection.elaboration.debug.SolverDebugLaunchConfiguration";
    private static final String NULL_VARIABLE_VALUE = "[null]";
    private static final int BUCKET_SIZE = 100;
    private Map<ParserPath, BitSet> breakpointsMap = new HashMap<ParserPath, BitSet>();
    private boolean isEnabled;
    private Solver solver;
    private Launch debugLaunch;
    private EvalDebugTarget debugTarget;
    private EvalDebugThread debugThread;
    private ArrayDeque<EvalStackFrame> stackFrames;
    private final int[] prevStackFrameSize = new int[]{-1};
    private InstancesContainer currentInstanceScope;
    private Map<InstancesContainer, String> prevVariablesMap = new IdentityHashMap<InstancesContainer, String>();
    private Map<InstancesContainer, String> currVariablesMap = new IdentityHashMap<InstancesContainer, String>();

    public SolverDebugger(Solver solver, String diagramName) {
        this.solver = solver;
        this.isEnabled = DebugPlugin.getDefault().getBreakpointManager().isEnabled();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.collectBreakpoints(solver.getRfProject());
        this.debugLaunch = this.createLaunch(solver);
        this.debugTarget = new EvalDebugTarget((ILaunch)this.debugLaunch, diagramName, null, this);
        this.debugLaunch.addDebugTarget((IDebugTarget)this.debugTarget);
        this.debugThread = new EvalDebugThread(this.debugTarget, "Thread [main]", null);
        this.debugTarget.setThread(this.debugThread);
        this.stackFrames = new ArrayDeque();
        this.debugThread.setStackFrames(this.stackFrames);
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)this.debugLaunch);
    }

    private final Launch createLaunch(Solver solver) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(PSS_DEBUG_LAUNCH_CONFIGURATION_ID);
            ILaunchConfigurationWorkingCopy launchConfig = null;
            launchConfig = type.newInstance(null, solver.getRfProject().getProject().getName());
            return new Launch((ILaunchConfiguration)launchConfig, "debug", (ISourceLocator)this);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new Launch(null, "debug", null){

                public ISourceLocator getSourceLocator() {
                    return SolverDebugger.this;
                }
            };
        }
    }

    public final void terminate() {
        try {
            this.debugTarget.terminate();
            DebugPlugin.getDefault().getLaunchManager().removeLaunch((ILaunch)this.debugLaunch);
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public final void fireTerminateEvent() {
        try {
            IProgressMonitor monitor = this.solver.getMonitor();
            if (monitor != null) {
                monitor.setCanceled(true);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private final void collectBreakpoints(RfProject rfProject) {
        try {
            IBreakpoint[] breakpoints;
            ArrayList<IBreakpoint> unsupportedBreakpoints = new ArrayList<IBreakpoint>();
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof LineBreakpoint) {
                    IMarker marker = breakpoint.getMarker();
                    int line = marker.getAttribute("lineNumber", -1);
                    ParserPath parserPath = rfProject.resource2parser(marker.getResource());
                    BitSet lineSet = this.breakpointsMap.get(parserPath);
                    if (lineSet == null) {
                        lineSet = new BitSet();
                        this.breakpointsMap.put(parserPath, lineSet);
                    }
                    if (breakpoint.isEnabled()) {
                        lineSet.add(line);
                    } else if (lineSet.member(line)) {
                        lineSet.remove(line);
                    }
                } else {
                    unsupportedBreakpoints.add(breakpoint);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public final void breakpointManagerEnablementChanged(boolean enabled) {
        this.isEnabled = enabled;
    }

    public final void breakpointAdded(IBreakpoint breakpoint) {
        this.collectBreakpoints(this.solver.getRfProject());
    }

    public final void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.collectBreakpoints(this.solver.getRfProject());
    }

    public final void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.collectBreakpoints(this.solver.getRfProject());
    }

    public final void debugBeginEvaluate(Expression expression, InstancesContainer currentInstanceScope) {
        try {
            this.currentInstanceScope = currentInstanceScope;
            ParserPath parserPath = expression.getParserPath();
            int lineNumber = expression.getLine();
            if (expression instanceof Expression.ExecBlockCall) {
                RfExecBlock rfExecBlock = ((Expression.ExecBlockCall)expression).getRfExecBlock();
                EvalStackFrame stackFrame = new EvalStackFrame(this.debugTarget, this.debugThread, this.stackFrames.size(), lineNumber, parserPath, new InstanceScopeWrapper(currentInstanceScope, rfExecBlock), this);
                this.stackFrames.push(stackFrame);
                return;
            }
            if (expression instanceof Expression.MethodCall && currentInstanceScope instanceof MethodCallContext) {
                EvalStackFrame stackFrame = new EvalStackFrame(this.debugTarget, this.debugThread, this.stackFrames.size(), lineNumber, parserPath, new InstanceScopeWrapper(currentInstanceScope, null), this);
                this.stackFrames.push(stackFrame);
                return;
            }
            if (!this.isEnabled) {
                return;
            }
            if (this.stackFrames.isEmpty()) {
                return;
            }
            EvalStackFrame stackFrame = this.stackFrames.peek();
            if (currentInstanceScope instanceof NestedBlockContext) {
                stackFrame.pushInstanceScope(new InstanceScopeWrapper(currentInstanceScope, null));
            }
            stackFrame.setLineNumber(lineNumber);
            stackFrame.setParserPath(parserPath);
            RfProject rfProject = this.solver.getRfProject();
            int stepKind = this.debugThread.getStepKind();
            switch (stepKind) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.stackFrames.size() <= this.prevStackFrameSize[0]) break;
                    LineBreakpoint lineBreakpoint = this.getLineBreakpoint(rfProject, lineNumber, parserPath);
                    this.setBreakpoint(lineBreakpoint);
                    if (lineBreakpoint != null) break;
                    return;
                }
                case 4: {
                    if (this.stackFrames.size() < this.prevStackFrameSize[0]) break;
                    LineBreakpoint lineBreakpoint = this.getLineBreakpoint(rfProject, lineNumber, parserPath);
                    this.setBreakpoint(lineBreakpoint);
                    if (lineBreakpoint != null) break;
                    return;
                }
                default: {
                    LineBreakpoint lineBreakpoint = this.getLineBreakpoint(rfProject, lineNumber, parserPath);
                    this.setBreakpoint(lineBreakpoint);
                    if (lineBreakpoint != null) break;
                    return;
                }
            }
            this.prevStackFrameSize[0] = this.stackFrames.size();
            ScenarioUtils.background(this.solver);
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DebugLaunchUtils.switchToDebugPerspective();
                }
            });
            this.debugTarget.suspend();
            try {
                IProgressMonitor monitor = this.solver.getMonitor();
                while (!this.debugTarget.isTerminated() && this.debugTarget.isSuspended() && monitor != null && !monitor.isCanceled()) {
                    Thread.sleep(200L);
                }
            }
            catch (Throwable e) {
                DVTLogger.INSTANCE.logError(e);
            }
            this.resume();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public final boolean isSuspended() {
        if (this.debugTarget == null) {
            return false;
        }
        return this.debugTarget.isSuspended();
    }

    private final void setBreakpoint(LineBreakpoint lineBreakpoint) {
        this.debugThread.setBreakpoint(lineBreakpoint);
    }

    public final void debugFinishEvaluate(Expression expression, InstancesContainer currentInstanceScope) {
        try {
            if (this.stackFrames.isEmpty()) {
                return;
            }
            if (expression instanceof Expression.ExecBlockCall) {
                this.stackFrames.pop();
                return;
            }
            if (expression instanceof Expression.MethodCall && currentInstanceScope instanceof MethodCallContext) {
                this.stackFrames.pop();
                return;
            }
            if (this.stackFrames.isEmpty()) {
                return;
            }
            EvalStackFrame stackFrame = this.stackFrames.peek();
            if (currentInstanceScope instanceof NestedBlockContext) {
                stackFrame.popInstanceScope();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private final LineBreakpoint getLineBreakpoint(RfProject rfProject, int lineNumber, ParserPath parserPath) {
        IBreakpointManager breakpointManager;
        block8: {
            if (parserPath == null || lineNumber < 0) {
                return null;
            }
            BitSet lines = this.breakpointsMap.get(parserPath);
            if (lines == null) {
                return null;
            }
            if (!lines.member(lineNumber)) {
                return null;
            }
            breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            if (breakpointManager.isEnabled()) break block8;
            return null;
        }
        try {
            IBreakpoint[] breakpoints;
            IBreakpoint[] iBreakpointArray = breakpoints = breakpointManager.getBreakpoints();
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource;
                LineBreakpoint lineBreakpoint;
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof LineBreakpoint && breakpoint.isEnabled() && (lineBreakpoint = (LineBreakpoint)breakpoint).getLineNumber() == lineNumber && parserPath.equals((Object)rfProject.resource2parser(resource = lineBreakpoint.getMarker().getResource()))) {
                    return lineBreakpoint;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public final boolean hasLineBreakpoint(RfNamedElement rfElement) {
        if (!this.isEnabled || rfElement == null) {
            return false;
        }
        RfDefElement declaration = rfElement.getDeclaration();
        if (declaration == null) {
            return false;
        }
        ParserPath parserPath = declaration.getParserPath();
        int startLine = declaration.getStartLine();
        int endLine = declaration.getEndLine();
        if (parserPath == null || startLine < 0 || endLine < 0) {
            return false;
        }
        BitSet lines = this.breakpointsMap.get(parserPath);
        if (lines == null) {
            return false;
        }
        int line = startLine;
        while (line < endLine) {
            if (lines.member(line)) {
                return true;
            }
            ++line;
        }
        return false;
    }

    public final IEditorInput getEditorInput(Object element) {
        if (element instanceof ParserPath) {
            final IEditorPart[] editor = new IEditorPart[1];
            RfProject rfProject = this.solver.getRfProject();
            editor[0] = rfProject.getEditor((ParserPath)element);
            if (editor[0] != null) {
                return editor[0].getEditorInput();
            }
            final IFile file = DVTFileUtils.getInstance().findProjectFile(rfProject.getProject(), ((ParserPath)element).path);
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                        editor[0] = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
            if (editor[0] != null) {
                return editor[0].getEditorInput();
            }
            return new PSSFileEditorInput(new File(((ParserPath)element).path));
        }
        return null;
    }

    public final String getEditorId(IEditorInput input, Object element) {
        return "ro.amiq.pssdt.ui.editor.PSSEditor";
    }

    public final Object getSourceElement(IStackFrame stackFrame) {
        return ((EvalStackFrame)stackFrame).getParserPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean hasVariables(IRfDebugElement rfElement) {
        try {
            InstancesContainer instancesContainer;
            if (rfElement == null) {
                return false;
            }
            InstancesContainer currentInstance = ((InstanceScopeWrapper)rfElement).getInstance();
            if (!(currentInstance instanceof NestedBlockContext)) {
                if (!this.hasVariables(currentInstance)) return false;
                return true;
            }
            ArrayList<InstancesContainer> instancesContainers = new ArrayList<InstancesContainer>();
            do {
                instancesContainers.add(currentInstance);
            } while (!(currentInstance instanceof MethodCallContext) && (currentInstance = ((NestedBlockContext)currentInstance).getParentInstance()) instanceof NestedBlockContext);
            while (true) {
                if (!(currentInstance instanceof NestedBlockContext)) {
                    if (((InstanceScopeWrapper)rfElement).instanceScope == currentInstance || !this.hasVariables(currentInstance)) break;
                    return true;
                }
                currentInstance = ((NestedBlockContext)currentInstance).getParentInstance();
            }
            Collections.reverse(instancesContainers);
            Iterator iterator = instancesContainers.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.hasVariables(instancesContainer = (InstancesContainer)iterator.next()));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public final IVariable[] getVariables(IRfDebugElement rfElement, int bucketIndex) {
        ArrayList<IVariable> variables = new ArrayList<IVariable>();
        try {
            if (rfElement == null) {
                return variables.toArray(new IVariable[variables.size()]);
            }
            InstancesContainer currentInstance = ((InstanceScopeWrapper)rfElement).getInstance();
            if (currentInstance instanceof NestedBlockContext) {
                ArrayList<InstancesContainer> instancesContainers = new ArrayList<InstancesContainer>();
                do {
                    instancesContainers.add(currentInstance);
                } while (!(currentInstance instanceof MethodCallContext) && (currentInstance = ((NestedBlockContext)currentInstance).getParentInstance()) instanceof NestedBlockContext);
                while (currentInstance instanceof NestedBlockContext) {
                    currentInstance = ((NestedBlockContext)currentInstance).getParentInstance();
                }
                if (((InstanceScopeWrapper)rfElement).instanceScope != currentInstance) {
                    this.createThisVariable(currentInstance, variables);
                }
                Collections.reverse(instancesContainers);
                for (InstancesContainer instancesContainer : instancesContainers) {
                    this.collectVariables(variables, instancesContainer, -1);
                }
            } else {
                this.collectVariables(variables, currentInstance, bucketIndex);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return variables.toArray(new IVariable[variables.size()]);
    }

    private final void createThisVariable(InstancesContainer thisInstance, List<IVariable> variables) throws DebugException {
        if (thisInstance == null) {
            return;
        }
        InstanceScopeWrapper instancesContainerWrapper = new InstanceScopeWrapper(thisInstance, null);
        EvalDebugVariable variable = new EvalDebugVariable(this.debugTarget, "this", this.getFieldDeclaredTypeName(thisInstance), instancesContainerWrapper, this);
        EvalDebugValue value = new EvalDebugValue(this.debugTarget, this.getClassReferenceName(thisInstance), instancesContainerWrapper, -1, this);
        variable.setValue(value);
        variables.add(variable);
    }

    private final String getClassReferenceName(InstancesContainer thisContainer) {
        try {
            FieldInstance fieldInstance = thisContainer.getFieldInstance("[unique_id]");
            return ro.amiq.pssdt.model.reflection.elaboration.util.Utils.append(fieldInstance.getParentInstance().getRfFieldType().getElabName(), "@", fieldInstance.getVariableValue(true).toString());
        }
        catch (Exception exception) {
            return "";
        }
    }

    private final void collectVariables(List<IVariable> variables, InstancesContainer instancesContainer, int bucketIndex) {
        try {
            instancesContainer = ro.amiq.pssdt.model.reflection.elaboration.util.Utils.unwrapReferenceInstance(instancesContainer);
            Collection<? extends InstancesContainer> childrenInstances = instancesContainer.debuggerGetMembers();
            if (childrenInstances == null || childrenInstances.isEmpty()) {
                return;
            }
            int itemCount = -1;
            if (bucketIndex == -1) {
                InstanceScopeWrapper instancesContainerWrapper;
                if (instancesContainer instanceof ActionInstance) {
                    ComponentInstance componentInstance = instancesContainer.getParentComponentInstance();
                    instancesContainerWrapper = new InstanceScopeWrapper(componentInstance, null);
                    EvalDebugVariable evalDebugVariable = new EvalDebugVariable(this.debugTarget, "comp", this.getCompFieldTypeName(instancesContainer), instancesContainerWrapper, this);
                    EvalDebugValue value = new EvalDebugValue(this.debugTarget, this.getClassReferenceName(componentInstance), instancesContainerWrapper, -1, this);
                    evalDebugVariable.setValue(value);
                    variables.add(evalDebugVariable);
                }
                int n = instancesContainer.getArraySize();
                instancesContainerWrapper = new InstanceScopeWrapper(instancesContainer, null);
                for (InstancesContainer instancesContainer2 : childrenInstances) {
                    InstancesContainer parentInstance;
                    if (instancesContainer2.isUniqueIdField()) continue;
                    InstancesContainer instancesContainer3 = parentInstance = instancesContainer2 instanceof FieldInstance ? ((FieldInstance)instancesContainer2).getParentInstance() : null;
                    if (parentInstance instanceof PortInstance && ((PortInstance)parentInstance).isInput() && ((PortInstance)parentInstance).isState() && "prev".equals(instancesContainer2.getName()) || instancesContainer2 instanceof PortInstance.StatePrevPortInstance) continue;
                    if (instancesContainer2.isArrayItem()) {
                        ++itemCount;
                    }
                    if (n > 100 && instancesContainer2.isArrayItem()) {
                        if (itemCount % 100 != 0) continue;
                        String name = ro.amiq.pssdt.model.reflection.elaboration.util.Utils.append("[", itemCount, "..", Math.min(itemCount + 100, n) - 1, "]");
                        EvalDebugVariable variable = new EvalDebugVariable(this.debugTarget, name, null, instancesContainerWrapper, this);
                        EvalDebugValue value = new EvalDebugValue(this.debugTarget, "", instancesContainerWrapper, itemCount / 100, this);
                        variable.setValue(value);
                        variables.add(variable);
                        continue;
                    }
                    this.createVariable(variables, instancesContainer2);
                }
            } else {
                for (InstancesContainer instancesContainer4 : childrenInstances) {
                    if (instancesContainer4.isUniqueIdField() || !instancesContainer4.isArrayItem() || ++itemCount < bucketIndex * 100 || itemCount >= (bucketIndex + 1) * 100) continue;
                    this.createVariable(variables, instancesContainer4);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private final String getCompFieldTypeName(InstancesContainer instancesContainer) {
        block3: {
            try {
                if (instancesContainer != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        RfStruct rfAction = ((ActionInstance)instancesContainer).getRfAction();
        RfNamedElement rfCompField = rfAction.getLocalMember(null, Collections.singleton(RfPredefinedField.class), "comp", false, null);
        return ((RfField)rfCompField).getAssociatedTypeName();
    }

    private final String getFieldActualTypeName(InstancesContainer instancesContainer) {
        block5: {
            block4: {
                try {
                    if (instancesContainer != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            instancesContainer = ro.amiq.pssdt.model.reflection.elaboration.util.Utils.unwrapReferenceInstance(instancesContainer);
            if (instancesContainer != null) break block5;
            return null;
        }
        return this.getFieldDeclaredTypeName(instancesContainer);
    }

    private final String getFieldDeclaredTypeName(InstancesContainer instancesContainer) {
        RfField rfField;
        block7: {
            block6: {
                try {
                    if (instancesContainer != null) break block6;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            rfField = instancesContainer.getRfField();
            if (rfField != null) break block7;
            return null;
        }
        DataType dataType = rfField.getDataType();
        boolean isSetType = instancesContainer.isSetType();
        boolean isArrayItem = instancesContainer.isArrayItem();
        if (isSetType && isArrayItem && dataType != null && dataType.getKeyDataType() != null) {
            return dataType.getKeyDataType().getTypeName();
        }
        if (!isSetType && isArrayItem && dataType != null && dataType.getValueDataType() != null) {
            return dataType.getValueDataType().getTypeName();
        }
        return rfField.getAssociatedTypeName();
    }

    private final void createVariable(List<IVariable> variables, InstancesContainer instance) {
        try {
            InstanceScopeWrapper fieldInstanceWrapper = new InstanceScopeWrapper(instance, null);
            EvalDebugVariable variable = new EvalDebugVariable(this.debugTarget, instance.getName(), this.getFieldDeclaredTypeName(instance), fieldInstanceWrapper, this);
            EvalDebugValue value = new EvalDebugValue(this.debugTarget, null, fieldInstanceWrapper, -1, this);
            variable.setValue(value);
            variables.add(variable);
            InstancesContainer unwrappedInstance = ro.amiq.pssdt.model.reflection.elaboration.util.Utils.unwrapReferenceInstance(instance);
            Expression.Value variableValueExpr = unwrappedInstance.getVariableDebuggerValue();
            String valueText = null;
            if (variableValueExpr != null) {
                valueText = Expression.Value.isInteger(variableValueExpr) ? unwrappedInstance.toStringVariableValue() : (Expression.Value.isEnumItem(variableValueExpr) ? unwrappedInstance.toStringVariableValue() : variableValueExpr.toString());
            }
            value.setValue(valueText);
            variable.setValueChanged(this.hasValueChanged(instance, valueText));
            this.currVariablesMap.put(instance, valueText == null ? NULL_VARIABLE_VALUE : valueText);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private final void resume() throws DebugException {
        this.prevVariablesMap.putAll(this.currVariablesMap);
        this.debugTarget.resume();
    }

    private final boolean hasValueChanged(InstancesContainer instancesContainer, String valueText) {
        String existingValueText;
        block4: {
            existingValueText = this.prevVariablesMap.get(instancesContainer);
            if (existingValueText != null) break block4;
            return false;
        }
        try {
            if (!existingValueText.equals(valueText)) {
                return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean hasVariables(InstancesContainer instancesContainer) {
        try {
            instancesContainer = ro.amiq.pssdt.model.reflection.elaboration.util.Utils.unwrapReferenceInstance(instancesContainer);
            Collection<? extends InstancesContainer> childrenInstances = instancesContainer.debuggerGetMembers();
            if (childrenInstances == null) return false;
            if (childrenInstances.isEmpty()) {
                return false;
            }
            Iterator<? extends InstancesContainer> iterator = childrenInstances.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                InstancesContainer childInstance = iterator.next();
                if (!childInstance.isUniqueIdField()) return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public final String getText(IRfDebugElement rfElement) {
        try {
            return ro.amiq.pssdt.model.reflection.elaboration.util.Utils.append(((InstanceScopeWrapper)rfElement).getDebugName());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "[unknown]";
        }
    }

    @Override
    public final void setVariableValue(IRfDebugElement rfElement, String expression) {
        try {
            BitVectorInt number = SemanticUtils.asBitVector(null, null, expression, true, 1024, 0, null);
            if (number == null) {
                Utils.popMessage((int)1, (String)"Set Variable Value Error", (String)"DVT was unable to set the variable value.");
                return;
            }
            InstancesContainer currentInstance = ((InstanceScopeWrapper)rfElement).getInstance();
            currentInstance.setVariableValue(Expression.Value.from(number.bigIntegerValue(), number.nofBits(), true));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final IWatchExpressionResult getWatchExpressionResult(String expression, IRfScopeElement cursorScope, IStackFrame[] stackFrames) {
        try {
            EvalStackFrame evalStackFrame = (EvalStackFrame)stackFrames[0];
            if (cursorScope instanceof IRfDefElement) {
                IRfNamedElement rfElementScope = ((IRfDefElement)cursorScope).getNamedElement();
                RfMethod rfMethodScope = rfElementScope instanceof RfMethod ? (RfMethod)rfElementScope : (RfMethod)rfElementScope.getEnclosingScope(RfMethod.class);
                IStackFrame[] iStackFrameArray = stackFrames;
                int n = stackFrames.length;
                int n2 = 0;
                while (n2 < n) {
                    RfMethod rfMethodCandidate;
                    InstancesContainer instance;
                    IStackFrame stackFrame = iStackFrameArray[n2];
                    IRfDebugElement element = ((EvalStackFrame)stackFrame).getRfElement();
                    if (element instanceof InstanceScopeWrapper && (instance = ((InstanceScopeWrapper)element).getInstance()) instanceof MethodCallContext && rfMethodScope == (rfMethodCandidate = ((MethodCallContext)instance).getRfMethod())) {
                        evalStackFrame = (EvalStackFrame)stackFrame;
                        break;
                    }
                    ++n2;
                }
            }
            this.solver.setDisablePrint(true);
            if (expression == null) {
                this.solver.setDisablePrint(false);
                return null;
            }
            IWatchExpressionResult result = this.evaluateExpression(expression = expression.trim(), evalStackFrame);
            if (result != null) {
                IWatchExpressionResult iWatchExpressionResult = result;
                this.solver.setDisablePrint(false);
                return iWatchExpressionResult;
            }
            InstancesContainer instancesContainer = this.currentInstanceScope;
            while (instancesContainer != null) {
                InstancesContainer fieldInstance = ro.amiq.pssdt.model.reflection.elaboration.util.Utils.unwrapReferenceInstance(instancesContainer.getFieldInstance(expression));
                if (fieldInstance != null) {
                    Expression.Value value = fieldInstance.getVariableDebuggerValue();
                    String valueText = value == null ? null : value.toString();
                    InstanceScopeWrapper fieldInstanceWrapper = new InstanceScopeWrapper(fieldInstance, null);
                    EvalDebugValue debugValue = new EvalDebugValue(this.debugTarget, valueText, fieldInstanceWrapper, -1, this);
                    WatchExpressionResult watchExpressionResult = new WatchExpressionResult(expression, debugValue, null);
                    this.solver.setDisablePrint(false);
                    return watchExpressionResult;
                }
                try {
                    if (instancesContainer instanceof NestedBlockContext) {
                        instancesContainer = ((NestedBlockContext)instancesContainer).getParentInstance();
                        continue;
                    }
                    if (instancesContainer instanceof ActionInstance) {
                        instancesContainer = ((ActionInstance)instancesContainer).getParentComponentInstance();
                        continue;
                    }
                    if (!(instancesContainer instanceof ComponentInstance)) return new WatchExpressionResult(expression, null, "evaluation failed");
                    instancesContainer = ((ComponentInstance)instancesContainer).getParentComponentInstance();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return new WatchExpressionResult(expression, null, "evaluation failed");
                }
            }
            return new WatchExpressionResult(expression, null, "evaluation failed");
        }
        finally {
            this.solver.setDisablePrint(false);
        }
    }

    private final IWatchExpressionResult evaluateExpression(String expression, EvalStackFrame stackFrame) {
        Expression.Value variableValue;
        List<Expression.ExprAndDep<Expression.Value>> value;
        Expression expr;
        block16: {
            block15: {
                RfDefElement currScope;
                AST exprAST;
                PSSFileInstance fileInstance;
                ParserPath parserPath;
                RfProject rfProject;
                block14: {
                    IDocument document;
                    RfFileDef currFileDef;
                    int currLineNumber;
                    block13: {
                        DVTEditor currEditor;
                        block12: {
                            ParserPath currParserPath;
                            block11: {
                                block10: {
                                    try {
                                        rfProject = this.solver.getRfProject();
                                        PSSCompiler exprEvalParser = new PSSCompiler();
                                        parserPath = new ParserPath("<expression>");
                                        fileInstance = new PSSFileInstance(rfProject, parserPath, -1, -1, null);
                                        exprAST = exprEvalParser.parseExpression(IBuildConfigParserConstants.LanguageSyntax.PSS, rfProject, fileInstance, parserPath, expression);
                                        if (exprAST != null) break block10;
                                        return null;
                                    }
                                    catch (Exception exception) {
                                        return null;
                                    }
                                }
                                currParserPath = stackFrame.getParserPath();
                                currLineNumber = stackFrame.getLineNumber();
                                currFileDef = rfProject.getFile(currParserPath);
                                if (currFileDef != null) break block11;
                                return null;
                            }
                            currEditor = rfProject.getEditor(currParserPath);
                            if (currEditor != null) break block12;
                            return null;
                        }
                        document = currEditor.getDocument();
                        if (document != null) break block13;
                        return null;
                    }
                    int offset = document.getLineOffset(currLineNumber);
                    currScope = currFileDef.getScope(offset);
                    if (currScope != null) break block14;
                    return null;
                }
                RfFileDef fileDef = new RfFileDef("<expression>", -1, parserPath, rfProject.getLocalLibrary("work"), IBuildConfigParserConstants.LanguageSyntax.PSS);
                SemanticWalker semanticWalker = new SemanticWalker(rfProject, fileInstance, fileDef);
                semanticWalker.setTemplateReparse(null, currScope);
                semanticWalker.expression(exprAST);
                ModelWalker modelWalker = new ModelWalker(this.solver, parserPath);
                expr = modelWalker.getExpression(exprAST);
                if (expr != null) break block15;
                return null;
            }
            value = expr.evaluate(this.solver.getScenario(), this.currentInstanceScope);
            if (value != null && !value.isEmpty()) break block16;
            return null;
        }
        InstancesContainer fieldInstance = null;
        if (expr instanceof Expression.Hid && !((Expression.Hid)expr).getIds().isEmpty()) {
            List<InstancePath> variablesPaths = ((Expression.Hid)expr).getVariablesPaths(this.solver.getScenario(), false, this.currentInstanceScope, true, Integer.MAX_VALUE);
            fieldInstance = variablesPaths == null || variablesPaths.isEmpty() ? null : variablesPaths.get(0).getInstance();
        }
        String valueText = (variableValue = value.get(0).value()) == null ? null : variableValue.toString();
        InstanceScopeWrapper fieldInstanceWrapper = fieldInstance == null ? null : new InstanceScopeWrapper(fieldInstance, null);
        EvalDebugValue debugValue = new EvalDebugValue(this.debugTarget, valueText, fieldInstanceWrapper, -1, this);
        return new WatchExpressionResult(expression, debugValue, null);
    }

    @Override
    public final String getValueTypeName(IRfDebugElement rfElement) {
        try {
            InstancesContainer instancesContainer = ((InstanceScopeWrapper)rfElement).instanceScope;
            return this.getFieldActualTypeName(instancesContainer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static class InstanceScopeWrapper
    implements IRfDebugElement {
        private String name;
        private InstancesContainer instanceScope;
        private RfExecBlock rfExecBlock;

        public InstanceScopeWrapper(InstancesContainer instanceScope, RfExecBlock rfExecBlock) {
            this.name = instanceScope.toString();
            this.instanceScope = instanceScope;
            this.rfExecBlock = rfExecBlock;
        }

        public InstancesContainer getInstance() {
            return this.instanceScope;
        }

        public String getDebugName() {
            try {
                if (this.rfExecBlock != null) {
                    return ro.amiq.pssdt.model.reflection.elaboration.util.Utils.append("exec ", this.rfExecBlock.getElabName(), "()");
                }
                if (this.instanceScope instanceof MethodCallContext) {
                    RfMethod rfMethod = ((MethodCallContext)this.instanceScope).getRfMethod();
                    return ro.amiq.pssdt.model.reflection.elaboration.util.Utils.append(rfMethod.getElabName(), "(", rfMethod.getArgs(true, false, false), ")");
                }
                return this.instanceScope.getName();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "[unknown]";
            }
        }

        @Override
        public Image getImage() {
            if (this.rfExecBlock != null) {
                return this.rfExecBlock.getImage();
            }
            if (this.instanceScope instanceof MethodCallContext) {
                RfMethod rfMethod = ((MethodCallContext)this.instanceScope).getRfMethod();
                return rfMethod == null ? null : rfMethod.getImage();
            }
            RfField rfField = this.instanceScope.getRfField();
            return rfField == null ? null : rfField.getImage();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class WatchExpressionResult
    implements IWatchExpressionResult {
        private String expression;
        private IValue value;
        private String errorMessage;

        public WatchExpressionResult(String expression, IValue value, String errorMessage) {
            this.expression = expression;
            this.value = value;
            this.errorMessage = errorMessage;
        }

        public IValue getValue() {
            return this.value;
        }

        public boolean hasErrors() {
            return this.errorMessage != null;
        }

        public String[] getErrorMessages() {
            String[] stringArray;
            if (this.errorMessage == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.errorMessage;
            }
            return stringArray;
        }

        public String getExpressionText() {
            return this.expression;
        }

        public DebugException getException() {
            return null;
        }
    }
}

