/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.foreign;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.apache.commons.io.output.NullWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.model.reflection.elaboration.foreign.ForeignJavaUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.SolverConsole;
import ro.amiq.pssdt.model.reflection.elaboration.util.SolverConsoleRegistry;

public enum ForeignJavaCompiler {
    INSTANCE;

    private JavaCompiler fCompiler = new EclipseCompiler();
    private MemoryFileManager fManager;
    private List<String> fOptions;
    private ErrorsCollector<JavaFileObject> fDiagCollector;
    private Map<String, Property> fCompiledClasses;
    private ForeignClassLoader fClassLoader;
    private boolean fDebugLog;
    private static final Pattern MEMO_PATH;

    static {
        MEMO_PATH = Pattern.compile("memo://");
    }

    public boolean doCompile(Map<String, String> classes, boolean[] nothingToCompile, File classPathDir) {
        String javaTypeName;
        int newHash;
        if (this.fCompiler == null) {
            return false;
        }
        if (this.fManager == null) {
            this.fManager = new MemoryFileManager(this.fCompiler);
        }
        if (this.fCompiledClasses == null) {
            this.fCompiledClasses = new HashMap<String, Property>();
        }
        this.fDiagCollector = new ErrorsCollector();
        ArrayList<Source> list = new ArrayList<Source>();
        for (Map.Entry<String, String> entry : classes.entrySet()) {
            String javaTypeClass = entry.getValue();
            if (javaTypeClass == null) continue;
            String javaTypeName2 = entry.getKey();
            Property oldProperty = this.fCompiledClasses.get(javaTypeName2);
            newHash = javaTypeClass.hashCode();
            if (oldProperty != null && oldProperty.getHashCode() == newHash) {
                if (!oldProperty.hasErrors()) continue;
                nothingToCompile[0] = true;
                return false;
            }
            list.add(new Source(javaTypeName2, JavaFileObject.Kind.SOURCE, javaTypeClass));
        }
        if (list.isEmpty()) {
            nothingToCompile[0] = true;
            return true;
        }
        if (this.fDebugLog) {
            DVTLogger.INSTANCE.logDebug("FOREIGN_JAVA_IO: *** Info:  Recompiling list (removed cached classes): " + ((Object)list).toString());
        }
        this.fClassLoader = null;
        boolean success = this.doCompile(list, classPathDir);
        for (Source source : list) {
            String javaTypeClass = (String)source.getCharContent(false);
            javaTypeName = source.getRawName();
            newHash = javaTypeClass.hashCode();
            this.fCompiledClasses.put(javaTypeName, new Property(newHash));
        }
        if (!success) {
            for (Diagnostic diagnostic : this.fDiagCollector.getDiagnostics()) {
                Property property;
                JavaFileObject source;
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR || !((source = (JavaFileObject)diagnostic.getSource()) instanceof Source) || (property = this.fCompiledClasses.get(javaTypeName = ((Source)source).getRawName())) == null) continue;
                property.setHasErrors();
            }
        }
        nothingToCompile[0] = false;
        return success;
    }

    public synchronized void clean(boolean cleanCompiledClasses) {
        if (cleanCompiledClasses) {
            if (this.fManager != null) {
                this.fManager.clear();
            }
            if (this.fCompiledClasses != null) {
                this.fCompiledClasses.clear();
            }
        }
        this.fClassLoader = null;
        this.fDiagCollector = new ErrorsCollector();
    }

    public byte[] getBytecode(String className) {
        ByteArrayOutputStream output;
        block3: {
            try {
                output = this.fManager.getOutputStream(className.replace('/', '.'));
                if (output != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        byte[] bytecode = output.toByteArray();
        output.close();
        return bytecode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doCompile(List<Source> list, File classPathDir) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (NullWriter out = new NullWriter();){
                this.initClassPath(classPathDir);
                JavaCompiler.CompilationTask compilationTask = this.fCompiler.getTask((Writer)out, this.fManager, this.fDiagCollector, this.fOptions, null, list);
                if (compilationTask != null) return compilationTask.call();
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void initClassPath(File classPathDir) {
        if (this.fOptions != null) {
            return;
        }
        this.fOptions = ForeignJavaUtils.initClassPath(classPathDir);
    }

    public ClassLoader getClassLoader() {
        if (this.fClassLoader == null) {
            this.fClassLoader = new ForeignClassLoader(((Object)((Object)this)).getClass());
        }
        return this.fClassLoader;
    }

    public void printErrors(IProject project, String debugPath) {
        if (project == null || this.fDiagCollector == null) {
            return;
        }
        String fullDebugPath = debugPath == null ? "" : Path.fromOSString((String)debugPath).append("ro.amiq.pssdt.debug.foreign.java".replace('.', '/')).toOSString();
        for (Diagnostic<JavaFileObject> diagnostic : this.fDiagCollector.getDiagnostics()) {
            try {
                URI uri;
                SolverConsole console;
                String message;
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR || (message = diagnostic.getMessage(null)) == null) continue;
                message = MEMO_PATH.matcher(message).replaceFirst(fullDebugPath);
                if (this.fDebugLog) {
                    DVTLogger.INSTANCE.logDebug("FOREIGN_JAVA_IO: *** COMPILER ERROR: " + message);
                }
                if ((console = SolverConsoleRegistry.getConsole(project)) == null) {
                    return;
                }
                int index = message.lastIndexOf(".java:");
                if (index > 0 && (index = message.indexOf(58, index + 6)) > 0) {
                    message = message.substring(index + 1).trim();
                }
                message = message.replace("\n", "\n    ");
                String fileName = null;
                JavaFileObject source = diagnostic.getSource();
                if (source != null && (uri = source.toUri()) != null) {
                    fileName = uri.toString();
                }
                if (fileName == null) {
                    Field fileNameField = diagnostic.getClass().getDeclaredField("val$originatingFileName");
                    fileNameField.setAccessible(true);
                    char[] fileNameCharArray = (char[])fileNameField.get(diagnostic);
                    fileName = "memo://" + new String(fileNameCharArray);
                }
                fileName = MEMO_PATH.matcher(fileName).replaceFirst(fullDebugPath);
                String messageToPrint = "*** Error: COMPILER_ERROR: " + message + "\n    at line " + (diagnostic.getLineNumber() - 1L) + " in " + fileName;
                console.print(messageToPrint);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (Exception exception) {}
        }
    }

    protected void setDebugLog(boolean debugLog) {
        this.fDebugLog = debugLog;
    }

    public final class ErrorsCollector<S>
    implements DiagnosticListener<S> {
        private List<Diagnostic<? extends S>> fDiagnostics = new ArrayList<Diagnostic<? extends S>>();

        @Override
        public void report(Diagnostic<? extends S> diagnostic) {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                this.fDiagnostics.add(diagnostic);
            }
        }

        public List<Diagnostic<? extends S>> getDiagnostics() {
            return Collections.unmodifiableList(this.fDiagnostics);
        }

        public void clear() {
            if (!this.fDiagnostics.isEmpty()) {
                this.fDiagnostics.clear();
            }
        }
    }

    class ForeignClassLoader
    extends ClassLoader {
        protected Map<String, Class<?>> fLoadedClasses;

        public ForeignClassLoader(Class<?> parent) {
            super(parent.getClassLoader());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (this.fLoadedClasses == null) {
                this.fLoadedClasses = new HashMap();
            }
            if (this.fLoadedClasses.containsKey(name)) {
                return this.fLoadedClasses.get(name);
            }
            byte[] bytecode = ForeignJavaCompiler.this.getBytecode(name);
            if (bytecode == null) {
                return null;
            }
            Class<?> clazz = this.defineClass(name, bytecode, 0, bytecode.length);
            this.fLoadedClasses.put(name, clazz);
            return clazz;
        }
    }

    private final class MemoryFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private Map<String, Output> fMap;

        protected MemoryFileManager(JavaCompiler compiler) {
            super(compiler.getStandardFileManager(null, null, null));
            this.fMap = new HashMap<String, Output>();
        }

        @Override
        public Output getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject source) {
            Output mc = new Output(name.replace('/', '.'), kind);
            this.fMap.put(name, mc);
            return mc;
        }

        protected ByteArrayOutputStream getOutputStream(String name) {
            Output clazz = this.fMap.get(name.replace('.', '/'));
            if (clazz == null) {
                return null;
            }
            return clazz.openOutputStream();
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            Output clazz = this.fMap.get(className);
            if (clazz != null) {
                return clazz;
            }
            JavaFileObject result = super.getJavaFileForInput(location, className, kind);
            return result;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            if (packageName.replace('.', '/').equals("ro.amiq.pssdt.debug.foreign.java")) {
                ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(this.fMap.values());
                return result;
            }
            return super.list(location, packageName.replace('/', '.'), kinds, recurse);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof Output) {
                return file.getName().substring(1).replace(".class", "").replace('/', '.');
            }
            String result = super.inferBinaryName(location, file);
            return result;
        }

        public void clear() {
            this.fMap.clear();
        }
    }

    private final class Output
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream fOutput;

        protected Output(String name, JavaFileObject.Kind kind) {
            super(URI.create("memo:///" + name + kind.extension), kind);
            this.fOutput = new ByteArrayOutputStream();
        }

        @Override
        public ByteArrayOutputStream openOutputStream() {
            return this.fOutput;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.fOutput.toByteArray());
        }
    }

    public final class Property {
        int fHashCode;
        boolean fHasErrors;

        public Property(int hashCode) {
            this.fHashCode = hashCode;
        }

        public int getHashCode() {
            return this.fHashCode;
        }

        public void setHasErrors() {
            this.fHasErrors = true;
        }

        public boolean hasErrors() {
            return this.fHasErrors;
        }
    }

    private final class Source
    extends SimpleJavaFileObject {
        private final String fContent;
        private final String fName;

        protected Source(String name, JavaFileObject.Kind kind, String content) {
            super(URI.create("memo:///" + name.replace('.', '/') + kind.extension), kind);
            this.fName = name;
            this.fContent = content;
        }

        public String getRawName() {
            return this.fName;
        }

        @Override
        public CharSequence getCharContent(boolean ignore) {
            return this.fContent;
        }
    }
}

