/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.foreign;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.core.PSSPlugin;

public class ForeignJavaUtils {
    public static final Pattern WS_COMMA_WS = Pattern.compile("\\s*,\\s*");

    public static List<String> initClassPath(File classPathDir) {
        StringBuilder classPathBuilder = new StringBuilder();
        Bundle dvtBundle = DVTPlugin.getDefault().getBundle();
        Bundle pssBaseBundle = PSSPlugin.getDefault().getBundle();
        try {
            String[] candidates;
            String[] stringArray = candidates = DVTStringUtil.split((Pattern)WS_COMMA_WS, (String)((String)pssBaseBundle.getHeaders().get("Bundle-ClassPath")));
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate = stringArray[n2];
                URL url = FileLocator.find((Bundle)pssBaseBundle, (IPath)new Path(candidate), null);
                if (url != null) {
                    classPathBuilder.append(File.pathSeparator).append(FileLocator.toFileURL((URL)url).getPath());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        try {
            Bundle adaptableBundle = FrameworkUtil.getBundle(IAdaptable.class);
            File bundleFile = FileLocator.getBundleFile((Bundle)adaptableBundle);
            if (bundleFile != null) {
                classPathBuilder.append(File.pathSeparator).append(bundleFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
        try {
            String bundleFilePath;
            File bundleFile = FileLocator.getBundleFile((Bundle)pssBaseBundle);
            if (bundleFile != null) {
                bundleFilePath = bundleFile.getAbsolutePath();
                classPathBuilder.append(File.pathSeparator).append(bundleFilePath);
                if (!bundleFilePath.endsWith(".jar")) {
                    classPathBuilder.append(File.separator).append("bin");
                }
            }
            if ((bundleFile = FileLocator.getBundleFile((Bundle)dvtBundle)) != null) {
                bundleFilePath = bundleFile.getAbsolutePath();
                classPathBuilder.append(File.pathSeparator).append(bundleFilePath);
                if (!bundleFilePath.endsWith(".jar")) {
                    classPathBuilder.append(File.separator).append("bin");
                }
            }
        }
        catch (Exception exception) {}
        classPathDir.list((dir, name) -> {
            if (name.endsWith(".jar")) {
                classPathBuilder.append(File.pathSeparator).append(dir.getAbsolutePath()).append(File.separator).append(name);
            }
            return false;
        });
        String classPath = classPathBuilder.toString();
        DVTLogger.INSTANCE.logInfo("CLASS_PATH = " + classPath);
        return Arrays.asList("-classpath", classPath, "-1.8", "-nowarn");
    }
}

