/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class ByteArrayOutputStream
extends OutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected byte[] buffer;
    protected int size;

    public ByteArrayOutputStream() {
        this(1024);
    }

    public ByteArrayOutputStream(int size) {
        this.buffer = new byte[size];
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.buffer.length;
        if (minCapacity - oldCapacity > 0) {
            int newCapacity = oldCapacity << 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = ByteArrayOutputStream.hugeCapacity(minCapacity);
            }
            this.buffer = Arrays.copyOf(this.buffer, newCapacity);
        }
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void write(int dataByte) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.size] = (byte)dataByte;
        ++this.size;
    }

    @Override
    public void write(byte[] dataBytes, int offset, int length) {
        if (offset < 0 || offset > dataBytes.length || length < 0 || offset + length - dataBytes.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + length);
        System.arraycopy(dataBytes, offset, this.buffer, this.size, length);
        this.size += length;
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    @Override
    public void close() throws IOException {
    }
}

