/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.util;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.RfClassType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.elaboration.CoverageModel;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.debug.SolverDebugger;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;

public final class ScenarioUtils {
    public static final String UNIQUE_ID_FIELD_NAME = "[unique_id]";
    private static final List<RfNamedElement> mapKeyToRf = new ArrayList<RfNamedElement>();
    private static final Map<RfNamedElement, Integer> mapRfToKey = new IdentityHashMap<RfNamedElement, Integer>();
    private static final List<AST> mapKeyToAst = new ArrayList<AST>();
    private static final Map<AST, Integer> mapAstToKey = new IdentityHashMap<AST, Integer>();
    private static int uniqueId = -1;
    private static Solver solver;
    private static ProgressMonitorJobsDialog progressDialog;
    private static final Object FAMILY_SCENARIO;
    private static boolean isSolverSessionRunning;
    private static final Map<RfNamedElement, String> mapUniqueNames;
    public static final String INDENT_STOP = "\u2007   ";
    public static final String INDENT_CONT = "    ";
    public static final String NL_INDENT_CONT = "\n    ";
    public static final String INTERNAL_FIELD_PREFIX = "___internal";

    static {
        FAMILY_SCENARIO = new Object();
        mapUniqueNames = new IdentityHashMap<RfNamedElement, String>();
    }

    private ScenarioUtils() {
    }

    public static final int getKeyOfRf(RfNamedElement element) {
        if (element == null) {
            return -1;
        }
        Integer key = mapRfToKey.get(element);
        if (key != null) {
            return key;
        }
        key = mapKeyToRf.size();
        mapKeyToRf.add(element);
        mapRfToKey.put(element, key);
        return key;
    }

    public static final RfNamedElement getRfOfKey(int key) {
        if (key < 0) {
            return null;
        }
        return mapKeyToRf.get(key);
    }

    public static final int getKeyOfAst(AST ast) {
        if (ast == null) {
            return -1;
        }
        Integer key = mapAstToKey.get(ast);
        if (key != null) {
            return key;
        }
        key = mapKeyToAst.size();
        mapKeyToAst.add(ast);
        mapAstToKey.put(ast, key);
        return key;
    }

    public static final AST getAstOfKey(int key) {
        if (key < 0) {
            return null;
        }
        return mapKeyToAst.get(key);
    }

    public static final void clear() {
        mapKeyToRf.clear();
        mapRfToKey.clear();
        mapKeyToAst.clear();
        mapAstToKey.clear();
        mapUniqueNames.clear();
        uniqueId = -1;
    }

    public static final int getUniqueId() {
        return ++uniqueId;
    }

    public static final void setSolver(Solver solver) {
        ScenarioUtils.solver = solver;
    }

    public static final Solver getSolver() {
        return solver;
    }

    public static final Scenario getScenario() {
        return solver.getScenario();
    }

    public static final void logError(String message, int line, ParserPath parserPath) {
        if (line < 0 || parserPath == null) {
            solver.logError(Utils.append("*** Error: ", message));
        } else {
            solver.logError(Utils.append("*** Error: ", message, NL_INDENT_CONT, "at line ", line, " in '", parserPath.path, "'"));
        }
    }

    public static final void logWarning(String message, int line, ParserPath parserPath) {
        if (line < 0 || parserPath == null) {
            solver.logWarning(Utils.append("*** Warning: ", message));
        } else {
            solver.logWarning(Utils.append("*** Warning: ", message, NL_INDENT_CONT, "at line ", line, " in '", parserPath.path, "'"));
        }
    }

    public static final void print(String message) {
        solver.print(message);
    }

    public static final void print(int severity, String message) {
        solver.print(severity, message);
    }

    public static final void print(String message, boolean reportOnce) {
        solver.print(message, reportOnce);
    }

    public static final void printWarning(String message, boolean reportOnce, RfDefElement rfDefElement) {
        if (rfDefElement == null) {
            ScenarioUtils.printError(message, reportOnce, -1, null);
            return;
        }
        ScenarioUtils.printWarning(message, reportOnce, rfDefElement.getStartLine(), rfDefElement.getParserPath());
    }

    public static final void printWarning(String message, boolean reportOnce, int line, ParserPath parserPath) {
        if (line < 0 || parserPath == null) {
            solver.print(Utils.append("*** Warning: ", message, "\r"), reportOnce);
        } else {
            solver.print(Utils.append("*** Warning: ", message, NL_INDENT_CONT, "at line ", line, " in '", parserPath.path, "'\r"), reportOnce);
        }
    }

    public static final void printError(String message, boolean reportOnce, RfDefElement rfDefElement) {
        if (rfDefElement == null) {
            ScenarioUtils.printError(message, reportOnce, -1, null);
            return;
        }
        ScenarioUtils.printError(message, reportOnce, rfDefElement.getStartLine(), rfDefElement.getParserPath());
    }

    public static final void printError(String message, boolean reportOnce, int line, ParserPath parserPath) {
        if (line < 0 || parserPath == null) {
            solver.print(Utils.append("*** Error: ", message), reportOnce);
        } else {
            solver.print(Utils.append("*** Error: ", message, NL_INDENT_CONT, "at line ", line, " in '", parserPath.path, "'\r"), reportOnce);
        }
    }

    public static final void printNote(String message, boolean reportOnce, RfDefElement rfDefElement) {
        if (rfDefElement == null) {
            ScenarioUtils.printNote(message, reportOnce, -1, null);
            return;
        }
        ScenarioUtils.printNote(message, reportOnce, rfDefElement.getStartLine(), rfDefElement.getParserPath());
    }

    public static final void printNote(String message, boolean reportOnce, int line, ParserPath parserPath) {
        if (line < 0 || parserPath == null) {
            solver.print(Utils.append("*** Note: ", message), reportOnce);
        } else {
            solver.print(Utils.append("*** Note: ", message, NL_INDENT_CONT, "at line ", line, " in '", parserPath.path, "'\r"), reportOnce);
        }
    }

    public static final void printInternalError(RfProject rfProject) {
        if (rfProject == null) {
            return;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return;
        }
        IWorkspace workspace = project.getWorkspace();
        if (workspace == null) {
            return;
        }
        IWorkspaceRoot root = workspace.getRoot();
        if (root == null) {
            return;
        }
        IPath location = root.getLocation();
        if (location == null) {
            return;
        }
        solver.print(Utils.append("*** Error: See the error log for more details\n", INDENT_CONT, "at line ", 0, " in ", location.toOSString(), "/.metadata/.log"));
    }

    public static final void printDebug1(String message) {
        solver.printDebug1(message);
    }

    public static final void printDebug2(String message) {
        solver.printDebug2(message);
    }

    public static final Object invokeMethod(String methodName, Class<?>[] parameterTypes, Object[] parameterValues) {
        return solver.invokeMethod(methodName, parameterTypes, parameterValues);
    }

    public static final boolean hasForeignEvaluator() {
        return solver.hasForeignEvaluator();
    }

    public static Solver generateScenario(final RootDescriptor rootDescriptor, final Long keepSeedValue, final boolean isBlocking) {
        final Solver solver = new Solver();
        try {
            Job job = new Job("Solving scenario ... "){

                public boolean belongsTo(Object family) {
                    return family == FAMILY_SCENARIO;
                }

                public boolean shouldRun() {
                    if (isSolverSessionRunning) {
                        SolverDebugger debugger = ScenarioUtils.getSolver().getDebugger();
                        if (debugger.isSuspended()) {
                            ro.amiq.dvt.ui.Utils.popMessage((int)1, (String)"Solve Scenario Error", (String)"DVT cannot solve the scenario because there is another solver session running.");
                        }
                        return false;
                    }
                    return super.shouldRun();
                }

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            isSolverSessionRunning = true;
                            monitor.beginTask("Solving scenario ... ", -1);
                            solver.setDisableDebug(isBlocking);
                            solver.setSolverDone(false);
                            solver.setMonitor(monitor);
                            ScenarioUtils.foreground(solver);
                            solver.createModel(rootDescriptor.rfProject);
                            solver.setRootAction(rootDescriptor.rfInstance, rootDescriptor.rfComponent, rootDescriptor.rfAction, keepSeedValue);
                        }
                        catch (Solver.InterruptException interruptException) {
                            monitor.done();
                            solver.setSolverDone(true);
                            solver.setMonitor(null);
                            isSolverSessionRunning = false;
                        }
                    }
                    finally {
                        monitor.done();
                        solver.setSolverDone(true);
                        solver.setMonitor(null);
                        isSolverSessionRunning = false;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.schedule();
            if (isBlocking) {
                job.join();
            }
        }
        catch (Exception exception) {}
        return solver;
    }

    public static void background(Solver solver) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (progressDialog == null) {
                return;
            }
            progressDialog.getProgressMonitor().done();
            progressDialog.close();
            progressDialog = null;
        });
    }

    public static void foreground(Solver solver) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                progressDialog = new ProgressMonitorJobsDialog2();
                progressDialog.run(true, true, monitor -> {
                    try {
                        monitor.beginTask("Solving scenario ... ", -1);
                        IProgressMonitor monitor2 = solver.getMonitor();
                        while (!(monitor.isCanceled() || monitor2 == null || monitor2.isCanceled() || solver.isSolverDone() || PlatformUI.getWorkbench().isClosing())) {
                            Thread.sleep(200L);
                        }
                        if (monitor2 != null && monitor.isCanceled()) {
                            monitor2.setCanceled(true);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final RfDefElement getDeclaration(InstancesContainer.GeneratedVar generatedVar) {
        if (generatedVar == null || generatedVar.getInstance() == null) {
            return null;
        }
        parentInstance = generatedVar.getInstance();
        rfElement /* !! */  = parentInstance.getRfField();
        if (rfElement /* !! */  != null) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            if (!(parentInstance.getRfFieldType() instanceof RfTemplateInstance)) continue;
            rfElement /* !! */  = parentInstance.getRfField();
lbl9:
            // 3 sources

            ** while (parentInstance instanceof FieldInstance && (parentInstance = ((FieldInstance)parentInstance).getParentInstance()) != null)
        }
lbl10:
        // 1 sources

        do {
            if ((declaration = rfElement /* !! */ .getDeclaration()) == null) continue;
            return declaration;
        } while ((rfElement /* !! */  = rfElement /* !! */ .getEnclosingScope()) != null);
        return null;
    }

    public static final String getDeduplicateName(RfNamedElement rfElement) {
        String name = rfElement.getElabName();
        if (rfElement.getClass() != RfField.class) {
            return name;
        }
        RfNamedElement rfEnclosingScope = rfElement.getEnclosingScope();
        if (!(rfEnclosingScope instanceof RfStruct)) {
            return name;
        }
        String existingUniqueName = mapUniqueNames.get(rfElement);
        if (existingUniqueName != null) {
            return existingUniqueName;
        }
        int duplicateCount = 0;
        IRfClassType rfParentStruct = (RfStruct)rfEnclosingScope;
        while (rfParentStruct instanceof RfStruct && (rfParentStruct = ((RfClassType)rfParentStruct).getParent()) != null) {
            RfNamedElement rfFieldInParent = rfParentStruct.getLocalMember(null, SemanticUtils.MEMBER_FIELDS, name, false, null);
            if (rfFieldInParent == null) continue;
            ++duplicateCount;
        }
        String uniqueName = duplicateCount == 0 ? name : Utils.append(name, "@", duplicateCount);
        mapUniqueNames.put(rfElement, uniqueName);
        return uniqueName;
    }

    public static CoverageModel getCovergeModel() {
        return solver == null ? null : solver.getCovergeModel();
    }

    static class ProgressMonitorJobsDialog2
    extends ProgressMonitorJobsDialog {
        public ProgressMonitorJobsDialog2() {
            super(ProgressManagerUtil.getDefaultParent());
            this.setShellStyle(ProgressMonitorJobsDialog2.getDefaultOrientation() | 0x800 | 0x20 | 0x10 | 0x400);
        }

        public boolean close() {
            this.decrementNestingDepth();
            return super.close();
        }
    }

    public static class RootDescriptor {
        public RfProject rfProject;
        public RfField rfInstance;
        public RfStruct rfComponent;
        public RfStruct rfAction;

        public RootDescriptor(RfProject rfProject, RfField rfInstance, RfStruct rfComponent, RfStruct rfAction) {
            this.rfProject = rfProject;
            this.rfInstance = rfInstance;
            this.rfComponent = rfComponent;
            this.rfAction = rfAction;
        }
    }
}

