/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.test.TestHelper;

public class SolverConsole
implements IResourceChangeListener {
    public static final String CONSOLE_NAME_PREFIX = "PSS Solver Console for project";
    private static final Pattern PATTERN_TIME_INFO = Pattern.compile("\\s+\\[[0-9]+\\s+ms\\]");
    private static final Set<String> PATTERN_NAMES = new HashSet<String>(Arrays.asList("DVT Error Filter", "DVT Warning Filter", "General Note Filter"));
    private static final String SECTION_FORMAT = "*** {0} ***";
    private IProject fProject;
    private DVTMessageConsole fConsole;
    private IConsoleManager fConsoleManager;
    private MessageConsoleStream fOutputStream;

    public SolverConsole(IProject project) {
        this.fProject = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 14);
    }

    public void clean() {
        this.clearConsole();
    }

    public void done() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                ObjectionManager.getInstance().clear(Objection.CONSOLE_OUTPUT_COMPLETE);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fProject.equals((Object)event.getResource()) && (event.getType() == 4 || event.getType() == 2)) {
            this.removeConsole();
        }
    }

    private void createConsole() {
        try {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            this.fConsoleManager = plugin.getConsoleManager();
            this.fConsole = new DVTMessageConsole(this.fProject, "PSS Solver Console for project [" + this.fProject.getName() + "]", null, new DVTConsoleButtonsDescription(false, false, true));
            this.fConsoleManager.addConsoles(new IConsole[]{this.fConsole});
            this.fOutputStream = this.fConsole.newMessageStream();
            this.setProcessConsole();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void setProcessConsole() {
        ExternalToolsConfiguration config = new ExternalToolsConfiguration();
        ExternalToolsModelManager.getInstance().setProcessConsole((IConsole)this.fConsole, this.fProject, (IExternalToolsConfiguration)config, null, 1, this.fProject.getLocation().toOSString());
    }

    private void clearConsole() {
        if (this.fConsole == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.fConsole == null) {
                return;
            }
            this.fConsole.activate();
            this.fConsole.clearConsole();
            ExternalToolsModelManager.fAppliedPatterns.clear();
            ExternalToolsModelManager.fAppliedProblemsPatterns.clear();
        });
    }

    public void bringToTop() {
        if (this.fConsole == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.fConsole == null) {
                return;
            }
            this.setProcessConsole();
            this.fConsole.activate();
        });
    }

    private void removeConsole() {
        try {
            if (this.fConsole != null) {
                this.fConsole.clearConsole();
                this.fConsoleManager.removeConsoles(new IConsole[]{this.fConsole});
                this.fConsole = null;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void print(String message) {
        this.initSinks();
        this.scheduleProcessMessages(message);
    }

    private void initSinks() {
        if (this.fConsole == null) {
            this.createConsole();
        }
    }

    private void scheduleProcessMessages(String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                this.fOutputStream.print(message);
                this.fOutputStream.println();
                this.fOutputStream.flush();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public void printSection(String message) {
        this.print(MessageFormat.format(SECTION_FORMAT, message));
    }

    public String toString() {
        return "SolverConsole [fProject=" + this.fProject + "]";
    }

    public String testGetConsoleContent() {
        if (this.fConsole == null) {
            return null;
        }
        TestHelper.delay((long)100L);
        IDocument document = this.fConsole.getDocument();
        if (document == null) {
            return null;
        }
        return document.get().replace("\r", "");
    }

    public PrintStream getPrintStream() {
        this.initSinks();
        OutputStream outputStream = new OutputStream(){
            byte[] buff = new byte[0];
            int size;

            @Override
            public void write(int b) throws IOException {
                if (this.size % 256 == 0) {
                    this.buff = Arrays.copyOf(this.buff, this.buff.length + 256);
                }
                this.buff[this.size] = (byte)b;
                ++this.size;
            }

            @Override
            public void flush() throws IOException {
                if (this.size == 0) {
                    return;
                }
                SolverConsole.this.scheduleProcessMessages(new String(this.buff, 0, this.size));
                this.size = 0;
                this.buff = new byte[0];
            }
        };
        return new PrintStream(outputStream, true);
    }

    class ConsoleListener
    implements IConsoleScanListener {
        private TextConsole fTextConsole;
        private Pattern fPattern;
        private String fLineQualifier;
        private TextConsoleViewer fConsoleViewer;

        ConsoleListener(Pattern pattern, String lineQualifier) {
            this.fPattern = pattern;
            this.fLineQualifier = lineQualifier;
        }

        public TextConsole getConsole() {
            return this.fTextConsole;
        }

        public TextConsoleViewer getConsoleViewer() {
            return this.fConsoleViewer;
        }

        public void connect(TextConsole console) {
            this.fTextConsole = console;
        }

        public void disconnect() {
            this.fTextConsole = null;
            this.fConsoleViewer = null;
        }

        public void addHyperlink(int offset, int length) {
            try {
                IDocument document = this.fTextConsole.getDocument();
                String filePath = "";
                int lineNumber = 0;
                String text = document.get(offset, length);
                if (text.startsWith("***") && text.endsWith("***")) {
                    return;
                }
                Matcher m = this.fPattern.matcher(text);
                if (!m.matches() || m.groupCount() < 1) {
                    return;
                }
                filePath = m.group(1);
                if (m.groupCount() >= 2) {
                    lineNumber = DVTStringUtil.parseInt((String)m.group(2), (int)0);
                }
                offset += m.start(1);
                length = filePath.length();
                m = PATTERN_TIME_INFO.matcher(filePath);
                if (m.find()) {
                    filePath = filePath.substring(0, m.start());
                    length = filePath.length();
                }
                if (SolverConsole.this.fProject == null) {
                    return;
                }
                ((DVTMessageConsole)this.fTextConsole).addHyperlink((IHyperlink)new DVTMessageConsole.DummyHyperlinkLineContainer(lineNumber == 0 ? 1 : lineNumber), offset, length);
            }
            catch (Exception exception) {}
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return this.fLineQualifier;
        }

        public String getPattern() {
            return this.fPattern.pattern();
        }

        public Pattern getWholePattern() {
            return this.fPattern;
        }

        public void setConsoleViewer(TextConsoleViewer newConsoleViewer) {
            this.fConsoleViewer = newConsoleViewer;
        }
    }

    private final class ExternalToolsConfiguration
    implements IExternalToolsConfiguration {
        private ExternalToolsConfiguration() {
        }

        public void setWorkingDir(String workingDir) {
        }

        public void setWSLink(boolean wSLink) {
        }

        public void setPatterns(ExternalToolsPattern[] patterns) {
        }

        public void setName(String name) {
        }

        public void setFullCommand(String fullCommand) {
        }

        public void setFilterKinds(String[] filterKinds) {
        }

        public void setEnable(boolean builderEnable) {
        }

        public void setCleanCommand(String cleanCommand) {
        }

        public void setAutoCommand(String autoCommand) {
        }

        public boolean isWSLink() {
            return false;
        }

        public String getWorkingDir() {
            return null;
        }

        public ExternalToolsPattern[] getPatterns() {
            ArrayList<ExternalToolsPattern> result = new ArrayList<ExternalToolsPattern>();
            List patterns = ExternalToolsUtil.getCategoryPatterns((String)"Specman");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns((String)"DVT");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns((String)"General");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            return result.toArray(result.toArray(new ExternalToolsPattern[result.size()]));
        }

        public String getName() {
            return "[" + SolverConsole.this.fProject + "] " + SolverConsole.CONSOLE_NAME_PREFIX;
        }

        public String getFullCommand() {
            return null;
        }

        public String[] getFilterKinds() {
            return new String[0];
        }

        public boolean getEnable() {
            return false;
        }

        public String getConfigurationType() {
            return null;
        }

        public String getCleanCommand() {
            return null;
        }

        public String getAutoCommand() {
            return null;
        }

        public boolean getAttribute(String attributeName, boolean defaultValue) {
            return false;
        }

        public int getAttribute(String attributeName, int defaultValue) {
            return 0;
        }

        public String getAttribute(String attributeName, String defaultValue) {
            return null;
        }

        public List getAttribute(String attributeName, List defaultValue) {
            return null;
        }

        public Set getAttribute(String attributeName, Set defaultValue) {
            return null;
        }

        public Map getAttribute(String attributeName, Map defaultValue) {
            return null;
        }

        public void setAttribute(String attributeName, Object attributeValue) {
        }

        public void removeAttribute(String attributeName) {
        }

        public boolean hasAttribute(String attributeName) {
            return false;
        }

        public Map getAttributes() {
            return null;
        }

        public void setAttributes(Map attributes) {
        }

        public IExternalToolsConfiguration getWorkingCopy() {
            return this;
        }
    }
}

