/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.util;

import java.io.Serializable;
import java.util.Arrays;

public class SolverOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int INITIAL_SIZE = 128;
    private int[] array = new int[128];

    public void set(int level, int value) {
        this.resize(level);
        this.array[level] = value;
    }

    public void increment(int level) {
        this.resize(level);
        int n = level;
        this.array[n] = this.array[n] + 1;
    }

    public void decrement(int level) {
        this.resize(level);
        int n = level;
        this.array[n] = this.array[n] - 1;
    }

    private void resize(int level) {
        if (this.array.length <= level) {
            this.array = Arrays.copyOf(this.array, level + 32);
        }
    }

    public int get(int level) {
        this.resize(level);
        return this.array[level];
    }

    public void removeUpperLevelsOptions(int level) {
        int i = level + 1;
        while (i < this.array.length) {
            this.array[i] = 0;
            ++i;
        }
    }

    public final int nofLowerLevelsOptions(int level) {
        int result = 0;
        int i = 0;
        while (i < level) {
            result += this.array[i];
            ++i;
        }
        return result;
    }

    public int[] getLowerLevelsWithOptions(int level, int nofLevels) {
        int[] newArray = new int[nofLevels];
        int size = 0;
        int i = 0;
        while (i < level && size < nofLevels) {
            if (this.array[i] > 0) {
                newArray[size] = i;
                ++size;
            }
            ++i;
        }
        return Arrays.copyOf(newArray, size);
    }

    public boolean hasRemainingOptions() {
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

