/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.util;

import java.io.Serializable;

public final class SquareByteMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LENGTH_INCREMENT = 16;
    private byte[][] matrix;
    private int length;

    public SquareByteMatrix(int initialLength, int length) {
        this.matrix = new byte[initialLength][initialLength];
        this.length = length;
    }

    public SquareByteMatrix() {
        this(16, 0);
    }

    public final void set(int row, int column, byte value) {
        if (row >= this.matrix.length || column >= this.matrix.length) {
            this.expandMatrixBy(Math.max(row, column) - this.matrix.length + 1 + 16);
        }
        this.length = Math.max(this.length, Math.max(row, column) + 1);
        this.matrix[row][column] = value;
    }

    public final byte get(int row, int column) {
        if (row >= this.matrix.length || column >= this.matrix.length) {
            this.expandMatrixBy(Math.max(row, column) - this.matrix.length + 1 + 16);
        }
        this.length = Math.max(this.length, Math.max(row, column) + 1);
        return this.matrix[row][column];
    }

    public final byte fastGet(int row, int column) {
        return this.matrix[row][column];
    }

    private final void expandMatrixBy(int lengthIncrement) {
        int oldLength = this.matrix.length;
        int newLength = oldLength + lengthIncrement;
        byte[][] result = new byte[newLength][newLength];
        int row = 0;
        while (row < oldLength) {
            System.arraycopy(this.matrix[row], 0, result[row], 0, oldLength);
            ++row;
        }
        this.matrix = result;
    }

    public final SquareByteMatrix createCopy() {
        SquareByteMatrix result = new SquareByteMatrix(this.matrix.length, this.length);
        int row = 0;
        while (row < this.matrix.length) {
            System.arraycopy(this.matrix[row], 0, result.matrix[row], 0, this.matrix.length);
            ++row;
        }
        return result;
    }

    public final int getLength() {
        return this.length;
    }

    public final byte[] getRow(int row) {
        return this.matrix[row];
    }
}

