/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration.util;

import antlr.collections.AST;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.TypeInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Stack;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.ModelWalker;

public final class Utils {
    public static final Pattern NEW_LINE_WS = Pattern.compile("(?U)[\r|\n]\\s*");
    public static final Pattern STRING_NEW_LINE_WS = Pattern.compile("(?U)\\\\[\r|\n]\\s*");
    public static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    public static final IRfElementFilter STATE_PREV_VARIABLE_FILTER = new IRfElementFilter(){

        public boolean validElement(IRfNamedElement candidate) {
            IRfScopeElement enclosingScope;
            return !(candidate instanceof RfPredefinedField) || !"prev".equals(candidate.getName()) || !((enclosingScope = candidate.getEnclosingScope()) instanceof RfStruct) || ((RfStruct)enclosingScope).getStructKind() != StructKind.STATE;
        }

        public int resultMaxSize() {
            return 0;
        }

        public boolean allowEnumElement() {
            return false;
        }
    };
    private static Stack<Set<Object>> setsStack = new Stack();
    private static final int TWO_POW_CACHE_SIZE = 1024;
    private static final BigInteger[] TWO_POW = new BigInteger[1024];
    private static final BigInteger[] TWO_POW_MASK = new BigInteger[1024];

    static {
        Utils.TWO_POW[0] = BigInteger.ONE;
        Utils.TWO_POW_MASK[0] = BigInteger.ZERO;
        int i = 1;
        while (i < 1024) {
            Utils.TWO_POW[i] = TWO_POW[i - 1].shiftLeft(1);
            Utils.TWO_POW_MASK[i] = TWO_POW[i].subtract(BigInteger.ONE);
            ++i;
        }
    }

    public static BigInteger getPowerOfTwo(int exponent) {
        if (exponent <= 0) {
            return TWO_POW[0];
        }
        if (exponent < 1024) {
            return TWO_POW[exponent];
        }
        return BigInteger.ONE.shiftLeft(exponent);
    }

    public static BigInteger getPowerOfTwoMask(int exponent) {
        if (exponent <= 0) {
            return TWO_POW_MASK[0];
        }
        if (exponent < 1024) {
            return TWO_POW_MASK[exponent];
        }
        return Utils.getPowerOfTwo(exponent).subtract(BigInteger.ONE);
    }

    private Utils() {
    }

    public static <T> Set<T> popReusableSet(Class<T> t) {
        if (!setsStack.isEmpty()) {
            return new SetWrapper(setsStack.pop());
        }
        return new SetWrapper(Collections.newSetFromMap(new IdentityHashMap()));
    }

    public static <T> void pushReusableSet(Set<T> s) {
        s.clear();
        setsStack.push(((SetWrapper)s).rawSet);
    }

    public static final <T> T first(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static final <K, V> V first(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        V result = map.values().iterator().next();
        return result;
    }

    public static final <T> T last(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static final boolean isVacuous(ActionInstance a1, ActionInstance a2) {
        if (a1.getRepeatIndex() == -1 || a2.getRepeatIndex() == -1) {
            return false;
        }
        if (a1.getRepeatIndex() == a2.getRepeatIndex()) {
            return false;
        }
        return a1.getParentActionInstance() == a2.getParentActionInstance();
    }

    public static final TypeInstance.TypeKind getMemberTypeKind(IRfAssociatedType rfElement) {
        RfNamedElement rfElementType = Utils.getAssociatedType(rfElement);
        return Utils.getTypeKind(rfElementType);
    }

    public static final TypeInstance.TypeKind getTypeKind(RfNamedElement rfElementType) {
        if (rfElementType instanceof RfCollectionType) {
            DataType.CollectionKind collectionKind = ((RfCollectionType)rfElementType).getCollectionKind();
            if (collectionKind == DataType.CollectionKind.ARRAY || collectionKind == DataType.CollectionKind.ARRAY_INIT) {
                return TypeInstance.TypeKind.ARRAY;
            }
            if (collectionKind == DataType.CollectionKind.LIST) {
                return TypeInstance.TypeKind.LIST;
            }
            if (collectionKind == DataType.CollectionKind.MAP || collectionKind == DataType.CollectionKind.MAP_INIT) {
                return TypeInstance.TypeKind.MAP;
            }
            if (collectionKind == DataType.CollectionKind.SET || collectionKind == DataType.CollectionKind.SET_INIT) {
                return TypeInstance.TypeKind.SET;
            }
        }
        if (rfElementType instanceof RfEnumType) {
            return TypeInstance.TypeKind.ENUM;
        }
        if (rfElementType instanceof RfStruct) {
            return TypeInstance.TypeKind.STRUCT;
        }
        if (rfElementType instanceof RfPredefinedType && "bool".equals(ScenarioUtils.getDeduplicateName(rfElementType))) {
            return TypeInstance.TypeKind.BOOL;
        }
        if (rfElementType instanceof RfPredefinedType && "string".equals(ScenarioUtils.getDeduplicateName(rfElementType))) {
            return TypeInstance.TypeKind.STRING;
        }
        if (rfElementType instanceof RfPredefinedType && "int".equals(ScenarioUtils.getDeduplicateName(rfElementType))) {
            return TypeInstance.TypeKind.INT;
        }
        return TypeInstance.TypeKind.UINT;
    }

    public static final RfNamedElement getArrayItemType(RfCollectionType element) {
        RfNamedElement rfFieldItemType = element.getAssociatedType();
        rfFieldItemType = SemanticUtils.unwrap(rfFieldItemType, true, true);
        return rfFieldItemType;
    }

    public static final RfNamedElement getKeyItemType(RfCollectionType element) {
        RfNamedElement rfKeyItemType = (RfNamedElement)((Object)element.getKeyElementType());
        rfKeyItemType = SemanticUtils.unwrap(rfKeyItemType, true, true);
        return rfKeyItemType;
    }

    public static final RfNamedElement getBaseElementType(RfNamedElement rfFieldType) {
        RfNamedElement baseAssociatedType = SemanticUtils.unwrap(rfFieldType, true, true);
        if (baseAssociatedType instanceof RfCollectionType) {
            baseAssociatedType = ((RfCollectionType)baseAssociatedType).getAssociatedType();
            return Utils.getBaseElementType(baseAssociatedType);
        }
        return baseAssociatedType;
    }

    public static final RfNamedElement getAssociatedType(IRfAssociatedType rfAssocType) {
        return SemanticUtils.unwrap((RfNamedElement)rfAssocType.getAssociatedType(), true, true);
    }

    public static final int getAssociatedTypeArrayDim(RfAssociatedType rfAssocType) {
        return rfAssocType.getAssociatedTypeArrayDimAsInteger();
    }

    public static final int getAssociatedTypeArrayDim(RfMethod rfAssocType) {
        return rfAssocType.getAssociatedTypeArrayDimAsInteger();
    }

    public static final int getAssociatedTypeArrayDim(RfCollectionType rfAssocType) {
        return rfAssocType.getAssociatedTypeArrayDimAsInteger();
    }

    public static final List<Integer> getIndexesList(List<?> anyList) {
        if (anyList == null || anyList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(anyList.size());
        int i = 0;
        while (i < anyList.size()) {
            result.add(i);
            ++i;
        }
        return result;
    }

    public static final String append(Object ... strings) {
        return DVTStringUtil.appendString((Object[])strings);
    }

    public static final String unquote(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static InstancesContainer unwrapReferenceInstance(InstancesContainer instance) {
        if (instance == null) {
            return null;
        }
        Expression.Value value = instance.getVariableValue(false);
        int i = 0;
        block0: while (Expression.Value.isReference(value)) {
            instance = value.getRefValue();
            value = instance.getVariableValue(false);
            if (i == 20) {
                Set visited = Collections.newSetFromMap(new IdentityHashMap());
                while (Expression.Value.isReference(value)) {
                    instance = value.getRefValue();
                    if (visited.contains(instance)) break block0;
                    visited.add(instance);
                    value = instance.getVariableValue(false);
                }
            }
            ++i;
        }
        if (instance.isRef()) {
            return new InstancesContainer.NullRefInstance(instance);
        }
        return instance;
    }

    public static String formatNumber(int radix, BigInteger number, int nofBits, int nofCharsToDelimit) {
        if (nofBits <= 0) {
            nofBits = 32;
        }
        String value = number.toString(radix);
        if (radix == 10) {
            return value;
        }
        String prefix = radix == 16 ? "'h" : "'b";
        StringBuilder sb = new StringBuilder();
        int firstNumberCharIndex = value.startsWith("-") ? 1 : 0;
        int i = value.length() - 1;
        int charCount = 1;
        while (i >= firstNumberCharIndex) {
            sb.append(value.charAt(i));
            if (i != firstNumberCharIndex && charCount % nofCharsToDelimit == 0) {
                sb.append("_");
            }
            --i;
            ++charCount;
        }
        return Utils.append(firstNumberCharIndex == 1 ? "-" : "", nofBits, prefix, sb.reverse().toString());
    }

    public static boolean isSizeofMember(RfField rfField) {
        if (rfField == null) {
            return false;
        }
        FieldModifier fieldModifier = rfField.getFieldModifier();
        if (fieldModifier != FieldModifier.STATIC_CONST) {
            return false;
        }
        String name = rfField.getName();
        if (!"nbits".equals(name) && !"nbytes".equals(name)) {
            return false;
        }
        RfNamedElement rfTemplateInstance = rfField.getEnclosingScope();
        return rfTemplateInstance.isCoreLibInstanceOf("sizeof_s");
    }

    public static int nofBytes(int sizeof) {
        int remainingBits = sizeof % 8;
        if (remainingBits == 0) {
            return sizeof / 8;
        }
        return (sizeof - remainingBits) / 8 + 1;
    }

    public static void flattenFieldInstances(LinkedList<FieldInstance> flattenFieldInstances, InstancesContainer instance, boolean isBigEndian) {
        Map<String, FieldInstance> fieldInstances = instance.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            if (isBigEndian) {
                flattenFieldInstances.add(0, (FieldInstance)instance);
            } else {
                flattenFieldInstances.add((FieldInstance)instance);
            }
            return;
        }
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if (fieldInstance.isUniqueIdField() || fieldInstance.isCollectionSize() || fieldInstance.isCollectionSum()) continue;
            Utils.flattenFieldInstances(flattenFieldInstances, fieldInstance, isBigEndian);
        }
    }

    public static BigInteger unsigned(BigInteger value, int nofBits) {
        if (value.signum() < 0) {
            return Utils.getPowerOfTwo(nofBits).add(value);
        }
        return value;
    }

    private static BigInteger unsigned(BigInteger value, BigInteger twoPowNofBits) {
        if (value.signum() < 0) {
            return twoPowNofBits.add(value);
        }
        return value;
    }

    public static BigInteger signed(BigInteger value, int nofBits) {
        if (value.signum() > 0 && value.testBit(nofBits - 1) && value.compareTo(Utils.getPowerOfTwo(nofBits - 1)) >= 0) {
            return value.subtract(Utils.getPowerOfTwo(nofBits));
        }
        return value;
    }

    private static BigInteger signed(BigInteger value, int nofBits, BigInteger twoPowNofBits) {
        if (value.signum() > 0 && value.testBit(nofBits - 1) && value.bitLength() >= nofBits - 1) {
            return value.subtract(twoPowNofBits);
        }
        return value;
    }

    public static BigInteger truncate(BigInteger value, int nofBits, boolean hasSign) {
        if (!hasSign) {
            if (value.signum() < 0 || value.bitLength() >= nofBits) {
                value = value.mod(Utils.getPowerOfTwo(nofBits));
            }
            return value;
        }
        BigInteger twoPowNofBits = Utils.getPowerOfTwo(nofBits);
        value = Utils.unsigned(value, twoPowNofBits);
        value = value.mod(twoPowNofBits);
        value = Utils.signed(value, nofBits, twoPowNofBits);
        return value;
    }

    public static Expression.Value getInitialValue(Scenario scenario, InstancesContainer instancesContainer) {
        try {
            RfField rfField = instancesContainer.getRfField();
            if (rfField == null) {
                return Expression.Value.from(null);
            }
            if (rfField instanceof RfEnumItem || instancesContainer.isUniqueIdField() && !instancesContainer.isArrayItem()) {
                return Expression.Value.from(rfField.getInitialValue(-1).bigIntegerValue(), 32, true);
            }
            DataType dataType = rfField.getDataType();
            AST exprAST = dataType.getInitialValueAST();
            if (exprAST == null) {
                return Expression.Value.from(BigInteger.ZERO, 32, true);
            }
            if (exprAST.getType() == 276 || exprAST.getType() == 277) {
                RfField rfParamValue = SemanticUtils.getTransientResult(RfField.class, exprAST);
                if (instancesContainer.isEnumType() && rfParamValue instanceof RfTemplateParam.RfInstanceValueParam && rfParamValue.getDataType() != null) {
                    return Expression.Value.from(rfParamValue.getDataType().getInitialValue(-1).bigIntegerValue(), 32, true);
                }
                if (rfParamValue instanceof RfTemplateParam.RfInstanceValueParam && rfParamValue.getDataType() != null) {
                    exprAST = rfParamValue.getDataType().getInitialValueAST();
                }
            }
            RfDefElement declaration = rfField.getDeclaration();
            ModelWalker modelWalker = new ModelWalker(scenario.getSolver(), declaration == null ? null : declaration.getParserPath());
            Expression expression = modelWalker.getExpression(exprAST);
            List<Expression.ExprAndDep<Expression.Value>> exprValue = expression.evaluate(scenario, instancesContainer);
            Expression.Value value = exprValue.get(0).value();
            int nofBits = instancesContainer.nofBits();
            boolean hasSign = instancesContainer.hasSign();
            if (instancesContainer.isHandleType()) {
                if (Expression.Value.isReference(value)) {
                    return Expression.Value.from(value);
                }
                return Expression.Value.from(null, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, false);
            }
            return Expression.Value.from(value, nofBits, hasSign);
        }
        catch (Solver.EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            ScenarioUtils.printInternalError(scenario.getSolver().getRfProject());
            throw new Solver.InterruptException();
        }
    }

    public static List<Expression.ExpressionError> collectErrors(Expression ... exprs) {
        if (exprs == null) {
            return null;
        }
        ArrayList<Expression.ExpressionError> result = null;
        Expression[] expressionArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            List<Expression.ExpressionError> errors;
            Expression expr = expressionArray[n2];
            if (expr != null && (errors = expr.getErrors()) != null) {
                if (result == null) {
                    result = new ArrayList<Expression.ExpressionError>(errors.size());
                }
                result.addAll(errors);
            }
            ++n2;
        }
        return result;
    }

    public static List<Expression.ExpressionError> collectErrors(List<Expression> exprs) {
        if (exprs == null) {
            return null;
        }
        return Utils.collectErrors(exprs.toArray(new Expression[exprs.size()]));
    }

    public static void cleanErrors(Expression ... exprs) {
        if (exprs == null) {
            return;
        }
        Expression[] expressionArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expr = expressionArray[n2];
            if (expr != null) {
                expr.cleanErrors();
            }
            ++n2;
        }
    }

    public static void cleanErrors(List<Expression> exprs) {
        if (exprs == null) {
            return;
        }
        for (Expression expr : exprs) {
            if (expr == null) continue;
            expr.cleanErrors();
        }
    }

    public static BigInteger intValue(FieldInstance fieldInstance) {
        if (fieldInstance == null) {
            return null;
        }
        Expression.Value variableValue = fieldInstance.getVariableValue();
        if (variableValue == null) {
            return null;
        }
        return variableValue.getIntValue();
    }

    public static IntDomain getFullIntDomain(InstancesContainer instance) {
        int nofBits = instance.nofBits();
        boolean hasSign = instance.hasSign();
        BigInteger lowerBound = hasSign ? Utils.getPowerOfTwo(nofBits - 1).negate() : BigInteger.ZERO;
        BigInteger upperBound = hasSign ? Utils.getPowerOfTwoMask(nofBits - 1) : Utils.getPowerOfTwoMask(nofBits);
        return new IntDomain(lowerBound, upperBound);
    }

    public static boolean isRegionInstance(RfNamedElement rfFieldType) {
        return rfFieldType != null && rfFieldType.isCoreLibInstanceOf("addr_region_s");
    }

    public static boolean isAddressClaimInstance(RfNamedElement rfFieldType) {
        return rfFieldType != null && rfFieldType.isCoreLibInstanceOf("addr_claim_s");
    }

    public static boolean isExecutorClaimInstance(RfNamedElement rfFieldType) {
        return rfFieldType != null && rfFieldType.isCoreLibInstanceOf("executor_claim_s");
    }

    public static boolean boolValue(FieldInstance fieldInstance) {
        return !fieldInstance.getVariableValue().getIntValue().equals(BigInteger.ZERO);
    }

    public static int getLine(RfDefElement declaration) {
        return declaration == null ? -1 : declaration.getStartLine();
    }

    public static ParserPath getParserPath(RfDefElement declaration) {
        return declaration == null ? null : declaration.getParserPath();
    }

    public static RfMethod getExecutorOverriddenFunction(RfNamedElement rfExecutorType, RfMethod rfMethod) {
        RfMethod rfOverriddenMethod = (RfMethod)rfExecutorType.getMember(null, RfPackage.ANY_DETERMINANT, rfMethod.getElabName(), false, true, Collections.singleton(RfMethod.class), null);
        if (rfOverriddenMethod == null) {
            return rfMethod;
        }
        return rfOverriddenMethod;
    }

    public static RfMethod getMethod(RfStruct rfStruct, String methodName) {
        if (rfStruct == null) {
            return null;
        }
        RfMethod rfMethod = null;
        do {
            if ((rfMethod = (RfMethod)rfStruct.getLocalMember(null, SemanticUtils.MEMBER_METHODS, methodName, false, null)) == null) continue;
            return rfMethod;
        } while ((rfStruct = (RfStruct)rfStruct.getParent()) != null);
        return null;
    }

    public static RfField getNodeStructTypeField(boolean isList) {
        RfProject rfProject = ScenarioUtils.getSolver().getRfProject();
        RfPackage rfPackage = rfProject.getPackage("addr_reg_pkg");
        RfNamedElement rfFieldType = rfPackage.getLocalMember(null, SemanticUtils.MEMBER_TYPES, "node_s", false, null);
        if (isList) {
            DataType dataType = new DataType("list<node_s>");
            dataType.setItemDataType(null, new DataType("node_s"), DataType.CollectionKind.LIST);
            RfField rfField = new RfField("path", dataType);
            rfField.setAssociatedType(RfCollectionType.createList(rfProject, rfFieldType, dataType));
            return rfField;
        }
        RfField rfField = new RfField("path", new DataType("node_s"));
        rfField.setAssociatedType(rfFieldType);
        return rfField;
    }

    public static final <T> List<T> copy(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list instanceof ArrayList) {
            return new ArrayList<T>(list);
        }
        if (list instanceof LinkedList) {
            return new LinkedList<T>(list);
        }
        if (list.getClass() == Collections.emptyList().getClass()) {
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException();
    }

    public static final <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof LinkedHashMap) {
            return new LinkedHashMap<K, V>(map);
        }
        if (map instanceof IdentityHashMap) {
            return new IdentityHashMap<K, V>(map);
        }
        if (map instanceof HashMap) {
            return new HashMap<K, V>(map);
        }
        if (map.getClass() == Collections.emptyMap().getClass()) {
            return Collections.emptyMap();
        }
        throw new UnsupportedOperationException();
    }

    public static final boolean isPure(RfNamedElement rfElement) {
        if (rfElement instanceof RfCollectionType) {
            return Utils.isPure(Utils.getArrayItemType((RfCollectionType)rfElement));
        }
        if (rfElement instanceof RfStruct) {
            return ((RfStruct)rfElement).hasQualifier(1);
        }
        return false;
    }

    public static String processHrText(String hrText) {
        boolean removeEnclosingParens;
        boolean bl = removeEnclosingParens = hrText.startsWith("(") && hrText.endsWith(")");
        if (!removeEnclosingParens) {
            return hrText;
        }
        int nofParens = 0;
        int i = 1;
        while (i < hrText.length() - 1) {
            char ch = hrText.charAt(i);
            if (ch == '(') {
                ++nofParens;
            } else if (ch == ')') {
                --nofParens;
            }
            if (nofParens < 0) {
                return hrText;
            }
            ++i;
        }
        return hrText.substring(1, hrText.length() - 1);
    }

    public static boolean isRand(RfField rfField) {
        if (rfField == null) {
            return false;
        }
        if (rfField.isPort()) {
            return true;
        }
        return rfField.isRand();
    }

    static class SetWrapper<T>
    implements Set<T> {
        private Set<Object> rawSet;

        public SetWrapper(Set<Object> rawSet) {
            this.rawSet = rawSet;
        }

        @Override
        public int size() {
            return this.rawSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.rawSet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.rawSet.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.rawSet.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T e) {
            return this.rawSet.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.rawSet.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.rawSet.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return this.rawSet.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.rawSet.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.rawSet.removeAll(c);
        }

        @Override
        public void clear() {
            this.rawSet.clear();
        }
    }
}

