/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.predefined.corelib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.pssdt.model.IPSSProject;
import ro.amiq.pssdt.model.PSSModelManager;

public class RfPredefinedCodeLoader {
    public static final String[] PREDEF_FILES_LIST = new String[]{"core_library.pss"};

    public static final List<IPath> getPredefinedFilePaths(IProject project) {
        IPSSProject pssProject = PSSModelManager.getInstance().getPSSModel().getPSSProject(project);
        ArrayList<String> predefinedFiles = new ArrayList<String>(Arrays.asList(PREDEF_FILES_LIST));
        ArrayList<IPath> predefinedPaths = new ArrayList<IPath>(predefinedFiles.size());
        for (String predefinedFile : predefinedFiles) {
            BufferedWriter predefinedFileWriter = null;
            String inputPredefinedPath = null;
            BufferedReader predefinedFileReader = null;
            try {
                try {
                    String line;
                    IPath predefinedPath = pssProject.getExtensionsPath(predefinedFile);
                    predefinedPaths.add(predefinedPath);
                    predefinedFileWriter = new BufferedWriter(new FileWriter(predefinedPath.toOSString()));
                    URL predefinedURL = RfPredefinedCodeLoader.class.getResource(predefinedFile);
                    inputPredefinedPath = predefinedURL.getPath();
                    predefinedFileReader = new BufferedReader(new InputStreamReader(predefinedURL.openStream()));
                    while ((line = predefinedFileReader.readLine()) != null) {
                        predefinedFileWriter.write(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException iOException) {
                    DVTLogger.INSTANCE.logInfo("Could not load extension: " + inputPredefinedPath);
                    DVTUtilsCommon.INSTANCE.closeClosable(predefinedFileReader);
                    DVTUtilsCommon.INSTANCE.closeClosable((Closeable)predefinedFileWriter);
                    continue;
                }
            }
            catch (Throwable throwable) {
                DVTUtilsCommon.INSTANCE.closeClosable(predefinedFileReader);
                DVTUtilsCommon.INSTANCE.closeClosable(predefinedFileWriter);
                throw throwable;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)predefinedFileReader);
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)predefinedFileWriter);
        }
        return predefinedPaths;
    }
}

