/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.semantic;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.pssdt.model.problems.Bridge;
import ro.amiq.pssdt.model.reflection.semantic.RfSemanticError;

public enum SemanticErrorsManager {
    INSTANCE;


    public static SemanticErrorsManager getInstance() {
        return INSTANCE;
    }

    private SemanticErrorsManager() {
        DVTProblemsUiUpdaterRegistry.register((DVTProblemsUiUpdater)new DVTProblemsUiUpdater(PSSProblemCategories.PSS_SEMANTIC));
    }

    public void reparsed(IProject project, Map<String, Collection<RfSemanticError>> semanticErrors, boolean toConsole) {
        if (!DVTPlugin.getDefault().collect().c(project.getProject(), "F707373")) {
            return;
        }
        if (semanticErrors != null) {
            for (Collection<RfSemanticError> errors : semanticErrors.values()) {
                if (errors == null || errors.isEmpty()) continue;
                for (RfSemanticError error : errors) {
                    DVTProblemManager.getInstance().reportProblem(Bridge.from(project.getProject(), error, toConsole));
                }
            }
        }
        DVTProblemsUiUpdaterRegistry.get((String)PSSProblemCategories.PSS_SEMANTIC.getId()).update(project);
        DVTProblemManager.getInstance().save(project);
        DVTProblemsUiUpdaterRegistry.get((String)PSSProblemCategories.PSS_SEMANTIC.getId()).scheduleObjectionsClear(project);
        DVTProblemsUiUpdaterRegistry.get((String)PSSProblemCategories.PSS_SYNTAX.getId()).scheduleObjectionsClear(project);
    }

    public void clean(IProject project) {
        DVTProblemManager.getInstance().removeProblemsWithCategory(project, PSSProblemCategories.PSS_SEMANTIC);
        DVTProblemsUiUpdaterRegistry.get((String)PSSProblemCategories.PSS_SEMANTIC.getId()).clean(project);
    }
}

