/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.semantic;

import antlr.collections.AST;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.ASTUtils;
import ro.amiq.pssdt.model.reflection.AmbiguousAccessError;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.MethodKind;
import ro.amiq.pssdt.model.reflection.RfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfClassType;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfDummyElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfExecBlock;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumItem;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumType;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedMethod;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfPropTypeOverride;
import ro.amiq.pssdt.model.reflection.RfScopeDefElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.RfTemplateStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.TransitiveAccessError;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.pssdt.parser.EAST;
import ro.amiq.pssdt.parser.ElementScope;
import ro.amiq.pssdt.parser.RfDummyField;
import ro.amiq.pssdt.parser.SemanticWalker;
import ro.amiq.pssdt.parser.utils.BitVectorFloat;
import ro.amiq.pssdt.parser.utils.BitVectorInt;
import ro.amiq.pssdt.parser.utils.BitVectorRef;

public class SemanticUtils {
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_STRUCTS = new HashSet<Class>(Arrays.asList(RfStruct.class, RfPredefinedStruct.class, RfTemplateStruct.class, RfTemplateInstance.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_ACTIONS = new HashSet<Class>(Arrays.asList(RfStruct.class, RfPredefinedStruct.class, RfTemplateInstance.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_TYPES = new HashSet<Class>(Arrays.asList(RfPackage.class, RfStruct.class, RfPredefinedStruct.class, RfTemplateStruct.class, RfTemplateInstance.class, RfTypeAlias.class, RfEnumType.class, RfPredefinedEnumType.class, RfCovergroup.class, RfTemplateParam.RfTemplateTypeParam.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_VARIABLES = new HashSet<Class>(Arrays.asList(RfField.class, RfField.RfIteratorField.class, RfField.RfIndexField.class, RfPredefinedField.class, RfBlock.class, RfEnumItem.class, RfPredefinedEnumItem.class, RfTemplateParam.RfTemplateValueParam.class, RfTemplateParam.RfTemplateTypeParam.class, RfMethod.class, RfPredefinedMethod.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_FIELDS = new HashSet<Class>(Arrays.asList(RfField.class, RfField.RfIteratorField.class, RfField.RfIndexField.class, RfPredefinedField.class, RfEnumItem.class, RfPredefinedEnumItem.class, RfTemplateParam.RfTemplateValueParam.class, RfTemplateParam.RfTemplateTypeParam.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_FIELDS_2 = new HashSet<Class>(Arrays.asList(RfField.class, RfField.RfIteratorField.class, RfField.RfIndexField.class, RfPredefinedField.class, RfBlock.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_METHODS = new HashSet<Class>(Arrays.asList(RfMethod.class, RfPredefinedMethod.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_ENUM_TYPES = new HashSet<Class>(Arrays.asList(RfEnumType.class, RfPredefinedEnumType.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_ENUM_ITEMS = new HashSet<Class>(Arrays.asList(RfEnumItem.class, RfPredefinedEnumItem.class));
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_TYPES_OR_FIELDS = new HashSet<Class>(Arrays.asList(RfPackage.class, RfStruct.class, RfPredefinedStruct.class, RfTemplateStruct.class, RfTemplateInstance.class, RfTypeAlias.class, RfEnumType.class, RfPredefinedEnumType.class, RfCovergroup.class, RfTemplateParam.RfTemplateTypeParam.class, RfField.class, RfPredefinedField.class, RfEnumItem.class, RfPredefinedEnumItem.class, RfTemplateParam.RfTemplateValueParam.class, RfTemplateParam.RfTemplateTypeParam.class));
    public static final Set<String> ASSIGNMENT_COMPATIBLE_1 = new HashSet<String>(Arrays.asList("bit", "int", "chandle", "float32", "float64"));
    public static final RfNamedElement IF_BRANCH_ACTIVE = new RfDummyElement("IF_BRANCH_ACTIVE");
    public static final RfNamedElement ELSE_BRANCH_ACTIVE = new RfDummyElement("ELSE_BRANCH_ACTIVE");
    public static final LineInfo UNKNOWN_LINE_INFO = new LineInfo(-1, -1, -1);
    private static final Pattern UNQUALIFY_PARAMS_PATTERN = Pattern.compile("(?:::)?[a-zA-Z_0-9]+::");

    public static void setTransientResult(AST node, RfNamedElement result) {
        if (node == null) {
            return;
        }
        if (node.getType() == 280 || node.getType() == 281 || node.getType() == 207 || node.getType() == 208 || node.getType() == 96 || node.getType() == 36) {
            return;
        }
        ((EAST)node).transientResult = result;
    }

    public static boolean isLast(AST node) {
        return node != null && ((EAST)node).getMeta("last") != null;
    }

    public static RfNamedElement unwrap(RfNamedElement candidate, boolean unwrapTypeInstanceParam, boolean unwrapTypeAlias) {
        int i = 0;
        while (unwrapTypeInstanceParam && candidate instanceof RfTemplateParam.RfInstanceTypeParam && i < 20) {
            candidate = ((RfTemplateParam.RfInstanceTypeParam)candidate).getAssociatedType();
            ++i;
        }
        i = 0;
        while (unwrapTypeAlias && candidate instanceof RfTypeAlias && !(candidate instanceof RfTemplateParam.RfInstanceTypeParam) && i < 20) {
            candidate = ((RfTypeAlias)candidate).getAssociatedType();
            ++i;
        }
        return candidate;
    }

    public static <T extends IRfNamedElement> T getTransientResult(Class<T> clazz, AST node) {
        if (node == null || ((EAST)node).transientResult == null) {
            return null;
        }
        Object candidate = ((EAST)node).transientResult;
        if (!clazz.isInstance(candidate)) {
            return null;
        }
        return (T)((IRfNamedElement)candidate);
    }

    public static void setTransientScope(AST node, IRfScope result) {
        if (node == null) {
            return;
        }
        ((EAST)node).transientScope = result;
    }

    public static <T> T getTransientScope(Class<T> clazz, AST node) {
        if (node == null || ((EAST)node).transientScope == null) {
            return null;
        }
        Object candidate = ((EAST)node).transientScope;
        if (!clazz.isInstance(candidate)) {
            return null;
        }
        return (T)candidate;
    }

    public static LineInfo getLineInfo(AST node) {
        if (node == null) {
            return UNKNOWN_LINE_INFO;
        }
        EAST t = (EAST)node;
        LineInfo result = new LineInfo(t.getLine(), t.getOffset(), -1);
        return result;
    }

    public static final LineInfo metaToLineInfo(String meta) {
        if (meta != null) {
            try {
                int index = meta.indexOf(58);
                int line = Integer.parseInt(meta.substring(0, index));
                int offset = Integer.parseInt(meta.substring(index + 1));
                return new LineInfo(line, offset, -1);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return new LineInfo(-1, -1, -1);
    }

    public static LineInfo getTreeLineInfo(AST rootAST) {
        if (rootAST == null) {
            return UNKNOWN_LINE_INFO;
        }
        if (rootAST.getType() == 131) {
            LineInfo lineInfo = SemanticUtils.metaToLineInfo(((EAST)rootAST).getMeta("endLineInfo"));
            return new LineInfo(rootAST.getLine(), rootAST.getOffset(), lineInfo.realOffset + 1);
        }
        final LineInfo first = new LineInfo(Integer.MAX_VALUE, Integer.MAX_VALUE, -1);
        final LineInfo last = new LineInfo(0, 0, -1);
        ASTUtils.scanBelowAST(new ASTUtils.ASTRunnable(){

            @Override
            public void run(AST node) throws Exception {
                boolean enable2;
                int t = node.getType();
                boolean enable1 = node.getLine() > 0 && node.getOffset() > 0;
                boolean bl = enable2 = t == 276 || t == 286 || t == 279 || t == 289 || t == 277 || t == 96 || t == 36 || t == 56 || t == 16 || t == 14 || t == 12 || t == 91 || t == 281 || t == 131;
                if ((enable1 || enable2) && node.getLine() <= first.line && node.getOffset() > 0 && node.getOffset() < first.realOffset) {
                    first.line = node.getLine();
                    first.realOffset = node.getOffset();
                }
                int endOffset = node.getOffset() + (enable2 ? node.getText().length() : 0);
                if ((enable1 || enable2) && node.getLine() >= last.line && node.getOffset() > 0 && endOffset > last.realOffset) {
                    last.line = node.getLine();
                    last.realOffset = endOffset;
                }
            }
        }, rootAST);
        if (first.line != Integer.MAX_VALUE && first.realOffset != Integer.MAX_VALUE && last.realOffset > 0) {
            return new LineInfo(first.line, first.realOffset, last.realOffset);
        }
        return UNKNOWN_LINE_INFO;
    }

    public static RfNamedElement resolveHierarchicalId(RfProject project, ElementScope scopeContainer, AST id, boolean isFirst, boolean isLast, boolean isMethod, boolean isConstraintUsed, boolean isRuntime, boolean isLocalVarUsageBefore, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        RfNamedElement result = SemanticUtils.resolveHierarchicalId(project, scopeContainer, id, isFirst, isLast, isMethod, isConstraintUsed, isRuntime, MEMBER_VARIABLES, false, fileIndex, parserPath, fileDef);
        if (isLocalVarUsageBefore && parserPath != null && SemanticUtils.valid(result) && result instanceof RfField && !result.isPredefined()) {
            RfDefElement declaration;
            RfNamedElement enclosingProceduralBlock = result.getEnclosingScope(RfMethod.class);
            if (enclosingProceduralBlock instanceof RfMethod && ((RfMethod)enclosingProceduralBlock).isSymbol()) {
                return result;
            }
            if (enclosingProceduralBlock == null) {
                enclosingProceduralBlock = result.getEnclosingScope(RfExecBlock.class);
            }
            if (enclosingProceduralBlock == null) {
                return result;
            }
            UsageBeforeDefFilter usageBeforeFilter = new UsageBeforeDefFilter(fileIndex, id.getOffset());
            if (!usageBeforeFilter.validElement(result) && (declaration = result.getDeclaration()) != null) {
                project.addSemanticError(1, "USAGE_BEFORE_DECLARATION: Element ''{0}'' is used before being declared\n    at line {1,number,#######} in {2}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), declaration.getStartLine(), declaration.getParserPath());
            }
        }
        return result;
    }

    public static RfNamedElement resolveCondCompHierarchicalId(RfProject project, ElementScope scopeContainer, AST id, boolean isFirst, boolean isLast, boolean isMethod, boolean isConstraintUsed, boolean isRuntime, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        return SemanticUtils.resolveHierarchicalId(project, scopeContainer, id, isFirst, isLast, isMethod, isConstraintUsed, isRuntime, MEMBER_TYPES_OR_FIELDS, true, fileIndex, parserPath, fileDef);
    }

    private static RfNamedElement resolveHierarchicalId(RfProject project, ElementScope scopeContainer, AST id, boolean isFirst, boolean isLast, boolean isMethod, boolean isConstraintUsed, boolean isRuntime, Set<Class<? extends IRfNamedElement>> variableKinds, boolean isStrictUsageBefore, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (scopeContainer == null) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        Determinant determinant = scopeContainer.determinant;
        RfNamedElement currentScope = scopeContainer.enclosingScope;
        RfNamedElement assignmentScope = SemanticUtils.unwrap(scopeContainer.assignmentScope, false, true);
        if (!SemanticUtils.valid(currentScope)) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        if (id == null) {
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        boolean isThis = "this".equals(id.getText());
        int offset = isStrictUsageBefore ? id.getOffset() : -1;
        RfNamedElement result = null;
        if (isFirst && !isThis && assignmentScope instanceof RfEnumType) {
            result = assignmentScope.getMember(scopeContainer.lexicalScope, determinant, id.getText(), isFirst, isFirst, variableKinds, new UsageBeforeDefFilter(fileIndex, offset));
        }
        if (result == null && isFirst && isThis) {
            RfNamedElement enclosing = currentScope;
            do {
                if (!(enclosing instanceof RfStruct)) continue;
                result = new RfPredefinedField("this", new DataType(enclosing.getName()), "The predefined variable this is used refer the current enclosing class");
                ((RfField)result).setAssociatedType(enclosing);
                result.setEnclosingScope(enclosing);
                break;
            } while ((enclosing = enclosing.getEnclosingScope()) != null);
        } else if (result == null && isFirst && currentScope instanceof RfPredefinedField && "super".equals(currentScope.getName())) {
            currentScope = ((RfAssociatedType)currentScope).getAssociatedType();
            result = currentScope.getMember(scopeContainer.lexicalScope, determinant, id.getText(), isFirst, isFirst, isMethod ? MEMBER_METHODS : variableKinds, new UsageBeforeDefFilter(fileIndex, offset));
        } else if (result == null) {
            result = currentScope.getMember(scopeContainer.lexicalScope, determinant, id.getText(), isFirst, isFirst, isMethod ? MEMBER_METHODS : variableKinds, new UsageBeforeDefFilter(fileIndex, offset));
        }
        if (SemanticUtils.isPrevStateField(result) && scopeContainer.prevElement instanceof RfField) {
            if (((RfField)scopeContainer.prevElement).isInput()) {
                if (parserPath != null) {
                    project.addSemanticError(1, "ILLEGAL_ACCESS: Cannot make a reference to ''prev'' variable of ''{0}'' input port", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, scopeContainer.prevElement.getName());
                }
                SemanticUtils.setTransientResult(id, result);
                return result;
            }
            if (SemanticUtils.isPrevStateField(scopeContainer.prevElement)) {
                if (parserPath != null) {
                    project.addSemanticError(1, "ILLEGAL_ACCESS: Multiple level of ''prev'' variable reference is not allowed", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, new Object[0]);
                }
                SemanticUtils.setTransientResult(id, result);
                return result;
            }
        }
        if (result == null && isLast && !isMethod) {
            result = currentScope.getMember(scopeContainer.lexicalScope, determinant, id.getText(), isFirst, isFirst, Collections.singleton(RfEnumType.class), new UsageBeforeDefFilter(fileIndex, offset));
        }
        result = SemanticUtils.unwrapElement(project, currentScope, id, isMethod, result, parserPath);
        if (!SemanticUtils.valid(currentScope)) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        if (result == null || !SemanticUtils.valid(result)) {
            if (parserPath != null && !SemanticUtils.hasEnclosingTemplateStruct(currentScope)) {
                if (isFirst) {
                    project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
                } else {
                    project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), currentScope.getName());
                }
            }
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        if (result instanceof RfTemplateParam.RfInstanceValueParam && ((RfTemplateParam.RfInstanceValueParam)result).getValue() instanceof BitVectorRef) {
            result = ((BitVectorRef)((RfTemplateParam.RfInstanceValueParam)result).getValue()).get();
        }
        if (parserPath != null && (result instanceof RfField || result instanceof RfMethod)) {
            RfNamedElement enclosingScope = result.getEnclosingScope();
            RfStruct currentScopeStruct = null;
            RfExecBlock currentScopeExec = null;
            if (isFirst && !SemanticUtils.hasStaticAccess(result) && enclosingScope instanceof RfStruct && enclosingScope.isComponent() && (currentScopeStruct = currentScope.getEnclosingScope(RfStruct.class)) != null && currentScopeStruct.isAction(true)) {
                project.addSemanticError(1, "ILLEGAL_ACCESS: Cannot make a static reference to the non-static member ''{0}'' (use ''comp.'' to access members of parent component)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            } else if (isFirst && result instanceof RfPredefinedField && "comp".equals(result.getName()) && (currentScopeExec = currentScope.getEnclosingScope(RfExecBlock.class)) != null && currentScopeExec.getExecBlockKind() == ExecBlockKind.PRE_SOLVE) {
                project.addSemanticError(1, "ILLEGAL_ACCESS: Cannot make a parent component ''comp.'' reference in pre-solve exec block (''comp'' might be uninitilized at this time)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, new Object[0]);
            } else if (!isFirst && scopeContainer.isStaticAccess && !SemanticUtils.hasStaticAccess(result)) {
                project.addSemanticError(1, "ILLEGAL_ACCESS: Cannot make a static reference to the non-static member ''{0}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            } else if (!isFirst && !scopeContainer.isStaticAccess && SemanticUtils.hasStaticAccess(result) && enclosingScope != null) {
                project.addSemanticError(2, "STATIC_ACCESS: The static member ''{0}'' should be accessed in a static way (e.g. ''{1}::{0}'')", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), enclosingScope.getName());
            } else if (result instanceof RfPredefinedField && enclosingScope instanceof RfCollectionType && ("sum".equals(result.getName()) || "size".equals(result.getName()))) {
                project.addSemanticError(2, "DEPRECATED_ACCESS: Field ''{0}'' is deprecated, use the corresponding function instead", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            } else if (result instanceof RfMethod && !isRuntime && ((RfMethod)result).hasQualifier(2)) {
                project.addSemanticError(1, "FUNCTION_CALL: Call of target function ''{0}'' in solve phase is not allowed", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            } else if (result instanceof RfMethod && isRuntime && ((RfMethod)result).hasQualifier(4)) {
                project.addSemanticError(1, "FUNCTION_CALL: Call of solve function ''{0}'' in target phase is not allowed", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            } else if (result.isNonStandard()) {
                project.addSemanticError(2, "NON_STANDARD_FIELD: Non-standard field ''{0}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            }
        }
        fileDef.createVariableDependency(project, result, id.getText());
        SemanticUtils.setTransientResult(id, result);
        if (result instanceof RfField) {
            result.setConstraintUsed();
        }
        return result;
    }

    public static boolean isPrevStateField(IRfNamedElement result) {
        return result instanceof RfPredefinedField && result.getEnclosingScope() instanceof RfStruct && ((RfStruct)result.getEnclosingScope()).getStructKind() == StructKind.STATE && "prev".equals(result.getName());
    }

    public static boolean hasStaticAccess(RfNamedElement element) {
        if (!SemanticUtils.valid(element)) {
            return false;
        }
        if (element instanceof RfEnumItem) {
            return true;
        }
        RfNamedElement enclosingScope = element.getEnclosingScope();
        if (enclosingScope instanceof RfPackage) {
            return true;
        }
        return element instanceof RfField && ((RfField)element).getFieldModifier() == FieldModifier.STATIC_CONST;
    }

    private static boolean hasEnclosingTemplateStruct(RfNamedElement namedElement) {
        while ((namedElement = namedElement.getEnclosingScope()) != null) {
            if (!(namedElement instanceof RfStruct) || !((RfStruct)namedElement).isTemplateStuct()) continue;
            return true;
        }
        return false;
    }

    private static void setUnresolved(List<AST> qid) {
        for (AST id : qid) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
        }
    }

    public static void checkExtendStructKind(RfProject project, RfDefElement enclosingScopeLayer, RfDefElement currentScopeLayer, StructKind structKind, LineInfo lineInfo) {
        RfStruct parentComponentScope;
        RfStruct enclosingComponentScope;
        if (currentScopeLayer == null) {
            return;
        }
        RfNamedElement element = currentScopeLayer.getNamedElement();
        if (element == null || element instanceof RfTemplateInstance) {
            return;
        }
        int startOffset = lineInfo.realOffset;
        String name = element.getName();
        int endOffset = startOffset + name.length();
        ParserPath parserPath = currentScopeLayer.getParserPath();
        int startLine = lineInfo.line;
        List<RfDefElement> layers = element.getLayers();
        RfDefElement declaration = null;
        if (layers == null || layers.size() <= 1 || (declaration = layers.iterator().next()) != null && !declaration.isIs()) {
            project.addSemanticError(1, "EXTEND_UNDEFINED_TYPE: Cannot extend ''{0}'' {1} type, because it was not previously defined", null, startOffset, endOffset, null, startLine, parserPath, name, structKind.toString());
            return;
        }
        if (element instanceof RfEnumType && structKind != StructKind.ENUM_TYPE) {
            project.addSemanticError(1, "EXTEND_ENUM_TYPE: Wrong kind ''{0}'' specified to extend ''{1}'' enum type", null, startOffset, endOffset, null, startLine, parserPath, structKind.toString(), name);
            return;
        }
        if (element instanceof IRfClassType) {
            boolean allowedExtends;
            StructKind expectedStructKind = ((IRfClassType)((Object)element)).getStructKind();
            boolean bl = allowedExtends = expectedStructKind == structKind || (expectedStructKind == StructKind.ACTION_ABSTRACT || expectedStructKind == StructKind.ACTION) && (structKind == StructKind.ACTION_ABSTRACT || structKind == StructKind.ACTION);
            if (!allowedExtends) {
                project.addSemanticError(1, "EXTEND_CLASS_TYPE: Wrong kind ''{0}'' specified to extend ''{1}'' {2} type", null, startOffset, endOffset, null, startLine, parserPath, structKind.toString(), name, expectedStructKind.toString());
                return;
            }
        }
        if (structKind == StructKind.ACTION && (enclosingComponentScope = SemanticUtils.getEnclosingComponent(enclosingScopeLayer)) != null && (parentComponentScope = SemanticUtils.getEnclosingComponent(currentScopeLayer)) != null && parentComponentScope != enclosingComponentScope) {
            project.addSemanticError(1, "ILLEGAL_EXTEND_STATEMENT: Extend of ''{0}'' {1} defined in ''{2}'' component not allowed in ''{3}'' component", null, startOffset, endOffset, null, startLine, parserPath, name, structKind.toString(), parentComponentScope.getName(), enclosingComponentScope.getName());
            return;
        }
    }

    private static RfStruct getEnclosingComponent(RfDefElement enclosingScopeLayer) {
        if (enclosingScopeLayer instanceof RfFileDef) {
            return null;
        }
        RfNamedElement enclosingScope = enclosingScopeLayer.getNamedElement();
        return SemanticUtils.getEnclosingComponent(enclosingScope);
    }

    private static RfStruct getEnclosingComponent(RfNamedElement enclosingScope) {
        try {
            do {
                if (!(enclosingScope instanceof RfStruct) || !((RfStruct)enclosingScope).isComponent()) continue;
                return (RfStruct)enclosingScope;
            } while ((enclosingScope = enclosingScope.getEnclosingScope()) != null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static void checkNofArgsMismatch(RfProject project, RfNamedElement element, AST id, boolean isVariadic, int nofParamsExpectedMin, int nofParamsExpectedMax, int nofParamsFound, ParserPath parserPath) {
        if (element == null) {
            return;
        }
        if (nofParamsExpectedMin <= nofParamsFound && nofParamsExpectedMax >= nofParamsFound) {
            return;
        }
        if (isVariadic && nofParamsExpectedMin - 1 <= nofParamsFound) {
            return;
        }
        if (element instanceof RfMethod && !((RfMethod)element).isArgumentsCheck()) {
            return;
        }
        String message = "FUNCTION_CALL_ARGUMENTS: Expecting ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
        if (element instanceof RfCovergroup) {
            message = "COVERGROUP_INSTANCE_PORTS: Expecting ''{1}'' port{1,choice,0#s|1#|1<s} when instantiating ''{0}'', found ''{2}''";
        } else if (element instanceof RfMethod && ((RfMethod)element).getMethodKind() == MethodKind.SYMBOL) {
            message = "SYMBOL_CALL_ARGUMENTS: Expecting ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
        } else if (element instanceof RfMethod) {
            message = "FUNCTION_CALL_ARGUMENTS: Expecting ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
        } else {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(id);
        project.addSemanticError(1, message, null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, element.getName(), nofParamsExpectedMin, nofParamsFound);
    }

    public static RfNamedElement checkElementKind(RfProject project, RfNamedElement element, AST id, Class<? extends RfNamedElement> elementClass, MethodKind methodKind, ExecBlockKind execKind, ParserPath parserPath) {
        if (id == null) {
            return element;
        }
        if (element == null) {
            return element;
        }
        if (!elementClass.isInstance(element) && SemanticUtils.valid(element)) {
            String name = id.getText();
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(id);
            if (elementClass == RfCovergroup.class) {
                project.addSemanticError(1, "NOT_A_COVERGROUP: ''{0}'' is not a cover group instance", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, name);
                SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
                return SemanticWalker.UNRESOLVED_ELEMENT;
            }
            if (elementClass == RfMethod.class && methodKind == MethodKind.METHOD) {
                project.addSemanticError(1, "NOT_A_FUNCTION: ''{0}'' is not a function", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, name);
                SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
                return SemanticWalker.UNRESOLVED_ELEMENT;
            }
            if (elementClass == RfMethod.class && methodKind == MethodKind.SYMBOL) {
                project.addSemanticError(1, "NOT_A_SYMBOL: ''{0}'' is not a symbol", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, name);
                SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
                return SemanticWalker.UNRESOLVED_ELEMENT;
            }
        }
        if (element instanceof RfMethod && SemanticUtils.valid(element) && element.isCoreLibMember()) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(id);
            String name = element.getName();
            if (execKind != ExecBlockKind.NONE && !execKind.isInit() && "add_executor".equals(name)) {
                project.addSemanticError(1, "ILLEGAL_FUNCTION_CALL: Call of ''{0}'' function outside the scope of exec {1} phase is not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, name, "init_up or init_down");
                return element;
            }
            if (execKind != ExecBlockKind.NONE && !execKind.isInit() && ("add_region".equals(name) || "add_nonallocatable_region".equals(name))) {
                project.addSemanticError(1, "ILLEGAL_FUNCTION_CALL: Call of ''{0}'' function outside the scope of exec {1} phase is not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, name, "init_up or init_down");
                return element;
            }
            if (execKind != ExecBlockKind.NONE && !execKind.isRuntime() && "addr_value".equals(name)) {
                project.addSemanticError(1, "ILLEGAL_FUNCTION_CALL: Call of ''{0}'' function outside the scope of exec {1} phase is not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, name, "run_start, run_end or body");
                return element;
            }
        }
        return element;
    }

    public static void checkIdentifierExists(RfProject project, AST id, Determinant determinant, RfDefElement currentScopeLayer, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (id == null) {
            return;
        }
        RfNamedElement currentScope = SemanticUtils.getNamedElement(project, currentScopeLayer);
        if (currentScope == null || !SemanticUtils.valid(currentScope)) {
            return;
        }
        RfNamedElement result = currentScope.getMember(currentScopeLayer, determinant, id.getText(), false, true, MEMBER_FIELDS, new UsageBeforeDefFilter(fileIndex, -1));
        if ((result = SemanticUtils.unwrapElement(project, currentScope, id, false, result, parserPath)) == null || !SemanticUtils.valid(result)) {
            project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        fileDef.createVariableDependency(project, result, id.getText());
        SemanticUtils.setTransientResult(id, result);
    }

    public static boolean checkIllegalAssignment(RfProject project, AST operator, AST leftAST, RfNamedElement left, AST rightAST, RfNamedElement right, ParserPath parserPath) {
        return SemanticUtils.checkIllegalAssignment(project, operator, leftAST, left, rightAST, right, false, parserPath);
    }

    public static boolean checkIllegalAssignment(RfProject project, AST operator, AST leftAST, RfNamedElement left, AST rightAST, RfNamedElement right, boolean isMapKeyCheck, ParserPath parserPath) {
        String message;
        int opType;
        if (!SemanticUtils.valid(left) || !SemanticUtils.valid(right)) {
            return false;
        }
        if (!(left instanceof IRfAssociatedType) || !(right instanceof IRfAssociatedType)) {
            return false;
        }
        if (left == right) {
            return false;
        }
        if (right instanceof RfTemplateParam.RfTemplateValueParam) {
            return false;
        }
        if (operator == null) {
            return false;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(rightAST);
        String rightElementName = SemanticUtils.getElementName(rightAST, right);
        String leftElementName = SemanticUtils.getElementName(leftAST, left);
        IRfNamedElement assocTypeLeft = ((IRfAssociatedType)((Object)left)).getAssociatedType();
        IRfNamedElement assocTypeRight = ((IRfAssociatedType)((Object)right)).getAssociatedType();
        if (!SemanticUtils.valid((RfNamedElement)assocTypeLeft) || !SemanticUtils.valid((RfNamedElement)assocTypeRight)) {
            return false;
        }
        String assocTypeLeftName = SemanticUtils.getAssociatedTypeName((IRfAssociatedType)((Object)left));
        String assocTypeRightName = SemanticUtils.getAssociatedTypeName((IRfAssociatedType)((Object)right));
        if (assocTypeLeft instanceof RfPredefinedType && ((RfPredefinedType)assocTypeLeft).isGenericType()) {
            StructKind rightStructKind;
            StructKind leftStructKind = ((RfPredefinedType)assocTypeLeft).getStructKind();
            StructKind structKind = rightStructKind = assocTypeRight instanceof RfStruct ? ((RfStruct)assocTypeRight).getStructKind() : StructKind.GENERIC;
            if (leftStructKind == StructKind.GENERIC || leftStructKind == rightStructKind) {
                return true;
            }
            project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting ''{2}'' type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightElementName, assocTypeRightName, assocTypeLeftName);
            return false;
        }
        int n = opType = operator.getType() == 23 ? 236 : operator.getType();
        if (opType == 236 && assocTypeLeft instanceof RfCollectionType && assocTypeRight instanceof RfCollectionType) {
            boolean hasError;
            if (((RfCollectionType)assocTypeLeft).isInitCollection()) {
                project.addSemanticError(2, "UNEXPECTED_EXPRESSION: Unexpected expression as left hand side operand", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
                return true;
            }
            if (((RfCollectionType)assocTypeLeft).isSetType() && !((RfCollectionType)assocTypeRight).isSetType() || ((RfCollectionType)assocTypeLeft).isMapType() && !((RfCollectionType)assocTypeRight).isMapType() || ((RfCollectionType)assocTypeLeft).isVectorType() && !((RfCollectionType)assocTypeRight).isVectorType()) {
                project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting ''{2}'' type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightElementName, assocTypeRightName, assocTypeLeftName);
                return true;
            }
            DataType.CollectionKind collectionKind = ((RfCollectionType)assocTypeLeft).getCollectionKind();
            if (collectionKind == DataType.CollectionKind.ARRAY && (((RfCollectionType)assocTypeRight).getCollectionKind() == DataType.CollectionKind.ARRAY || ((RfCollectionType)assocTypeRight).getCollectionKind() == DataType.CollectionKind.ARRAY_INIT)) {
                int leftArraySize = ((RfCollectionType)assocTypeLeft).getCollectionSize();
                int rightArraySize = ((RfCollectionType)assocTypeRight).getCollectionSize();
                if (leftArraySize != 0 && leftArraySize != rightArraySize) {
                    project.addSemanticError(2, "SIZE_MISMATCH: ''{0}'' initial value size mismatch (expecting ''{1}'' elements instead of ''{2}'')", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, left.getName(), leftArraySize, rightArraySize);
                    return true;
                }
            }
            if (isMapKeyCheck && collectionKind == DataType.CollectionKind.MAP) {
                assocTypeLeft = (IRfNamedElement)((RfCollectionType)assocTypeLeft).getKeyElementType();
                assocTypeRight = (IRfNamedElement)((RfCollectionType)assocTypeRight).getKeyElementType();
            } else if (collectionKind == DataType.CollectionKind.ARRAY || collectionKind == DataType.CollectionKind.LIST || collectionKind == DataType.CollectionKind.MAP) {
                assocTypeLeft = (IRfNamedElement)((RfCollectionType)assocTypeLeft).getValueElementType();
                assocTypeRight = (IRfNamedElement)((RfCollectionType)assocTypeRight).getValueElementType();
            } else if (collectionKind == DataType.CollectionKind.SET) {
                assocTypeLeft = (IRfNamedElement)((RfCollectionType)assocTypeLeft).getKeyElementType();
                assocTypeRight = (IRfNamedElement)((RfCollectionType)assocTypeRight).getKeyElementType();
            }
            if (!SemanticUtils.valid((RfNamedElement)assocTypeLeft) || !SemanticUtils.valid((RfNamedElement)assocTypeRight)) {
                return false;
            }
            if (!isMapKeyCheck && (hasError = SemanticUtils.checkIllegalAssignment(project, operator, leftAST, left, rightAST, right, true, parserPath))) {
                return true;
            }
        }
        if (opType == 49 && !(assocTypeRight instanceof RfCollectionType)) {
            project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting ''{2}'' type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, right.getName(), assocTypeRightName, String.valueOf(assocTypeLeftName) + "[]");
            return true;
        }
        if (opType == 49 && assocTypeRight instanceof RfCollectionType) {
            if (!SemanticUtils.valid((RfNamedElement)(assocTypeRight = ((RfCollectionType)assocTypeRight).getAssociatedType()))) {
                return false;
            }
            assocTypeRightName = assocTypeRight.getName();
        }
        if ((assocTypeLeft instanceof RfStruct || assocTypeRight instanceof RfStruct) && (opType == 251 || opType == 254 || opType == 253 || opType == 255 || opType == 259 || opType == 260)) {
            boolean isRightCompField;
            boolean isLeftCompField = left instanceof RfField && "comp".equals(left.getName());
            boolean bl = isRightCompField = right instanceof RfField && "comp".equals(right.getName());
            if (!isLeftCompField && !isRightCompField) {
                if (opType == 259 || opType == 260) {
                    if (assocTypeLeft == assocTypeRight) {
                        return false;
                    }
                    if (assocTypeLeft instanceof RfStruct && assocTypeRight instanceof RfStruct) {
                        boolean isStructRight;
                        StructKind leftStructKind = ((RfStruct)assocTypeLeft).getStructKind();
                        StructKind rightStructKind = ((RfStruct)assocTypeRight).getStructKind();
                        boolean isStructLeft = leftStructKind == StructKind.STRUCT || leftStructKind == StructKind.BUFFER || leftStructKind == StructKind.RESOURCE || leftStructKind == StructKind.STATE || leftStructKind == StructKind.STREAM;
                        boolean bl2 = isStructRight = rightStructKind == StructKind.STRUCT || rightStructKind == StructKind.BUFFER || rightStructKind == StructKind.RESOURCE || rightStructKind == StructKind.STATE || rightStructKind == StructKind.STREAM;
                        if (!isStructLeft) {
                            lineInfo = SemanticUtils.getTreeLineInfo(operator);
                            project.addSemanticError(1, "ILLEGAL_EXPRESSION: Compare expression referring to {0}-type objects not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, leftStructKind.toString());
                            return true;
                        }
                        if (!isStructRight) {
                            lineInfo = SemanticUtils.getTreeLineInfo(operator);
                            project.addSemanticError(1, "ILLEGAL_EXPRESSION: Compare expression referring to {0}-type objects not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightStructKind.toString());
                            return true;
                        }
                        project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting ''{2}'' type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightElementName, assocTypeRightName, assocTypeLeftName);
                        return true;
                    }
                } else {
                    if (assocTypeLeft instanceof RfStruct) {
                        lineInfo = SemanticUtils.getTreeLineInfo(operator);
                        StructKind leftStructKind = ((RfStruct)assocTypeLeft).getStructKind();
                        project.addSemanticError(1, "ILLEGAL_EXPRESSION: Compare expression referring to {0}-type objects not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, leftStructKind.toString());
                        return true;
                    }
                    if (assocTypeRight instanceof RfStruct) {
                        lineInfo = SemanticUtils.getTreeLineInfo(operator);
                        StructKind rightStructKind = ((RfStruct)assocTypeRight).getStructKind();
                        project.addSemanticError(1, "ILLEGAL_EXPRESSION: Compare expression referring to {0}-type objects not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightStructKind.toString());
                        return true;
                    }
                }
            }
        }
        int sizeArrayLeft = 0;
        int i = 0;
        while (i < 20) {
            if (assocTypeLeft instanceof RfTypeAlias) {
                assocTypeLeft = ((RfTypeAlias)assocTypeLeft).getAssociatedType();
            } else {
                if (!(assocTypeLeft instanceof RfCollectionType)) break;
                assocTypeLeft = (IRfNamedElement)((RfCollectionType)assocTypeLeft).getValueElementType();
                ++sizeArrayLeft;
            }
            ++i;
        }
        int sizeArrayRight = 0;
        int i2 = 0;
        while (i2 < 20) {
            if (assocTypeRight instanceof RfTypeAlias) {
                assocTypeRight = ((RfTypeAlias)assocTypeRight).getAssociatedType();
            } else {
                if (!(assocTypeRight instanceof RfCollectionType)) break;
                assocTypeRight = (IRfNamedElement)((RfCollectionType)assocTypeRight).getValueElementType();
                ++sizeArrayRight;
            }
            ++i2;
        }
        if (!(sizeArrayLeft == sizeArrayRight || left instanceof RfField && ((RfField)left).getFieldModifier() == FieldModifier.VARIADIC_PARAM && sizeArrayLeft == 1 && sizeArrayRight == 0)) {
            String message2 = rightElementName == null || rightElementName.startsWith("{") ? "UNEXPECTED_TYPE: Expression is of type ''{1}'', while expecting type ''{2}''" : "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting ''{2}'' type";
            project.addSemanticError(1, message2, null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightElementName, assocTypeRightName, assocTypeLeftName);
            return true;
        }
        if (assocTypeLeft instanceof RfPredefinedType && ((RfPredefinedType)assocTypeLeft).isGenericType()) {
            StructKind rightStructKind;
            StructKind leftStructKind = ((RfPredefinedType)assocTypeLeft).getStructKind();
            StructKind structKind = rightStructKind = assocTypeRight instanceof RfStruct ? ((RfStruct)assocTypeRight).getStructKind() : StructKind.GENERIC;
            if (leftStructKind == rightStructKind) {
                return true;
            }
            if (left instanceof RfField && (((RfField)left).isMethodParam() || ((RfField)left).isVariadic())) {
                return true;
            }
            String elementName2 = SemanticUtils.getElementName(rightAST, right);
            project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting ''{2}'' type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, elementName2, assocTypeRightName, assocTypeLeftName);
            return false;
        }
        if (assocTypeLeft == assocTypeRight) {
            return false;
        }
        if (opType == 97 || opType == 55 || opType == 236 || opType == 26 || opType == 180 || opType == 189 || opType == 190) {
            if (SemanticUtils.isLike(assocTypeRight, assocTypeLeft)) {
                return false;
            }
        } else {
            if (assocTypeRight instanceof RfClassType && !(assocTypeLeft instanceof RfClassType)) {
                String message3 = rightElementName == null ? "UNEXPECTED_TYPE: Expression is of type ''{1}'', while expecting numeric type" : "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting numeric type";
                project.addSemanticError(1, message3, null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightElementName, assocTypeRightName);
                return true;
            }
            if (assocTypeLeft instanceof RfClassType && !(assocTypeRight instanceof RfClassType)) {
                LineInfo lineInfo2 = SemanticUtils.getTreeLineInfo(leftAST);
                String message4 = leftElementName == null ? "UNEXPECTED_TYPE: Expression is of type ''{1}'', while expecting numeric type" : "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting numeric type";
                project.addSemanticError(1, message4, null, lineInfo2.realOffset, lineInfo2.virtOffset, null, lineInfo2.line, parserPath, leftElementName, assocTypeLeftName);
                return true;
            }
        }
        if (opType == 194 && "bit".equals(assocTypeRightName)) {
            return false;
        }
        if (opType == 49 && SemanticUtils.isLike(assocTypeLeft, assocTypeRight)) {
            return false;
        }
        if (opType != 49 && SemanticUtils.isLike(assocTypeRight, assocTypeLeft)) {
            return false;
        }
        if (SemanticUtils.isAssignmentCompatible(project, assocTypeLeft, assocTypeRight)) {
            int nofBitsLeft = SemanticUtils.nofBits((IRfAssociatedType)((Object)left));
            int nofBitsRight = SemanticUtils.nofBits((IRfAssociatedType)((Object)right));
            if (nofBitsLeft <= 0 || nofBitsRight > 0) {
                // empty if block
            }
            return false;
        }
        String string = message = rightElementName == null ? "UNEXPECTED_TYPE: Expression is of type ''{1}'', while expecting type ''{2}''" : "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting ''{2}'' type";
        if (opType == 49) {
            project.addSemanticError(1, message, null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, leftElementName, assocTypeLeftName, assocTypeRightName);
            return true;
        }
        project.addSemanticError(1, message, null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightElementName, assocTypeRightName, assocTypeLeftName);
        return true;
    }

    private static boolean isAssignmentCompatible(RfProject project, IRfNamedElement assocTypeLeft, IRfNamedElement assocTypeRight) {
        if (assocTypeLeft == null || assocTypeRight == null) {
            return false;
        }
        if (assocTypeLeft instanceof RfEnumType && assocTypeLeft == assocTypeRight) {
            return true;
        }
        boolean isArrayLeft = assocTypeLeft instanceof RfCollectionType;
        boolean isArrayRight = assocTypeRight instanceof RfCollectionType;
        if (isArrayLeft && !isArrayRight || !isArrayLeft && isArrayRight) {
            return false;
        }
        String typeNameLeft = assocTypeLeft.getName();
        String typeNameRight = assocTypeRight.getName();
        boolean isAllowNonStandardEnumInExpr = project.isAllowNonStandardEnumInExpr();
        if (isAllowNonStandardEnumInExpr) {
            if (assocTypeLeft instanceof RfEnumType && "int".equals(typeNameRight)) {
                return true;
            }
            if (assocTypeRight instanceof RfEnumType && "int".equals(typeNameLeft)) {
                return true;
            }
        }
        return ASSIGNMENT_COMPATIBLE_1.contains(typeNameLeft) && ASSIGNMENT_COMPATIBLE_1.contains(typeNameRight);
    }

    public static boolean isLike(IRfNamedElement classChild, IRfNamedElement classParent) {
        if (!(classChild instanceof RfClassType) || !(classParent instanceof RfClassType)) {
            return false;
        }
        IRfClassType child = (RfClassType)classChild;
        while ((child = child.getParent()) != null) {
            if (child != classParent) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignmentCompatible(IRfNamedElement assocTypeLeft, IRfNamedElement assocTypeRight) {
        if (assocTypeLeft == null || assocTypeRight == null) {
            return false;
        }
        if (assocTypeLeft == assocTypeRight) {
            return true;
        }
        return ASSIGNMENT_COMPATIBLE_1.contains(assocTypeLeft.getName()) && ASSIGNMENT_COMPATIBLE_1.contains(assocTypeRight.getName());
    }

    private static String getAssociatedTypeName(IRfAssociatedType assocType) {
        String assocTypeName = assocType.getAssociatedTypeName();
        if (assocTypeName == null) {
            return "null";
        }
        if (assocType instanceof RfTemplateInstance) {
            assocTypeName = SemanticUtils.unqualifiedName(assocTypeName);
        }
        return assocTypeName;
    }

    public static String getElementName(AST expFrom, RfNamedElement assignFromElement) {
        String fromElementName;
        String string = fromElementName = assignFromElement instanceof RfDummyField ? ((RfDummyField)assignFromElement).getNameForErrorReporting() : assignFromElement.getName();
        if (fromElementName == null) {
            fromElementName = expFrom == null ? "null" : SemanticUtils.getTextMeta(expFrom);
        }
        fromElementName = SemanticUtils.customizeElementName(fromElementName);
        return fromElementName;
    }

    public static String customizeElementName(String elementName) {
        if (elementName != null) {
            elementName = elementName.replace('\n', ' ');
            elementName = elementName.replace('\r', ' ');
            if ((elementName = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)elementName, (String)" ")).length() > 100) {
                elementName = elementName.startsWith("\"") && elementName.endsWith("\"") ? String.valueOf(elementName.substring(0, 97)) + "...\"" : String.valueOf(elementName.substring(0, 97)) + " ...";
            }
        }
        return elementName;
    }

    public static boolean valid(RfNamedElement result) {
        if (result instanceof RfTemplateParam.RfInstanceValueParam) {
            return true;
        }
        if (result instanceof RfTemplateParam.RfInstanceTypeParam) {
            return true;
        }
        if (result instanceof RfCollectionType) {
            return true;
        }
        if (result instanceof RfDummyField) {
            return true;
        }
        if (result == null) {
            return false;
        }
        if (result == SemanticWalker.UNRESOLVED_ELEMENT) {
            return false;
        }
        if (result.isPredefined()) {
            return true;
        }
        return !result.hasNoDefs(false);
    }

    public static void reportAssert(RfProject project, LineInfo infoLine, AST message, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        String messageText = "Assertion failed";
        if (message != null && (messageText = message.getText()).startsWith("\"") && messageText.endsWith("\"")) {
            messageText = messageText.substring(1, messageText.length() - 1);
        }
        project.addSemanticError(1, "COMPILE_ASSERT: {0}", null, -1, -1, null, infoLine.line, parserPath, messageText);
    }

    public static RfNamedElement resolveOptionId(RfProject project, RfDefElement currentScopeLayer, AST id, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (currentScopeLayer == null) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        RfNamedElement currentScope = currentScopeLayer.getNamedElement();
        if (currentScope == null) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        RfNamedElement result = RfCovergroup.getOption(project, id.getText());
        if (result == null || !SemanticUtils.valid(result)) {
            project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        SemanticUtils.setTransientResult(id, result);
        return result;
    }

    public static BigInteger parseInt(RfProject project, AST n, String numberText, ParserPath parserPath) {
        BitVectorInt result = SemanticUtils.asBitVector(project, n, numberText, true, -1, -1, parserPath);
        if (result == null) {
            throw new UnsupportedOperationException("Number format exception '" + numberText + "'");
        }
        return result.bigIntegerValue();
    }

    public static boolean isSigned(String numberText) {
        int signedIndex = numberText.indexOf("'s");
        return signedIndex >= 0;
    }

    public static BitVectorInt asBitVector(RfProject project, AST n, String numberText, ParserPath parserPath) {
        BitVectorInt result = SemanticUtils.asBitVector(project, n, numberText, true, -1, -1, parserPath);
        if (result == null) {
            throw new UnsupportedOperationException("Number format exception '" + numberText + "'");
        }
        return result;
    }

    public static BitVectorInt asBitVector(RfProject project, AST n, String numberText, boolean sign, int left, int right, ParserPath parserPath) {
        String origNumberText = numberText;
        try {
            int baseIndex;
            numberText = StringUtils.replace((String)numberText.toLowerCase(), (String)"_", (String)"");
            if (numberText == null) {
                return new BitVectorInt(sign, left, right).setValue("0", 16);
            }
            if ("true".equals(numberText)) {
                return new BitVectorInt(sign, 0, 0).setValue("1", 16);
            }
            if ("false".equals(numberText)) {
                return new BitVectorInt(sign, 0, 0).setValue("0", 16);
            }
            int signedIndex = numberText.indexOf("'s");
            sign |= signedIndex >= 0;
            if (signedIndex >= 0) {
                numberText = StringUtils.replace((String)numberText, (String)"'s", (String)"'");
            }
            if ((baseIndex = numberText.indexOf("'")) > 0) {
                left = Integer.parseInt(numberText.substring(0, baseIndex).trim());
                right = 0;
            }
            if (numberText.startsWith("x")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(1), 16);
            }
            if (numberText.startsWith("h")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(1), 16);
            }
            if (numberText.startsWith("o")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(1), 8);
            }
            if (numberText.startsWith("d")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(1), 10);
            }
            if (numberText.startsWith("b")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(1), 2);
            }
            if (numberText.startsWith("0x")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(2), 16);
            }
            if (numberText.startsWith("0h")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(2), 16);
            }
            if (numberText.startsWith("0o")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(2), 8);
            }
            if (numberText.startsWith("0d")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(2), 10);
            }
            if (numberText.startsWith("0b")) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(2), 2);
            }
            if (baseIndex < 0 && numberText.indexOf(".") > -1) {
                return new BitVectorFloat(true).setValue(numberText, -1);
            }
            if (baseIndex < 0 && numberText.indexOf("e") > -1) {
                return new BitVectorFloat(true).setValue(numberText, -1);
            }
            baseIndex = numberText.indexOf("'x");
            if (baseIndex > -1) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(baseIndex + 2), 16);
            }
            baseIndex = numberText.indexOf("'h");
            if (baseIndex > -1) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(baseIndex + 2), 16);
            }
            baseIndex = numberText.indexOf("'o");
            if (baseIndex > -1) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(baseIndex + 2), 8);
            }
            baseIndex = numberText.indexOf("'b");
            if (baseIndex > -1) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(baseIndex + 2), 2);
            }
            baseIndex = numberText.indexOf("'d");
            if (baseIndex > -1) {
                return new BitVectorInt(sign, left, right).setValue(numberText.substring(baseIndex + 2), 10);
            }
            return new BitVectorInt(sign, left, right).setValue(numberText, 10);
        }
        catch (Exception exception) {
            if (project == null) {
                return null;
            }
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(n);
            project.addSemanticError(1, "EVALUATION_FAIL: Expression ''{0}'' cannot be evaluated", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, origNumberText);
            return new BitVectorInt(sign, left, right).setValue("0", 16);
        }
    }

    public static void setTypeClassParent(RfProject project, RfTemplateParam.RfTemplateTypeParam typeParam, RfNamedElement parentClassType, AST id, ParserPath parserPath) {
        SemanticUtils.setClassParent(project, typeParam, parentClassType, id, parserPath);
    }

    public static void setClassParent(RfProject project, IRfClassType classType, RfNamedElement parentClassType, AST id, ParserPath parserPath) {
        RfStruct parentComponentScope;
        RfStruct enclosingComponentScope;
        if (id == null || !SemanticUtils.valid((RfNamedElement)((Object)classType)) || !SemanticUtils.valid(parentClassType)) {
            return;
        }
        String name = id.getText();
        int startOffset = id.getOffset();
        int endOffset = startOffset + name.length();
        int line = id.getLine();
        if (!SemanticUtils.valid(parentClassType = SemanticUtils.unwrap(parentClassType, true, true))) {
            return;
        }
        boolean isPure = classType.hasQualifier(1);
        StructKind childStructKind = classType.getStructKind();
        if (!(parentClassType instanceof IRfClassType)) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(id);
            project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is not a {1} type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, parentClassType.getName(), childStructKind.toString());
            return;
        }
        StructKind parentStructKind = ((IRfClassType)((Object)parentClassType)).getStructKind();
        boolean isPureParent = ((IRfClassType)((Object)parentClassType)).hasQualifier(1);
        String childStructKindName = childStructKind.toString();
        String parentStructKindName = parentStructKind.toString();
        switch (parentStructKind) {
            case COMPONENT: {
                if (childStructKind != StructKind.COMPONENT) {
                    project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName);
                    return;
                }
                if (isPureParent || !isPure) break;
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), DVTStringUtil.appendString((Object[])new Object[]{"pure ", childStructKindName}), parentClassType.getName(), parentStructKindName);
                return;
            }
            case ACTION: {
                if (childStructKind == StructKind.ACTION) break;
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName);
                return;
            }
            case ACTION_ABSTRACT: {
                if (childStructKind == StructKind.ACTION || childStructKind == StructKind.ACTION_ABSTRACT) break;
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName);
                return;
            }
            case BUFFER: {
                if (childStructKind == StructKind.BUFFER) break;
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName);
                return;
            }
            case STREAM: {
                if (childStructKind == StructKind.STREAM) break;
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName);
                return;
            }
            case STATE: {
                if (childStructKind == StructKind.STATE) break;
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName);
                return;
            }
            case RESOURCE: {
                if (childStructKind == StructKind.RESOURCE) break;
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName);
                return;
            }
            case STRUCT: {
                if (childStructKind != StructKind.COMPONENT && childStructKind != StructKind.ACTION && childStructKind != StructKind.ACTION_ABSTRACT) break;
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName);
                return;
            }
        }
        classType.setParent((IRfClassType)((Object)parentClassType));
        if (classType.getParent() == RfClassType.CIRCULAR_INHERITANCE) {
            String kindName = String.valueOf(childStructKindName.substring(0, 1).toUpperCase()) + childStructKindName.substring(1);
            project.addSemanticError(1, "CIRCULAR_INHERITANCE: {0} ''{1}'' extends itself", null, startOffset, endOffset, null, line, parserPath, kindName, name);
            return;
        }
        if (childStructKind != StructKind.COMPONENT && (enclosingComponentScope = SemanticUtils.getEnclosingComponent((RfNamedElement)((Object)classType))) != null && (parentComponentScope = SemanticUtils.getEnclosingComponent(parentClassType)) != null && enclosingComponentScope != parentComponentScope && !enclosingComponentScope.isLike(parentComponentScope)) {
            project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} cannot inherit from ''{2}'' {3} defined in a different component", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), childStructKindName, parentClassType.getName(), parentStructKindName, parentComponentScope.getName());
            return;
        }
    }

    public static void checkTypeClassParent(RfProject project, RfTemplateParam.RfTemplateTypeParam typeParam, AST tid, ParserPath parserPath) {
        if (tid == null || !SemanticUtils.valid(typeParam)) {
            return;
        }
        IRfClassType parentClassType = typeParam.getParent();
        RfNamedElement assocType = typeParam.getAssociatedType();
        if (!SemanticUtils.valid(assocType)) {
            return;
        }
        if (assocType == parentClassType) {
            return;
        }
        StructKind childStructKind = typeParam.getStructKind();
        if (childStructKind != null) {
            String childStructKindName = childStructKind.toString();
            if (!(assocType instanceof IRfClassType)) {
                LineInfo lineInfo = SemanticUtils.getTreeLineInfo(tid);
                project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is not a {1} type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, assocType.getName(), childStructKindName);
                return;
            }
            StructKind typeStructKind = ((IRfClassType)((Object)assocType)).getStructKind();
            if (typeStructKind != childStructKind) {
                LineInfo lineInfo = SemanticUtils.getTreeLineInfo(tid);
                project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is not a {1} type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, assocType.getName(), childStructKindName);
                return;
            }
            if (assocType instanceof IRfClassType && parentClassType != null && !((RfClassType)assocType).isLike(parentClassType)) {
                StructKind parentStructKind = parentClassType.getStructKind();
                String parentStructKindName = parentStructKind.toString();
                LineInfo lineInfo = SemanticUtils.getTreeLineInfo(tid);
                project.addSemanticError(1, "INCONSISTENT_INHERITANCE: ''{0}'' {1} does not inherit from ''{2}'' {3}", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, assocType.getName(), childStructKindName, parentClassType.getName(), parentStructKindName);
                return;
            }
        }
    }

    public static void checkBindAssignment(RfProject project, RfDefElement currentScopeLayer, AST leftAST, RfNamedElement left, AST rightAST, RfNamedElement right, ParserPath parserPath) {
        if (left == null || right == null || currentScopeLayer == null) {
            return;
        }
        if (left == SemanticWalker.UNRESOLVED_ELEMENT || right == SemanticWalker.UNRESOLVED_ELEMENT) {
            return;
        }
        if (!(left instanceof RfField) || !(right instanceof RfField)) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(rightAST);
        RfNamedElement assocTypeLeft = ((RfField)left).getAssociatedType();
        RfNamedElement assocTypeRight = ((RfField)right).getAssociatedType();
        RfNamedElement currentScope = currentScopeLayer.getNamedElement();
        if (currentScope == null) {
            return;
        }
        RfStruct actionScope = currentScope.getEnclosingScope(RfStruct.class);
        if (actionScope == null) {
            return;
        }
        if (assocTypeLeft == assocTypeRight || SemanticUtils.isAliased(assocTypeLeft, assocTypeRight)) {
            FieldModifier fieldModifierLeft = ((RfField)left).getFieldModifier();
            FieldModifier fieldModifierRight = ((RfField)right).getFieldModifier();
            RfNamedElement leftEnclosingScope = left.getEnclosingScope();
            RfNamedElement rightEnclosingScope = right.getEnclosingScope();
            if (fieldModifierLeft == FieldModifier.INPUT && fieldModifierRight == FieldModifier.OUTPUT && actionScope != rightEnclosingScope && actionScope != leftEnclosingScope) {
                return;
            }
            if (fieldModifierLeft == FieldModifier.OUTPUT && fieldModifierRight == FieldModifier.INPUT && actionScope != rightEnclosingScope && actionScope != leftEnclosingScope) {
                return;
            }
            if (fieldModifierLeft == FieldModifier.LOCK && fieldModifierRight == FieldModifier.SHARE && actionScope == leftEnclosingScope) {
                return;
            }
            String lowerCaseFieldModifierRight = fieldModifierRight.toString().toLowerCase();
            String lowerCaseFieldModifierLeft = fieldModifierLeft.toString().toLowerCase();
            if (fieldModifierLeft == fieldModifierRight && (fieldModifierLeft == FieldModifier.INPUT || fieldModifierLeft == FieldModifier.OUTPUT || fieldModifierLeft == FieldModifier.SHARE || fieldModifierLeft == FieldModifier.LOCK)) {
                boolean likeRight;
                boolean likeLeft = actionScope == leftEnclosingScope || actionScope.isLike((RfClassType)leftEnclosingScope);
                boolean bl = likeRight = actionScope == rightEnclosingScope || actionScope.isLike((RfClassType)rightEnclosingScope);
                if (likeLeft && !likeRight) {
                    return;
                }
                if (likeRight && !likeLeft) {
                    project.addSemanticError(1, "ILLEGAL_BIND_STATEMENT: {0} ''{1}'' should be first within the bind statement", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, String.valueOf(lowerCaseFieldModifierRight.substring(0, 1).toUpperCase()) + lowerCaseFieldModifierRight.substring(1), SemanticUtils.getTextMeta(rightAST));
                    return;
                }
            }
            project.addSemanticError(1, "ILLEGAL_BIND_STATEMENT: Illegal bind statement between {0} ''{1}'' to {2} ''{3}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, lowerCaseFieldModifierLeft, SemanticUtils.getTextMeta(leftAST), lowerCaseFieldModifierRight, SemanticUtils.getTextMeta(rightAST));
        } else {
            String assocTypeLeftName = SemanticUtils.getAssociatedTypeName((RfAssociatedType)left);
            String assocTypeRightName = SemanticUtils.getAssociatedTypeName((RfAssociatedType)right);
            project.addSemanticError(1, "ILLEGAL_BIND_STATEMENT: Illegal bind statement between ''{0}'' of type ''{1}'' to ''{2}'' of type ''{3}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, SemanticUtils.getTextMeta(leftAST), assocTypeLeftName, SemanticUtils.getTextMeta(rightAST), assocTypeRightName);
        }
    }

    public static RfNamedElement getNamedElement(RfProject project, RfDefElement scopeLayer) {
        if (scopeLayer == null) {
            return null;
        }
        if (scopeLayer instanceof RfFileDef) {
            return project.getMainPackage();
        }
        return scopeLayer.getNamedElement();
    }

    public static String getTextMeta(AST hidAST) {
        if (hidAST.getType() == 276) {
            return hidAST.getText();
        }
        return ((EAST)hidAST).getMeta("text");
    }

    private static boolean isAliased(RfNamedElement assocTypeLeft, RfNamedElement assocTypeRight) {
        while (assocTypeLeft instanceof RfTypeAlias) {
            assocTypeLeft = ((RfTypeAlias)assocTypeLeft).getAssociatedType();
        }
        while (assocTypeRight instanceof RfTypeAlias) {
            assocTypeRight = ((RfTypeAlias)assocTypeRight).getAssociatedType();
        }
        return assocTypeLeft == assocTypeRight;
    }

    public static void checkAllowedPoolArray(RfProject project, RfDefElement currentScopeLayer, AST ad, AST tid, RfNamedElement type, String poolName, ParserPath parserPath) {
        if (tid == null || type == null) {
            return;
        }
        if (type instanceof IRfClassType) {
            StructKind structKind = ((IRfClassType)((Object)type)).getStructKind();
            if (ad != null && structKind != StructKind.RESOURCE) {
                LineInfo lineInfo = SemanticUtils.getTreeLineInfo(ad);
                project.addSemanticError(1, "ILLEGAL_RESOURCE_INSTANCES: Illegal resource instances specified for {0} type pool ''{1}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, structKind.toString(), poolName);
            } else if (structKind != StructKind.RESOURCE && structKind != StructKind.BUFFER && structKind != StructKind.STATE && structKind != StructKind.STREAM) {
                LineInfo lineInfo = SemanticUtils.getTreeLineInfo(tid);
                project.addSemanticError(1, "UNEXPECTED_POOL_TYPE: ''{0}'' is not of a buffer, resource, state or stream type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, type.getName());
            }
        } else {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(tid);
            project.addSemanticError(1, "UNEXPECTED_POOL_TYPE: ''{0}'' is not of a buffer, resource, state or stream type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, type.getName());
        }
    }

    public static void checkIsPoolInstance(RfProject rfp, RfDefElement currentScopeLayer, AST hid, RfNamedElement poolCandidate, ParserPath parserPath) {
        if (hid == null || !SemanticUtils.valid(poolCandidate)) {
            return;
        }
        if (!(poolCandidate instanceof RfField) || ((RfField)poolCandidate).getFieldModifier() != FieldModifier.POOL) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(hid);
            rfp.addSemanticError(1, "NOT_A_POOL: ''{0}'' is not a pool", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, poolCandidate.getName());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void resolveComponentPath(RfProject project, Determinant determinant, RfDefElement currentScopeLayer, List<Identifier> qid, boolean endsWithStar, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (qid == null || qid.isEmpty()) {
            return;
        }
        currentScope = SemanticUtils.getNamedElement(project, currentScopeLayer);
        if (currentScope == null || !SemanticUtils.valid(currentScope)) {
            return;
        }
        size = qid.size();
        actionIndex = endsWithStar != false ? size - 1 : size - 2;
        i = 0;
        while (i < size) {
            id = qid.get((int)i).id;
            nofSelects = qid.get((int)i).nofSelects;
            result = currentScope.getMember(currentScopeLayer, determinant, id.getText(), false, i == 0, SemanticUtils.MEMBER_VARIABLES, new UsageBeforeDefFilter(fileIndex, -1));
            if (result == null && i == actionIndex) {
                result = currentScope.getMember(currentScopeLayer, determinant, id.getText(), true, i == 0, Collections.singleton(RfStruct.class), new UsageBeforeDefFilter(fileIndex, -1));
            }
            if (result instanceof AmbiguousAccessError) {
                packageName1 = SemanticUtils.getEnclosingPackageOrComponentName(((AmbiguousAccessError)result).getCandidate1());
                packageName2 = SemanticUtils.getEnclosingPackageOrComponentName(((AmbiguousAccessError)result).getCandidate2());
                if (((AmbiguousAccessError)result).getCandidate1() instanceof RfField) {
                    project.addSemanticError(1, "AMBIGUOUS_FIELD: Field name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, new Object[]{id.getText(), packageName1, packageName2});
                } else {
                    project.addSemanticError(1, "AMBIGUOUS_TYPE: Type name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, new Object[]{id.getText(), packageName1, packageName2});
                }
                result = SemanticWalker.UNRESOLVED_ELEMENT;
            } else if (result == null || !SemanticUtils.valid(result)) {
                project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, new Object[]{id.getText()});
                result = SemanticWalker.UNRESOLVED_ELEMENT;
            }
            fileDef.createVariableDependency(project, result, id.getText());
            SemanticUtils.setTransientResult(id, result);
            if (SemanticUtils.valid(result)) ** GOTO lbl51
            return;
lbl-1000:
            // 1 sources

            {
                if (result instanceof RfAssociatedType) {
                    isArray = ((RfAssociatedType)result).getAssociatedTypeArray();
                    if (nofSelects > 0 && !isArray) {
                        lineInfo = SemanticUtils.getTreeLineInfo(id);
                        project.addSemanticError(1, "NOT_AN_ARRAY: Expression must be of array type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
                        return;
                    }
                    assocType = ((RfAssociatedType)result).getAssociatedType();
                    if (assocType != null) {
                        result = assocType;
                    }
                } else if (nofSelects > 0) {
                    lineInfo = SemanticUtils.getTreeLineInfo(id);
                    project.addSemanticError(1, "NOT_AN_ARRAY: Expression must be of array type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
                    return;
                }
                --nofSelects;
lbl51:
                // 2 sources

                ** while (nofSelects >= 0)
            }
lbl52:
            // 1 sources

            currentScope = result;
            ++i;
        }
    }

    public static RfNamedElement resolveSuperId(RfProject project, RfNamedElement currentScope, AST sp, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (currentScope == null) {
            SemanticUtils.setUnresolved(Collections.singletonList(sp));
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        RfNamedElement result = null;
        RfNamedElement enclosing = currentScope;
        do {
            if (!(enclosing instanceof RfStruct)) continue;
            IRfClassType parentStruct = ((RfStruct)enclosing).getParent();
            if (parentStruct == null) break;
            result = new RfPredefinedField("super", new DataType(parentStruct.getName()), "The predefined variable super is used refer the parent of current enclosing class");
            ((RfField)result).setAssociatedType((RfNamedElement)((Object)parentStruct));
            result.setEnclosingScope(enclosing);
            break;
        } while ((enclosing = enclosing.getEnclosingScope()) != null);
        if (result == null || !SemanticUtils.valid(result)) {
            if (parserPath != null) {
                project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, sp.getOffset(), sp.getOffset() + sp.getText().length(), null, sp.getLine(), parserPath, sp.getText());
            }
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        fileDef.createVariableDependency(project, result, sp.getText());
        SemanticUtils.setTransientResult(sp, result);
        return result;
    }

    public static void reportConstOverrideError(RfProject project, AST err, ParserPath parserPath) {
        if (err == null) {
            return;
        }
        project.addSemanticError(1, "CONSTANT_OVERRIDE: Wrong constant override specification in configuration file", null, -1, -1, null, err.getLine(), parserPath, new Object[0]);
    }

    public static void checkIllegalConstraintExpr(RfProject project, AST expAST, RfNamedElement result, ParserPath parserPath) {
        RfNamedElement assocType;
        if (expAST == null || result == null) {
            return;
        }
        if (result == SemanticWalker.UNRESOLVED_ELEMENT) {
            return;
        }
        if (result instanceof RfBlock ? ((RfBlock)result).isConstraint() : result instanceof RfAssociatedType && (assocType = ((RfAssociatedType)result).getAssociatedType()) instanceof RfPredefinedType && "bool".equals(assocType.getName())) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(expAST);
        project.addSemanticError(1, "NOT_A_CONSTRAINT: Expression must be a constraint or a reference to a constraint block", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
    }

    public static void checkIteratorAssociatedType(RfProject project, AST forAST, AST iteratorAST, AST indexAST, AST expAST, RfNamedElement result, RfNamedElement pathResult, ParserPath parserPath) {
        if (iteratorAST == null || expAST == null) {
            return;
        }
        RfField field = SemanticUtils.getTransientResult(RfField.class, iteratorAST);
        if (!SemanticUtils.valid(field) || !SemanticUtils.valid(result)) {
            return;
        }
        if (forAST.getType() == 105) {
            RfNamedElement associatedType = result;
            while (associatedType instanceof RfTypeAlias) {
                associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
            }
            if (!SemanticUtils.valid(associatedType)) {
                return;
            }
            if (!(associatedType instanceof RfStruct)) {
                LineInfo lineInfo = SemanticUtils.getTreeLineInfo(expAST);
                project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is not a {1} type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, associatedType.getName(), "struct");
                return;
            }
            field.setDataType(new DataType(associatedType.getName()));
            field.setAssociatedType(associatedType);
            if (SemanticUtils.valid(pathResult)) {
                RfNamedElement associatedType2 = result;
                while (associatedType2 instanceof RfTypeAlias) {
                    associatedType2 = ((RfTypeAlias)associatedType2).getAssociatedType();
                }
                if (!SemanticUtils.valid(associatedType2)) {
                    return;
                }
                if (associatedType != associatedType2) {
                    LineInfo lineInfo = SemanticUtils.getTreeLineInfo(indexAST);
                    project.addSemanticError(1, "UNEXPECTED_TYPE: Expression is of type ''{1}'', while expecting type ''{2}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, associatedType2.getName(), associatedType.getName());
                    return;
                }
            }
            return;
        }
        if (!(result instanceof IRfAssociatedType)) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(expAST);
            project.addSemanticError(1, "NOT_AN_ARRAY: Expression must be of array type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
            return;
        }
        RfNamedElement assocType = (RfNamedElement)((IRfAssociatedType)((Object)result)).getAssociatedType();
        if (!SemanticUtils.valid(assocType)) {
            return;
        }
        ((IRfAssociatedType)((Object)result)).getDataType();
        int i = 0;
        while (assocType instanceof RfTypeAlias && i < 20) {
            assocType = ((RfTypeAlias)assocType).getAssociatedType();
            ((RfTypeAlias)assocType).getDataType();
            ++i;
        }
        while (assocType instanceof RfTypeAlias) {
            assocType = ((RfTypeAlias)assocType).getAssociatedType();
        }
        if (!(assocType instanceof RfCollectionType)) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(expAST);
            project.addSemanticError(1, "NOT_AN_ARRAY: Expression must be of array type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
            return;
        }
        RfField itemField = ((RfCollectionType)assocType).getItemField();
        if (itemField == null) {
            return;
        }
        field.setDataType(itemField.getDataType());
        field.setAssociatedType(itemField.getAssociatedType());
    }

    public static void checkInputOutput(RfProject project, AST typeAST, RfNamedElement type, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        StructKind structKind;
        if (typeAST == null || !SemanticUtils.valid(type)) {
            return;
        }
        if ((type = SemanticUtils.unwrap(type, true, true)) instanceof IRfClassType && ((structKind = ((IRfClassType)((Object)type)).getStructKind()) == StructKind.BUFFER || structKind == StructKind.STATE || structKind == StructKind.STREAM)) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(typeAST);
        project.addSemanticError(1, "FLOW_REF_FIELD: Type ''{0}'' is not a flow type object", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, type.getName());
    }

    public static void checkLockShare(RfProject project, AST typeAST, RfNamedElement type, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        StructKind structKind;
        if (typeAST == null || !SemanticUtils.valid(type)) {
            return;
        }
        if ((type = SemanticUtils.unwrap(type, true, true)) instanceof IRfClassType && (structKind = ((IRfClassType)((Object)type)).getStructKind()) == StructKind.RESOURCE) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(typeAST);
        project.addSemanticError(1, "RESOURCE_REF_FIELD: Type ''{0}'' is not a resource type object", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, type.getName());
    }

    public static void checkEnumValue(RfProject project, AST idAST, AST expAST, RfProject.ElementContainer enumContainer, BitVectorInt value, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (idAST == null || expAST == null || value == null || enumContainer == null || !(enumContainer.element instanceof RfEnumType)) {
            return;
        }
        RfEnumType enumType = (RfEnumType)enumContainer.element;
        RfEnumItem existingEnumItem = enumType.getEnumItem(value.intValue(), idAST.getText());
        if (existingEnumItem == null) {
            return;
        }
        RfDefElement declaration = existingEnumItem.getDeclaration();
        if (declaration == null) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(expAST);
        project.addSemanticError(1, "NOT_ALLOWED_ENUM_VALUE: Enum item value ''{0}'' already assigned to enum item ''{1}''\n    at line {2,number,#######} in {3}", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, value.intValue(), existingEnumItem.getName(), declaration.getStartLine(), declaration.getParserPath());
    }

    public static RfNamedElement overrideScope(RfDefElement currentScopeLayer, StringBuilder hierarchicalPath, Determinant determinant, RfNamedElement currentScope) {
        if (currentScopeLayer == null || currentScope == null) {
            return currentScope;
        }
        StringBuilder hierarchicalPathFull = new StringBuilder("__override__inst__");
        RfStruct structScope = SemanticUtils.getEnclosingStruct(currentScopeLayer.getNamedElement(), hierarchicalPathFull);
        if (structScope == null) {
            return currentScope;
        }
        List<RfNamedElement> overrides = ((RfNamedElement)structScope).getLocalMembers(determinant, Collections.singleton(RfPropTypeOverride.class));
        if (overrides == null || overrides.isEmpty()) {
            return currentScope;
        }
        if (hierarchicalPath.length() != 0) {
            String instOverrideName = hierarchicalPathFull.append((CharSequence)hierarchicalPath).toString();
            for (RfNamedElement override : overrides) {
                RfNamedElement typeReplacement;
                if (!instOverrideName.equals(override.getName()) || !SemanticUtils.isLike(typeReplacement = ((RfPropTypeOverride)override).getTypeTo(), currentScope)) continue;
                return typeReplacement;
            }
        }
        for (RfNamedElement override : overrides) {
            RfNamedElement typeReplacement;
            if (((RfPropTypeOverride)override).getTypeFrom() != currentScope || !SemanticUtils.isLike(typeReplacement = ((RfPropTypeOverride)override).getTypeTo(), currentScope)) continue;
            return typeReplacement;
        }
        return currentScope;
    }

    private static RfStruct getEnclosingStruct(RfNamedElement namedElement, StringBuilder hierarchicalPathFull) {
        do {
            if (namedElement == null) {
                return null;
            }
            if (namedElement instanceof RfStruct) {
                return (RfStruct)namedElement;
            }
            if (namedElement instanceof RfExecBlock && ((RfExecBlock)namedElement).isActivity()) continue;
            if (namedElement instanceof RfBlock && ((RfBlock)namedElement).getInstanceScopeName() != null) {
                hierarchicalPathFull.append(((RfBlock)namedElement).getInstanceScopeName()).append('.');
                continue;
            }
            if (namedElement.isAnonymous()) continue;
            hierarchicalPathFull.append(namedElement.getName()).append('.');
        } while ((namedElement = namedElement.getEnclosingScope()) != null);
        return null;
    }

    public static RfNamedElement getOverridenActionHandle(RfDefElement currentScopeLayer, ActionInstance parentActionInstance, Determinant determinant, RfField rfActionHandle) {
        if (currentScopeLayer == null || rfActionHandle == null) {
            return rfActionHandle;
        }
        LinkedList<RfField> pathSegments = new LinkedList<RfField>();
        do {
            RfNamedElement typeReplacement;
            RfStruct rfAction;
            if (parentActionInstance instanceof ISchedulingInstance || (rfAction = parentActionInstance.getRfAction()) == null) continue;
            pathSegments.add(0, parentActionInstance.getRfField());
            List<RfNamedElement> overrides = rfAction.getLocalMembers(determinant, Collections.singleton(RfPropTypeOverride.class));
            if (overrides == null || overrides.isEmpty()) continue;
            StringBuilder hierarchicalPath = new StringBuilder("__override__inst__");
            int i = 1;
            while (i < pathSegments.size()) {
                hierarchicalPath.append(((RfNamedElement)pathSegments.get(i)).getName());
                hierarchicalPath.append('.');
                ++i;
            }
            hierarchicalPath.append(rfActionHandle.getName());
            String instOverrideName = hierarchicalPath.toString();
            RfNamedElement associatedType = rfActionHandle.getAssociatedType();
            for (RfNamedElement override : overrides) {
                if (!instOverrideName.equals(override.getName()) || (typeReplacement = ((RfPropTypeOverride)override).getTypeTo()) == null || !SemanticUtils.isLike(typeReplacement, associatedType)) continue;
                RfField rfActionHandleReplacement = new RfField(rfActionHandle.getName(), rfActionHandle.getDataType());
                rfActionHandleReplacement.setAssociatedType(typeReplacement);
                rfActionHandleReplacement.setEnclosingScope(rfActionHandle.getEnclosingScope());
                return rfActionHandleReplacement;
            }
            for (RfNamedElement override : overrides) {
                if (((RfPropTypeOverride)override).getTypeFrom() != associatedType || (typeReplacement = ((RfPropTypeOverride)override).getTypeTo()) == null || !SemanticUtils.isLike(typeReplacement, associatedType)) continue;
                RfField rfActionHandleReplacement = new RfField(rfActionHandle.getName(), rfActionHandle.getDataType());
                rfActionHandleReplacement.setAssociatedType(typeReplacement);
                rfActionHandleReplacement.setEnclosingScope(rfActionHandle.getEnclosingScope());
                return rfActionHandleReplacement;
            }
        } while ((parentActionInstance = parentActionInstance.getParentActionInstance()) != null);
        return rfActionHandle;
    }

    public static final RfNamedElement unwrapElement(RfProject project, RfNamedElement currentScope, AST id, boolean isMethod, RfNamedElement element, ParserPath parserPath) {
        String packageName2;
        String packageName1;
        if (element instanceof AmbiguousAccessError) {
            packageName1 = SemanticUtils.getEnclosingPackageOrComponentName(((AmbiguousAccessError)element).getCandidate1());
            packageName2 = SemanticUtils.getEnclosingPackageOrComponentName(((AmbiguousAccessError)element).getCandidate2());
            element = ((AmbiguousAccessError)element).getCandidate1();
            if (isMethod) {
                project.addSemanticError(1, "AMBIGUOUS_FUNCTION: Function name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), packageName1, packageName2);
            } else if (element instanceof RfField) {
                project.addSemanticError(1, "AMBIGUOUS_FIELD: Field name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), packageName1, packageName2);
            } else {
                project.addSemanticError(1, "AMBIGUOUS_TYPE: Type name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), packageName1, packageName2);
            }
        }
        if (element instanceof TransitiveAccessError) {
            packageName1 = SemanticUtils.getEnclosingPackageOrComponentName(((TransitiveAccessError)element).getCandidate());
            packageName2 = SemanticUtils.getEnclosingPackageOrComponentName(currentScope);
            element = ((TransitiveAccessError)element).getCandidate();
            project.addSemanticError(1, "ILLEGAL_PACKAGE_ACCESS: Access of ''{0}'' declared in package ''{1}'' from package ''{2}'' is illegal (use ''import {1}::{0}'')", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), packageName1, packageName2);
        }
        return element;
    }

    private static final String getEnclosingPackageOrComponentName(RfNamedElement element) {
        RfDefElement declaration = element.getDeclaration();
        if (declaration == null) {
            RfNamedElement packageOrComponent = SemanticUtils.getEnclosingPackageOrComponent(element);
            if (packageOrComponent != null) {
                return packageOrComponent.getName();
            }
            return "main";
        }
        String packageName = declaration.getPackageName();
        if (declaration.getEnclosingStructDef() != null) {
            RfNamedElement packageOrComponent = SemanticUtils.getEnclosingPackageOrComponent(element);
            if (packageOrComponent == null) {
                return "main";
            }
            if (packageOrComponent instanceof RfPackage) {
                return packageName;
            }
            return packageOrComponent.getName();
        }
        return packageName;
    }

    public static final RfNamedElement getEnclosingPackageOrComponent(RfNamedElement element) {
        do {
            if (element instanceof RfPackage) {
                return element;
            }
            if (!(element instanceof RfStruct) || ((RfStruct)element).getStructKind() != StructKind.COMPONENT) continue;
            return element;
        } while ((element = element.getEnclosingScope()) != null);
        return null;
    }

    public static RfNamedElement createTemplateInstance(RfProject project, Determinant determinant, RfNamedElement teplateStruct, AST id, List<RfNamedElement> instanceParameters, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (teplateStruct == null || !SemanticUtils.valid(teplateStruct)) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        RfNamedElement result = teplateStruct;
        if (!(result instanceof RfTemplateStruct)) {
            project.addSemanticError(1, "NOT_A_TEMPLATE: ''{0}'' is not a template type", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            SemanticUtils.setTransientResult(id, result);
            return result;
        }
        result = ((RfTemplateStruct)result).getTemplateInstance(project, id, instanceParameters, fileDef, parserPath);
        SemanticUtils.setTransientResult(id, result);
        fileDef.createTypeDependency(project, result, id.getText());
        return result;
    }

    public static RfNamedElement resolveType(RfProject project, ElementScope currentScope, ElementScope typeParamScope, AST id, final StructKind structKind, boolean isFirst, boolean isLast, StaticRefElementKind elementKind, boolean isStrictUsageBefore, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        RfNamedElement enclosingScope2;
        RfDefElement declaration;
        RfNamedElement enclosingScope;
        if (currentScope == null || !SemanticUtils.valid(currentScope.enclosingScope)) {
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        boolean isMethod = isLast && elementKind == StaticRefElementKind.METHOD;
        boolean isField = isLast && elementKind == StaticRefElementKind.FIELD;
        RfNamedElement result = null;
        if (isFirst && currentScope.lexicalScope instanceof RfScopeDefElement) {
            result = currentScope.lexicalScope.getPackageAlias(id.getText());
        }
        if (result == null && typeParamScope != null && SemanticUtils.valid(typeParamScope.enclosingScope)) {
            enclosingScope = typeParamScope.enclosingScope;
            result = enclosingScope.getLocalMember(typeParamScope.determinant, Collections.singleton(RfTemplateParam.RfTemplateTypeParam.class), id.getText(), false, null);
        }
        enclosingScope = currentScope.enclosingScope;
        UsageBeforeDefFilter usageBeforeFilter = new UsageBeforeDefFilter(fileIndex, id.getOffset());
        if (result == null) {
            result = enclosingScope.getMember(currentScope.lexicalScope, currentScope.determinant, id.getText(), isFirst, isFirst, isMethod ? MEMBER_METHODS : (isField ? MEMBER_FIELDS : MEMBER_TYPES), usageBeforeFilter);
        }
        if (usageBeforeFilter.importElement != null && isStrictUsageBefore && (declaration = (RfDefElement)usageBeforeFilter.importElement.getDeclaration()) != null) {
            project.addSemanticError(1, "USAGE_BEFORE_DECLARATION: Element ''{0}'' is used before being imported\n    at line {1,number,#######} in {2}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), declaration.getStartLine(), declaration.getParserPath());
        }
        if (result == null && (result = enclosingScope.getMember(currentScope.lexicalScope, currentScope.determinant, id.getText(), isFirst, isFirst, isMethod ? MEMBER_METHODS : (isField ? MEMBER_FIELDS : MEMBER_TYPES), new UsageBeforeDefFilter(fileIndex, -1))) != null && isStrictUsageBefore) {
            declaration = result.getDeclaration();
            if (declaration != null) {
                project.addSemanticError(1, "USAGE_BEFORE_DECLARATION: Element ''{0}'' is used before being declared\n    at line {1,number,#######} in {2}", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), declaration.getStartLine(), declaration.getParserPath());
                SemanticUtils.setTransientResult(id, result);
                return result;
            }
            result = null;
        }
        if (result == null && typeParamScope != null && SemanticUtils.valid(typeParamScope.enclosingScope) && (enclosingScope = typeParamScope.enclosingScope) instanceof RfTemplateInstance) {
            enclosingScope = ((RfTemplateInstance)enclosingScope).getTemplateStruct();
            result = enclosingScope.getLocalMember(typeParamScope.determinant, Collections.singleton(RfTemplateParam.RfTemplateTypeParam.class), id.getText(), false, null);
            result = SemanticUtils.unwrap(result, true, false);
        }
        enclosingScope = currentScope.enclosingScope;
        if (result == null && !isStrictUsageBefore) {
            IRfElementFilter forwardDeclarationFilter = new IRfElementFilter(){

                public boolean validElement(IRfNamedElement candidate) {
                    return (!(candidate instanceof RfStruct) || structKind != StructKind.ENUM_TYPE) && (!(candidate instanceof RfEnumType) || structKind == StructKind.ENUM_TYPE);
                }

                public int resultMaxSize() {
                    return 1;
                }

                public boolean allowEnumElement() {
                    return true;
                }
            };
            result = enclosingScope.getMember(currentScope.lexicalScope, currentScope.determinant, id.getText(), isFirst, isFirst, isMethod ? MEMBER_METHODS : (isField ? MEMBER_FIELDS : MEMBER_TYPES), forwardDeclarationFilter);
        }
        if ((result = SemanticUtils.unwrapElement(project, enclosingScope, id, isMethod, result, parserPath)) == null) {
            if (isMethod) {
                project.addSemanticError(1, "UNDECLARED_FUNCTION: Function ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            } else if (isField && isFirst) {
                project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            } else if (isField && !isFirst) {
                project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), enclosingScope.getName());
            } else if (enclosingScope instanceof RfTemplateInstance && !isStrictUsageBefore) {
                project.addSemanticError(1, "UNDECLARED_TYPE: Type ''{0}'' is not declared in ''{1}'' template instance scope", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), enclosingScope.getName());
            } else {
                project.addSemanticError(1, "UNDECLARED_TYPE: Type ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            }
            result = SemanticWalker.UNRESOLVED_ELEMENT;
            SemanticUtils.setTransientResult(id, result);
            return result;
        }
        if (result instanceof RfTemplateParam.RfTemplateTypeParam) {
            int index = ((RfTemplateParam.RfTemplateTypeParam)result).getIndex();
            if (enclosingScope instanceof RfTemplateInstance) {
                result = ((RfTemplateInstance)enclosingScope).getInstanceParameter(index);
            } else if (enclosingScope instanceof RfTemplateStruct) {
                result = ((RfTemplateStruct)enclosingScope).getParameter(index);
            }
            if (result == null) {
                project.addSemanticError(1, "UNDECLARED_TYPE: Type ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
                result = SemanticWalker.UNRESOLVED_ELEMENT;
            }
        }
        if (!isFirst && enclosingScope instanceof RfPackage && (enclosingScope2 = result.getEnclosingScope()) instanceof RfPackage && enclosingScope != enclosingScope2) {
            String packageName1 = SemanticUtils.getEnclosingPackageOrComponentName(enclosingScope);
            String packageName2 = SemanticUtils.getEnclosingPackageOrComponentName(enclosingScope2);
            project.addSemanticError(1, "ILLEGAL_PACKAGE_ACCESS: Access of ''{0}'' declared in package ''{1}'' from package ''{2}'' is illegal (use ''import {1}::{0}'')", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), enclosingScope2.getName(), packageName1, packageName2);
        }
        SemanticUtils.setTransientResult(id, result);
        if (!SemanticUtils.valid(result)) {
            return result;
        }
        if (isMethod || isField) {
            fileDef.createVariableDependency(project, result, id.getText());
        } else {
            fileDef.createTypeDependency(project, result, id.getText());
        }
        return result;
    }

    public static void reportNonArrayElementError(RfProject project, AST id, RfNamedElement rfElement, RfNamedElement associatedType, ParserPath parserPath) {
        if (id == null || !SemanticUtils.valid(rfElement)) {
            return;
        }
        if (associatedType == SemanticWalker.UNRESOLVED_ELEMENT || associatedType == null) {
            return;
        }
        if (rfElement instanceof RfField && ((RfField)rfElement).getFieldModifier() == FieldModifier.POOL && associatedType instanceof IRfClassType && ((IRfClassType)((Object)associatedType)).getStructKind() == StructKind.RESOURCE) {
            return;
        }
        if (associatedType instanceof RfCollectionType) {
            return;
        }
        if (associatedType instanceof RfBlock && ((RfBlock)associatedType).isBlockArray()) {
            return;
        }
        if (associatedType.isNumericType()) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(id);
        project.addSemanticError(1, "NOT_AN_ARRAY: Expression must be of array type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
    }

    public static void reportNotAllowedSetSelectError(RfProject project, AST id, RfNamedElement rfElement, RfNamedElement associatedType, ParserPath parserPath) {
        if (id == null || !SemanticUtils.valid(rfElement)) {
            return;
        }
        if (associatedType instanceof RfCollectionType && ((RfCollectionType)associatedType).getCollectionKind() == DataType.CollectionKind.SET) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(id);
            project.addSemanticError(1, "NOT_ALLOWED_SELECT: Select element from a set is not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
        }
    }

    public static void checkArrayDimention(RfProject project, BitVectorInt arrayDim, AST arrayDimAST, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (arrayDimAST == null) {
            return;
        }
        if (arrayDim instanceof BitVectorRef) {
            return;
        }
        if (arrayDim != null && arrayDim.intValue() >= 0) {
            return;
        }
        String value = arrayDim == null ? "0" : arrayDim.toString();
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(arrayDimAST);
        project.addSemanticError(1, "ILLEGAL_ARRAY_DIMENTION: ''{0}'' is not a legal array dimention value", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, value);
    }

    public static void checkAllowedImportedElement(RfProject project, AST typeAST, RfNamedElement importedType, boolean isWhildcard, ParserPath parserPath) {
        if (typeAST == null || importedType == null) {
            return;
        }
        String importedName = importedType.getName();
        if (importedType instanceof RfTemplateInstance) {
            importedName = SemanticUtils.unqualifiedName(importedName);
        }
        if (importedType instanceof RfTemplateStruct && ((RfTemplateStruct)importedType).isTemplateStuct()) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(typeAST);
            project.addSemanticError(1, "ILLEGAL_TEMPLATE_TYPE_USAGE: Cannot use ''{0}'' generic template-type (expecting template-type instance)", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, importedName);
            return;
        }
        RfNamedElement enclosingScope = importedType;
        do {
            if (!(enclosingScope instanceof RfStruct) || !((RfStruct)enclosingScope).isComponent()) continue;
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(typeAST);
            project.addSemanticError(2, "ILLEGAL_PACKAGE_IMPORT: Import of ''{0}'' is not allowed (not a package or package member)", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, importedName);
            return;
        } while ((enclosingScope = enclosingScope.getEnclosingScope()) != null);
    }

    public static void checkValidConstraint(RfProject project, RfDefElement currentScopeLayer, AST constraintAST, boolean hasActionReference, boolean hasRandFieldReference, boolean hasActionRandFieldReference, boolean hasConstraintItems, ParserPath parserPath) {
        if (constraintAST == null || !hasConstraintItems || currentScopeLayer == null) {
            return;
        }
        if (!hasActionReference) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(constraintAST);
            project.addSemanticError(1, "ILLEGAL_CONSTRAINT: Constraint not referring an action handle attribute not allowed under activity block", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
            return;
        }
        if (!hasRandFieldReference) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(constraintAST);
            project.addSemanticError(2, "NON_RAND_CONSTRAINT: Constraint of non-random attribute(s) may lead to contradiction", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
            return;
        }
        if (!hasActionRandFieldReference) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(constraintAST);
            project.addSemanticError(2, "VACUOUS_CONSTRAINT: Constraint of an action handle non-random attribute(s) is vacuous", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
            return;
        }
    }

    public static boolean isRand(RfNamedElement candidate) {
        if (!SemanticUtils.valid(candidate)) {
            return true;
        }
        if (!(candidate instanceof RfField)) {
            return true;
        }
        if (candidate instanceof RfPredefinedField && "comp".equals(candidate.getName())) {
            return true;
        }
        if (candidate instanceof RfPredefinedField && "prev".equals(candidate.getName())) {
            return true;
        }
        if (((RfField)candidate).isRand()) {
            return true;
        }
        if (((RfField)candidate).isOutput() || ((RfField)candidate).isInput() || ((RfField)candidate).isShare() || ((RfField)candidate).isLock()) {
            return true;
        }
        return ((RfField)candidate).isActionHandle();
    }

    public static boolean isRandActionMember(RfNamedElement candidate, RfNamedElement currentScope) {
        if (!SemanticUtils.valid(candidate)) {
            return true;
        }
        if (!SemanticUtils.isRand(candidate)) {
            return false;
        }
        if (candidate instanceof RfField && ((RfField)candidate).isActionQualified()) {
            return true;
        }
        RfStruct enclosingScope1 = currentScope.getEnclosingScope(RfStruct.class);
        if (enclosingScope1 == null) {
            return false;
        }
        RfStruct enclosingScope2 = candidate.getEnclosingScope(RfStruct.class);
        if (enclosingScope2 == null) {
            return false;
        }
        return enclosingScope1 != enclosingScope2 && !enclosingScope1.isLike(enclosingScope2);
    }

    public static boolean isActionHandleMember(RfNamedElement candidate, RfNamedElement currentScope) {
        if (!SemanticUtils.valid(candidate)) {
            return true;
        }
        RfStruct enclosingScope1 = currentScope.getEnclosingScope(RfStruct.class);
        RfStruct enclosingScope2 = candidate.getEnclosingScope(RfStruct.class);
        if (enclosingScope2 == null) {
            return false;
        }
        return enclosingScope1 != enclosingScope2 && !enclosingScope1.isLike(enclosingScope2);
    }

    public static BitVectorInt getEnumItemValue(RfProject project, Determinant determinant, RfEnumType currentScope, AST id, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        RfEnumItem enumItem = (RfEnumItem)currentScope.getLocalMember(determinant, Collections.singleton(RfEnumItem.class), id.getText(), false, null);
        if (enumItem == null) {
            project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return null;
        }
        SemanticUtils.setTransientResult(id, enumItem);
        BitVectorInt value = enumItem.getInitialValue(-1);
        return value;
    }

    public static void checkAllowedAssociatedType(RfProject project, AST dtAST, RfNamedElement rfType, ParserPath parserPath) {
        if (!SemanticUtils.valid(rfType) || dtAST == null) {
            return;
        }
        if (rfType.getClass() != RfTemplateStruct.class) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(dtAST);
        project.addSemanticError(1, "UNEXPECTED_TYPE: Generic template struct type ''{0}'' not allowed (use <> for default parameters instantiation)", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rfType.getName());
    }

    public static void checkIllegalDefaultConstraint(RfProject project, AST defaultAST, boolean isConditionalConstraint, boolean isActivityBlock, boolean isDynamicConstraint, AST id, RfNamedElement hidElement, AST exprAST, RfNamedElement exprElement, ParserPath parserPath) {
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(defaultAST);
        if (isConditionalConstraint) {
            project.addSemanticError(1, "ILLEGAL_CONSTRAINT: Default-value and default-disable constraints cannot be conditioned on non-constant expressions (use compile if)", null, lineInfo.realOffset, lineInfo.virtOffset, null, id.getLine(), parserPath, new Object[0]);
            return;
        }
        if (isDynamicConstraint) {
            project.addSemanticError(1, "ILLEGAL_CONSTRAINT: Default-value and default-disable constraints cannot be used dynamic constraints", null, lineInfo.realOffset, lineInfo.virtOffset, null, id.getLine(), parserPath, new Object[0]);
            return;
        }
        SemanticUtils.checkIllegalAssignment(project, defaultAST, id, hidElement, exprAST, exprElement, parserPath);
    }

    public static RfNamedElement checkAllowedTemplateStruct(RfProject project, Determinant determinant, RfNamedElement element, AST id, boolean isLast, boolean isExtend, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (element == null || !SemanticUtils.valid(element)) {
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        if (element instanceof RfTemplateStruct && ((RfTemplateStruct)element).isTemplateStuct() && (!isLast || !isExtend)) {
            project.addSemanticError(1, "ILLEGAL_TEMPLATE_TYPE_USAGE: Cannot use ''{0}'' generic template-type (expecting template-type instance)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
        }
        return element;
    }

    public static void checkTraversalType(RfProject project, AST typeAST, RfNamedElement member, RfNamedElement assocType, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (typeAST == null || !SemanticUtils.valid(assocType)) {
            return;
        }
        if (member != null && !SemanticUtils.valid(member)) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(typeAST);
        if (member instanceof RfBlock) {
            if (!((RfBlock)member).isDynamicConstraint()) {
                project.addSemanticError(1, "NOT_ALLOWED_TRAVERSAL: Traversal of non-dynamic constraint ''{0}'' is not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, member.getName());
                return;
            }
            return;
        }
        if (member instanceof RfField && ((RfField)member).isActionQualified()) {
            return;
        }
        if ((assocType = SemanticUtils.unwrap(assocType, true, true)) instanceof RfCollectionType && ((RfCollectionType)assocType).getCollectionKind() == DataType.CollectionKind.ARRAY) {
            assocType = ((RfCollectionType)assocType).getAssociatedType();
        }
        if (assocType instanceof IRfClassType) {
            StructKind structKind = ((IRfClassType)((Object)assocType)).getStructKind();
            if (structKind == StructKind.ACTION) {
                return;
            }
            if (structKind == StructKind.ACTION_ABSTRACT) {
                project.addSemanticError(1, "NOT_ALLOWED_TRAVERSAL: Traversal of abstract action ''{0}'' is not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, assocType.getName());
                return;
            }
        }
        project.addSemanticError(1, "NOT_ALLOWED_TRAVERSAL: Traversal of ''{0}'' is not allowed", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, assocType.getName());
    }

    public static boolean checkIsConstant(RfProject project, AST expressionAST, RfNamedElement namedElement, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (!SemanticUtils.valid(namedElement)) {
            return true;
        }
        if (namedElement instanceof RfField && ((RfField)namedElement).isConstant()) {
            return true;
        }
        if (MEMBER_TYPES.contains(namedElement.getClass())) {
            return true;
        }
        if (namedElement instanceof RfTemplateParam) {
            return true;
        }
        if (namedElement instanceof RfTemplateParam.RfInstanceTypeParam || namedElement instanceof RfTemplateParam.RfInstanceValueParam) {
            return true;
        }
        if (namedElement instanceof RfEnumType) {
            return true;
        }
        if (namedElement instanceof RfPredefinedMethod && namedElement.getEnclosingScope() instanceof RfCollectionType) {
            return true;
        }
        if (namedElement instanceof RfAssociatedType && ((RfAssociatedType)namedElement).getAssociatedType() instanceof RfCollectionType) {
            return true;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(expressionAST);
        project.addSemanticError(1, "NOT_A_CONSTANT: ''{0}'' is not a constant expression", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, namedElement.getName());
        return false;
    }

    public static void checkCoverCrossItem(RfProject project, AST idAST, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (idAST == null) {
            return;
        }
        RfNamedElement namedElement = SemanticUtils.getTransientResult(RfNamedElement.class, idAST);
        if (!SemanticUtils.valid(namedElement)) {
            return;
        }
        if (namedElement instanceof RfField && ((RfField)namedElement).getFieldModifier() == FieldModifier.COVERCROSS) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(idAST);
            project.addSemanticError(1, "NOT_A_COVERPOINT: ''{0}'' is not a cover point instance", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, namedElement.getName());
        }
    }

    public static void checkImmutableFieldAccess(RfProject project, AST pathAST, RfNamedElement namedElement, ParserPath parserPath) {
        if (pathAST == null) {
            return;
        }
        if (!SemanticUtils.valid(namedElement)) {
            return;
        }
        RfNamedElement enclosingScope = namedElement.getEnclosingScope();
        if (enclosingScope instanceof RfStruct && enclosingScope.isComponent()) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(pathAST);
            project.addSemanticError(1, "ILLEGAL_MODIFICATION: Illegal modification of an immutable attribute ''{0}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, namedElement.getName());
        }
    }

    public static void checkImmutableFunctionAccess(RfProject project, AST idAST, RfNamedElement prevElement, RfNamedElement namedElement, ParserPath parserPath) {
        String name;
        if (idAST == null || prevElement == null) {
            return;
        }
        if (!SemanticUtils.valid(namedElement)) {
            return;
        }
        RfNamedElement enclosingScope = prevElement.getEnclosingScope();
        if (enclosingScope instanceof RfStruct && enclosingScope.isComponent() && namedElement instanceof RfPredefinedMethod && namedElement.getEnclosingScope() instanceof RfCollectionType && ("push_front".equals(name = namedElement.getName()) || "push_back".equals(name) || "insert".equals(name) || "clear".equals(name) || "delete".equals(name) || "pop_front".equals(name) || "pop_back".equals(name) || "set".equals(name))) {
            LineInfo lineInfo = SemanticUtils.getTreeLineInfo(idAST);
            project.addSemanticError(1, "ILLEGAL_MODIFICATION: Illegal modification of an immutable attribute ''{0}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, prevElement.getName());
        }
    }

    public static int getNofArgumentsNoDefault(List<RfField> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return 0;
        }
        int nofArgumentsNoDefault = 0;
        for (RfField argument : arguments) {
            DataType dataType = argument.getDataType();
            if (dataType != null && dataType.getInitialValue() != null) continue;
            ++nofArgumentsNoDefault;
        }
        return nofArgumentsNoDefault;
    }

    public static void checkIllegalValueParam(RfProject project, AST idAST, RfNamedElement namedElement, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (!SemanticUtils.valid(namedElement)) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(idAST);
        if (namedElement instanceof RfCollectionType) {
            project.addSemanticError(2, "NON_STANDARD_PARAMETER: Non-standard collection type value parameter ''{0}'' (allowed int, bit, bool, string, and enum value parameter type)", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, idAST.getText());
        }
        if (namedElement instanceof RfStruct) {
            project.addSemanticError(1, "ILLEGAL_PARAMETER: Illegal struct type value parameter ''{0}'' (allowed int, bit, bool, string, and enum value parameter type)", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, idAST.getText());
        }
    }

    public static void setTypedefAssociatedType(RfProject project, AST idAST, RfTypeAlias namedElement, RfNamedElement type, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (!SemanticUtils.valid(namedElement)) {
            return;
        }
        if (!(type instanceof RfTypeAlias)) {
            namedElement.setAssociatedType(type);
            return;
        }
        RfNamedElement resolvedElement = type;
        int i = 0;
        while (resolvedElement instanceof RfTypeAlias) {
            resolvedElement = ((RfTypeAlias)resolvedElement).getAssociatedType();
            if (i > 20 || namedElement == resolvedElement) {
                LineInfo lineInfo = SemanticUtils.getTreeLineInfo(idAST);
                project.addSemanticError(1, "CIRCULAR_TYPEDEF: Type ''{0}'' alias itself", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, idAST.getText());
                namedElement.setAssociatedType(SemanticWalker.UNRESOLVED_ELEMENT);
                return;
            }
            ++i;
        }
        namedElement.setAssociatedType(type);
    }

    public static final int nofBits(IRfAssociatedType element) {
        if (element == null) {
            return -1;
        }
        IRfNamedElement resolvedAssocType = element.getAssociatedType();
        if (resolvedAssocType instanceof RfEnumType) {
            return 32;
        }
        DataType lastDataType = element.getDataType();
        int i = 0;
        while (i < 20) {
            if (resolvedAssocType instanceof RfEnumType) {
                return 32;
            }
            if (!(resolvedAssocType instanceof RfTypeAlias)) break;
            lastDataType = ((RfTypeAlias)resolvedAssocType).getDataType();
            resolvedAssocType = ((RfTypeAlias)resolvedAssocType).getAssociatedType();
            ++i;
        }
        return lastDataType == null ? -1 : lastDataType.nofBits();
    }

    public static final boolean hasSign(IRfAssociatedType element) {
        if (element == null) {
            return true;
        }
        IRfNamedElement resolvedAssocType = element.getAssociatedType();
        if (resolvedAssocType instanceof RfEnumType) {
            return true;
        }
        DataType lastDataType = element.getDataType();
        int i = 0;
        while (i < 20) {
            if (resolvedAssocType instanceof RfEnumType) {
                return true;
            }
            if (!(resolvedAssocType instanceof RfTypeAlias)) break;
            lastDataType = ((RfTypeAlias)resolvedAssocType).getDataType();
            resolvedAssocType = ((RfTypeAlias)resolvedAssocType).getAssociatedType();
            ++i;
        }
        return lastDataType == null || lastDataType.hasSign();
    }

    public static final IntDomain toIntDomain(IRfAssociatedType element, IntDomain fullDomain) {
        if (element == null) {
            return fullDomain;
        }
        IRfNamedElement resolvedAssocType = element.getAssociatedType();
        DataType lastDataType = element.getDataType();
        ArrayList<DataType> aliasesDataType = new ArrayList<DataType>();
        int i = 0;
        while (i < 20) {
            aliasesDataType.add(lastDataType);
            if (resolvedAssocType instanceof RfEnumType || !(resolvedAssocType instanceof RfTypeAlias)) break;
            lastDataType = ((RfTypeAlias)resolvedAssocType).getDataType();
            resolvedAssocType = ((RfTypeAlias)resolvedAssocType).getAssociatedType();
            ++i;
        }
        Collections.reverse(aliasesDataType);
        IntDomain domain = fullDomain;
        for (DataType dataType : aliasesDataType) {
            IntDomain tempDomain = dataType.toIntDomain(domain);
            domain = (IntDomain)domain.intersect((IDomain)tempDomain);
        }
        if (resolvedAssocType instanceof RfEnumType) {
            BigInteger[] values = ((RfEnumType)resolvedAssocType).getEnumValues();
            domain = (IntDomain)domain.intersect((IDomain)new IntDomain(values));
        }
        return domain;
    }

    public static RfScopeDefElement getLexicalScope(RfDefElement lexicalScope) {
        if (lexicalScope == null) {
            return null;
        }
        return lexicalScope.getLexicalScope(RfScopeDefElement.class);
    }

    public static void checkIllegalCast(RfProject project, AST castAST, RfNamedElement castElement, AST expAST, RfNamedElement exprElement, ParserPath parserPath) {
        String castTypeName;
        String exprTypeName;
        LineInfo lineInfo;
        if (!SemanticUtils.valid(castElement) || !SemanticUtils.valid(exprElement)) {
            return;
        }
        if (!(castElement instanceof IRfAssociatedType)) {
            return;
        }
        if (!(exprElement instanceof IRfAssociatedType)) {
            return;
        }
        IRfNamedElement castType = ((IRfAssociatedType)((Object)castElement)).getAssociatedType();
        IRfNamedElement expType = ((IRfAssociatedType)((Object)exprElement)).getAssociatedType();
        if ((castType = SemanticUtils.unwrap((RfNamedElement)castType, false, true)) instanceof RfStruct ^ (expType = SemanticUtils.unwrap((RfNamedElement)expType, false, true)) instanceof RfStruct) {
            lineInfo = SemanticUtils.getTreeLineInfo(expAST);
            exprTypeName = SemanticUtils.getAssociatedTypeName((IRfAssociatedType)((Object)exprElement));
            castTypeName = SemanticUtils.getAssociatedTypeName((IRfAssociatedType)((Object)castElement));
            project.addSemanticError(1, "ILLEGAL_CAST_EXPRESSION: Cannot cast expression of type ''{0}'' to type ''{1}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, exprTypeName, castTypeName);
        }
        if (castType instanceof RfCollectionType ^ expType instanceof RfCollectionType) {
            lineInfo = SemanticUtils.getTreeLineInfo(expAST);
            exprTypeName = SemanticUtils.getAssociatedTypeName((IRfAssociatedType)((Object)exprElement));
            castTypeName = SemanticUtils.getAssociatedTypeName((IRfAssociatedType)((Object)castElement));
            project.addSemanticError(1, "ILLEGAL_CAST_EXPRESSION: Cannot cast expression of type ''{0}'' to type ''{1}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, exprTypeName, castTypeName);
        }
    }

    public static String unqualifiedName(String name) {
        if (name == null) {
            return name;
        }
        int start = name.indexOf("<");
        int end = name.lastIndexOf(">");
        if (start <= 0 || end < start) {
            return name;
        }
        if (!name.substring(start, end).contains("::")) {
            return name;
        }
        return DVTStringUtil.appendString((Object[])new Object[]{name.substring(0, start), DVTStringUtil.replaceAll((Pattern)UNQUALIFY_PARAMS_PATTERN, (CharSequence)name.substring(start, end), (String)""), name.substring(end)});
    }

    public static String getStructName(RfNamedElement enclosingScope) {
        if (enclosingScope instanceof RfTemplateInstance) {
            return ((RfTemplateInstance)enclosingScope).getTemplateStruct().getName();
        }
        return enclosingScope.getName();
    }

    public static class Identifier {
        private AST id;
        private int nofSelects;

        public Identifier(AST id, int nofSelects) {
            this.id = id;
            this.nofSelects = nofSelects;
        }
    }

    public static enum StaticRefElementKind {
        TYPE,
        FIELD,
        METHOD;

    }

    static class UsageBeforeDefFilter
    implements IRfElementFilter {
        private int usageIndex;
        private int usageOffset;
        private IRfNamedElement importElement;

        public UsageBeforeDefFilter(int fileIndex, int offset) {
            this.usageIndex = fileIndex;
            this.usageOffset = offset;
        }

        public boolean validImport(IRfNamedElement importedElement) {
            return this.validElement(importedElement);
        }

        public void setImportLayer(IRfNamedElement importElement) {
            if (this.importElement == null) {
                this.importElement = importElement;
            }
        }

        public boolean validElement(IRfNamedElement candidate) {
            if (candidate.isPredefined()) {
                return true;
            }
            if (this.usageIndex <= 0) {
                return true;
            }
            IRfDefElement declaration = candidate.getDeclaration();
            if (declaration == null) {
                if (candidate instanceof RfTemplateParam) {
                    return true;
                }
                return this.usageOffset < 0;
            }
            RfFileDef fileDef = (RfFileDef)declaration.getDefFile();
            if (fileDef == null) {
                return this.usageOffset < 0;
            }
            int declarationIndex = fileDef.getIndex();
            if (declarationIndex > this.usageIndex) {
                return false;
            }
            if (declarationIndex < this.usageIndex) {
                return true;
            }
            if (this.usageOffset < 0) {
                return true;
            }
            int declarationOffset = declaration.getStartOffset();
            return declarationOffset < this.usageOffset;
        }

        public boolean allowEnumElement() {
            return true;
        }

        public int resultMaxSize() {
            return 1;
        }
    }
}

