/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.util;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.StructKind;

public class RfEnclosingScopeUtils {
    public static String getScopeInfo(IProject project, ParserPath parserPath, int offset) {
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return null;
        }
        RfDefElement scope = fileDef.getScope(offset);
        RfNamedElement namedElement = scope.getNamedElement();
        while (namedElement != null && (!(namedElement instanceof RfMembersContainer) || namedElement.isAnonymous())) {
            namedElement = namedElement.getEnclosingScope();
        }
        if (namedElement != null) {
            String text = namedElement.getName();
            if (text == null) {
                return null;
            }
            String kindName = namedElement.getKindName();
            while (namedElement instanceof RfStruct && ((RfStruct)namedElement).getStructKind() != StructKind.COMPONENT) {
                namedElement = namedElement.getEnclosingScope();
                text = DVTStringUtil.appendString((Object[])new Object[]{namedElement.getName(), "::", text});
            }
            if (kindName != null && !kindName.isEmpty()) {
                text = DVTStringUtil.appendString((Object[])new Object[]{kindName, ": ", text});
            }
            return DVTStringUtil.appendString((Object[])new Object[]{" [", text, "]"});
        }
        return null;
    }

    public static IRfDefElement getScope(IProject project, ParserPath parserPath, int offset) {
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return null;
        }
        RfDefElement scope = fileDef.getScope(offset);
        if (scope == null) {
            return null;
        }
        RfNamedElement namedElement = scope.getNamedElement();
        while (namedElement != null && (!(namedElement instanceof RfMembersContainer) || namedElement.isAnonymous())) {
            namedElement = namedElement.getEnclosingScope();
        }
        return namedElement == null ? null : namedElement.getDeclaration();
    }
}

