/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.util;

import java.util.IdentityHashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

public class VisitedCheck {
    public static final int LOCAL = 1;
    public static final int IMPORT = 2;
    public static final int ENCLOSING = 4;
    public static final int FULL = 7;
    private Map<IRfNamedElement, Integer> visited = new IdentityHashMap<IRfNamedElement, Integer>();

    public void visit(IRfNamedElement element, int kind) {
        int existingKind = this.visited.getOrDefault(element, kind);
        this.visited.put(element, existingKind | kind);
    }

    public boolean isVisited(IRfNamedElement element, int kind) {
        int existingKind = this.visited.getOrDefault(element, 0);
        return (existingKind & kind) == kind;
    }

    public void remove(IRfNamedElement element, int kind) {
        int existingKind = this.visited.getOrDefault(element, 0);
        if ((existingKind & kind) == kind) {
            this.visited.put(element, existingKind - kind);
        }
    }

    public void clear() {
        this.visited.clear();
    }
}

