/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IOutlineTreeViewProvider;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.views.PSSLabelProvider;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.parser.EAST;

public class OutlineTreeViewProvider
extends PSSLabelProvider
implements ITreeContentProvider,
IOutlineTreeViewProvider {
    private static final Pattern p = Pattern.compile("\\R");

    public Object[] getElements(Object wrapper) {
        List elements;
        if (wrapper == null) {
            return new Object[0];
        }
        if (wrapper instanceof IDVTElementWrapper && (elements = ((IDVTElementWrapper)wrapper).getChildren()) != null) {
            return elements.toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object wrapper) {
        List elements;
        if (wrapper == null) {
            return null;
        }
        if (wrapper instanceof IDVTElementWrapper && (elements = ((IDVTElementWrapper)wrapper).getChildren()) != null) {
            return elements.toArray();
        }
        return null;
    }

    public Object getParent(Object wrapper) {
        return null;
    }

    public boolean hasChildren(Object wrapper) {
        if (wrapper == null) {
            return false;
        }
        return ((IDVTElementWrapper)wrapper).getChildren() != null;
    }

    public Image getImage(Object wrapper) {
        Object element = null;
        if (wrapper instanceof IDVTElementWrapper) {
            element = ((IDVTElementWrapper)wrapper).getRfElement();
        } else if (wrapper instanceof TreePath) {
            element = ((TreePath)wrapper).getElement();
        }
        Image result = null;
        if (element instanceof IDVTElementWrapper || element instanceof EAST) {
            return this.getASTImage(wrapper);
        }
        if (element instanceof RfNamedElement) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (element instanceof String) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!(element instanceof IRfDefElement)) {
            return null;
        }
        IRfNamedElement namedElement = ((IRfDefElement)element).getNamedElement();
        result = namedElement != null ? (element instanceof RfDefElement && !((RfDefElement)element).isIs() ? (namedElement instanceof RfStruct ? ((RfStruct)namedElement).getExtendImage() : (namedElement instanceof RfEnumType ? ((RfEnumType)namedElement).getExtendImage() : namedElement.getImage())) : namedElement.getImage()) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
        if (wrapper instanceof RfTreeElementWrapper && !((RfTreeElementWrapper)((Object)wrapper)).getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    public String getText(Object object) {
        String result = this.internalGetText(object);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String internalGetText(Object wrapper) {
        Object element = null;
        if (wrapper instanceof IDVTElementWrapper) {
            element = ((IDVTElementWrapper)wrapper).getRfElement();
        } else if (wrapper instanceof TreePath) {
            element = ((TreePath)wrapper).getElement();
        }
        if (element instanceof IDVTElementWrapper || element instanceof EAST) {
            return this.getASTText(wrapper);
        }
        if (element instanceof IRfNamedElement) {
            return ((IRfNamedElement)element).getName();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (!(element instanceof IRfDefElement)) {
            return null;
        }
        IRfNamedElement namedElement = ((IRfDefElement)element).getNamedElement();
        String result = namedElement.getName();
        return result;
    }

    public Image getImageByFieldName(String fieldName) {
        try {
            ImageDescriptor descriptor = (ImageDescriptor)DVTImages.class.getDeclaredField(fieldName).get(null);
            return DVTImages.imageCache.getImage(descriptor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private String getASTText(Object o) {
        String[] tokenNames;
        String signature;
        IDVTElementWrapper wrapper = null;
        if (o instanceof IDVTElementWrapper) {
            wrapper = (IDVTElementWrapper)o;
        } else if (o instanceof TreePath) {
            wrapper = (IDVTElementWrapper)((TreePath)o).getElement();
        }
        if (wrapper == null) {
            return null;
        }
        EAST east = (EAST)((Object)wrapper.getRfElement());
        if (east == null || east.getText() == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder(east.getText());
        if (east.transientResult instanceof IRfNamedElement && (signature = ((RfNamedElement)east.transientResult).getSignature()) != null) {
            result.append(" : ").append(DVTStringUtil.replaceAll((Pattern)p, (CharSequence)signature, (String)" "));
        }
        if ((tokenNames = EAST.getTokenNames()) == null) {
            return "[not initialized]";
        }
        result.append(" <").append(tokenNames[east.getType()]).append(">");
        return result.toString();
    }

    private Image getASTImage(Object o) {
        IDVTElementWrapper wrapper = null;
        if (o instanceof IDVTElementWrapper) {
            wrapper = (IDVTElementWrapper)o;
        } else if (o instanceof TreePath) {
            wrapper = (IDVTElementWrapper)((TreePath)o).getElement();
        }
        if (wrapper == null) {
            return null;
        }
        if (wrapper.getChildren() != null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }
}

