/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.compileorder.BaseCompileOrderViewContributor;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.pssdt.model.reflection.RfDummyElement;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.views.CompileOrderViewLabelProvider;
import ro.amiq.pssdt.model.reflection.views.PSSCompileOrderViewLabelProvider;
import ro.amiq.pssdt.model.reflection.views.PSSLanguageElement;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.utils.PSSFileUtils;

public class PSSCompileOrderViewContributor
extends BaseCompileOrderViewContributor {
    private CompileOrderViewLabelProvider fLabelProvider = new PSSCompileOrderViewLabelProvider();

    private void toWrappers(RfTreeElementWrapper root, Collection<RfFileDef> files, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        try {
            if (root == null || files == null || configurator == null || configurator.isCanceled()) {
                return;
            }
            boolean ignoreContentFilters = configurator.ignoreContentFilters();
            for (RfFileDef instance : files) {
                if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                    return;
                }
                String name = instance.getName();
                if (name.startsWith("__pss__")) continue;
                RfTreeElementWrapper child = new RfTreeElementWrapper(instance);
                child.setProject(configurator.getProject());
                String text = this.getLabelProvider((Object)child).getText((Object)child);
                DVTGUIFilterMatcher.ITextProvider textProvider = () -> text;
                if (!ignoreContentFilters && DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)configurator.getProject(), (IRfFileDef)instance, (DVTGUIFilterMatcher.ITextProvider)textProvider) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (!input.hasSearchedElementFiltered() && ViewsUtils.matchesPath((Object)((Object)child), (IRfFilterableTreeAccessor)configurator.getView())) {
                        input.setHasSearchedElementFiltered(true);
                    }
                    input.setHasGUIFilteredElements(true);
                    continue;
                }
                if (!this.shouldAddFile((ISymbolCollectorPrerequisite)child, configurator)) continue;
                root.addChild(child);
                input.incrementElementCount();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void countElements(IDVTElementWrapper root, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        if (root == null) {
            return;
        }
        if (root.getRfElement() instanceof RfFileDef && root.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            input.incrementNotFilteredElementCount();
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            if (configurator.isCanceled()) {
                return;
            }
            this.countElements(child, configurator, input);
        }
    }

    private void filterOutElementsWithoutErrors(RfTreeElementWrapper root, RfTreeElementWrapper newRoot, CompileOrderViewInputConfigurator configurator) {
        List<RfTreeElementWrapper> children = root.getChildren();
        RfFileDef rfElement = (RfFileDef)root.getRfElement();
        boolean hasErrors = false;
        if (rfElement != null) {
            hasErrors = Utils.hasErrors((IProject)configurator.getProject(), (String)DVTFileUtils.getInstance().parser2resource(configurator.getProject(), rfElement.getParserPath()), (LanguageKind)LanguageKind.PSS);
        }
        if (children == null || children.isEmpty()) {
            if (hasErrors) {
                newRoot.addChild(root);
            }
            return;
        }
        Iterator<RfTreeElementWrapper> iterator = children.iterator();
        while (iterator.hasNext()) {
            if (configurator.isCanceled()) {
                return;
            }
            RfTreeElementWrapper child = iterator.next();
            this.filterOutElementsWithoutErrors(child, newRoot, configurator);
            iterator.remove();
        }
        if (hasErrors) {
            newRoot.addChild(root);
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : namedElement.getComment();
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        Object rfElement = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)rfElement;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (element == null || !(element instanceof RfFileDef)) {
                return;
            }
            RfFileDef instance = (RfFileDef)element;
            IFile file = (IFile)instance.getAdapter(IResource.class);
            if (file != null) {
                PSSFileUtils.getInstance().openEditor(file, 0, null);
            } else if (instance.getParserPath() != null) {
                PSSFileUtils.getInstance().openFile(project, instance.getParserPath().path, 0, null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public CompileOrderViewInput getInput(CompileOrderViewInputConfigurator configurator) {
        try {
            CompileOrderViewInput input = CompileOrderViewInput.emptyInput();
            IProject project = configurator.getProject();
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.pssdt.pssnature")) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
                return input;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return input;
            }
            Collection<RfFileDef> files = rfProject.getFiles();
            RfTreeElementWrapper root = new RfTreeElementWrapper();
            if (files == null || files.size() - 1 <= 0) {
                return input;
            }
            this.toWrappers(root, files, configurator, input);
            ViewsUtils.hierarchicalSearch((IDVTElementWrapper)root, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)configurator.getUpdateJob(), (StringMatcher[])configurator.getSearchSegments(), (boolean[])configurator.getSearchStrictness());
            if (configurator.hasShowFilesWithErrors()) {
                RfTreeElementWrapper newRoot = new RfTreeElementWrapper();
                this.filterOutElementsWithoutErrors(root, newRoot, configurator);
                List<RfTreeElementWrapper> children = newRoot.getChildren();
                if (children != null) {
                    children.stream().forEach(e -> e.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true));
                    Collections.sort(children, (o1, o2) -> ((RfFileDef)o1.getRfElement()).getIndex() - ((RfFileDef)o2.getRfElement()).getIndex());
                } else {
                    newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement(project.getName())));
                    newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement("does not contain")));
                    newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement("any PSS files with errors!")));
                }
                root = newRoot;
            }
            if (configurator.hasShowFilesWithErrors() || configurator.getSearchSegments() != null && configurator.getSearchSegments().length != 0) {
                this.countElements(root, configurator, input);
            } else {
                input.setNotFilteredElementCount(input.getElementCount());
            }
            int elementCount = input.getElementCount();
            int notFilteredElementCount = input.getNotFilteredElementCount();
            input.setTableInfo("[" + (elementCount != notFilteredElementCount ? String.valueOf(notFilteredElementCount) + "/" + elementCount : Integer.valueOf(elementCount)) + ViewsUtils.getUnitName((String)"file", (int)elementCount, (String)" ", (String)"") + "]");
            if (elementCount == 0 || root.getChildren() != null && root.getChildren().isEmpty()) {
                return input;
            }
            List elements = input.getElements();
            if (configurator.isShowLanguageNameAsRootElement()) {
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new PSSLanguageElement<String>(String.valueOf(LanguageKind.PSS.VIEW_NAME) + " " + input.getTableInfo()));
                elements.add(languageWrapper);
                if (root.getChildren() != null) {
                    languageWrapper.addChildren(root.getChildren());
                }
            } else if (root.getChildren() != null) {
                elements.addAll(root.getChildren());
            }
            return input;
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
            return CompileOrderViewInput.emptyInput();
        }
    }

    public void gotoInclude(IProject project, IDVTElementWrapper wrapper) {
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof PSSLanguageElement) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
    }

    public String getShortFileName(IDVTElementWrapper element) {
        RfNamedElement namedElement = this.getNamedElement(element);
        if (namedElement != null) {
            return namedElement.getName();
        }
        return "";
    }

    public boolean canShowGotoIncludeMenu(IDVTElementWrapper element) {
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public InspectViewInput getInspectContent(IDVTElementWrapper wrapper) {
        IFile file;
        block7: {
            Object element;
            block6: {
                block5: {
                    try {
                        if (wrapper instanceof RfTreeElementWrapper) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                element = wrapper.getRfElement();
                if (element != null && element instanceof RfFileDef) break block6;
                return null;
            }
            RfFileDef instance = (RfFileDef)element;
            file = (IFile)instance.getAdapter(IResource.class);
            if (file != null) break block7;
            return null;
        }
        return DVTInspectViewUtils.getInstance().processFile(file);
    }

    public void gotoImport(IProject project, IDVTElementWrapper wrapper) {
    }

    public boolean canShowGotoImportMenu(IDVTElementWrapper element) {
        return false;
    }
}

