/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.coverage.CoverageViewInput;
import ro.amiq.dvt.ui.views.coverage.CoverageViewInputConfigurator;
import ro.amiq.dvt.ui.views.coverage.ICoverageViewContributor;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.views.CoverageViewLabelProvider;
import ro.amiq.pssdt.model.reflection.views.PSSLanguageElement;
import ro.amiq.pssdt.model.reflection.views.PSSQuickViewersUtil;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class PSSCoverageViewContributor
implements ICoverageViewContributor {
    private CoverageViewLabelProvider fLabelProvider = new CoverageViewLabelProvider();
    private int fNrTotalCoverGroups;
    private int fNrNotFilteredCoverGroups;
    private int fNrTotalCoverItems;
    private int fNrNotFilteredCoverItems;
    private boolean fHasGUIFilteredElements;

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        Object rfElement = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)rfElement;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (object == null || !(object instanceof RfNamedElement)) {
                return;
            }
            RfNamedElement element = (RfNamedElement)object;
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(element, project, null, null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public CoverageViewInput getInput(CoverageViewInputConfigurator inputSourceConfigurator) {
        this.fNrTotalCoverGroups = 0;
        this.fNrNotFilteredCoverGroups = 0;
        this.fNrTotalCoverItems = 0;
        this.fNrNotFilteredCoverItems = 0;
        this.fHasGUIFilteredElements = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!(inputSourceConfigurator.getSource() instanceof IProject)) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            IProject project = (IProject)inputSourceConfigurator.getSource();
            if (!project.isAccessible() || !project.hasNature("ro.amiq.pssdt.pssnature")) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            List<IDVTElementWrapper> wrappers = this.toWrappers(rfProject, inputSourceConfigurator.getSearchSegments(), inputSourceConfigurator.getSearchStrictness(), inputSourceConfigurator.getUpdateJob());
            if (wrappers == null || wrappers.isEmpty()) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            this.internalSort(wrappers, inputSourceConfigurator.isSortByType());
            if (inputSourceConfigurator.isShowLanguageNameAsRootElement()) {
                StringBuilder infoText = new StringBuilder("[");
                if (this.fNrTotalCoverGroups == this.fNrNotFilteredCoverGroups) {
                    infoText.append(this.fNrTotalCoverGroups);
                } else {
                    infoText.append(this.fNrNotFilteredCoverGroups).append("/").append(this.fNrTotalCoverGroups);
                }
                infoText.append(ViewsUtils.getUnitName((String)"cover group", (int)this.fNrTotalCoverGroups, (String)" ", (String)"")).append("][");
                if (this.fNrTotalCoverItems == this.fNrNotFilteredCoverItems) {
                    infoText.append(this.fNrTotalCoverItems);
                } else {
                    infoText.append(this.fNrNotFilteredCoverItems).append("/").append(this.fNrTotalCoverItems);
                }
                infoText.append(ViewsUtils.getUnitName((String)"cover item", (int)this.fNrTotalCoverItems, (String)" ", (String)"")).append("]");
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new PSSLanguageElement<String>(String.valueOf(LanguageKind.PSS.VIEW_NAME) + " " + infoText.toString()));
                elements.add(languageWrapper);
                languageWrapper.addChildren(wrappers);
            } else {
                elements.addAll(wrappers);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
    }

    private List<IDVTElementWrapper> toWrappers(RfProject rfProject, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        IDVTElementWrapper root = this.toWrappersRecursive(rfProject, rfProject, searchSegments, searchStrictness, updateJob);
        if (root == null || !root.hasChildren()) {
            return null;
        }
        RfTreeElementWrapper noLibsRoot = new RfTreeElementWrapper("");
        for (IDVTElementWrapper wrapper : root.getChildren()) {
            if (wrapper.getRfElement() instanceof RfLibrary) {
                noLibsRoot.addChildren(wrapper.getChildren());
                continue;
            }
            noLibsRoot.addChild(wrapper);
        }
        this.countCoverGorupsAndItems(noLibsRoot, true);
        ViewsUtils.hierarchicalSearch((IDVTElementWrapper)noLibsRoot, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness);
        this.countCoverGorupsAndItems(noLibsRoot, false);
        return noLibsRoot.getChildren();
    }

    private IDVTElementWrapper toWrappersRecursive(RfProject rfProject, RfNamedElement root, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        List<RfNamedElement> children;
        List<RfNamedElement> members;
        RfCovergroup covergroup;
        RfNamedElement enclosingScope;
        if (root instanceof RfCovergroup && !root.isAnonymous()) {
            RfCovergroup covergroup2 = (RfCovergroup)root;
            RfTreeElementWrapper cgWrapper = new RfTreeElementWrapper(covergroup2);
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)covergroup2, () -> this.fLabelProvider.getText((Object)cgWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                this.fHasGUIFilteredElements = true;
                return null;
            }
            List<RfNamedElement> blocks = covergroup2.getLocalMembers(RfPackage.ANY_DETERMINANT, Collections.singleton(RfBlock.class));
            if (blocks != null && !blocks.isEmpty()) {
                for (RfNamedElement block : blocks) {
                    if (block == null) continue;
                    if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)block, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(block))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    List<RfNamedElement> fields = block.getLocalMembers(RfPackage.ANY_DETERMINANT, Collections.singleton(RfField.class));
                    if (fields == null || fields.isEmpty()) continue;
                    for (RfNamedElement field : fields) {
                        if (field instanceof RfField && (((RfField)field).isCovercross() || ((RfField)field).isCoverpoint()) && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)field, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(field))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                            this.fHasGUIFilteredElements = true;
                            continue;
                        }
                        cgWrapper.addChild(new RfTreeElementWrapper(field));
                    }
                }
            }
            return cgWrapper;
        }
        if (root instanceof RfCovergroup && root.isAnonymous() && (enclosingScope = (covergroup = (RfCovergroup)root).getEnclosingScope()) != null && (members = enclosingScope.getLocalMembers(null, Collections.singleton(RfField.class))) != null && !members.isEmpty()) {
            for (RfNamedElement member : members) {
                if (!(member instanceof RfField) || ((RfField)member).getFieldModifier() != FieldModifier.COVERGROUP_INLINE || ((RfField)member).getAssociatedType() != covergroup) continue;
                RfTreeElementWrapper cgWrapper = new RfTreeElementWrapper(member);
                if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)covergroup, () -> this.fLabelProvider.getText((Object)cgWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    this.fHasGUIFilteredElements = true;
                    continue;
                }
                List<RfNamedElement> blocks = covergroup.getLocalMembers(RfPackage.ANY_DETERMINANT, Collections.singleton(RfBlock.class));
                if (blocks != null && !blocks.isEmpty()) {
                    for (RfNamedElement block : blocks) {
                        if (block == null) continue;
                        if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)block, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(block))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                            this.fHasGUIFilteredElements = true;
                            continue;
                        }
                        List<RfNamedElement> fields = block.getLocalMembers(RfPackage.ANY_DETERMINANT, Collections.singleton(RfField.class));
                        if (fields == null || fields.isEmpty()) continue;
                        for (RfNamedElement field : fields) {
                            if (!(field instanceof RfField) || !((RfField)field).isCovercross() && !((RfField)field).isCoverpoint()) continue;
                            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)field, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(field))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                                this.fHasGUIFilteredElements = true;
                                continue;
                            }
                            cgWrapper.addChild(new RfTreeElementWrapper(field));
                        }
                    }
                }
                return cgWrapper;
            }
        }
        if ((children = this.getChildTypesAndCoverGroupContainersAndCoverGroup(rfProject, root)).isEmpty()) {
            return null;
        }
        RfTreeElementWrapper myWrapper = new RfTreeElementWrapper(root);
        ArrayList<IDVTElementWrapper> myChildren = new ArrayList<IDVTElementWrapper>();
        for (RfNamedElement child : children) {
            IDVTElementWrapper childWrapper = this.toWrappersRecursive(rfProject, child, searchSegments, searchStrictness, updateJob);
            if (childWrapper == null) continue;
            myChildren.add(childWrapper);
        }
        if (myChildren.isEmpty()) {
            return null;
        }
        if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)root, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(root))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            this.fHasGUIFilteredElements = true;
            return null;
        }
        myWrapper.addChildren(myChildren);
        return myWrapper;
    }

    private List<RfNamedElement> getChildTypesAndCoverGroupContainersAndCoverGroup(RfProject rfProject, RfNamedElement root) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (rfProject == null || rfProject.getProject() == null) {
            return result;
        }
        boolean hideDuplicates = BuildConfigManager.isHideDuplicateTypesView((IProject)rfProject.getProject());
        Collection<? extends RfNamedElement> localTypes = rfProject.getLocalTypes(root, false, hideDuplicates);
        if (localTypes != null) {
            result.addAll(localTypes);
        }
        return result;
    }

    private void countCoverGorupsAndItems(IDVTElementWrapper root, boolean total) {
        if (root == null) {
            return;
        }
        if (this.isCovergroup(root.getRfElement())) {
            if (total) {
                ++this.fNrTotalCoverGroups;
            } else {
                ++this.fNrNotFilteredCoverGroups;
            }
            if (root.hasChildren()) {
                if (total) {
                    this.fNrTotalCoverItems += root.getChildren().size();
                } else {
                    this.fNrNotFilteredCoverItems += root.getChildren().size();
                }
            }
            return;
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            this.countCoverGorupsAndItems(child, total);
        }
    }

    private boolean isCovergroup(Object element) {
        if (element instanceof RfCovergroup) {
            return true;
        }
        return element instanceof RfField && ((RfField)element).getFieldModifier() == FieldModifier.COVERGROUP_INLINE;
    }

    private void internalSort(List<IDVTElementWrapper> wrappers, boolean sortByType) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        if (sortByType) {
            Collections.sort(wrappers, PSSQuickViewersUtil.getSortByTypeComparator((LabelProvider)this.fLabelProvider));
        } else {
            Collections.sort(wrappers, PSSQuickViewersUtil.getSortByNameComparator((LabelProvider)this.fLabelProvider));
        }
        for (IDVTElementWrapper wrapper : wrappers) {
            this.internalSort(wrapper.getChildren(), sortByType);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfCovergroup || rfElement instanceof RfField) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element)) || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getColumnText(element, 1));
        }
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }
}

