/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.BaseInspectViewContributor;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.FileCompileInfo;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.parser.PSSFileInstance;
import ro.amiq.pssdt.parser.PSSFileInstancesMap;
import ro.amiq.pssdt.ui.editor.PSSDocumentSetupParticipant;
import ro.amiq.pssdt.ui.editor.PSSEditor;
import ro.amiq.pssdt.ui.editor.PSSSourceViewerConfiguration;

public class PSSInspectViewContributor
extends BaseInspectViewContributor {
    private static final String ATOMIC_ACTION_MESSAGE = "// Selection contains an atomic action." + System.lineSeparator();
    private static final PSSDocumentSetupParticipant PSS_DOCUMENT_SETUP_PARTICIPANT = new PSSDocumentSetupParticipant();
    private static final HashSet<Character> possibleCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('\''), Character.valueOf('.'), Character.valueOf('B'), Character.valueOf('S'), Character.valueOf('X'), Character.valueOf('O'), Character.valueOf('D'), Character.valueOf('U'), Character.valueOf('\"'), Character.valueOf('_'), Character.valueOf('\''), Character.valueOf('#')));

    public void updatePreviewer(DVTPreviewSourceViewer previewViewer, final IHyperlinkDetector hyperlinkDetector, boolean disableHighlight) {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(() -> {
            PSSSourceViewerConfiguration configuration = new PSSSourceViewerConfiguration(null){

                @Override
                public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
                    return new IHyperlinkDetector[]{hyperlinkDetector};
                }

                protected boolean isInspectView() {
                    return true;
                }

                public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
                    return 0;
                }
            };
            previewViewer.unconfigure();
            previewViewer.setEditable(false);
            previewViewer.setPreferenceStore(PSSPlugin.getDefault().getCombinedPreferenceStore());
            previewViewer.configure((SourceViewerConfiguration)configuration);
            previewViewer.setDocument((IDocument)new Document());
            if (!disableHighlight) {
                PSS_DOCUMENT_SETUP_PARTICIPANT.setup(previewViewer.getDocument());
            }
        });
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursorOffset) {
        IDocument document;
        RfProject rfProject;
        IProject project;
        IFile file;
        block15: {
            IDocumentProvider documentProvider;
            IEditorInput editorInput;
            block14: {
                PSSEditor pssEditor;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    try {
                                        if (editor instanceof PSSEditor) break block9;
                                        return null;
                                    }
                                    catch (Exception e) {
                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                        return null;
                                    }
                                }
                                pssEditor = (PSSEditor)editor;
                                editorInput = pssEditor.getEditorInput();
                                if (editorInput != null) break block10;
                                return null;
                            }
                            file = (IFile)editorInput.getAdapter(IFile.class);
                            if (file != null) break block11;
                            return null;
                        }
                        project = file.getProject();
                        if (project != null) break block12;
                        return null;
                    }
                    rfProject = RfManager.getInstance().getRfProject(project);
                    if (rfProject != null) break block13;
                    return null;
                }
                documentProvider = pssEditor.getDocumentProvider();
                if (documentProvider != null) break block14;
                return null;
            }
            document = documentProvider.getDocument((Object)editorInput);
            if (document != null) break block15;
            return null;
        }
        cursorOffset = cursorOffset >= document.getLength() ? document.getLength() - 1 : cursorOffset;
        List<Object> object = Arrays.asList(file, rfProject, document);
        return new InspectViewUpdateEvent(object, LanguageKind.PSS, cursorOffset, null, project, InspectViewUpdateEventCommon.TYPE.PRELIMINARY_EDITOR);
    }

    public InspectViewUpdateEvent createEventFromPreliminary(InspectViewUpdateEvent preliminaryEvent) {
        IDocument document;
        RfProject rfProject;
        IFile file;
        int cursorOffset;
        block8: {
            Object preliminaryEventElement;
            block7: {
                try {
                    preliminaryEventElement = preliminaryEvent.getElement();
                    if (preliminaryEventElement instanceof List) break block7;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            List preliminaryData = (List)preliminaryEventElement;
            cursorOffset = preliminaryEvent.getCallOffset();
            file = (IFile)preliminaryData.get(0);
            rfProject = (RfProject)preliminaryData.get(1);
            document = (IDocument)preliminaryData.get(2);
            if (file != null && rfProject != null && document != null) break block8;
            return null;
        }
        IRfNamedElement element = null;
        RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(file, document, cursorOffset);
        if (elementAndScope == null || elementAndScope.getIRfNamedElement() == null) {
            String number = this.findNumberAtOffset(cursorOffset, document);
            RfFileDef defFile = rfProject.getFile((IResource)file);
            if (number != null && defFile != null) {
                number = number.replace("_", "");
                return new InspectViewUpdateEvent((Object)number, LanguageKind.PSS, cursorOffset, defFile.getParserPath().path, file.getProject(), InspectViewUpdateEventCommon.TYPE.NUMBER);
            }
        } else {
            element = elementAndScope.getIRfNamedElement();
        }
        InspectViewUpdateEvent returnEvent = null;
        returnEvent = element == null ? new InspectViewUpdateEvent(file, InspectViewUpdateEventCommon.TYPE.FILE) : new InspectViewUpdateEvent((Object)element, element.getLanguageKind(), cursorOffset, null, rfProject.getProject(), InspectViewUpdateEventCommon.TYPE.EDITOR);
        return returnEvent;
    }

    /*
     * Unable to fully structure code
     */
    private String findNumberAtOffset(int cursorOffset, IDocument document) throws BadLocationException {
        numberAtOffset = new StringBuilder();
        if (cursorOffset >= 0 && cursorOffset < document.getLength()) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            --cursorOffset;
lbl5:
            // 2 sources

            ** while (cursorOffset >= 0 && (document.getChar((int)cursorOffset) == '\n' || document.getChar((int)cursorOffset) == '\t' || document.getChar((int)cursorOffset) == ' '))
        }
lbl6:
        // 1 sources

        if (cursorOffset < 0) {
            return null;
        }
        endPosition = cursorOffset;
        start = '\u0000';
        end = '\u0000';
        for (startingPosition = cursorOffset; startingPosition >= 0; --startingPosition) {
            start = TextUtils.getChar((IDocument)document, (int)startingPosition);
            document.getChar(startingPosition);
            if (PSSInspectViewContributor.possibleCharacters.contains(Character.valueOf(start))) continue;
        }
        while (endPosition < document.getLength()) {
            end = document.getChar(endPosition);
            ++endPosition;
            if (PSSInspectViewContributor.possibleCharacters.contains(Character.valueOf(end))) continue;
        }
        index = startingPosition + 2;
        while (index <= endPosition - 2) {
            temp = document.getChar(index);
            numberAtOffset.append(temp);
            ++index;
        }
        return numberAtOffset.length() > 0 ? numberAtOffset.toString() : null;
    }

    public InspectViewInput getInput(InspectViewUpdateEvent event) {
        InspectViewInput result;
        block10: {
            IProject iProject;
            block9: {
                block8: {
                    block7: {
                        result = null;
                        if (event.getLanguage().equals((Object)LanguageKind.PSS)) break block7;
                        return null;
                    }
                    iProject = event.getProject();
                    if (iProject != null && iProject.isAccessible() && iProject.hasNature("ro.amiq.pssdt.pssnature")) break block8;
                    return null;
                }
                if (DVTPlugin.getDefault().collect().c(iProject, "F707373")) break block9;
                return null;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(iProject);
            if (rfProject != null) break block10;
            return null;
        }
        try {
            result = this.getInspectContent(event);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        Object element = event.getElement();
        if (element instanceof String) {
            result = new InspectViewInput(element.toString());
        }
        return result;
    }

    private InspectViewInput getInspectContent(InspectViewUpdateEvent event) {
        if (event.hasInfos()) {
            return this.getInspectFromDiagram(event);
        }
        IProject project = event.getProject();
        Object selectedElement = event.getElement();
        if (event.getType() == InspectViewUpdateEventCommon.TYPE.WRAPPER && selectedElement instanceof IDVTElementWrapper) {
            selectedElement = ((IDVTElementWrapper)selectedElement).getRfElement();
        }
        if (selectedElement instanceof IRfNamedElement) {
            IRfNamedElement element = (IRfNamedElement)selectedElement;
            return PSSInspectViewContributor.processNamedElement(project, element);
        }
        if (selectedElement instanceof IRfDefElement) {
            IRfDefElement def = (IRfDefElement)selectedElement;
            return PSSInspectViewContributor.processDefElement(project, def);
        }
        if (event.getType() == InspectViewUpdateEventCommon.TYPE.DIAGRAM && selectedElement instanceof Set) {
            return this.processActivityDiagramElements(project, (Set)selectedElement);
        }
        return null;
    }

    private InspectViewInput processActivityDiagramElements(IProject project, Set<?> selectedElementPaths) {
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject((IProject)project);
        InspectViewInput result = new InspectViewInput("", lineDelimiter);
        for (Object element : selectedElementPaths) {
            if (!(element instanceof RfElementPath)) continue;
            RfElementPath elementPath = (RfElementPath)element;
            IRfNamedElement namedElement = elementPath.toNamedElement(project);
            if (!(namedElement instanceof RfStruct) || !((RfStruct)namedElement).isAction(false)) {
                InspectViewInput namedElementInput = PSSInspectViewContributor.processNamedElement(project, namedElement);
                result.appendPositionAdjustedInput(namedElementInput);
                continue;
            }
            RfStruct action = (RfStruct)namedElement;
            if (!action.isCompoundAction()) {
                InspectViewInput atomicActionInput = new InspectViewInput(ATOMIC_ACTION_MESSAGE);
                result.appendPositionAdjustedInput(atomicActionInput);
                continue;
            }
            List<RfDefElement> activities = action.getActivities();
            for (RfDefElement activity : activities) {
                InspectViewInput activityInput = PSSInspectViewContributor.processDefElement(project, activity);
                result.appendPositionAdjustedInput(activityInput);
            }
        }
        return result;
    }

    public static InspectViewInput processNamedElement(IProject project, IRfNamedElement element) {
        IRfDefElement declaration = element.getDeclaration();
        return PSSInspectViewContributor.processDefElement(project, declaration);
    }

    private static InspectViewInput processDefElement(IProject project, IRfDefElement declaration) {
        if (!(declaration instanceof RfDefElement)) {
            return null;
        }
        return DVTInspectViewUtils.getInstance().processDefElement(project, declaration, "//", null, 0, null);
    }

    public FileCompileInfo getCompileInfo(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        if (iFile.getProject() == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(iFile.getProject());
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)iFile);
        if (parserPath == null) {
            return null;
        }
        PSSFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return null;
        }
        List<PSSFileInstance> fileInstances = fileInstancesMap.getFileInstances(parserPath);
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        ArrayList<Integer> compileIndices = new ArrayList<Integer>();
        ArrayList<IBuildConfigParserConstants.LanguageSyntax> languageSyntaxes = new ArrayList<IBuildConfigParserConstants.LanguageSyntax>();
        for (PSSFileInstance fileInstance : fileInstances) {
            if (fileInstance.getIndex() < 0) continue;
            compileIndices.add(fileInstance.getIndex());
            languageSyntaxes.add(fileInstance.getLanguageSyntax());
        }
        return compileIndices.isEmpty() ? null : new FileCompileInfo(compileIndices, languageSyntaxes);
    }
}

