/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.ui.views.layers.LayersViewInput;
import ro.amiq.dvt.ui.views.layers.LayersViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfScopeUtil;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.model.reflection.util.NullProtectedList;
import ro.amiq.pssdt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.model.reflection.views.PSSLayersViewLabelProvider;
import ro.amiq.pssdt.model.reflection.views.PSSQuickViewersUtil;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.ui.editor.PSSEditor;
import ro.amiq.pssdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class PSSLayersViewContributor
implements ILayersViewContributor {
    private PSSLayersViewLabelProvider fLabelProvider = new PSSLayersViewLabelProvider();
    private int fNrTotalLayers;
    private int fNrTotalFiles;
    private int fNrNotFilteredLayers;
    private int fNrNotFilteredFiles;

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        Object rfElement = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)rfElement;
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        Object element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfDefElement) {
            actionHyperlink = RfUtils.createOpenAction((RfDefElement)element, project, null);
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public LayersViewInput getQuickViewInput(LayersViewInputConfigurator inputConfig) {
        this.fLabelProvider.setUsedByQuickLayersView(true);
        this.fNrTotalLayers = 0;
        this.fNrTotalFiles = 0;
        this.fNrNotFilteredLayers = 0;
        this.fNrNotFilteredFiles = 0;
        String bulkDataInfo = "";
        Object namedElement = null;
        boolean showScopeColumn = false;
        List<Object> elements = new ArrayList();
        try {
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)LanguageKind.PSS)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature("ro.amiq.pssdt.pssnature")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfElementPair elementPair = this.getLayersData(rfProject, ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getStringMather(), true, ev.getOffset(), ev.getFileName(), inputConfig.getUpdateJob());
            if (elementPair.fElements == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, null, elements, showScopeColumn, bulkDataInfo);
            }
            elements = this.toQuickViewWrappers(elementPair.fElements, inputConfig);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
    }

    private List<IDVTElementWrapper> toQuickViewWrappers(List<IDVTElementWrapper> elements, LayersViewInputConfigurator inputConfig) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        UpdateJob updateJob = inputConfig.getUpdateJob();
        try {
            for (IDVTElementWrapper wrapper : elements) {
                RfTreeElementWrapper tmpWrapper;
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                Object tmpElment = wrapper.getRfElement();
                if (!(tmpElment instanceof RfDefElement)) continue;
                RfDefElement rfDefElem = (RfDefElement)tmpElment;
                RfNamedElement namedElement = rfDefElem.getNamedElement();
                RfTreeElementWrapper lastWrapper = new RfTreeElementWrapper(rfDefElem);
                RfNamedElement enclosingScope = namedElement.getEnclosingScope();
                while (!(enclosingScope == null || enclosingScope instanceof RfProject || enclosingScope instanceof RfLibrary || enclosingScope instanceof RfPackage && ((RfPackage)enclosingScope).isMainPackage())) {
                    tmpWrapper = new RfTreeElementWrapper(enclosingScope);
                    tmpWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS, "false");
                    tmpWrapper.addChild(lastWrapper);
                    lastWrapper = tmpWrapper;
                    enclosingScope = enclosingScope.getEnclosingScope();
                }
                tmpWrapper = new RfTreeElementWrapper(rfDefElem.getDefFile());
                tmpWrapper.addChild(lastWrapper);
                lastWrapper = tmpWrapper;
                this.addToFullTreeHelper(result, lastWrapper, updateJob);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void addToFullTreeHelper(List<IDVTElementWrapper> allWrappers, IDVTElementWrapper currentWrapper, UpdateJob updateJob) {
        boolean found = false;
        IDVTElementWrapper foundWrapper = null;
        for (IDVTElementWrapper tmpWrapper : allWrappers) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            if (!this.fLabelProvider.getText(tmpWrapper).equalsIgnoreCase(this.fLabelProvider.getText(currentWrapper))) continue;
            found = true;
            foundWrapper = tmpWrapper;
            break;
        }
        if (!found) {
            allWrappers.add(currentWrapper);
            return;
        }
        if (foundWrapper != null) {
            List currentChildren = currentWrapper.getChildren();
            if (currentChildren == null || currentChildren.isEmpty()) {
                return;
            }
            List foundChildren = foundWrapper.getChildren();
            if (foundChildren == null || foundChildren.isEmpty()) {
                foundWrapper.addChildren(currentChildren);
                return;
            }
            for (IDVTElementWrapper currentChild : currentChildren) {
                this.addToFullTreeHelper(foundChildren, currentChild, updateJob);
            }
        }
    }

    public LayersViewInput getInput(LayersViewInputConfigurator inputConfig) {
        this.fLabelProvider.setUsedByQuickLayersView(false);
        this.fNrTotalLayers = 0;
        this.fNrTotalFiles = 0;
        this.fNrNotFilteredFiles = 0;
        this.fNrNotFilteredLayers = 0;
        String bulkDataInfo = "";
        RfNamedElement namedElement = null;
        boolean showScopeColumn = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)LanguageKind.PSS)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature("ro.amiq.pssdt.pssnature")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfElementPair elementPair = this.getLayersData(rfProject, ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getStringMather(), false, ev.getOffset(), ev.getFileName(), inputConfig.getUpdateJob());
            List<IDVTElementWrapper> wrappers = elementPair.fElements;
            namedElement = elementPair.fNamedElement;
            if (wrappers == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, null, elements, showScopeColumn, bulkDataInfo);
            }
            if (ev.getElementType() == 4) {
                showScopeColumn = true;
            }
            elements.addAll(wrappers);
            bulkDataInfo = namedElement == null ? "" : (namedElement instanceof RfMethod ? ((RfMethod)namedElement).getSignature() : namedElement.getSignature());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
    }

    private int getFilesNo(List<IDVTElementWrapper> wrappedElements) {
        HashSet<ParserPath> set = new HashSet<ParserPath>();
        int i = 0;
        while (i < wrappedElements.size()) {
            RfDefElement element = (RfDefElement)wrappedElements.get(i).getRfElement();
            set.add(element.getDefFile().getParserPath());
            ++i;
        }
        return set.size();
    }

    private RfElementPair getLayersData(RfProject project, String elementName, int elementType, List<RfNameTypeScopeHelper> elementScope, StringMatcher matcher, boolean triggeredFromQuickView, int lineOffset, String fileName, UpdateJob updateJob) {
        RfNamedElement namedElement = null;
        NullProtectedList elementDefs = new NullProtectedList();
        List<IDVTElementWrapper> wrappers = new ArrayList<IDVTElementWrapper>();
        try {
            if (project == null) {
                return new RfElementPair(namedElement, wrappers);
            }
            IRfScopeElement scope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
            if (scope == null || !(scope instanceof IRfScope)) {
                return new RfElementPair(namedElement, wrappers);
            }
            Collection<RfLibrary> allLibraries = project.getLibraries();
            if (allLibraries == null) {
                return new RfElementPair(namedElement, wrappers);
            }
            if (elementType == 64 || elementType == 2048 || elementType == 512) {
                namedElement = ((RfNamedElement)scope).getLocalMember(null, SemanticUtils.MEMBER_TYPES, elementName, false, null);
                if (namedElement != null) {
                    elementDefs.addAll(namedElement.getDeclarations());
                }
            } else if (elementType == 4 && (namedElement = ((RfNamedElement)scope).getLocalMember(null, SemanticUtils.MEMBER_METHODS, elementName, false, null)) != null) {
                elementDefs.addAll(namedElement.getDeclarations());
            }
            for (RfDefElement rfDefElement : elementDefs) {
                wrappers.add(new RfTreeElementWrapper(rfDefElement));
            }
            this.fNrTotalLayers = wrappers.size();
            this.fNrTotalFiles = this.getFilesNo(wrappers);
            if (matcher != null) {
                wrappers = this.filterElements(wrappers, matcher, triggeredFromQuickView, elementType);
            }
            this.fNrNotFilteredLayers = wrappers.size();
            this.fNrNotFilteredFiles = this.getFilesNo(wrappers);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new RfElementPair(namedElement, wrappers);
    }

    private List<IDVTElementWrapper> filterElements(List<IDVTElementWrapper> elements, StringMatcher matcher, boolean triggeredFromQuickView, int elementType) {
        if (matcher == null) {
            return elements;
        }
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper wrapper : elements) {
            this.fLabelProvider.setUsedByQuickLayersView(triggeredFromQuickView);
            String name = this.fLabelProvider.getColumnText(wrapper, 0);
            String scope = elementType == 4 ? this.fLabelProvider.getColumnText(wrapper, 1) : "";
            String comment = triggeredFromQuickView ? "" : this.fLabelProvider.getColumnText(wrapper, 2);
            String fileName = this.fLabelProvider.getColumnText(wrapper, 3);
            String linenr = this.fLabelProvider.getColumnText(wrapper, 4);
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)name) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)scope) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)comment) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)fileName) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)linenr)) continue;
            result.add(wrapper);
        }
        return result;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfFileDef) {
            return false;
        }
        if (referenceData instanceof UpdateViewEvent) {
            UpdateViewEvent updateEvent = (UpdateViewEvent)referenceData;
            if (updateEvent.getFileName() == null) {
                return false;
            }
            return this.fLabelProvider.getColumnText(element, 4).equals(updateEvent.getFileName()) && this.fLabelProvider.getColumnText(element, 5).equals(String.valueOf(updateEvent.getOffset())) || this.fLabelProvider.getColumnText(element, 3).equals(updateEvent.getFileName()) && this.fLabelProvider.getColumnText(element, 4).equals(String.valueOf(updateEvent.getOffset()));
        }
        if (referenceData instanceof RfTreeElementWrapper) {
            return this.fLabelProvider.getColumnText(element, 4).equals(this.fLabelProvider.getColumnText(referenceData, 4)) && this.fLabelProvider.getColumnText(element, 5).equals(this.fLabelProvider.getColumnText(referenceData, 5)) || this.fLabelProvider.getColumnText(element, 3).equals(this.fLabelProvider.getColumnText(referenceData, 3)) && this.fLabelProvider.getColumnText(element, 4).equals(this.fLabelProvider.getColumnText(referenceData, 4));
        }
        if (rfElement instanceof RfDefElement) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
        }
        return false;
    }

    public void collectEMethodLayers(List<IDVTElementWrapper> allLayers) {
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursor) {
        RfNamedElement namedElement;
        IDocument document;
        IProject project;
        IFile file;
        block22: {
            block21: {
                RfWNamedElementAndScope elementAndScope;
                block20: {
                    PSSEditor pssEditor;
                    block19: {
                        IDocumentProvider documentProvider;
                        IEditorInput editorInput;
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                try {
                                                    if (editor instanceof PSSEditor) break block13;
                                                    return null;
                                                }
                                                catch (Exception e) {
                                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                                    return null;
                                                }
                                            }
                                            pssEditor = (PSSEditor)editor;
                                            editorInput = pssEditor.getEditorInput();
                                            if (editorInput != null) break block14;
                                            return null;
                                        }
                                        file = (IFile)editorInput.getAdapter(IFile.class);
                                        if (file != null) break block15;
                                        return null;
                                    }
                                    project = file.getProject();
                                    if (project != null) break block16;
                                    return null;
                                }
                                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                                if (rfProject != null) break block17;
                                return null;
                            }
                            documentProvider = pssEditor.getDocumentProvider();
                            if (documentProvider != null) break block18;
                            return null;
                        }
                        document = documentProvider.getDocument((Object)editorInput);
                        if (document != null) break block19;
                        return null;
                    }
                    elementAndScope = RfUtils.getRfElement((ITextEditor)pssEditor, document, cursor);
                    if (elementAndScope != null) break block20;
                    return null;
                }
                namedElement = elementAndScope.getNamedElement();
                if (namedElement != null) break block21;
                return null;
            }
            if (namedElement instanceof RfField) {
                namedElement = ((RfField)namedElement).getAssociatedBaseType();
            }
            if (namedElement instanceof RfPackage || namedElement instanceof RfStruct || namedElement instanceof RfEnumType || namedElement instanceof RfMethod) break block22;
            return null;
        }
        UpdateViewEvent updateEvent = PSSQuickViewersUtil.createViewUpdateEvent(namedElement, project, 1);
        updateEvent.setOffset(document.getLineOfOffset(cursor) + 1);
        updateEvent.setFileName(file.getName());
        return updateEvent;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    private static class RfElementPair {
        RfNamedElement fNamedElement;
        List<IDVTElementWrapper> fElements;

        public RfElementPair(RfNamedElement namedElement, List<IDVTElementWrapper> elementDefs) {
            this.fNamedElement = namedElement;
            this.fElements = elementDefs;
        }
    }
}

