/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.model.reflection.views.PSSLabelProvider;
import ro.amiq.pssdt.model.reflection.views.PSSLanguageElement;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.model.reflection.views.TypesViewLabelProvider;

public class PSSLayersViewLabelProvider
extends PSSLabelProvider {
    private AtomicBoolean fUsedByQuickLayersView = new AtomicBoolean(false);
    private TypesViewLabelProvider fTypesViewLabelProvider = new TypesViewLabelProvider();

    public void setUsedByQuickLayersView(boolean usedByQuickLayersView) {
        this.fUsedByQuickLayersView.set(usedByQuickLayersView);
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object wrapper, int columnIndex) {
        Image result = null;
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
        Object rfElement = rfWrapper.getRfElement();
        if (rfElement instanceof PSSLanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(DVTImages.PSS_LANGUAGE);
        }
        if (rfElement instanceof RfNamedElement && this.fUsedByQuickLayersView.get()) {
            return ((RfNamedElement)rfElement).getImage();
        }
        RfDefElement defElement = (RfDefElement)rfElement;
        RfNamedElement namedElement = defElement.getNamedElement();
        if (columnIndex == 0) {
            if (this.fUsedByQuickLayersView.get() && defElement instanceof RfFileDef) {
                IFile file = (IFile)defElement.getFileAdapter();
                if (file == null) {
                    result = DVTImages.imageCache.getImage(DVTImages.DESC_PSS_MODULE_GRAY);
                } else {
                    result = DVTImages.imageCache.getImage(DVTImages.DESC_PSS_MODULE);
                    IContainer parent = file.getParent();
                    while (parent != null && !(parent instanceof IProject)) {
                        if (parent.isLinked()) {
                            result = DVTImages.imageCache.getImage(DVTImages.DESC_PSS_MODULE_LINKED);
                            break;
                        }
                        parent = parent.getParent();
                    }
                }
            } else if (namedElement != null && defElement.isIs()) {
                result = namedElement.getImage();
            } else if (namedElement != null) {
                if (namedElement instanceof RfStruct) {
                    result = ((RfStruct)namedElement).getExtendImage();
                } else if (namedElement instanceof RfEnumType) {
                    result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE_EXTEND);
                } else if (namedElement instanceof RfMethod) {
                    result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
                }
            } else {
                result = this.fTypesViewLabelProvider.getImage((Object)new RfTreeElementWrapper(namedElement));
            }
            if (result != null && this.fDecorator != null) {
                return this.fDecorator.decorateImage(result, wrapper);
            }
        } else if (columnIndex == 1) {
            RfNamedElement enclosing = defElement.getNamedElement().getEnclosingScope();
            result = enclosing != null ? enclosing.getImage() : this.fTypesViewLabelProvider.getImage((Object)new RfTreeElementWrapper(namedElement));
            if (result != null) {
                return result;
            }
        } else if (columnIndex == 3) {
            IFile file = (IFile)defElement.getDefFile().getFileAdapter();
            if (file == null) {
                result = DVTImages.imageCache.getImage(DVTImages.DESC_PSS_MODULE_GRAY);
            } else {
                result = DVTImages.imageCache.getImage(DVTImages.DESC_PSS_MODULE);
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        result = DVTImages.imageCache.getImage(DVTImages.DESC_PSS_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        String result = "";
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
        Object rfElement = rfWrapper.getRfElement();
        if (rfElement instanceof PSSLanguageElement && columnIndex == 0) {
            return (String)((PSSLanguageElement)((Object)rfElement)).getInfo();
        }
        if (!(rfElement instanceof RfDefElement) && this.fUsedByQuickLayersView.get()) {
            return this.fTypesViewLabelProvider.getText(wrapper);
        }
        RfDefElement defElement = (RfDefElement)rfElement;
        RfNamedElement namedElement = defElement.getNamedElement();
        switch (columnIndex) {
            case 0: {
                if (this.fUsedByQuickLayersView.get() && defElement instanceof RfFileDef) {
                    IFile file = (IFile)defElement.getFileAdapter();
                    if (file != null) {
                        result = file.getName();
                    }
                } else {
                    result = defElement.getName();
                    if (namedElement instanceof RfEnumType) {
                        List<RfNamedElement> enumItems = namedElement.getLocalMembers(null, SemanticUtils.MEMBER_ENUM_ITEMS);
                        if (enumItems == null || enumItems.isEmpty()) {
                            result = String.valueOf(result) + ": []";
                        } else {
                            StringBuilder temp = new StringBuilder();
                            for (RfNamedElement enumItem : enumItems) {
                                RfDefElement declaration = enumItem.getDeclaration();
                                if (!defElement.contains(declaration)) continue;
                                if (temp.length() + result.length() + 4 >= 1000) break;
                                if (temp.length() > 0) {
                                    temp.append(", ");
                                }
                                temp.append(enumItem.getName());
                            }
                            result = String.valueOf(result) + " : [" + temp.toString() + "]";
                        }
                    } else if (namedElement instanceof RfMethod) {
                        result = String.valueOf(result) + "()";
                    }
                    if (this.fUsedByQuickLayersView.get() && (rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS) == null || !rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS).equals("false"))) {
                        result = String.valueOf(result) + " @" + Integer.toString(defElement.getStartLine());
                    }
                }
                result = ViewsUtils.trimText((String)result, (int)1000, (boolean)true);
                break;
            }
            case 1: {
                RfNamedElement enclosing = namedElement.getEnclosingScope();
                result = enclosing == null ? "" : enclosing.getName();
                break;
            }
            case 2: {
                String comment = defElement.getDefComment();
                result = comment == null ? "" : comment;
                result = ViewsUtils.trimText((String)result, (int)100, (boolean)true);
                break;
            }
            case 3: {
                result = defElement.getDefFile().getName();
                break;
            }
            case 4: {
                result = Integer.toString(defElement.getStartLine());
            }
        }
        return result;
    }

    public String getText(Object element) {
        String result = this.getColumnText(element, 0);
        if (result == null) {
            return "";
        }
        return result;
    }
}

