/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewMessages;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.pssdt.model.IPSSModule;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfKind;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfScopeUtil;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.model.reflection.views.VHHistoryItem;

public enum PSSQuickViewersUtil {
    INSTANCE;

    private static Map<IFile, WaitEditorActiveJob> fWaitEditorJobs;
    private static final Object FAMILY_MODULE_REPARSE;
    private TreeItem fBestMatch;

    static {
        fWaitEditorJobs = new ConcurrentHashMap<IFile, WaitEditorActiveJob>();
        FAMILY_MODULE_REPARSE = new Object();
    }

    public static PSSQuickViewersUtil getInstance() {
        return INSTANCE;
    }

    public void scheduleReparseIfNonTop(ITextEditor editor) {
        IProject project = PSSQuickViewersUtil.getProject(editor);
        if (project == null) {
            return;
        }
        if (BuildConfigManager.isNonTopFileCompilationDisabled((IProject)project)) {
            return;
        }
        IFile resource = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (resource == null) {
            return;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)resource);
        if (parserPath == null) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        RfMixedLangProject rfMixedProject = rfProject.getMixedLangProjectParent();
        if (rfMixedProject == null) {
            return;
        }
        if (RfProjectState.BUILT.equals((Object)rfProject.getProjectState()) && !rfMixedProject.isBuildDone()) {
            return;
        }
        if (!RfProjectState.BUILT.equals((Object)rfProject.getProjectState()) && !RfProjectState.RESTORED.equals((Object)rfProject.getProjectState())) {
            return;
        }
        boolean isCompiled = rfProject.isCompiled(parserPath);
        if (isCompiled) {
            return;
        }
        RfFileDef fileDef = rfProject.getFile((IResource)resource);
        if (fileDef == null && !this.isWaitEditorJobScheduled(resource)) {
            WaitEditorActiveJob fWaitEditorJob = new WaitEditorActiveJob();
            fWaitEditorJob.setFile(resource);
            fWaitEditorJobs.put(resource, fWaitEditorJob);
            fWaitEditorJob.schedule(0L);
        }
    }

    private boolean isWaitEditorJobScheduled(IFile file) {
        if (file == null) {
            return false;
        }
        return fWaitEditorJobs.containsKey(file);
    }

    public void removeWaitEditorJob(IFile file) {
        if (file == null) {
            return;
        }
        fWaitEditorJobs.remove(file);
    }

    public static IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public TreeItem getSymbolAtLine(Tree tree, int line) {
        TreeItem item = this.getSymbolChildAtLine(tree, line);
        if (item == null) {
            item = this.fBestMatch;
        }
        return item;
    }

    private TreeItem getSymbolChildAtLine(Object parent, int line) {
        TreeItem[] items = null;
        if (parent instanceof Tree) {
            items = ((Tree)parent).getItems();
        } else if (parent instanceof TreeItem) {
            items = ((TreeItem)parent).getItems();
        }
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Object data;
                TreeItem item = items[i];
                if (!item.isDisposed() && (data = item.getData()) != null) {
                    Object element = ((RfTreeElementWrapper)((Object)data)).getRfElement();
                    if (!(element instanceof RfDefElement)) {
                        return null;
                    }
                    RfDefElement os = (RfDefElement)element;
                    if (line == os.getStartLine()) {
                        return item;
                    }
                    if (os.getStartLine() < line && (this.fBestMatch == null || this.fBestMatch.isDisposed() || ((RfDefElement)((RfTreeElementWrapper)((Object)this.fBestMatch.getData())).getRfElement()).getStartLine() > line || ((RfDefElement)((RfTreeElementWrapper)((Object)this.fBestMatch.getData())).getRfElement()).getStartLine() < os.getStartLine())) {
                        this.fBestMatch = item;
                    }
                    if ((item = this.getSymbolChildAtLine(item, line)) != null) {
                        return item;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void updateLayersView(RfNamedElement currentscope, RfNamedElement namedElement, IProject project, DVTViewEvent.EventKind kind, String sourceId, boolean updateHistory, boolean forceVisible) {
        UpdateViewEvent updateEvent = PSSQuickViewersUtil.createViewUpdateEvent(namedElement, project, updateHistory ? 1 : 0);
        DVTViewEvent viewEvent = new DVTViewEvent(kind, sourceId, new ViewDataContainer(project, (HistoryItem)updateEvent));
        ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.LayersView", (DVTViewEvent)viewEvent, (boolean)forceVisible);
    }

    public static int matchTypeForDesignHierarchyViewer(IRfNamedElement namedElement) {
        return 0;
    }

    public static int getType(RfNamedElement namedElement) {
        if (namedElement instanceof RfPackage) {
            return 512;
        }
        if (namedElement instanceof RfBlock && ((RfBlock)namedElement).isConstraint()) {
            return 4096;
        }
        if (namedElement instanceof RfBlock) {
            return 32;
        }
        if (namedElement instanceof RfLibrary) {
            return 1024;
        }
        if (namedElement instanceof RfStruct) {
            return 64;
        }
        if (namedElement instanceof RfMethod) {
            return 4;
        }
        if (namedElement instanceof RfEnumType) {
            return 2048;
        }
        return 0;
    }

    public static UpdateViewEvent createViewUpdateEvent(RfNamedElement source, IProject project, int updateHistory) {
        String info = "";
        if (source != null) {
            String sig = source.getSignature();
            info = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)sig, (String)"");
        }
        return PSSQuickViewersUtil.createViewUpdateEvent(info, source, project, updateHistory);
    }

    public static UpdateViewEvent createViewUpdateEvent(String text, RfNamedElement source, IProject project, int updateHistory) {
        String projectName = null;
        if (project != null) {
            projectName = project.getName();
        }
        int elementType = PSSQuickViewersUtil.getType(source);
        String elementName = null;
        List<RfNameTypeScopeHelper> elementScope = null;
        String entityName = null;
        if (source != null) {
            elementName = source.getName();
            elementScope = RfScopeUtil.getDefOfScopeElement((IRfScopeElement)source.getEnclosingScope());
        }
        return new UpdateViewEvent(text, projectName, elementType, elementName, elementScope, entityName, LanguageKind.PSS, updateHistory);
    }

    public static UpdateViewEvent createViewUpdateEvent(String text, String projectName, String elementName, List<RfNameTypeScopeHelper> elementScope, int elementType, int updateHistory) {
        return new UpdateViewEvent(text, projectName, elementType, elementName, elementScope, LanguageKind.PSS, updateHistory);
    }

    public void updateTypeHierarchyViewer(RfNamedElement namedElement, IProject project, DVTViewEvent.EventKind kind, String sourceId, boolean updateHistory, boolean forceVisible) {
        try {
            if (!(namedElement instanceof IRfClassType) && namedElement.getEnclosingScope() instanceof IRfClassType) {
                namedElement = namedElement.getEnclosingScope();
            }
            if (!(namedElement instanceof IRfClassType)) {
                return;
            }
            UpdateViewEvent updateViewEvent = PSSQuickViewersUtil.createViewUpdateEvent(namedElement, project, updateHistory ? 2 : 0);
            ViewDataContainer dataContainer = new ViewDataContainer(project, (HistoryItem)updateViewEvent);
            ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.TypeHierarchyView", (DVTViewEvent)new DVTViewEvent(kind, sourceId, dataContainer), (boolean)forceVisible);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IRfNamedElement getEnclosingFunctionOrClass(RfDefElement initialScope, boolean ignoreFunctions) {
        RfNamedElement namedElement = initialScope.getNamedElement();
        while (namedElement != null && namedElement instanceof IRfClassType) {
            namedElement = namedElement.getEnclosingScope();
        }
        return namedElement;
    }

    public static Comparator<IDVTElementWrapper> getSortByTypeComparator(final LabelProvider labelProvider) {
        return new Comparator<IDVTElementWrapper>(){

            @Override
            public int compare(IDVTElementWrapper e1, IDVTElementWrapper e2) {
                int cat2;
                Object obj1 = e1.getRfElement();
                Object obj2 = e2.getRfElement();
                String treeName1 = ((RfTreeElementWrapper)e1).getTreeName();
                String treeName2 = ((RfTreeElementWrapper)e2).getTreeName();
                if (obj1 instanceof String && obj2 instanceof String) {
                    return ((String)obj1).compareTo((String)obj2);
                }
                if (!(obj1 instanceof RfNamedElement) && !(obj2 instanceof RfNamedElement)) {
                    return 0;
                }
                if (!(obj1 instanceof RfNamedElement)) {
                    return -1;
                }
                if (!(obj2 instanceof RfNamedElement)) {
                    return 1;
                }
                int cat1 = RfKind.of((IRfNamedElement)obj1).ordinal();
                if (cat1 != (cat2 = RfKind.of((IRfNamedElement)obj2).ordinal())) {
                    return cat2 - cat1;
                }
                if (treeName1 != null && !treeName1.isEmpty() && treeName2 != null && !treeName2.isEmpty()) {
                    return treeName1.compareTo(treeName2);
                }
                return labelProvider.getText((Object)e1).compareTo(labelProvider.getText((Object)e2));
            }
        };
    }

    public static Comparator<IDVTElementWrapper> getSortByNameComparator(LabelProvider labelProvider) {
        return new Comparator<IDVTElementWrapper>(){

            @Override
            public int compare(IDVTElementWrapper o1, IDVTElementWrapper o2) {
                Object obj1 = o1.getRfElement();
                Object obj2 = o2.getRfElement();
                String treeName1 = ((RfTreeElementWrapper)o1).getTreeName();
                String treeName2 = ((RfTreeElementWrapper)o2).getTreeName();
                if (treeName1 != null && !treeName1.isEmpty() && treeName2 != null && !treeName2.isEmpty()) {
                    return treeName1.compareTo(treeName2);
                }
                if (obj1 instanceof RfNamedElement && obj2 instanceof RfNamedElement) {
                    return ((RfNamedElement)obj1).getName().compareTo(((RfNamedElement)obj2).getName());
                }
                if (obj1 instanceof String && obj2 instanceof String) {
                    return ((String)obj1).compareTo((String)obj2);
                }
                return 0;
            }
        };
    }

    public void openVerificationHierarchyForElementAtCursor() {
        IRfNamedElement namedElement = this.getElementAtExactCursor();
        if (namedElement == null) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextPSS);
            return;
        }
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.updateVerificationHierarchyViewer(namedElement, rfProject.getProject(), true);
    }

    public IRfNamedElement getElementAtExactCursor() {
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        IDocument document = Utils.getDocumentFromEditor((ITextEditor)((ITextEditor)editor));
        if (document == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        int offset = ((DVTEditor)editor).getCursor();
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(file, document, offset);
        if (namedElementAndScope != null) {
            return namedElementAndScope.getIRfNamedElement();
        }
        return null;
    }

    public void updateVerificationHierarchyViewer(IRfNamedElement namedElement, IProject project, boolean saveAsHistoryItem) {
        if (namedElement == null || project == null) {
            return;
        }
        String componentName = null;
        if (namedElement instanceof RfStruct && ((RfStruct)namedElement).getStructKind() == StructKind.COMPONENT) {
            componentName = namedElement.getName();
        }
        if (componentName == null) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextPSS);
            return;
        }
        HistoryItem item = VHHistoryItem.parseHistoryItem(project.getName(), componentName, LanguageKind.PSS);
        if (item == null) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextPSS);
            return;
        }
        VerificationHierarchyView view = (VerificationHierarchyView)ViewsUtils.getViewById((String)"ro.amiq.dvt.ui.views.VerificationHierarchyView", (boolean)true);
        if (view == null) {
            return;
        }
        view.setUpAndUpdate(item, saveAsHistoryItem);
    }

    private static class WaitEditorActiveJob
    extends Job {
        private IFile fFile;

        public WaitEditorActiveJob() {
            super("Wait Editor");
            this.setPriority(50);
            this.setSystem(true);
        }

        public void setFile(IFile file) {
            this.fFile = file;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_MODULE_REPARSE;
        }

        public boolean shouldSchedule() {
            boolean shouldSchedule;
            boolean bl = shouldSchedule = super.shouldSchedule() && ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (!shouldSchedule) {
                fWaitEditorJobs.remove(this.fFile);
            }
            return shouldSchedule;
        }

        public boolean shouldRun() {
            boolean shouldRun;
            boolean bl = shouldRun = super.shouldRun() && ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (!shouldRun) {
                fWaitEditorJobs.remove(this.fFile);
            }
            return shouldRun;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    IPSSModule pssFile = PSSModelManager.getInstance().getPSSModel().getOrCreatePSSFile(this.fFile);
                    pssFile.scheduleReparse(false, true, 0L, true);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    fWaitEditorJobs.remove(this.fFile);
                }
            }
            finally {
                fWaitEditorJobs.remove(this.fFile);
            }
            return Status.OK_STATUS;
        }
    }
}

