/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.pssdt.model.IPSSModel;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.util.RfEnclosingScopeUtils;
import ro.amiq.pssdt.model.reflection.views.PSSSearchContributorCommon;
import ro.amiq.pssdt.utils.Utils;

public class PSSSearchContributor
extends PSSSearchContributorCommon {
    public boolean isInstantiable(IRfNamedElement element) {
        return element instanceof RfStruct && ((RfStruct)element).isComponent();
    }

    public String getScopeInfo(IProject project, ParserPath parserPath, int line, int offset) {
        return RfEnclosingScopeUtils.getScopeInfo(project, parserPath, offset);
    }

    public IRfDefElement getScope(IProject project, ParserPath parserPath, int line, int offset) {
        return RfEnclosingScopeUtils.getScope(project, parserPath, offset);
    }

    public IRfNamedElement getElementFromString(IProject project, String elementString) {
        RfProject rfProject = Utils.getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        String string = elementString.replace(".", " ").replace("::", " ");
        String[] firstAndRest = RfElementPath.SPLIT_PATTERN.split(string, 2);
        RfLibrary library = rfProject.getLibraryWithPrefix(firstAndRest[0], 1);
        if (library != null) {
            if (firstAndRest.length == 1 || firstAndRest[1].isEmpty()) {
                return library;
            }
            return RfElementPath.fromString((String)this.getNature().concat(" ").concat(library.getName()).concat(" ").concat(firstAndRest[1])).toNamedElement(project);
        }
        for (RfLibrary libraryCandidate : rfProject.getLibraries()) {
            String libraryCandidateSegment = String.valueOf(libraryCandidate.getName()) + " ";
            String[] firstSecondAndRest = RfElementPath.SPLIT_PATTERN.split(string, 2);
            IRfNamedElement existingPackage = rfProject.getLocalMember(null, firstSecondAndRest[0], null);
            if (existingPackage != null) {
                if (firstSecondAndRest.length == 2 || firstAndRest[2].isEmpty()) {
                    return existingPackage;
                }
                return RfElementPath.fromString((String)this.getNature().concat(" ").concat(libraryCandidateSegment).concat(firstSecondAndRest[1]).concat(" ").concat(firstSecondAndRest[2])).toNamedElement(project);
            }
            Collection<RfNamedElement> pkgs = rfProject.getLocalMembers();
            if (pkgs == null || pkgs.isEmpty()) continue;
            for (RfNamedElement pkg : pkgs) {
                String pkgCandidateSegment = String.valueOf(pkg.getName()) + " ";
                IRfNamedElement result = RfElementPath.fromString((String)(String.valueOf(this.getNature()) + " " + libraryCandidateSegment + pkgCandidateSegment + string)).toNamedElement(project);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public IDVTFile getIDVTFile(IFile file) {
        IPSSModel pssModel = PSSModelManager.getInstance().getPSSModel();
        if (pssModel == null) {
            return null;
        }
        return pssModel.getPSSFile(file);
    }
}

