/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.Comparator;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.ui.editor.outline.CategorySortingAction;
import ro.amiq.pssdt.ui.editor.outline.IUpdateElement;

public class QuickViewCategorySortingAction
extends CategorySortingAction {
    private Comparator<IDVTElementWrapper> fComparator;
    private IUpdateElement fAtic;

    public QuickViewCategorySortingAction(IUpdateElement atic) {
        this.fAtic = atic;
        boolean disabled = PSSPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
        this.setEnabled(!disabled);
        if (!disabled) {
            boolean checked = PSSPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
            super.valueChanged(checked);
        }
    }

    @Override
    protected void valueChanged(boolean on) {
        super.valueChanged(on);
        this.fAtic.update(true);
    }

    public Comparator<IDVTElementWrapper> getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new Comparator<IDVTElementWrapper>(){

                public int category(Object obj) {
                    if (obj instanceof RfTreeElementWrapper) {
                        Object elem = ((RfTreeElementWrapper)((Object)obj)).getRfElement();
                        if (elem instanceof RfDefElement) {
                            elem = ((RfDefElement)elem).getNamedElement();
                        }
                        if (elem instanceof RfPackage) {
                            return 0;
                        }
                        if (elem instanceof RfStruct && ((RfStruct)elem).getStructKind() == StructKind.COMPONENT) {
                            return 1;
                        }
                        if (elem instanceof RfStruct && ((RfStruct)elem).getStructKind() == StructKind.ACTION) {
                            return 2;
                        }
                        if (elem instanceof RfStruct && ((RfStruct)elem).getStructKind() == StructKind.ACTION_ABSTRACT) {
                            return 2;
                        }
                        if (elem instanceof RfStruct) {
                            return 3;
                        }
                        if (elem instanceof RfTypeAlias) {
                            return 4;
                        }
                        if (elem instanceof RfEnumType) {
                            return 5;
                        }
                        if (elem instanceof RfCovergroup) {
                            return 6;
                        }
                        if (elem instanceof RfField) {
                            return 7;
                        }
                        if (elem instanceof RfEnumItem) {
                            return 8;
                        }
                        if (elem instanceof RfEnumItem) {
                            return 9;
                        }
                        if (elem instanceof RfMethod) {
                            return 10;
                        }
                        if (elem instanceof RfBlock) {
                            return 11;
                        }
                    }
                    return 100;
                }

                @Override
                public int compare(IDVTElementWrapper e1, IDVTElementWrapper e2) {
                    int line2;
                    int cat2;
                    if (!(e1.getRfElement() instanceof RfDefElement) || !(e2.getRfElement() instanceof RfDefElement)) {
                        return 0;
                    }
                    int cat1 = this.category(e1);
                    if (cat1 != (cat2 = this.category(e2))) {
                        return cat1 - cat2;
                    }
                    int line1 = ((RfDefElement)e1.getRfElement()).getStartLine();
                    if (line1 == (line2 = ((RfDefElement)e2.getRfElement()).getStartLine())) {
                        return 0;
                    }
                    if (line1 > line2) {
                        return 1;
                    }
                    return -1;
                }
            };
        }
        return this.fComparator;
    }
}

