/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.utils.Utils;

public class VHHistoryItem
extends HistoryItem {
    private String fComponentName;
    private String fProjectName;
    private LanguageKind fLanguageKind;

    private VHHistoryItem(String projectName, String componentName, LanguageKind languageKind) {
        super("[" + projectName + "] " + componentName);
        this.fProjectName = projectName;
        this.fComponentName = componentName;
        this.fLanguageKind = languageKind;
    }

    public static HistoryItem parseHistoryItem(String projectName, String componentTop, LanguageKind languageKind) {
        if (projectName == null || componentTop == null) {
            return null;
        }
        return new VHHistoryItem(projectName, componentTop, languageKind);
    }

    public LanguageKind getLanguage() {
        return this.fLanguageKind;
    }

    public String getComponentName() {
        return this.fComponentName;
    }

    public String getProjectName() {
        return this.fProjectName;
    }

    public boolean equals(Object hi) {
        if (hi instanceof VHHistoryItem) {
            VHHistoryItem vhi = (VHHistoryItem)((Object)hi);
            return this.fProjectName.equals(vhi.fProjectName) && this.fComponentName.equals(vhi.fComponentName);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.fProjectName.hashCode() + this.fComponentName.hashCode();
    }

    public String toString() {
        return this.fComponentName;
    }

    public IProject getProject() {
        if (this.fProjectName == null) {
            return null;
        }
        return Utils.getProject((String)this.fProjectName);
    }
}

