/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.views;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfDummyElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;

public class VHViewUtil {
    private static final Comparator<RfTreeElementWrapper> fLexicalSorter = new Comparator<RfTreeElementWrapper>(){

        @Override
        public int compare(RfTreeElementWrapper w1, RfTreeElementWrapper w2) {
            Object o1 = w1.getRfElement();
            Object o2 = w2.getRfElement();
            boolean firstIsField = o1 instanceof RfField;
            boolean secondIsField = o2 instanceof RfField;
            if (firstIsField && secondIsField) {
                return ((RfField)o1).getName().compareTo(((RfField)o2).getName());
            }
            if (firstIsField) {
                return -1;
            }
            if (secondIsField) {
                return 1;
            }
            return 0;
        }
    };

    public static void getRecursiveInstances(RfTreeElementWrapper root, RfNamedElement candidate, Set<RfNamedElement> visited, boolean sorting, boolean prependPackage, UpdateJob updateJob) {
        List<RfTreeElementWrapper> children;
        if (candidate instanceof RfCollectionType) {
            candidate = ((RfCollectionType)candidate).getAssociatedType();
        }
        if (visited.contains(candidate)) {
            root.addChild(new RfTreeElementWrapper(new RfDummyElement("[...recurrence detected]")));
            return;
        }
        visited.add(candidate);
        if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
            return;
        }
        Collection<RfNamedElement> members = candidate.getLocalMembers();
        if (members != null) {
            for (RfNamedElement member : members) {
                if (!(member instanceof RfField)) continue;
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return;
                }
                if (((RfField)member).isPool()) {
                    RfTreeElementWrapper fieldWrapper = new RfTreeElementWrapper(member);
                    root.addChild(fieldWrapper);
                    if (!prependPackage) continue;
                    fieldWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
                    continue;
                }
                if (!((RfField)member).isInstance()) continue;
                RfNamedElement associatedType = ((RfField)member).getAssociatedBaseType();
                while (associatedType instanceof RfTypeAlias) {
                    associatedType = ((RfTypeAlias)associatedType).getAssociatedBaseType();
                }
                RfTreeElementWrapper fieldWrapper = new RfTreeElementWrapper(member);
                root.addChild(fieldWrapper);
                if (prependPackage) {
                    fieldWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
                }
                VHViewUtil.getRecursiveInstances(fieldWrapper, associatedType, visited, sorting, prependPackage, updateJob);
            }
        }
        if (sorting && (children = root.getChildren()) != null) {
            Collections.sort(children, fLexicalSorter);
        }
        visited.remove(candidate);
    }
}

