/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.parser;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.utils.DVTStringUtil;

public class EAST
extends CommonAST {
    private static final long serialVersionUID = 2L;
    private Map<String, String> metas;
    private transient EAST parent;
    private transient EAST left;
    private boolean isRoot;
    private int line;
    private int offset;
    public transient Object transientScope;
    public transient Object transientResult;
    public static final int TEXT = 0;
    public static final int TOKEN = 1;
    public static final int FULL = 2;
    private static int stringConversion = 0;
    private static String[] stringConversionNames;

    public EAST() {
    }

    public EAST(EAST east) {
        this.setType(east.getType());
        this.setText(east.getText());
        this.line = east.line;
        this.offset = east.offset;
        this.metas = east.getMetaTable();
        this.transientScope = east.transientScope;
        this.transientResult = east.transientResult;
    }

    public void initialize(AST t) {
        if (t instanceof EAST) {
            EAST east = (EAST)t;
            this.setType(east.getType());
            this.setText(east.getText());
            this.line = east.line;
            this.offset = east.offset;
            this.metas = east.getMetaTable();
            this.transientScope = east.transientScope;
            this.transientResult = east.transientResult;
        }
    }

    public void initialize(Token tok) {
        this.setText(tok.getText());
        this.setType(tok.getType());
        this.line = tok.getLine();
        this.offset = tok.getOffset();
    }

    public EAST(Token tok) {
    }

    public static void setStringConversion(int conv, String[] names) {
        stringConversion = conv;
        stringConversionNames = names;
    }

    public static String[] getTokenNames() {
        return stringConversionNames;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setColumn(int column) {
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return -1;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        switch (stringConversion) {
            case 0: {
                return this.getText();
            }
            case 1: {
                StringBuilder b = new StringBuilder();
                b.append("<");
                b.append(stringConversionNames[this.getType()]);
                b.append(">");
                return b.toString();
            }
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        b.append(this.getText());
        b.append(",<");
        b.append(stringConversionNames[this.getType()]);
        b.append(">");
        b.append("," + this.getLine() + ":" + this.getColumn());
        b.append("]");
        return b.toString();
    }

    void packEAST(StringBuilder sb, List<EAST> list) {
        EAST t = this;
        if (t.getFirstChild() != null) {
            sb.append("(");
        }
        sb.append("#");
        list.add(new EAST(this));
        if (t.getFirstChild() != null) {
            ((EAST)t.getFirstChild()).packEAST(sb, list);
        }
        if (t.getFirstChild() != null) {
            sb.append(")");
        }
        if (t.getNextSibling() != null) {
            ((EAST)t.getNextSibling()).packEAST(sb, list);
        }
    }

    public Map<String, String> getMetaTable() {
        return this.metas;
    }

    public void setMetaTable(Map<String, String> meta) {
        this.metas = meta;
    }

    public String getMeta(String key) {
        if (this.metas == null || !this.metas.containsKey(key)) {
            return null;
        }
        return this.metas.get(key);
    }

    public void addMeta(String key, String meta) {
        if (this.metas == null) {
            this.metas = new HashMap<String, String>(4);
        }
        this.metas.put(DVTStringUtil.intern((String)key), meta);
    }

    public boolean hasMeta(String key) {
        return this.metas != null && this.metas.containsKey(key);
    }

    public void setParent(EAST parent) {
        this.parent = parent;
    }

    public EAST getParent() {
        return this.parent;
    }

    public void setPrevSibling(EAST left) {
        this.left = left;
    }

    public EAST getPrevSibling() {
        return this.left;
    }

    public void setText(String text_) {
        super.setText(DVTStringUtil.intern((String)text_));
    }

    public void setRootElement(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isRootElement() {
        return this.isRoot;
    }
}

