/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.parser;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.utils.FileInputStreamUtils;
import ro.amiq.dvt.utils.MD5InputStream;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.pssdt.model.IPSSModule;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.parser.EAST;
import ro.amiq.pssdt.parser.IParsingListener;
import ro.amiq.pssdt.parser.PSSFileInstance;
import ro.amiq.pssdt.parser.PSSLexer;
import ro.amiq.pssdt.parser.PSSLexerStack;
import ro.amiq.pssdt.parser.PSSLoadedInfo;
import ro.amiq.pssdt.parser.PSSParser;
import ro.amiq.pssdt.parser.PSSProblem;
import ro.amiq.pssdt.parser.PSSSkipInfo;
import ro.amiq.pssdt.parser.PSSStartedInfo;
import ro.amiq.pssdt.parser.PSSUtil;
import ro.amiq.pssdt.ui.persistenttask.TaskInfoWrapper;

public class PSSCompiler {
    private PSSUtil util = new PSSUtil();
    private IPSSModule parsingInstanceListener;
    private AST fileAST;

    /*
     * Loose catch block
     */
    public AST parseExpression(IBuildConfigParserConstants.LanguageSyntax languageSyntax, RfProject rfProject, PSSFileInstance fileInstance, ParserPath parserPath, String expression) {
        try {
            this.util.setMaxIssuesKindPerFile(10);
            this.util.setInvocationProperties(-1, IBuildConfigParserConstants.ToolCompat.DVT);
            this.util.restoreFileInstancesMap(rfProject.getFileInstancesMap());
            this.util.setRfProject(rfProject);
            this.util.cleanFileInstanceCustomPragmas();
            this.util.setCurrentFile(fileInstance);
            this.util.addFileInstance(fileInstance);
            byte[] bytevals = expression.getBytes();
            Throwable throwable = null;
            Object var8_13 = null;
            try {
                AST aST;
                BufferedReader reader;
                ByteArrayInputStream inputStream;
                block22: {
                    block21: {
                        AST exprAST;
                        inputStream = new ByteArrayInputStream(bytevals);
                        reader = new BufferedReader(new InputStreamReader(inputStream));
                        PSSLexer lexer = new PSSLexer(reader);
                        lexer.util = this.util;
                        lexer.setFilename(rfProject, parserPath, true);
                        lexer.lS = new PSSLexerStack(lexer, this.util);
                        PSSParser parser = new PSSParser(lexer.lS);
                        parser.setFilename(parserPath.toString());
                        parser.setASTNodeClass(EAST.class);
                        parser.util = this.util;
                        parser.rfp = rfProject;
                        parser.expression();
                        aST = exprAST = parser.getAST();
                        if (reader == null) break block21;
                        reader.close();
                    }
                    if (inputStream == null) break block22;
                    ((InputStream)inputStream).close();
                }
                return aST;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (inputStream != null) {
                                ((InputStream)inputStream).close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (TokenStreamRecognitionException e) {
            this.util.reportError("*** Error: ", e.recog.getFilename(), this.util.getLanguageSyntax(), e.recog.getLine(), e.recog.getOffset(), e.recog.getLength(), e.recog.getMessage(), -1);
        }
        catch (RecognitionException e) {
            this.util.reportError("*** Error: ", e.getFilename(), this.util.getLanguageSyntax(), e.getLine(), e.getOffset(), e.getLength(), e.getMessage(), -1);
        }
        catch (TokenStreamException e) {
            if (!e.getMessage().equals("INTERRUPT")) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public int parseFile(String filename, String libraryName, IBuildConfigParserConstants.LanguageSyntax languageSyntax, RfProject rfProject, String documentContent, boolean incremental, int fileIndex, int invocNumber, int maxIssuesKindNumber, List<CustomPragma> customPragmas, DVTCodeCommentsPreferences commentsPreferences, Set<String> taskNames, boolean caseSensitive, boolean hideTaskName, SkipCompileFilter skipCompileFilter) {
        try {
            this.util.setMaxIssuesKindPerFile(maxIssuesKindNumber);
            this.util.setInvocationProperties(invocNumber, IBuildConfigParserConstants.ToolCompat.DVT);
            this.util.setTaskTagsProperties(taskNames, caseSensitive, hideTaskName);
            this.util.setCustomPragmas(customPragmas);
            this.util.setSkipCompileFilter(skipCompileFilter);
            this.util.restoreFileInstancesMap(rfProject.getFileInstancesMap());
            this.util.setRfProject(rfProject);
            this.util.setNextFileIndex(fileIndex);
            PSSUtil.setCommentsPreferences(commentsPreferences);
            File file = new File(filename);
            ParserPath parserPath = new ParserPath(filename);
            this.util.cleanMessages(parserPath);
            this.util.cleanFileInstanceCustomPragmas();
            if (this.util.isIgnored(file)) {
                this.util.notifyParsingListeners(new PSSSkipInfo(parserPath));
                this.util.incrementNextFileIndex();
                return this.util.getNextFileIndex();
            }
            this.util.notifyParsingListeners(new PSSStartedInfo(parserPath));
            this.util.setIncremental(incremental);
            if (incremental) {
                List<PSSFileInstance> fileInstances = this.util.getFileInstances(parserPath);
                if (fileInstances == null || fileInstances.isEmpty()) {
                    PSSFileInstance fileInstance = new PSSFileInstance(rfProject, parserPath, fileIndex, invocNumber, null);
                    this.util.incrementNextFileIndex();
                    this.util.setCurrentFile(fileInstance);
                    this.util.addFileInstance(fileInstance);
                    this.parseFileInstance(file, fileInstance, rfProject, documentContent, libraryName, incremental, languageSyntax);
                } else {
                    for (PSSFileInstance fileInstance : fileInstances) {
                        this.util.setCurrentFile(fileInstance);
                        this.util.removeComments();
                        fileInstance.clearDefines();
                        this.parseFileInstance(file, fileInstance, rfProject, documentContent, libraryName, incremental, languageSyntax);
                    }
                }
            } else {
                PSSFileInstance fileInstance = new PSSFileInstance(rfProject, parserPath, fileIndex, invocNumber, null);
                this.util.incrementNextFileIndex();
                this.util.setCurrentFile(fileInstance);
                this.util.addFileInstance(fileInstance);
                this.parseFileInstance(file, fileInstance, rfProject, documentContent, libraryName, incremental, languageSyntax);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return this.util.getNextFileIndex();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseFileInstance(File file, PSSFileInstance fileInstance, RfProject rfProject, String documentContent, String libraryName, boolean incremental, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        PSSLexer lexer;
        ParserPath parserPath;
        block20: {
            parserPath = fileInstance.getParserPath();
            lexer = null;
            int fileIndex = -1;
            try {
                Throwable throwable = null;
                Object var12_18 = null;
                try {
                    InputStream inputStream = this.getInputStream(file, documentContent);
                    try {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                            lexer = new PSSLexer(reader);
                            lexer.compiler = this;
                            lexer.libraryName = libraryName;
                            lexer.util = this.util;
                            lexer.setFilename(rfProject, parserPath, incremental);
                            lexer.fileInstance = fileInstance;
                            lexer.lS = new PSSLexerStack(lexer, this.util);
                            PSSParser parser = new PSSParser(lexer.lS);
                            parser.setFilename(parserPath.toString());
                            parser.setASTNodeClass(EAST.class);
                            parser.util = this.util;
                            parser.rfp = rfProject;
                            RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
                            fileIndex = fileDef == null ? -1 : fileDef.getIndex();
                            parser.model();
                            if (fileDef != null) {
                                fileDef.getParserPath().setMd5(((MD5InputStream)inputStream).getMD5());
                                fileDef.getParserPath().setSize(file.length());
                            }
                            this.fileAST = parser.getAST();
                        }
                        if (inputStream == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (TokenStreamRecognitionException e) {
                this.util.reportError("*** Error: ", e.recog.getFilename(), this.util.getLanguageSyntax(), e.recog.getLine(), e.recog.getOffset(), e.recog.getLength(), e.recog.getMessage(), fileIndex);
            }
            catch (RecognitionException e) {
                this.util.reportError("*** Error: ", e.getFilename(), this.util.getLanguageSyntax(), e.getLine(), e.getOffset(), e.getLength(), e.getMessage(), fileIndex);
            }
            catch (TokenStreamException e) {
                if (!e.getMessage().equals("INTERRUPT")) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        int nofRawLines = lexer == null ? 0 : lexer.getLine();
        this.util.notifyParsingListeners(new PSSLoadedInfo(parserPath, this.util, languageSyntax, nofRawLines, this.fileAST));
        if (this.parsingInstanceListener == null) return;
        this.parsingInstanceListener.notifyInstanceParsing(fileInstance, this);
    }

    private InputStream getInputStream(File file, String documentContent) throws NoSuchAlgorithmException, IOException {
        MD5InputStream inputStream;
        if (documentContent != null) {
            byte[] bytevals = documentContent.getBytes();
            ByteArrayInputStream byteis = new ByteArrayInputStream(bytevals);
            inputStream = new MD5InputStream((InputStream)new BufferedInputStream(byteis), file);
        } else {
            inputStream = new MD5InputStream(FileInputStreamUtils.createStream((File)file), file);
        }
        return inputStream;
    }

    public void addParsingInstanceListener(IPSSModule pssModule) {
        this.parsingInstanceListener = pssModule;
    }

    public void removeParsingInstanceListener(IPSSModule pssModule) {
        this.parsingInstanceListener = null;
    }

    public List<PSSProblem> getErrors(ParserPath parserPath) {
        Set<PSSProblem> problems = this.util.getErrors(parserPath);
        if (problems == null) {
            return null;
        }
        ArrayList<PSSProblem> result = new ArrayList<PSSProblem>(problems.size());
        result.addAll(problems);
        return result;
    }

    public List<PSSProblem> getWarnings(ParserPath parserPath) {
        Set<PSSProblem> problems = this.util.getWarnings(parserPath);
        if (problems == null) {
            return null;
        }
        ArrayList<PSSProblem> result = new ArrayList<PSSProblem>(problems.size());
        result.addAll(problems);
        return result;
    }

    public AST getFileAST() {
        return this.fileAST;
    }

    public final List<TaskInfoWrapper> getTasks(ParserPath parserPath) {
        List<TaskInfoWrapper> taskInfoWrappers = this.util.getTasks(parserPath);
        if (taskInfoWrappers == null) {
            return null;
        }
        ArrayList<TaskInfoWrapper> result = new ArrayList<TaskInfoWrapper>(taskInfoWrappers.size());
        result.addAll(taskInfoWrappers);
        return result;
    }

    public boolean isEncrypted(ParserPath parserPath) {
        return this.util.isEncrypted(parserPath);
    }

    public Map<ParserPath, Set<PSSProblem>> getErrorsMap() {
        return this.util.getErrorsMap();
    }

    public Map<ParserPath, Set<PSSProblem>> getWarningsMap() {
        return this.util.getWarningsMap();
    }

    public Map<ParserPath, List<TaskInfoWrapper>> getTasksMap() {
        return this.util.getTasksMap();
    }

    public void interrupt() {
        this.util.setInterrupt(true);
    }

    public boolean isInterrupted() {
        return this.util.getInterrupt();
    }

    protected boolean hasParsingListeners() {
        return !this.util.parsingListeners.isEmpty();
    }

    public void addParsingListener(IParsingListener l) {
        this.util.parsingListeners.add(l);
    }

    public void removeParsingListener(IParsingListener l) {
        this.util.parsingListeners.remove(l);
    }

    public void resetInterrupt() {
        this.util.setInterrupt(false);
    }
}

