/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.parser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.parser.PSSFileInstance;

public class PSSFileInstancesMap
implements Serializable {
    private static final long serialVersionUID = 7L;
    private Map<ParserPath, List<PSSFileInstance>> fFileInstancesMap = new LinkedHashMap<ParserPath, List<PSSFileInstance>>();

    public PSSFileInstancesMap(RfProject rfProject) {
    }

    public void addFileInstance(PSSFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        List<PSSFileInstance> fileInstances = this.fFileInstancesMap.get(parserPath);
        if (fileInstances == null) {
            fileInstances = new ArrayList<PSSFileInstance>();
            this.fFileInstancesMap.put(parserPath, fileInstances);
        }
        fileInstances.add(fileInstance);
    }

    protected Map<ParserPath, List<PSSFileInstance>> getFileInstances() {
        return this.fFileInstancesMap;
    }

    public List<PSSFileInstance> getFileInstances(ParserPath parserPath) {
        if (this.fFileInstancesMap == null) {
            return Collections.emptyList();
        }
        return this.fFileInstancesMap.get(parserPath);
    }

    public final void clear() {
        if (this.fFileInstancesMap != null) {
            this.fFileInstancesMap.clear();
        }
    }

    public final void cleanAllComments(boolean recursive) {
        if (this.fFileInstancesMap == null || this.fFileInstancesMap.isEmpty()) {
            return;
        }
        for (List<PSSFileInstance> fileInstances : this.fFileInstancesMap.values()) {
            for (PSSFileInstance fileInstance : fileInstances) {
                fileInstance.cleanAllComments();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void deepClean() {
        if (this.fFileInstancesMap == null || this.fFileInstancesMap.isEmpty()) {
            return;
        }
        for (List<PSSFileInstance> fileInstances : this.fFileInstancesMap.values()) {
            for (PSSFileInstance fileInstance : fileInstances) {
                fileInstance.deepClean();
            }
        }
    }
}

