/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.parser;

import antlr.ANTLRHashString;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.CharScanner;
import antlr.CharStreamException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.MD5InputStream;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.parser.DVTCustomToken;
import ro.amiq.pssdt.parser.PSSCompiler;
import ro.amiq.pssdt.parser.PSSFileInstance;
import ro.amiq.pssdt.parser.PSSLexerStack;
import ro.amiq.pssdt.parser.PSSLexerTokenTypes;
import ro.amiq.pssdt.parser.PSSStartedInfo;
import ro.amiq.pssdt.parser.PSSUtil;
import ro.amiq.pssdt.utils.Utils;

public class PSSLexer
extends CharScanner
implements PSSLexerTokenTypes,
TokenStream {
    protected RfProject rfp;
    protected PSSLexerStack lS;
    protected PSSUtil util;
    protected ParserPath parserPath;
    protected int fileIndex;
    protected IIdentifierIndexerExtension indexer;
    protected InputStream inputStream;
    protected Reader reader;
    protected boolean incremental;
    protected boolean interrupt;
    protected boolean enableMustache;
    protected PSSFileInstance fileInstance;
    protected PSSCompiler compiler;
    protected String libraryName;
    protected boolean skipTokens;
    private LineInfo ifLine;
    private LineInfo elseLine;
    public static final BitSet _tokenSet_0 = new BitSet(PSSLexer.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(PSSLexer.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(PSSLexer.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(PSSLexer.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(PSSLexer.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(PSSLexer.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(PSSLexer.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(PSSLexer.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(PSSLexer.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(PSSLexer.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(PSSLexer.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(PSSLexer.mk_tokenSet_11());

    protected IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return PSSUtil.getDefaultLanguageSyntax();
    }

    protected void setRfProject(RfProject project) {
        this.rfp = project;
    }

    public void setTokenObjectClass(String cl) {
        this.tokenObjectClass = DVTCustomToken.class;
    }

    public void reportError(RecognitionException ex) {
        this.reportError("*** Error: ", ex.getFilename(), ex.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
    }

    protected void reportError(String severity, String fileName, int line, int offset, int length, String message) {
        this.reportError(severity, fileName, line, offset, length, message, null);
    }

    protected void reportError(String severity, String fileName, int line, int offset, int length, String message, Map<String, Object> attributes) {
        this.util.reportError(severity, fileName, this.getLanguageSyntax(), line, offset, length, message, this.fileIndex, attributes);
    }

    public final void uponEOF() throws TokenStreamException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setTabSize(int size) {
        DVTLogger.INSTANCE.logError("setTabSize() is not called in all the constructors so we override tab()");
        throw new RuntimeException("setTabSize() is not called in all the constructors so we override tab()");
    }

    public void tab() {
        int c = this.getColumn();
        this.setColumn(c + 1);
    }

    protected PSSLexer(Reader in, Map<ANTLRHashString, Integer> literals) {
        super(new LexerSharedInputState((InputBuffer)new CharBuffer(in)));
        this.reader = in;
        this.caseSensitiveLiterals = true;
        this.setCaseSensitive(true);
        this.literals = literals;
    }

    protected PSSLexer(InputStream in, Map<ANTLRHashString, Integer> literals) {
        this(new InputStreamReader(in), literals);
        this.inputStream = in;
    }

    private String appendWS(String text) {
        return String.valueOf(text) + '\ufff0';
    }

    private final boolean isKeyword(int minLen) throws CharStreamException {
        char[] cbuf = new char[16];
        char ch = '\u0000';
        int length = 0;
        int i = 0;
        while (i < 15) {
            ch = this.LA(i + 1);
            if (ch == '_' || !Character.isJavaIdentifierStart(ch)) break;
            cbuf[i] = ch;
            ++length;
            ++i;
        }
        if (length < minLen) {
            return false;
        }
        this.hashString.setBuffer(cbuf, length);
        Integer literalsIndex = (Integer)this.literals.get(this.hashString);
        return literalsIndex != null;
    }

    public void setFilename(RfProject rfProject, ParserPath parserPath, boolean incremental) {
        this.setFilename(parserPath.toString());
        this.parserPath = parserPath;
        this.rfp = rfProject;
        this.incremental = incremental;
        if (rfProject != null) {
            this.indexer = Utils.getIndexer(rfProject.getProject());
            if (this.indexer != null) {
                this.indexer.startFile(parserPath.toString(), incremental);
            }
        }
    }

    public void userExceptionHandler(Exception ex) throws RecognitionException, CharStreamException, TokenStreamException {
        if (ex instanceof RecognitionException) {
            throw (RecognitionException)((Object)ex);
        }
        if (ex instanceof CharStreamException) {
            throw (CharStreamException)ex;
        }
        if (ex instanceof TokenStreamException) {
            throw (TokenStreamException)((Object)ex);
        }
        DVTLogger.INSTANCE.logError((Throwable)ex);
    }

    private String getFirstIdentifier(String trimmedText) {
        if (trimmedText == null || trimmedText.isEmpty()) {
            return null;
        }
        int length = trimmedText.length();
        int index = 0;
        char ch = '\u0000';
        while (index < length && (ch = trimmedText.charAt(index)) != '@' && !Character.isJavaIdentifierPart(ch)) {
            ++index;
        }
        StringBuilder sb = new StringBuilder();
        int i = index;
        while (i < length) {
            ch = trimmedText.charAt(i);
            if (!Character.isJavaIdentifierPart(ch) && (i != 0 || ch != '@')) break;
            sb.append(ch);
            ++i;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public void setInterrupt() {
        this.interrupt = true;
    }

    public Token nextTokenCustom() throws TokenStreamException {
        if (this.interrupt) {
            this.uponEOF();
            return this.makeToken(1);
        }
        PSSFileInstance fileInstance = this.util.getCurrentFileInstance();
        DVTCustomToken result = (DVTCustomToken)this.nextToken();
        while (this.skipTokens && result.getType() != 1) {
            result = (DVTCustomToken)this.nextToken();
        }
        if (result != null && fileInstance != null) {
            result.setFileInstance(fileInstance);
        }
        if (result != null && result.getType() != 1) {
            this.util.nextTokenLine(this.getLine(), false);
        }
        return result;
    }

    private String getTrimmedText(String text, int[] offsets) {
        int startIndex = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (!Character.isWhitespace(ch)) break;
            ++startIndex;
            ++i;
        }
        int endIndex = length;
        int i2 = length - 1;
        while (i2 > startIndex) {
            char ch = text.charAt(i2);
            if (!Character.isWhitespace(ch)) break;
            --endIndex;
            --i2;
        }
        if (offsets != null && offsets.length == 2) {
            offsets[0] = offsets[0] + startIndex;
            offsets[1] = offsets[1] - (length - endIndex);
        }
        return text.substring(startIndex, endIndex);
    }

    private LineInfo getLineInfo(Token t) throws TokenStreamException {
        if (t == null) {
            return new LineInfo(this.getLine(), this.getOffset(), -1);
        }
        return new LineInfo(t.getLine(), t.getOffset(), -1);
    }

    private LineInfo getLineInfo() throws TokenStreamException {
        return new LineInfo(this.getLine(), this.getOffset(), -1);
    }

    public final void newline() {
        super.newline();
        this.util.newLine(this.getLine());
    }

    public byte[] getMD5() {
        if (!(this.inputStream instanceof MD5InputStream)) {
            return null;
        }
        try {
            return ((MD5InputStream)this.inputStream).getMD5();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public PSSLexer(InputStream in) {
        this((InputBuffer)new ByteBuffer(in));
    }

    public PSSLexer(Reader in) {
        this((InputBuffer)new CharBuffer(in));
    }

    public PSSLexer(InputBuffer ib) {
        this(new LexerSharedInputState(ib));
    }

    public PSSLexer(LexerSharedInputState state) {
        super(state);
        this.caseSensitiveLiterals = true;
        this.setCaseSensitive(true);
        this.literals = new HashMap();
        this.literals.put(new ANTLRHashString("join_first", (CharScanner)this), 116);
        this.literals.put(new ANTLRHashString("abstract", (CharScanner)this), 4);
        this.literals.put(new ANTLRHashString("void", (CharScanner)this), 101);
        this.literals.put(new ANTLRHashString("activity", (CharScanner)this), 6);
        this.literals.put(new ANTLRHashString("static", (CharScanner)this), 89);
        this.literals.put(new ANTLRHashString("with", (CharScanner)this), 103);
        this.literals.put(new ANTLRHashString("join_branch", (CharScanner)this), 113);
        this.literals.put(new ANTLRHashString("ref", (CharScanner)this), 76);
        this.literals.put(new ANTLRHashString("pure", (CharScanner)this), 73);
        this.literals.put(new ANTLRHashString("import", (CharScanner)this), 48);
        this.literals.put(new ANTLRHashString("break", (CharScanner)this), 106);
        this.literals.put(new ANTLRHashString("stream", (CharScanner)this), 90);
        this.literals.put(new ANTLRHashString("init", (CharScanner)this), 50);
        this.literals.put(new ANTLRHashString("coverpoint", (CharScanner)this), 23);
        this.literals.put(new ANTLRHashString("continue", (CharScanner)this), 107);
        this.literals.put(new ANTLRHashString("run_end", (CharScanner)this), 80);
        this.literals.put(new ANTLRHashString("dist", (CharScanner)this), 28);
        this.literals.put(new ANTLRHashString("else", (CharScanner)this), 31);
        this.literals.put(new ANTLRHashString("init_down", (CharScanner)this), 52);
        this.literals.put(new ANTLRHashString("as", (CharScanner)this), 7);
        this.literals.put(new ANTLRHashString("__DVT__STATIC__CONST__OVERRIDE__", (CharScanner)this), 104);
        this.literals.put(new ANTLRHashString("typedef", (CharScanner)this), 99);
        this.literals.put(new ANTLRHashString("float32", (CharScanner)this), 38);
        this.literals.put(new ANTLRHashString("bind", (CharScanner)this), 10);
        this.literals.put(new ANTLRHashString("forall", (CharScanner)this), 105);
        this.literals.put(new ANTLRHashString("foreach", (CharScanner)this), 40);
        this.literals.put(new ANTLRHashString("memory", (CharScanner)this), 59);
        this.literals.put(new ANTLRHashString("private", (CharScanner)this), 70);
        this.literals.put(new ANTLRHashString("unique", (CharScanner)this), 100);
        this.literals.put(new ANTLRHashString("instance", (CharScanner)this), 55);
        this.literals.put(new ANTLRHashString("function", (CharScanner)this), 41);
        this.literals.put(new ANTLRHashString("pre_solve", (CharScanner)this), 69);
        this.literals.put(new ANTLRHashString("float64", (CharScanner)this), 39);
        this.literals.put(new ANTLRHashString("soft", (CharScanner)this), 87);
        this.literals.put(new ANTLRHashString("extend", (CharScanner)this), 35);
        this.literals.put(new ANTLRHashString("state", (CharScanner)this), 88);
        this.literals.put(new ANTLRHashString("in", (CharScanner)this), 49);
        this.literals.put(new ANTLRHashString("file", (CharScanner)this), 37);
        this.literals.put(new ANTLRHashString("iff", (CharScanner)this), 45);
        this.literals.put(new ANTLRHashString("dynamic", (CharScanner)this), 30);
        this.literals.put(new ANTLRHashString("declaration", (CharScanner)this), 25);
        this.literals.put(new ANTLRHashString("schedule", (CharScanner)this), 82);
        this.literals.put(new ANTLRHashString("target", (CharScanner)this), 95);
        this.literals.put(new ANTLRHashString("component", (CharScanner)this), 19);
        this.literals.put(new ANTLRHashString("null", (CharScanner)this), 60);
        this.literals.put(new ANTLRHashString("join_select", (CharScanner)this), 114);
        this.literals.put(new ANTLRHashString("init_up", (CharScanner)this), 51);
        this.literals.put(new ANTLRHashString("disable", (CharScanner)this), 27);
        this.literals.put(new ANTLRHashString("before", (CharScanner)this), 9);
        this.literals.put(new ANTLRHashString("chandle", (CharScanner)this), 16);
        this.literals.put(new ANTLRHashString("public", (CharScanner)this), 72);
        this.literals.put(new ANTLRHashString("compile", (CharScanner)this), 18);
        this.literals.put(new ANTLRHashString("repeat", (CharScanner)this), 77);
        this.literals.put(new ANTLRHashString("type_option", (CharScanner)this), 98);
        this.literals.put(new ANTLRHashString("false", (CharScanner)this), 36);
        this.literals.put(new ANTLRHashString("buffer", (CharScanner)this), 15);
        this.literals.put(new ANTLRHashString("sequence", (CharScanner)this), 84);
        this.literals.put(new ANTLRHashString("covergroup", (CharScanner)this), 22);
        this.literals.put(new ANTLRHashString("export", (CharScanner)this), 34);
        this.literals.put(new ANTLRHashString("inout", (CharScanner)this), 53);
        this.literals.put(new ANTLRHashString("output", (CharScanner)this), 62);
        this.literals.put(new ANTLRHashString("true", (CharScanner)this), 96);
        this.literals.put(new ANTLRHashString("bool", (CharScanner)this), 14);
        this.literals.put(new ANTLRHashString("bins", (CharScanner)this), 11);
        this.literals.put(new ANTLRHashString("do", (CharScanner)this), 29);
        this.literals.put(new ANTLRHashString("list", (CharScanner)this), 110);
        this.literals.put(new ANTLRHashString("ignore_bins", (CharScanner)this), 46);
        this.literals.put(new ANTLRHashString("pool", (CharScanner)this), 66);
        this.literals.put(new ANTLRHashString("action", (CharScanner)this), 5);
        this.literals.put(new ANTLRHashString("override", (CharScanner)this), 63);
        this.literals.put(new ANTLRHashString("enum", (CharScanner)this), 32);
        this.literals.put(new ANTLRHashString("set", (CharScanner)this), 112);
        this.literals.put(new ANTLRHashString("parallel", (CharScanner)this), 65);
        this.literals.put(new ANTLRHashString("protected", (CharScanner)this), 71);
        this.literals.put(new ANTLRHashString("run_start", (CharScanner)this), 81);
        this.literals.put(new ANTLRHashString("cross", (CharScanner)this), 24);
        this.literals.put(new ANTLRHashString("if", (CharScanner)this), 44);
        this.literals.put(new ANTLRHashString("resource", (CharScanner)this), 79);
        this.literals.put(new ANTLRHashString("exec", (CharScanner)this), 33);
        this.literals.put(new ANTLRHashString("post_solve", (CharScanner)this), 68);
        this.literals.put(new ANTLRHashString("const", (CharScanner)this), 20);
        this.literals.put(new ANTLRHashString("share", (CharScanner)this), 85);
        this.literals.put(new ANTLRHashString("string", (CharScanner)this), 91);
        this.literals.put(new ANTLRHashString("input", (CharScanner)this), 54);
        this.literals.put(new ANTLRHashString("return", (CharScanner)this), 108);
        this.literals.put(new ANTLRHashString("match", (CharScanner)this), 58);
        this.literals.put(new ANTLRHashString("illegal_bins", (CharScanner)this), 47);
        this.literals.put(new ANTLRHashString("default", (CharScanner)this), 26);
        this.literals.put(new ANTLRHashString("array", (CharScanner)this), 109);
        this.literals.put(new ANTLRHashString("symbol", (CharScanner)this), 94);
        this.literals.put(new ANTLRHashString("post_activity", (CharScanner)this), 67);
        this.literals.put(new ANTLRHashString("assert", (CharScanner)this), 8);
        this.literals.put(new ANTLRHashString("int", (CharScanner)this), 56);
        this.literals.put(new ANTLRHashString("constraint", (CharScanner)this), 21);
        this.literals.put(new ANTLRHashString("rand", (CharScanner)this), 74);
        this.literals.put(new ANTLRHashString("body", (CharScanner)this), 13);
        this.literals.put(new ANTLRHashString("randomize", (CharScanner)this), 75);
        this.literals.put(new ANTLRHashString("class", (CharScanner)this), 17);
        this.literals.put(new ANTLRHashString("struct", (CharScanner)this), 92);
        this.literals.put(new ANTLRHashString("select", (CharScanner)this), 83);
        this.literals.put(new ANTLRHashString("map", (CharScanner)this), 111);
        this.literals.put(new ANTLRHashString("while", (CharScanner)this), 102);
        this.literals.put(new ANTLRHashString("option", (CharScanner)this), 61);
        this.literals.put(new ANTLRHashString("package", (CharScanner)this), 64);
        this.literals.put(new ANTLRHashString("join_none", (CharScanner)this), 115);
        this.literals.put(new ANTLRHashString("super", (CharScanner)this), 93);
        this.literals.put(new ANTLRHashString("solve", (CharScanner)this), 86);
        this.literals.put(new ANTLRHashString("type", (CharScanner)this), 97);
        this.literals.put(new ANTLRHashString("bit", (CharScanner)this), 12);
        this.literals.put(new ANTLRHashString("lock", (CharScanner)this), 57);
        this.literals.put(new ANTLRHashString("has", (CharScanner)this), 42);
        this.literals.put(new ANTLRHashString("replicate", (CharScanner)this), 78);
        this.literals.put(new ANTLRHashString("header", (CharScanner)this), 43);
    }

    /*
     * Exception decompiling
     */
    public Token nextToken() throws TokenStreamException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void mINVALID_CHARS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int adjust;
        int offset;
        int line;
        int _ttype;
        int _begin;
        Token _token;
        block29: {
            _token = null;
            _begin = this.text.length();
            _ttype = 217;
            CharScanner.UserMark userMark = null;
            line = this.getLine();
            offset = this.getOffset();
            adjust = 0;
            this.mINVALID_CHAR(false);
            if (this.LA(1) >= '\u0000' && this.LA(1) <= '\ufffe') {
                int _cnt6 = 0;
                while (true) {
                    boolean synPredMatched5 = false;
                    if (this.LA(1) >= 'a' && this.LA(1) <= 'z') {
                        int _m5 = this.mark();
                        synPredMatched5 = true;
                        this.inputState.incGuessing();
                        try {
                            if (!this.isKeyword(3)) {
                                throw this.getSemanticException(" isKeyword(3) ");
                            }
                            this.mKEYWORD(false);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched5 = false;
                        }
                        this.rewind(_m5);
                        this.inputState.decGuessing(synPredMatched5);
                    }
                    if (synPredMatched5) {
                        if (this.inputState.guessing() == 0) {
                            try {
                                userMark = this.userMark();
                                adjust -= this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mKEYWORD(false);
                        if (this.inputState.guessing() == 0) {
                            try {
                                adjust += this.getOffset();
                                this.userRewind(userMark);
                                break block29;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else if (_tokenSet_2.member((int)this.LA(1))) {
                        this.mVALID_CHAR(false);
                    } else {
                        if (!_tokenSet_1.member((int)this.LA(1))) {
                            if (_cnt6 < 1) {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            break block29;
                        }
                        this.mINVALID_CHAR(false);
                    }
                    ++_cnt6;
                }
            }
            if (this.LA(1) == '\uffff') {
                this.match('\uffff');
            } else {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (this.inputState.guessing() == 0) {
            try {
                String temp = this.getText();
                if (temp != null && adjust > 0 && adjust < temp.length()) {
                    temp = temp.substring(0, temp.length() - adjust);
                }
                if (temp != null && temp.length() > 0) {
                    if (temp.length() == 1) {
                        this.reportError("*** Error: ", this.getFilename(), line, offset, temp.length(), "Unexpected char '" + temp.charAt(0) + "' (code 0x" + Integer.toHexString(temp.charAt(0)).toUpperCase() + ")");
                    } else if (temp.length() > 1) {
                        this.reportError("*** Error: ", this.getFilename(), line, offset, temp.length() - adjust, "Unexpected char sequence (" + temp.length() + " chars) starting with '" + temp.charAt(0) + "' (code 0x" + Integer.toHexString(temp.charAt(0)).toUpperCase() + ")");
                    }
                    _ttype = -1;
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mINVALID_CHAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 221;
        switch (this.LA(1)) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': {
                this.matchRange('\u0000', '\b');
                break;
            }
            case '\u000b': {
                this.match('\u000b');
                break;
            }
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                this.matchRange('\u000e', '\u001f');
                break;
            }
            default: {
                if (this.LA(1) >= '\u007f' && this.LA(1) <= '\ufffe') {
                    this.matchRange('\u007f', '\ufffe');
                    break;
                }
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mKEYWORD(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 220;
        this.matchRange('a', 'z');
        while (this.LA(1) >= 'a' && this.LA(1) <= 'z') {
            this.matchRange('a', 'z');
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mVALID_CHAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 222;
        boolean synPredMatched32 = false;
        if (this.LA(1) == '\r' && this.LA(2) == '\n') {
            int _m32 = this.mark();
            synPredMatched32 = true;
            this.inputState.incGuessing();
            try {
                this.match("\r\n");
            }
            catch (RecognitionException recognitionException) {
                synPredMatched32 = false;
            }
            this.rewind(_m32);
            this.inputState.decGuessing(synPredMatched32);
        }
        if (synPredMatched32) {
            this.match("\r\n");
            if (this.inputState.guessing() == 0) {
                try {
                    this.newline();
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else {
            boolean synPredMatched34 = false;
            if (this.LA(1) == '\r') {
                int _m34 = this.mark();
                synPredMatched34 = true;
                this.inputState.incGuessing();
                try {
                    this.match("\r");
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched34 = false;
                }
                this.rewind(_m34);
                this.inputState.decGuessing(synPredMatched34);
            }
            if (synPredMatched34) {
                this.match("\r");
                if (this.inputState.guessing() == 0) {
                    try {
                        this.newline();
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
            } else {
                boolean synPredMatched36 = false;
                if (this.LA(1) == '\n') {
                    int _m36 = this.mark();
                    synPredMatched36 = true;
                    this.inputState.incGuessing();
                    try {
                        this.match("\n");
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched36 = false;
                    }
                    this.rewind(_m36);
                    this.inputState.decGuessing(synPredMatched36);
                }
                if (synPredMatched36) {
                    this.match("\n");
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else if (_tokenSet_2.member((int)this.LA(1))) {
                    this.match(_tokenSet_2);
                } else {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPREPROCESSOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 218;
        if (!this.util.isCpreprocEnabled()) {
            throw this.getSemanticException(" util.isCpreprocEnabled() ");
        }
        boolean synPredMatched12 = false;
        if (this.LA(1) == '#' && this.LA(2) == 'i' && this.LA(3) == 'f') {
            int _m12 = this.mark();
            synPredMatched12 = true;
            this.inputState.incGuessing();
            try {
                this.match("#ifdef");
                this.mDEFINE_WS(false);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched12 = false;
            }
            this.rewind(_m12);
            this.inputState.decGuessing(synPredMatched12);
        }
        if (synPredMatched12) {
            this.mC_IFDEF(false);
            if (this.inputState.guessing() == 0) {
                try {
                    _ttype = -1;
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else {
            boolean synPredMatched14 = false;
            if (this.LA(1) == '#' && this.LA(2) == 'i' && this.LA(3) == 'f') {
                int _m14 = this.mark();
                synPredMatched14 = true;
                this.inputState.incGuessing();
                try {
                    this.match("#ifndef");
                    this.mDEFINE_WS(false);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched14 = false;
                }
                this.rewind(_m14);
                this.inputState.decGuessing(synPredMatched14);
            }
            if (synPredMatched14) {
                this.mC_IFNDEF(false);
                if (this.inputState.guessing() == 0) {
                    try {
                        _ttype = -1;
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
            } else {
                boolean synPredMatched17 = false;
                if (this.LA(1) == '#' && this.LA(2) == 'e' && this.LA(3) == 'l') {
                    int _m17 = this.mark();
                    synPredMatched17 = true;
                    this.inputState.incGuessing();
                    try {
                        this.match("#else");
                        switch (this.LA(1)) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                this.mWS(false);
                                break;
                            }
                            case '/': {
                                this.match("//");
                                break;
                            }
                            default: {
                                if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                        }
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched17 = false;
                    }
                    this.rewind(_m17);
                    this.inputState.decGuessing(synPredMatched17);
                }
                if (synPredMatched17) {
                    this.mC_ELSE_DEF(false);
                    if (this.inputState.guessing() == 0) {
                        try {
                            _ttype = -1;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else {
                    boolean synPredMatched19 = false;
                    if (this.LA(1) == '#' && this.LA(2) == 'i' && this.LA(3) == 'n') {
                        int _m19 = this.mark();
                        synPredMatched19 = true;
                        this.inputState.incGuessing();
                        try {
                            this.match("#include");
                            this.mDEFINE_WS(false);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched19 = false;
                        }
                        this.rewind(_m19);
                        this.inputState.decGuessing(synPredMatched19);
                    }
                    if (synPredMatched19) {
                        this.mC_INCLUDE(false);
                        if (this.inputState.guessing() == 0) {
                            try {
                                _ttype = 218;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else {
                        boolean synPredMatched22 = false;
                        if (this.LA(1) == '#' && this.LA(2) == 'e' && this.LA(3) == 'n') {
                            int _m22 = this.mark();
                            synPredMatched22 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("#endif");
                                if (this.LA(1) != '\uffff' && Character.isJavaIdentifierPart(this.LA(1))) {
                                    throw this.getSemanticException(" LA(1) == EOF_CHAR || !Character.isJavaIdentifierPart(LA(1)) ");
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched22 = false;
                            }
                            this.rewind(_m22);
                            this.inputState.decGuessing(synPredMatched22);
                        }
                        if (synPredMatched22) {
                            this.mC_ENDIF_DEF(false);
                            if (this.inputState.guessing() == 0) {
                                try {
                                    _ttype = -1;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else {
                            boolean synPredMatched10 = false;
                            if (this.LA(1) == '#' && this.LA(2) == 'd') {
                                int _m10 = this.mark();
                                synPredMatched10 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match("#define");
                                    this.mDEFINE_WS(false);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched10 = false;
                                }
                                this.rewind(_m10);
                                this.inputState.decGuessing(synPredMatched10);
                            }
                            if (synPredMatched10) {
                                this.mC_DEFINE_DEFINITION(false);
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        _ttype = -1;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                    }
                }
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_WS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 219;
        switch (this.LA(1)) {
            case ' ': {
                this.match(' ');
                break;
            }
            case '\t': {
                this.match('\t');
                break;
            }
            case '\f': {
                this.match('\f');
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_DEFINE_DEFINITION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 291;
        Token id = null;
        int offset = this.getOffset();
        int line = this.getLine();
        this.match("#define");
        int _cnt191 = 0;
        while (true) {
            if (this.LA(1) != '\t' && this.LA(1) != '\f' && this.LA(1) != ' ') {
                if (_cnt191 >= 1) break;
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.mDEFINE_WS(false);
            ++_cnt191;
        }
        if (this.inputState.guessing() == 0) {
            try {
                offset = this.getOffset();
                line = this.getLine();
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        this.mDEFINE_ID(true);
        id = this._returnToken;
        if (this.inputState.guessing() == 0) {
            try {
                boolean hasDefine = this.util.hasDefine(id.getText());
                if (hasDefine) {
                    this.reportError("*** Warning: ", this.getFilename(), line, offset, id.getText().length(), "Macro name '" + id.getText() + "' is already defined");
                } else {
                    this.util.addDefine(id.getText());
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_IFDEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 292;
        Token id = null;
        this.match("#ifdef");
        if (this.inputState.guessing() == 0) {
            try {
                this.ifLine = this.getLineInfo();
                this.elseLine = null;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        int _cnt194 = 0;
        while (true) {
            if (this.LA(1) != '\t' && this.LA(1) != '\f' && this.LA(1) != ' ') {
                if (_cnt194 >= 1) break;
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.mDEFINE_WS(false);
            ++_cnt194;
        }
        this.mDEFINE_ID(true);
        id = this._returnToken;
        if (this.inputState.guessing() == 0) {
            try {
                boolean hasDefine = this.util.hasDefine(id.getText());
                this.skipTokens = !hasDefine;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_IFNDEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 293;
        Token id = null;
        this.match("#ifndef");
        if (this.inputState.guessing() == 0) {
            try {
                this.ifLine = this.getLineInfo();
                this.elseLine = null;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        int _cnt197 = 0;
        while (true) {
            if (this.LA(1) != '\t' && this.LA(1) != '\f' && this.LA(1) != ' ') {
                if (_cnt197 >= 1) break;
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.mDEFINE_WS(false);
            ++_cnt197;
        }
        this.mDEFINE_ID(true);
        id = this._returnToken;
        if (this.inputState.guessing() == 0) {
            try {
                boolean hasDefine;
                this.skipTokens = hasDefine = this.util.hasDefine(id.getText());
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mWS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 223;
        int _cnt41 = 0;
        block14: while (true) {
            switch (this.LA(1)) {
                case ' ': {
                    this.match(' ');
                    break;
                }
                case '\t': {
                    this.match('\t');
                    break;
                }
                case '\f': {
                    this.match('\f');
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) == '\uffff') {
                        this.match("\r\n");
                        this.match('\uffff');
                        break;
                    }
                    if (this.LA(1) == '\r' && this.LA(2) == '\n') {
                        this.match("\r\n");
                        if (this.inputState.guessing() != 0) break;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    if (this.LA(1) == '\r' && this.LA(2) == '\uffff') {
                        this.match('\r');
                        this.match('\uffff');
                        break;
                    }
                    if (this.LA(1) == '\n' && this.LA(2) == '\uffff') {
                        this.match('\n');
                        this.match('\uffff');
                        break;
                    }
                    if (this.LA(1) == '\r') {
                        this.match('\r');
                        if (this.inputState.guessing() != 0) break;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    if (this.LA(1) == '\n') {
                        this.match('\n');
                        if (this.inputState.guessing() != 0) break;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                default: {
                    if (_cnt41 >= 1) break block14;
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            ++_cnt41;
        }
        if (this.inputState.guessing() == 0) {
            try {
                _ttype = -1;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_ELSE_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 294;
        this.match("#else");
        if (this.inputState.guessing() == 0) {
            try {
                this.elseLine = this.getLineInfo();
                this.skipTokens = !this.skipTokens;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_INCLUDE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block17: {
            _token = null;
            _begin = this.text.length();
            _ttype = 296;
            Token f = null;
            int offset = this.getOffset();
            int line = this.getLine();
            this.match("#include");
            int _cnt202 = 0;
            while (true) {
                if (this.LA(1) != '\t' && this.LA(1) != '\f' && this.LA(1) != ' ') {
                    if (_cnt202 >= 1) break;
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                this.mDEFINE_WS(false);
                ++_cnt202;
            }
            if (this.inputState.guessing() == 0) {
                try {
                    offset = this.getOffset();
                    line = this.getLine();
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
            this.mDOUBLE_QUOTED_STRING(true);
            f = this._returnToken;
            if (this.inputState.guessing() == 0) {
                try {
                    if (this.skipTokens) break block17;
                    String fileName = f.getText().trim();
                    fileName = fileName.substring(1, fileName.length() - 1);
                    if (this.util.isEnableIncludeEnvVarExpansion()) {
                        fileName = this.util.replaceAllSystemVariables(fileName);
                    }
                    File file = new File(fileName);
                    String fullFileName = fileName;
                    boolean fileExists = false;
                    if (!file.isAbsolute()) {
                        fullFileName = String.valueOf(new File(this.parserPath.path).getParent()) + File.separator + fileName;
                        file = new File(fullFileName);
                        fileExists = this.util.isFile(file);
                    } else {
                        file = new File(fullFileName);
                        fileExists = this.util.isFile(file);
                    }
                    if (!fileExists) {
                        this.reportError("*** Error: ", this.getFilename(), line, offset, fileName.length() + 2, "Cannot open #include file \"" + fileName + "\"");
                        break block17;
                    }
                    if (!this.incremental) {
                        try {
                            ParserPath parserPath = new ParserPath(file.getAbsolutePath());
                            this.util.notifyParsingListeners(new PSSStartedInfo(parserPath));
                            PSSFileInstance fileInstance = new PSSFileInstance(this.rfp, parserPath, this.util.getNextFileIndex(), 0, null);
                            this.util.incrementNextFileIndex();
                            this.util.setCurrentFile(fileInstance);
                            this.util.addFileInstance(fileInstance);
                            this.compiler.parseFileInstance(file, fileInstance, this.rfp, null, this.libraryName, false, IBuildConfigParserConstants.LanguageSyntax.PSS);
                            break block17;
                        }
                        finally {
                            this.util.setCurrentFile(this.fileInstance);
                        }
                    }
                    this.util.restoreIncludedFile(fullFileName, this.getLine(), this.getOffset());
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_ENDIF_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 295;
        this.match("#endif");
        if (this.inputState.guessing() == 0) {
            try {
                this.rfp.addInactiveCode(true, this.skipTokens, this.ifLine, this.elseLine == null ? this.getLineInfo() : this.elseLine, this.getLineInfo(), this.parserPath);
                this.skipTokens = false;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSL_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _saveIndex;
        int offset;
        int startLine;
        int _ttype;
        int _begin;
        Token _token;
        block23: {
            _token = null;
            _begin = this.text.length();
            _ttype = 224;
            startLine = this.getLine();
            offset = this.getOffset() + 2;
            _saveIndex = this.text.length();
            this.match("//");
            this.text.setLength(_saveIndex);
            if (this.LA(1) >= '\u0000' && this.LA(1) <= '\uffff' && !this.util.isOSX()) {
                while (true) {
                    boolean synPredMatched47 = false;
                    if (this.LA(1) == '\r' && _tokenSet_3.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                        int _m47 = this.mark();
                        synPredMatched47 = true;
                        this.inputState.incGuessing();
                        try {
                            this.match('\r');
                            this.match(_tokenSet_3);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched47 = false;
                        }
                        this.rewind(_m47);
                        this.inputState.decGuessing(synPredMatched47);
                    }
                    if (synPredMatched47) {
                        this.match('\r');
                        if (this.inputState.guessing() == 0) {
                            try {
                                this.newline();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.match(_tokenSet_3);
                        continue;
                    }
                    if (_tokenSet_4.member((int)this.LA(1))) {
                        this.match(_tokenSet_4);
                        continue;
                    }
                    break block23;
                    break;
                }
            }
            if (this.LA(1) >= '\u0000' && this.LA(1) <= '\uffff' && this.util.isOSX()) {
                while (_tokenSet_4.member((int)this.LA(1))) {
                    this.match(_tokenSet_4);
                }
            } else {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        switch (this.LA(1)) {
            case '\n': {
                this.match('\n');
                break;
            }
            case '\uffff': {
                _saveIndex = this.text.length();
                this.match('\uffff');
                this.text.setLength(_saveIndex);
                break;
            }
            default: {
                if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                    this.match("\r\n");
                    break;
                }
                if (this.LA(1) == '\r' && this.util.isOSX()) {
                    this.match('\r');
                    break;
                }
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (this.inputState.guessing() == 0) {
            try {
                _ttype = -1;
                int[] offsets = new int[]{offset, this.getOffset()};
                String rawComment = this.getText();
                String comment = this.getTrimmedText(this.getText(), offsets);
                String firstIdentifier = this.getFirstIdentifier(comment);
                this.util.collectTaskTag(firstIdentifier, comment, startLine, offsets[0], offsets[1], this.parserPath);
                this.util.addComment(new Comment(Comment.CommentStyle.SL_KIND, this.getLine(), this.getLine(), rawComment, null, 2));
                this.newline();
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mML_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block24: {
            _token = null;
            _begin = this.text.length();
            _ttype = 225;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            int startLine = this.getLine();
            int offset = this.getOffset() + 2;
            try {
                try {
                    int _saveIndex = this.text.length();
                    this.match("/*");
                    this.text.setLength(_saveIndex);
                    while (true) {
                        if (this.LA(1) == '*' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(2) != '/') {
                            this.match('*');
                            continue;
                        }
                        if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            this.match("\r\n");
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                this.newline();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            continue;
                        }
                        if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            this.match('\r');
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                this.newline();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            continue;
                        }
                        if (this.LA(1) == '\n') {
                            this.match('\n');
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                this.newline();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            continue;
                        }
                        if (!_tokenSet_5.member((int)this.LA(1))) break;
                        this.match(_tokenSet_5);
                    }
                    _saveIndex = this.text.length();
                    this.match("*/");
                    this.text.setLength(_saveIndex);
                    if (this.inputState.guessing() == 0) {
                        try {
                            _ttype = -1;
                            int[] offsets = new int[]{offset, this.getOffset()};
                            String rawComment = this.getText();
                            String comment = this.getTrimmedText(this.getText(), offsets);
                            String firstIdentifier = this.getFirstIdentifier(comment);
                            this.util.collectTaskTag(firstIdentifier, comment, startLine, offsets[0], offsets[1], this.parserPath);
                            this.util.addComment(new Comment(Comment.CommentStyle.ML_KIND, startLine, this.getLine(), rawComment, null, 2));
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOMMA(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 226;
        this.match(',');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSEMI(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 227;
        this.match(';');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON_COLON_STAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 228;
        if (this.LA(3) != '*') {
            throw this.getSemanticException(" LA(3) == '*' ");
        }
        this.match("::*");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON_COLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 229;
        if (this.LA(3) == '*') {
            throw this.getSemanticException(" LA(3) != '*' ");
        }
        this.match("::");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLPAREN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 230;
        this.match('(');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRPAREN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 231;
        this.match(')');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLBRACK(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 232;
        this.match('[');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRBRACK(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 233;
        this.match(']');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLCURLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 234;
        this.match('{');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mRCURLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 235;
        this.match('}');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 236;
        this.match("=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 237;
        this.match(":=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON_SLASH(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 238;
        this.match(":/");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 239;
        if (this.LA(3) == '<') {
            throw this.getSemanticException(" LA(3) != '<' ");
        }
        this.match("<<");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPLUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 240;
        this.match('+');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMINUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 241;
        this.match('-');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 242;
        this.match('&');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 243;
        this.match('|');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBXOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 244;
        this.match('^');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBNOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 245;
        this.match('~');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLNOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 246;
        this.match('!');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 247;
        if (this.LA(3) == '&') {
            throw this.getSemanticException(" LA(3) != '&' ");
        }
        this.match("&&");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 248;
        this.match("||");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 249;
        this.match(':');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mQUESTION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 250;
        this.match('?');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 251;
        this.match('<');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mGT_SR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 252;
        if (this.LA(2) != '>' || this.LA(3) == '=') {
            throw this.getSemanticException(" LA(2) == '>' && LA(3) != '=' ");
        }
        this.match('>');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mGT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 253;
        if (this.LA(2) == '>') {
            throw this.getSemanticException(" LA(2) != '>' ");
        }
        this.match('>');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 254;
        this.match("<=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mGE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 255;
        this.match(">=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 256;
        this.match('*');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDIV(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 257;
        this.match('/');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMOD(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 258;
        this.match('%');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mEQUAL_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 259;
        if (this.LA(3) == '=') {
            throw this.getSemanticException(" LA(3) != '=' ");
        }
        this.match("==");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mNOT_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 260;
        if (this.LA(3) == '=') {
            throw this.getSemanticException(" LA(3) != '=' ");
        }
        this.match("!=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 261;
        this.match('.');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDOT_DOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 262;
        if (this.LA(3) == '.') {
            throw this.getSemanticException(" LA(3) != '.' ");
        }
        this.match("..");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDOT_DOT_DOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 263;
        if (this.LA(3) != '.') {
            throw this.getSemanticException(" LA(3) == '.' ");
        }
        this.match("...");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR_STAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 264;
        this.match("**");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPLUS_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 265;
        if (this.LA(3) == '>') {
            throw this.getSemanticException(" LA(3) != '>' ");
        }
        this.match("+=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMINUS_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 266;
        if (this.LA(3) == '>') {
            throw this.getSemanticException(" LA(3) != '>' ");
        }
        this.match("-=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 267;
        this.match("*=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDIV_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 268;
        this.match("/=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMOD_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 269;
        this.match("%=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mAND_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 270;
        this.match("&=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mOR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 271;
        if (this.LA(3) == '>') {
            throw this.getSemanticException(" LA(3) != '>' ");
        }
        this.match("|=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mXOR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 272;
        this.match("^=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSL_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 273;
        if (this.LA(3) != '=') {
            throw this.getSemanticException(" LA(3) == '=' ");
        }
        this.match("<<=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 274;
        if (this.LA(3) != '=') {
            throw this.getSemanticException(" LA(3) == '=' ");
        }
        this.match(">>=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mIMPLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 275;
        this.match("->");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mID(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block31: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block30: {
                _token = null;
                _begin = this.text.length();
                _ttype = 276;
                userMark = null;
                finalRunnable = null;
                int column = this.getColumn();
                int line = this.getLine();
                StringBuilder sb = new StringBuilder();
                try {
                    try {
                        if (this.inputState.guessing() == 0) {
                            try {
                                sb.append(this.LA(1));
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        switch (this.LA(1)) {
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'g': 
                            case 'h': 
                            case 'i': 
                            case 'j': 
                            case 'k': 
                            case 'l': 
                            case 'm': 
                            case 'n': 
                            case 'o': 
                            case 'p': 
                            case 'q': 
                            case 'r': 
                            case 's': 
                            case 't': 
                            case 'u': 
                            case 'v': 
                            case 'w': 
                            case 'x': 
                            case 'y': 
                            case 'z': {
                                this.matchRange('a', 'z');
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'G': 
                            case 'H': 
                            case 'I': 
                            case 'J': 
                            case 'K': 
                            case 'L': 
                            case 'M': 
                            case 'N': 
                            case 'O': 
                            case 'P': 
                            case 'Q': 
                            case 'R': 
                            case 'S': 
                            case 'T': 
                            case 'U': 
                            case 'V': 
                            case 'W': 
                            case 'X': 
                            case 'Y': 
                            case 'Z': {
                                this.matchRange('A', 'Z');
                                break;
                            }
                            case '_': {
                                this.match('_');
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        block21: while (_tokenSet_6.member((int)this.LA(1))) {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    sb.append(this.LA(1));
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            switch (this.LA(1)) {
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': 
                                case 'g': 
                                case 'h': 
                                case 'i': 
                                case 'j': 
                                case 'k': 
                                case 'l': 
                                case 'm': 
                                case 'n': 
                                case 'o': 
                                case 'p': 
                                case 'q': 
                                case 'r': 
                                case 's': 
                                case 't': 
                                case 'u': 
                                case 'v': 
                                case 'w': 
                                case 'x': 
                                case 'y': 
                                case 'z': {
                                    this.matchRange('a', 'z');
                                    continue block21;
                                }
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': 
                                case 'G': 
                                case 'H': 
                                case 'I': 
                                case 'J': 
                                case 'K': 
                                case 'L': 
                                case 'M': 
                                case 'N': 
                                case 'O': 
                                case 'P': 
                                case 'Q': 
                                case 'R': 
                                case 'S': 
                                case 'T': 
                                case 'U': 
                                case 'V': 
                                case 'W': 
                                case 'X': 
                                case 'Y': 
                                case 'Z': {
                                    this.matchRange('A', 'Z');
                                    continue block21;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    this.matchRange('0', '9');
                                    continue block21;
                                }
                                case '_': {
                                    this.match('_');
                                    continue block21;
                                }
                            }
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        if (this.inputState.guessing() != 0) break block30;
                        try {
                            if (this.indexer != null) {
                                this.indexer.index(sb.toString(), line, column, 276, true);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        _ttype = this.testLiteralsTable(_ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mESCAPED_ID(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block34: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block33: {
                _token = null;
                _begin = this.text.length();
                _ttype = 277;
                userMark = null;
                finalRunnable = null;
                int column = this.getColumn();
                int line = this.getLine();
                try {
                    try {
                        this.match('\\');
                        int _cnt117 = 0;
                        while (true) {
                            if (!_tokenSet_7.member((int)this.LA(1))) {
                                if (_cnt117 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.match(_tokenSet_7);
                            ++_cnt117;
                        }
                        switch (this.LA(1)) {
                            case ' ': {
                                this.match(' ');
                                break;
                            }
                            case '\t': {
                                this.match('\t');
                                break;
                            }
                            case '\f': {
                                this.match('\f');
                                break;
                            }
                            case '\n': {
                                this.match('\n');
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    this.newline();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            default: {
                                if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                                    this.match("\r\n");
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        this.newline();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                if (this.LA(1) == '\r') {
                                    this.match('\r');
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        this.newline();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (this.inputState.guessing() != 0) break block33;
                        try {
                            String tmp = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                            int type = 277;
                            String rfName = tmp.length() > 0 ? tmp.substring(1, tmp.length() - 1) : "";
                            tmp = this.appendWS(tmp.trim());
                            this.text.setLength(_begin);
                            this.text.append(tmp);
                            if (this.indexer != null) {
                                this.indexer.index(rfName, line, column, type, true);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            if (this.LA(1) == '\r' && this.LA(2) == '\n') {
                                this.newline();
                                this.consume();
                                this.consume();
                            } else if (this.LA(1) == '\r' || this.LA(1) == '\n') {
                                this.newline();
                                this.consume();
                            } else {
                                this.consume();
                            }
                        } else {
                            throw ex;
                        }
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mWS_OR_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block24: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block23: {
                _token = null;
                _begin = this.text.length();
                _ttype = 278;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        switch (this.LA(1)) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                this.mWS(false);
                                switch (this.LA(1)) {
                                    case '/': {
                                        if (this.LA(1) == '/' && this.LA(2) == '*') {
                                            this.mML_COMMENT(false);
                                        } else if (this.LA(1) == '/' && this.LA(2) == '/') {
                                            this.mSL_COMMENT(false);
                                        } else {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                        this.mWS_OR_COMMENT(false);
                                        break block23;
                                    }
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': 
                                    case '?': 
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': 
                                    case 'X': 
                                    case 'Z': 
                                    case '_': 
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': 
                                    case 'x': 
                                    case 'z': {
                                        break block23;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case '?': 
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'X': 
                            case 'Z': 
                            case '_': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'x': 
                            case 'z': {
                                break;
                            }
                            default: {
                                if (this.LA(1) == '/' && this.LA(2) == '*') {
                                    this.mML_COMMENT(false);
                                    this.mWS_OR_COMMENT(false);
                                    break;
                                }
                                if (this.LA(1) == '/' && this.LA(2) == '/') {
                                    this.mSL_COMMENT(false);
                                    this.mWS_OR_COMMENT(false);
                                    break;
                                }
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mNUMBER_FORMAT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block83: {
            _token = null;
            _begin = this.text.length();
            _ttype = 279;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            Token nfb = null;
            char type = '?';
            char charZ = ' ';
            char charX = ' ';
            char charN = ' ';
            boolean report = true;
            try {
                try {
                    block9 : switch (this.LA(1)) {
                        case '0': {
                            this.match('0');
                            switch (this.LA(1)) {
                                case 'X': 
                                case 'x': {
                                    switch (this.LA(1)) {
                                        case 'x': {
                                            this.match('x');
                                            break;
                                        }
                                        case 'X': {
                                            this.match('X');
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    if (this.inputState.guessing() != 0) break block9;
                                    try {
                                        type = 'h';
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break block9;
                                }
                                case 'B': 
                                case 'b': {
                                    switch (this.LA(1)) {
                                        case 'b': {
                                            this.match('b');
                                            break;
                                        }
                                        case 'B': {
                                            this.match('B');
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    if (this.inputState.guessing() != 0) break block9;
                                    try {
                                        type = 'b';
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break block9;
                                }
                                default: {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                        }
                        case '\'': {
                            this.match('\'');
                            switch (this.LA(1)) {
                                case 'S': 
                                case 's': {
                                    switch (this.LA(1)) {
                                        case 's': {
                                            this.match('s');
                                            break;
                                        }
                                        case 'S': {
                                            this.match('S');
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    if (this.inputState.guessing() != 0) break;
                                    break;
                                }
                                case 'B': 
                                case 'D': 
                                case 'H': 
                                case 'O': 
                                case 'b': 
                                case 'd': 
                                case 'h': 
                                case 'o': {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            switch (this.LA(1)) {
                                case 'D': 
                                case 'd': {
                                    switch (this.LA(1)) {
                                        case 'd': {
                                            this.match('d');
                                            break;
                                        }
                                        case 'D': {
                                            this.match('D');
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        type = 'd';
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case 'B': 
                                case 'b': {
                                    switch (this.LA(1)) {
                                        case 'b': {
                                            this.match('b');
                                            break;
                                        }
                                        case 'B': {
                                            this.match('B');
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        type = 'b';
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case 'H': 
                                case 'h': {
                                    switch (this.LA(1)) {
                                        case 'h': {
                                            this.match('h');
                                            break;
                                        }
                                        case 'H': {
                                            this.match('H');
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        type = 'h';
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case 'O': 
                                case 'o': {
                                    switch (this.LA(1)) {
                                        case 'o': {
                                            this.match('o');
                                            break;
                                        }
                                        case 'O': {
                                            this.match('O');
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        type = 'o';
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            this.mWS_OR_COMMENT(false);
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    int _cnt136 = 0;
                    while (true) {
                        if (!_tokenSet_8.member((int)this.LA(1)) || type == 'd' && this.LA(1) == '?') {
                            if (_cnt136 < 1) {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            break;
                        }
                        this.mNUMBER_FORMAT_DIGIT(true, type);
                        nfb = this._returnToken;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (type == 'd') {
                                    char c = nfb.getText().charAt(0);
                                    if (c == 'x' || c == 'X') {
                                        char c2 = charN != ' ' ? charN : (tc = charZ != ' ' ? charZ : charX);
                                        if (tc != ' ' && report) {
                                            this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Near '" + tc + "': X is not allowed in decimal constants");
                                            report = false;
                                        }
                                        charX = c;
                                    } else if (c == 'z' || c == 'Z' || c == '?') {
                                        char c3 = charN != ' ' ? charN : (tc = charZ != ' ' ? charZ : charX);
                                        if (tc != ' ' && report) {
                                            c = c == 'z' ? (char)'Z' : (char)c;
                                            this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Near '" + tc + "': " + c + " is not allowed in decimal constants");
                                            report = false;
                                        }
                                        charZ = c;
                                    } else if (c >= '\u0000' && c <= '9') {
                                        char c4 = tc = charZ != ' ' ? charZ : charX;
                                        if (tc != ' ' && report) {
                                            this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Near '" + tc + "': " + c + " is not allowed in decimal constants");
                                            report = false;
                                        }
                                        charN = c;
                                    }
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        ++_cnt136;
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block83;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNUMBER_FORMAT_DIGIT(boolean _createToken, char type) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block31: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block30: {
                _token = null;
                _begin = this.text.length();
                _ttype = 289;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        switch (this.LA(1)) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.matchRange('0', '9');
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                this.matchRange('A', 'F');
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                this.matchRange('a', 'f');
                                break;
                            }
                            case '?': {
                                this.match('?');
                                break;
                            }
                            case '_': {
                                this.match('_');
                                break;
                            }
                            case 'z': {
                                this.match('z');
                                break;
                            }
                            case 'Z': {
                                this.match('Z');
                                break;
                            }
                            case 'x': {
                                this.match('x');
                                break;
                            }
                            case 'X': {
                                this.match('X');
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (this.inputState.guessing() != 0) break block30;
                        try {
                            try {
                                String tmp = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                                char c = tmp != null && tmp.length() == 1 ? tmp.charAt(0) : (char)'\u0000';
                                String numberType = null;
                                switch (type) {
                                    case 'd': {
                                        if (c >= '0' && c <= '9' || c == 'z' || c == 'Z' || c == 'x' || c == 'X' || c == '?' || c == '_') break;
                                        numberType = "decimal";
                                        break;
                                    }
                                    case 'b': {
                                        if (c >= '0' && c <= '1' || c == 'z' || c == 'Z' || c == 'x' || c == 'X' || c == '?' || c == '_') break;
                                        numberType = "binary";
                                        break;
                                    }
                                    case 'o': {
                                        if (c >= '0' && c <= '7' || c == 'z' || c == 'Z' || c == 'x' || c == 'X' || c == '?' || c == '_') break;
                                        numberType = "octal";
                                        break;
                                    }
                                    default: {
                                        if (c >= '0' && c <= '9' || c == 'z' || c == 'Z' || c == 'x' || c == 'X' || c == '?' || c == '_' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') break;
                                        numberType = "hexadecimal";
                                    }
                                }
                                if (numberType != null) {
                                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "'" + c + "' is not allowed in " + numberType + " number");
                                }
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mQUOTED_STRING(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block23: {
            _token = null;
            _begin = this.text.length();
            _ttype = 280;
            boolean synPredMatched139 = false;
            if (!(this.LA(1) != '\"' && this.LA(1) != '}' || this.LA(2) != '\"' && this.LA(2) != '}' || this.LA(3) < '\u0000' || this.LA(3) > '\ufffe')) {
                int _m139;
                block22: {
                    _m139 = this.mark();
                    synPredMatched139 = true;
                    this.inputState.incGuessing();
                    try {
                        if (this.LA(1) == '\"') {
                            this.match("\"\"\"");
                            break block22;
                        }
                        if (this.LA(1) == '}' && this.enableMustache) {
                            this.match("}}");
                            break block22;
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched139 = false;
                    }
                }
                this.rewind(_m139);
                this.inputState.decGuessing(synPredMatched139);
            }
            if (synPredMatched139) {
                this.mTRIPLE_DOUBLE_QUOTED_STRING(false);
                if (this.inputState.guessing() == 0) {
                    try {
                        if (this.enableMustache) {
                            _ttype = 282;
                            break block23;
                        }
                        _ttype = 202;
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
            } else if (this.LA(1) == '\"' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
                this.mDOUBLE_QUOTED_STRING(false);
                if (this.inputState.guessing() == 0) {
                    try {
                        _ttype = 281;
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
            } else if (this.LA(1) == '}') {
                this.mRCURLY(false);
                if (this.inputState.guessing() == 0) {
                    try {
                        _ttype = 235;
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
            } else {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mTRIPLE_DOUBLE_QUOTED_STRING(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block43: {
            _token = null;
            _begin = this.text.length();
            _ttype = 282;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    int _saveIndex;
                    if (this.LA(1) == '\"') {
                        _saveIndex = this.text.length();
                        this.match("\"\"\"");
                        this.text.setLength(_saveIndex);
                    } else if (this.LA(1) == '}' && this.enableMustache) {
                        _saveIndex = this.text.length();
                        this.match("}}");
                        this.text.setLength(_saveIndex);
                        if (this.inputState.guessing() == 0) {
                            try {
                                this.enableMustache = false;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    while (true) {
                        boolean synPredMatched157 = false;
                        if ((this.LA(1) == '\n' || this.LA(1) == '\r') && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m157;
                            block41: {
                                _m157 = this.mark();
                                synPredMatched157 = true;
                                this.inputState.incGuessing();
                                try {
                                    if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                                        this.match("\r\n");
                                        break block41;
                                    }
                                    if (this.LA(1) == '\r') {
                                        this.match('\r');
                                        break block41;
                                    }
                                    if (this.LA(1) == '\n') {
                                        this.match('\n');
                                        break block41;
                                    }
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched157 = false;
                                }
                            }
                            this.rewind(_m157);
                            this.inputState.decGuessing(synPredMatched157);
                        }
                        if (synPredMatched157) {
                            if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                                this.match("\r\n");
                            } else if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                                this.match('\r');
                            } else if (this.LA(1) == '\n') {
                                this.match('\n');
                            } else {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                this.newline();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            continue;
                        }
                        if (this.LA(1) == '\"' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && (this.LA(2) != '\"' || this.LA(3) != '\"')) {
                            this.match('\"');
                            continue;
                        }
                        if (this.LA(1) == '{' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(2) != '{') {
                            this.match('{');
                            continue;
                        }
                        if (!_tokenSet_9.member((int)this.LA(1)) || this.LA(2) < '\u0000' || this.LA(2) > '\ufffe' || this.LA(3) < '\u0000' || this.LA(3) > '\ufffe') break;
                        this.match(_tokenSet_9);
                    }
                    switch (this.LA(1)) {
                        case '\"': {
                            _saveIndex = this.text.length();
                            this.match("\"\"\"");
                            this.text.setLength(_saveIndex);
                            break;
                        }
                        case '{': {
                            _saveIndex = this.text.length();
                            this.match("{{");
                            this.text.setLength(_saveIndex);
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.enableMustache = true;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.enableMustache = false;
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block43;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDOUBLE_QUOTED_STRING(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block30: {
            _token = null;
            _begin = this.text.length();
            _ttype = 281;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            boolean report = true;
            try {
                try {
                    this.match('\"');
                    while (true) {
                        boolean synPredMatched146 = false;
                        if (this.LA(1) == '\\' && _tokenSet_10.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m146 = this.mark();
                            synPredMatched146 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('\\');
                                while (this.LA(1) == '\t' || this.LA(1) == '\f' || this.LA(1) == ' ') {
                                    this.mSTRING_WS(false);
                                }
                                switch (this.LA(1)) {
                                    case '\r': {
                                        this.match('\r');
                                        break;
                                    }
                                    case '\n': {
                                        this.match('\n');
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched146 = false;
                            }
                            this.rewind(_m146);
                            this.inputState.decGuessing(synPredMatched146);
                        }
                        if (synPredMatched146) {
                            this.mSTRING_NEWLINE(false);
                            continue;
                        }
                        boolean synPredMatched148 = false;
                        if (this.LA(1) == '\\' && this.LA(2) == '\\' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m148 = this.mark();
                            synPredMatched148 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("\\\\");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched148 = false;
                            }
                            this.rewind(_m148);
                            this.inputState.decGuessing(synPredMatched148);
                        }
                        if (synPredMatched148) {
                            this.match("\\\\");
                            continue;
                        }
                        boolean synPredMatched150 = false;
                        if (this.LA(1) == '\\' && this.LA(2) == '\"' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m150 = this.mark();
                            synPredMatched150 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("\\\"");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched150 = false;
                            }
                            this.rewind(_m150);
                            this.inputState.decGuessing(synPredMatched150);
                        }
                        if (synPredMatched150) {
                            this.match("\\\"");
                            continue;
                        }
                        if (_tokenSet_11.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
                            this.match(_tokenSet_11);
                            continue;
                        }
                        if (this.LA(1) != '\n' && this.LA(1) != '\r') break;
                        report = this.mNEWLINE(false, report);
                    }
                    this.match('\"');
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSTRING_WS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 285;
        switch (this.LA(1)) {
            case ' ': {
                this.match(' ');
                break;
            }
            case '\t': {
                this.match('\t');
                break;
            }
            case '\f': {
                this.match('\f');
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSTRING_NEWLINE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 284;
        this.match('\\');
        while (this.LA(1) == '\t' || this.LA(1) == '\f' || this.LA(1) == ' ') {
            this.mSTRING_WS(false);
        }
        this.mNEWLINE(false, false);
        if (this.inputState.guessing() == 0) {
            try {
                this.text.setLength(_begin);
                this.text.append(" ");
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final boolean mNEWLINE(boolean _createToken, boolean report) throws RecognitionException, CharStreamException, TokenStreamException {
        boolean doReport = true;
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 283;
        if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(1) == '\r' && this.LA(2) == '\n') {
            this.match("\r\n");
        } else if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
            this.match('\r');
        } else if (this.LA(1) == '\n') {
            this.match('\n');
        } else {
            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        if (this.inputState.guessing() == 0) {
            try {
                this.newline();
                this.text.setLength(_begin);
                this.text.append(" ");
                doReport = false;
                if (report) {
                    this.reportError(PSSUtil.getNonStandardSeverity(), this.getFilename(), this.getLine(), -1, -1, "NON_STANDARD: Use '\\' in order to continue the string on the next line");
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return doReport;
    }

    public final void mNUMBER_BASE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 286;
        this.mUNSIGNED_NUMBER(false);
        boolean synPredMatched172 = false;
        if (this.LA(1) == '.') {
            int _m172 = this.mark();
            synPredMatched172 = true;
            this.inputState.incGuessing();
            try {
                this.mDOT(false);
                this.matchRange('0', '9');
            }
            catch (RecognitionException recognitionException) {
                synPredMatched172 = false;
            }
            this.rewind(_m172);
            this.inputState.decGuessing(synPredMatched172);
        }
        if (synPredMatched172) {
            this.mDOT(false);
            this.mUNSIGNED_NUMBER(false);
        }
        boolean synPredMatched178 = false;
        if (this.LA(1) == 'E' || this.LA(1) == 'e') {
            int _m178 = this.mark();
            synPredMatched178 = true;
            this.inputState.incGuessing();
            try {
                switch (this.LA(1)) {
                    case 'e': {
                        this.match('e');
                        break;
                    }
                    case 'E': {
                        this.match('E');
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                switch (this.LA(1)) {
                    case '+': {
                        this.mPLUS(false);
                        break;
                    }
                    case '-': {
                        this.mMINUS(false);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.matchRange('0', '9');
            }
            catch (RecognitionException recognitionException) {
                synPredMatched178 = false;
            }
            this.rewind(_m178);
            this.inputState.decGuessing(synPredMatched178);
        }
        if (synPredMatched178) {
            switch (this.LA(1)) {
                case 'e': {
                    this.match('e');
                    break;
                }
                case 'E': {
                    this.match('E');
                    break;
                }
                default: {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            switch (this.LA(1)) {
                case '+': {
                    this.mPLUS(false);
                    break;
                }
                case '-': {
                    this.mMINUS(false);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            this.mUNSIGNED_NUMBER(false);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mUNSIGNED_NUMBER(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 287;
        this.matchRange('0', '9');
        block4: while (true) {
            switch (this.LA(1)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.matchRange('0', '9');
                    continue block4;
                }
                case '_': {
                    this.match('_');
                    continue block4;
                }
            }
            break;
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDECIMAL_DIGIT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 288;
        this.matchRange('0', '9');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_ID(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 290;
        switch (this.LA(1)) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                this.mID(false);
                break;
            }
            case '\\': {
                this.mESCAPED_ID(false);
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        _ttype = this.testLiteralsTable(new String(this.text.getBuffer(), _begin, this.text.length() - _begin), _ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[1025];
        data[1] = 74451316768276756L;
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[2048];
        data[0] = 0xFFFFC9FFL;
        data[1] = Long.MIN_VALUE;
        int i = 2;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[2048];
        data[0] = -4294953472L;
        data[1] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[2048];
        data[0] = -1025L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[2048];
        data[0] = -9217L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[2048];
        data[0] = -4398046520321L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[1025];
        data[0] = 0x3FF000000000000L;
        data[1] = 576460745995190270L;
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[2048];
        data[0] = -4294981121L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[1025];
        data[0] = -8935423135679774720L;
        data[1] = 360288513586888830L;
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[2048];
        data[0] = -17179869185L;
        data[1] = -576460752303423489L;
        int i = 2;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[1025];
        data[0] = 4294981120L;
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[2048];
        data[0] = -17179878401L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }
}

