/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.parser;

import java.io.Serializable;
import java.util.Map;
import ro.amiq.dvt.model.problems.ISourceProblem;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;

public class PSSProblem
implements ISourceProblem,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    private int fSeverity;
    private int fLine;
    private int fOffsetStart;
    private int fOffsetEnd;
    private String fFileName;
    private String fMessage;
    private String fPrefix;
    private int fFileIndex;
    private int fInvocNumber;
    private Map<String, Object> fAttributes;
    private transient Severity fSeverityAfterWaive;

    public PSSProblem(int severity, String filename, String prefix, int line, String message, int fileIndex, int invocNumber) {
        this.fFileName = Utils.canonicPath((String)filename);
        this.fLine = line;
        this.fMessage = message;
        this.fPrefix = prefix;
        this.fFileIndex = fileIndex;
        this.fSeverity = severity;
        this.fInvocNumber = invocNumber;
    }

    public int getInvocNumber() {
        return this.fInvocNumber;
    }

    public int getLine() {
        return this.fLine;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.fAttributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    public void setOffsetStart(int offsetStart) {
        this.fOffsetStart = offsetStart;
    }

    public void setOffsetEnd(int offsetEnd) {
        this.fOffsetEnd = offsetEnd;
    }

    public int getOffsetStart() {
        return this.fOffsetStart;
    }

    public int getOffsetEnd() {
        return this.fOffsetEnd;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public int getFileIndex() {
        return this.fFileIndex;
    }

    public String getMessage(boolean prependPrefix) {
        if (prependPrefix) {
            if (this.fFileIndex < 0) {
                return DVTStringUtil.appendString((Object[])new Object[]{"_", this.fPrefix, " ", this.fMessage});
            }
            return DVTStringUtil.appendString((Object[])new Object[]{this.fPrefix, " ", this.fMessage});
        }
        if (this.fFileIndex <= 0) {
            return DVTStringUtil.appendString((Object[])new Object[]{"_", this.fMessage});
        }
        return this.fMessage;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PSSProblem && this.fLine == ((PSSProblem)obj).getLine() && this.fSeverity == ((PSSProblem)obj).fSeverity && this.fFileName.equals(((PSSProblem)obj).getFileName())) {
            if (this.fMessage.startsWith("NON_STANDARD:") || ((PSSProblem)obj).fMessage.startsWith("NON_STANDARD:")) {
                return this.fMessage.equals(((PSSProblem)obj).fMessage);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String result = null;
        result = this.fSeverity == 1 ? "*** Error: " : "*** Warning: ";
        result = String.valueOf(result) + this.getMessage(true) + "\n" + "    detected at line " + this.getLine() + " in '" + this.getFileName() + "'";
        return result;
    }

    public void setFileName(String fileName) {
        this.fFileName = fileName;
    }

    public int hashCode() {
        if (this.fMessage.startsWith("NON_STANDARD:")) {
            return (String.valueOf(this.fMessage) + "@" + this.fSeverity + "@" + this.fLine + "@" + this.fFileName).hashCode();
        }
        return (String.valueOf(this.fSeverity) + "@" + this.fLine + "@" + this.fFileName).hashCode();
    }

    public Severity getSeverityAfterWaive() {
        return this.fSeverityAfterWaive;
    }

    public void setSeverityAfterWaive(Severity severity) {
        this.fSeverityAfterWaive = severity;
    }
}

