/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.parser.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public class BitVectorFloat
extends BitVectorInt {
    private BigDecimal number = BigDecimal.ZERO;

    public BitVectorFloat(boolean isFloat64) {
        super(false, isFloat64 ? 63 : 31, 0);
    }

    @Override
    public boolean isFloat64() {
        return this.nofBits() == 64;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    public static BitVectorFloat from(String number, boolean isFloat64) {
        BitVectorFloat result = new BitVectorFloat(isFloat64);
        result.number = new BigDecimal(number);
        return result;
    }

    @Override
    public BitVectorInt setValue(String number, int radix) {
        this.number = new BigDecimal(number);
        this.right = 0;
        this.left = 63;
        BitVectorFloat result = this.from(this);
        this.number = result.number;
        return this;
    }

    @Override
    public int nofBits() {
        return this.left + 1;
    }

    @Override
    public boolean hasSign() {
        return false;
    }

    @Override
    public <T extends BitVectorInt> T from(T bs) {
        return bs;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.number;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.number.toBigInteger();
    }

    @Override
    public BitVectorInt plus(BitVectorInt bs) {
        return this.plus(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    @Override
    public BitVectorInt plus(BitVectorInt bs, int resultSize) {
        BitVectorFloat thisBS = this;
        BitVectorInt otherBS = bs;
        boolean result64Bit = this.isFloat64() | bs.isFloat64();
        BitVectorFloat result = new BitVectorFloat(result64Bit);
        if (otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = ((BitVectorInt)thisBS).bigDecimalValue().add(otherBS.bigDecimalValue());
        result = result.from(result);
        return result;
    }

    @Override
    public BitVectorInt minus(BitVectorInt bs) {
        return this.minus(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    @Override
    public BitVectorInt minus(BitVectorInt bs, int resultSize) {
        BitVectorFloat thisBS = this;
        BitVectorInt otherBS = bs;
        boolean result64Bit = this.isFloat64() | bs.isFloat64();
        BitVectorFloat result = new BitVectorFloat(result64Bit);
        if (otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = ((BitVectorInt)thisBS).bigDecimalValue().subtract(otherBS.bigDecimalValue());
        result = result.from(result);
        return result;
    }

    @Override
    public BitVectorInt multiply(BitVectorInt bs) {
        return this.multiply(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    @Override
    public BitVectorInt multiply(BitVectorInt bs, int resultSize) {
        BitVectorFloat thisBS = this;
        BitVectorInt otherBS = bs;
        boolean result64Bit = this.isFloat64() | bs.isFloat64();
        BitVectorFloat result = new BitVectorFloat(result64Bit);
        if (otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = ((BitVectorInt)thisBS).bigDecimalValue().multiply(otherBS.bigDecimalValue());
        result = result.from(result);
        return result;
    }

    @Override
    public BitVectorInt divide(BitVectorInt bs) {
        return this.divide(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    @Override
    public BitVectorInt divide(BitVectorInt bs, int resultSize) {
        if (bs.equals(ZERO)) {
            throw new ArithmeticException("Cannot divide by ZERO");
        }
        BitVectorFloat thisBS = this;
        BitVectorInt otherBS = bs;
        boolean result64Bit = this.isFloat64() | bs.isFloat64();
        BitVectorFloat result = new BitVectorFloat(result64Bit);
        if (otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = ((BitVectorInt)thisBS).bigDecimalValue().divide(otherBS.bigDecimalValue());
        result = result.from(result);
        return result;
    }

    @Override
    public BitVectorInt mod(BitVectorInt bs) {
        return this.mod(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    @Override
    public BitVectorInt mod(BitVectorInt bs, int resultSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt pow(int exponent) {
        return this.pow(exponent, this.nofBits());
    }

    @Override
    public BitVectorInt pow(int exponent, int resultSize) {
        boolean result64Bit = this.isFloat64();
        BitVectorFloat result = new BitVectorFloat(result64Bit);
        if (exponent == 0) {
            return result.from(ONE);
        }
        if (this.number.compareTo(BigDecimal.ONE) == 0) {
            return result.from(ONE);
        }
        if (exponent < 0 && (this.number.compareTo(BigDecimal.valueOf(-1L)) < 0 || this.number.compareTo(BigDecimal.ONE) > 0)) {
            return result.from(ZERO);
        }
        if (this.number.compareTo(BigDecimal.ZERO) == 0 && exponent > 0) {
            return result.from(ZERO);
        }
        if (exponent < 0) {
            throw new ArithmeticException("Cannot power ZERO to negative exponent");
        }
        if (this.number.compareTo(BigDecimal.valueOf(-1L)) == 0 && exponent < 0) {
            if (exponent % 2 == 0) {
                return result.from(ONE);
            }
            return result.from(NEGATIVE_ONE);
        }
        result.number = this.number.pow(exponent);
        result = result.from(result);
        return result;
    }

    @Override
    public BitVectorInt and(BitVectorInt bs) {
        return this.and(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    @Override
    public BitVectorInt and(BitVectorInt bs, int resultSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt or(BitVectorInt bs) {
        return this.or(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    @Override
    public BitVectorInt or(BitVectorInt bs, int resultSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt xor(BitVectorInt bs) {
        return this.xor(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    @Override
    public BitVectorInt xor(BitVectorInt bs, int resultSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt shiftLeft(int shl) {
        return this.shiftLeft(shl, this.nofBits());
    }

    @Override
    public BitVectorInt shiftLeft(int shl, int resultSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt shiftRight(int shr, boolean keepSign) {
        return this.shiftRight(shr, keepSign, this.nofBits());
    }

    @Override
    public BitVectorInt shiftRight(int shr, boolean keepSign, int resultSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt abs() {
        return this;
    }

    @Override
    public BitVectorInt band() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt nband() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt bxor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt nbxor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt bor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt nbor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean gte(BitVectorInt bs) {
        return this.equals(bs) || this.gt(bs);
    }

    @Override
    public boolean gt(BitVectorInt bs) {
        BitVectorFloat thisBS = this;
        BitVectorInt otherBS = bs;
        if (otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        return ((BitVectorInt)thisBS).bigDecimalValue().compareTo(otherBS.bigDecimalValue()) > 0;
    }

    @Override
    public boolean lte(BitVectorInt bs) {
        return this.equals(bs) || this.lt(bs);
    }

    @Override
    public boolean lt(BitVectorInt bs) {
        BitVectorFloat thisBS = this;
        BitVectorInt otherBS = bs;
        if (otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        return ((BitVectorInt)thisBS).bigDecimalValue().compareTo(otherBS.bigDecimalValue()) < 0;
    }

    @Override
    public BitVectorInt countBits(int bit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt getRange(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRange(BitVectorInt bs, int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVectorInt toUnsigned() {
        return this;
    }

    @Override
    public boolean eq(BitVectorInt obj) {
        BitVectorFloat thisBS = this;
        BitVectorInt otherBS = obj;
        if (otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        return ((BitVectorInt)thisBS).bigDecimalValue().compareTo(otherBS.bigDecimalValue()) == 0;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isString ? 1231 : 1237);
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitVectorFloat other = (BitVectorFloat)obj;
        if (this.isString != other.isString) {
            return false;
        }
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }

    @Override
    public String toString(int radix) {
        return this.number.toString();
    }
}

