/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.parser.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import ro.amiq.dvt.IDVTConstants;

public class BitVectorInt {
    public static final BitVectorInt BIT_ZERO = new BitVectorInt(false, 0, 0, BigInteger.ZERO);
    public static final BitVectorInt BIT_ONE = new BitVectorInt(false, 0, 0, BigInteger.ONE);
    public static final BitVectorInt ZERO = new BitVectorInt(true, 31, 0, BigInteger.ZERO);
    public static final BitVectorInt ONE = new BitVectorInt(true, 31, 0, BigInteger.ONE);
    public static final BitVectorInt NEGATIVE_ONE = new BitVectorInt(true, 31, 0, BigInteger.valueOf(-1L));
    public static final BitVectorInt UNDEFINED = new UNDEFINED();
    public static final BitVectorInt FALSE = BIT_ZERO;
    public static final BitVectorInt TRUE = BIT_ONE;
    public static final BigInteger BIG_INTEGER_TWO = BigInteger.valueOf(2L);
    public static final BigInteger TWO_0 = BIG_INTEGER_TWO.pow(0);
    public static final BigInteger TWO_1 = BIG_INTEGER_TWO.pow(1);
    public static final BigInteger TWO_31 = BIG_INTEGER_TWO.pow(31);
    public static final BigInteger TWO_32 = BIG_INTEGER_TWO.pow(32);
    public static final BigInteger TWO_63 = BIG_INTEGER_TWO.pow(63);
    public static final BigInteger TWO_64 = BIG_INTEGER_TWO.pow(64);
    protected boolean isString;
    protected boolean sign;
    protected int left;
    protected int right;
    private BigInteger number;
    private String enumItemName;

    public BitVectorInt(boolean signed, int left, int right) {
        this.sign = signed;
        this.left = left;
        this.right = right;
        this.number = BigInteger.ZERO;
    }

    public BitVectorInt(BitVectorInt bs) {
        this.sign = bs.sign;
        this.left = bs.left;
        this.right = bs.right;
        this.number = new BigInteger(bs.number.toByteArray());
    }

    public static final boolean isUndefined(BitVectorInt number) {
        return number == UNDEFINED;
    }

    public static BitVectorInt mergeBitVector(int elementSize, List<BitVectorInt> result) {
        BitVectorInt bitVectorResult = BIT_ZERO;
        int nofBits = 0;
        int i = 0;
        while (i < result.size()) {
            BitVectorInt part = result.get(i);
            if (i > 0) {
                bitVectorResult = bitVectorResult.shiftLeft(elementSize, nofBits + elementSize);
            }
            bitVectorResult = bitVectorResult.plus(part, part.nofBits());
            nofBits += elementSize;
            ++i;
        }
        return bitVectorResult;
    }

    public static BitVectorInt from(boolean signed, int number) {
        BitVectorInt result = new BitVectorInt(signed, 31, 0);
        result.setValue(BigInteger.valueOf(number));
        return result;
    }

    public BitVectorInt(boolean signed, int left, int right, BigInteger number) {
        this.sign = signed;
        this.left = left;
        this.right = right;
        this.number = number;
    }

    public int nofBits() {
        return Math.abs(this.left - this.right) + 1;
    }

    public boolean hasSign() {
        return this.sign;
    }

    public void setSign(boolean hasSign) {
        this.sign = hasSign;
    }

    public BigInteger bigIntegerValue() {
        return this.number;
    }

    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.number.doubleValue());
    }

    public int intValue() {
        return this.number.intValue();
    }

    public BitVectorInt setValue(String number, int radix) {
        this.number = new BigInteger(number, radix);
        if (this.right == -1 && this.left == -1) {
            this.right = 0;
            this.left = Math.max(32, this.number.bitLength());
        }
        BitVectorInt result = this.from(this);
        this.number = result.number;
        return this;
    }

    public void setString(boolean string) {
        this.isString = string;
    }

    public boolean isString() {
        return this.isString;
    }

    public BitVectorInt setValue(BigInteger number) {
        this.number = number;
        BitVectorInt result = this.from(this);
        this.number = result.number;
        return this;
    }

    public <T extends BitVectorInt> T from(T bs) {
        int end;
        int start;
        int resultSize = this.nofBits() - 1;
        if (bs.left >= bs.right) {
            start = resultSize;
            end = 0;
        } else {
            start = 0;
            end = resultSize;
        }
        BitVectorInt result = bs.getRange(start, end, this.hasSign());
        result.convertInRange();
        return (T)result;
    }

    public BitVectorInt not() {
        BitVectorInt result = new BitVectorInt(this);
        result.number = result.number.not();
        result = result.from(result);
        return result;
    }

    public BitVectorInt plus(BitVectorInt bs) {
        return this.plus(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    public BitVectorInt plus(BitVectorInt bs, int resultSize) {
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BitVectorInt result = new BitVectorInt(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = thisBS.bigIntegerValue().add(otherBS.bigIntegerValue());
        result = result.from(result);
        return result;
    }

    public BitVectorInt minus(BitVectorInt bs) {
        return this.minus(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    public BitVectorInt minus(BitVectorInt bs, int resultSize) {
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BitVectorInt result = new BitVectorInt(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = thisBS.bigIntegerValue().subtract(otherBS.bigIntegerValue());
        result = result.from(result);
        return result;
    }

    public BitVectorInt multiply(BitVectorInt bs) {
        return this.multiply(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    public BitVectorInt multiply(BitVectorInt bs, int resultSize) {
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BitVectorInt result = new BitVectorInt(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = thisBS.bigIntegerValue().multiply(otherBS.bigIntegerValue());
        result = result.from(result);
        return result;
    }

    public BitVectorInt divide(BitVectorInt bs) {
        return this.divide(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    public BitVectorInt divide(BitVectorInt bs, int resultSize) {
        if (bs.equals(ZERO)) {
            throw new ArithmeticException("Cannot divide by ZERO");
        }
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BitVectorInt result = new BitVectorInt(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = thisBS.bigIntegerValue().divide(otherBS.bigIntegerValue());
        result = result.from(result);
        return result;
    }

    public BitVectorInt mod(BitVectorInt bs) {
        return this.mod(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    public BitVectorInt mod(BitVectorInt bs, int resultSize) {
        if (bs.equals(ZERO)) {
            throw new ArithmeticException("Cannot divide by ZERO");
        }
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BitVectorInt result = new BitVectorInt(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = thisBS.bigIntegerValue().abs().mod(otherBS.bigIntegerValue().abs());
        if (result.hasSign() && this.hasSign() && this.number.compareTo(BigInteger.ZERO) < 0) {
            result.number = result.number.negate();
        }
        result = result.from(result);
        return result;
    }

    public BitVectorInt pow(int exponent) {
        return this.pow(exponent, this.nofBits());
    }

    public BitVectorInt pow(int exponent, int resultSize) {
        BitVectorInt result = new BitVectorInt(this.sign, resultSize - 1, 0);
        if (exponent == 0) {
            return result.from(ONE);
        }
        if (this.number.compareTo(BigInteger.ONE) == 0) {
            return result.from(ONE);
        }
        if (exponent < 0 && (this.number.compareTo(BigInteger.valueOf(-1L)) < 0 || this.number.compareTo(BigInteger.ONE) > 0)) {
            return result.from(ZERO);
        }
        if (this.number.compareTo(BigInteger.ZERO) == 0) {
            if (exponent > 0) {
                return result.from(ZERO);
            }
            if (exponent < 0) {
                throw new ArithmeticException("Cannot power ZERO to negative exponent");
            }
        }
        if (this.number.compareTo(BigInteger.valueOf(-1L)) == 0 && exponent < 0) {
            if (exponent % 2 == 0) {
                return result.from(ONE);
            }
            return result.from(NEGATIVE_ONE);
        }
        result.number = this.number.pow(exponent);
        result = result.from(result);
        return result;
    }

    public BitVectorInt and(BitVectorInt bs) {
        return this.and(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    public BitVectorInt and(BitVectorInt bs, int resultSize) {
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BitVectorInt result = new BitVectorInt(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = thisBS.bigIntegerValue().and(otherBS.bigIntegerValue());
        result = result.from(result);
        return result;
    }

    public BitVectorInt or(BitVectorInt bs) {
        return this.or(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    public BitVectorInt or(BitVectorInt bs, int resultSize) {
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BitVectorInt result = new BitVectorInt(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = thisBS.bigIntegerValue().or(otherBS.bigIntegerValue());
        result = result.from(result);
        return result;
    }

    public BitVectorInt xor(BitVectorInt bs) {
        return this.xor(bs, Integer.max(this.nofBits(), bs.nofBits()));
    }

    public BitVectorInt xor(BitVectorInt bs, int resultSize) {
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        BitVectorInt result = new BitVectorInt(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        result.number = thisBS.bigIntegerValue().xor(otherBS.bigIntegerValue());
        result = result.from(result);
        return result;
    }

    public BitVectorInt shiftLeft(int shl) {
        return this.shiftLeft(shl, this.nofBits());
    }

    public BitVectorInt shiftLeft(int shl, int resultSize) {
        BitVectorInt result = new BitVectorInt(this.sign, resultSize - 1, 0);
        result.number = this.number.shiftLeft(shl);
        result = result.from(result);
        return result;
    }

    public BitVectorInt shiftRight(int shr, boolean keepSign) {
        return this.shiftRight(shr, keepSign, this.nofBits());
    }

    public BitVectorInt shiftRight(int shr, boolean keepSign, int resultSize) {
        BitVectorInt result = new BitVectorInt(this.sign, resultSize - 1, 0);
        result.number = this.number;
        if (!keepSign) {
            result = result.toUnsigned();
        }
        result.sign = this.sign;
        result.number = result.number.shiftRight(shr);
        result = result.from(result);
        return result;
    }

    public BitVectorInt abs() {
        BitVectorInt result = new BitVectorInt(false, this.left, this.right, this.number);
        result.number = result.number.abs();
        result = result.from(result);
        return result;
    }

    public BitVectorInt band() {
        int i = Math.min(this.left, this.right);
        boolean result = this.number.testBit(i);
        ++i;
        while (i < this.nofBits()) {
            if (!result) {
                return BIT_ZERO;
            }
            result &= this.number.testBit(i);
            ++i;
        }
        return BIT_ONE;
    }

    public BitVectorInt nband() {
        if (this.band() == BIT_ONE) {
            return BIT_ZERO;
        }
        return BIT_ONE;
    }

    public BitVectorInt bxor() {
        int i = Math.min(this.left, this.right);
        boolean result = this.number.testBit(i);
        ++i;
        while (i < this.nofBits()) {
            result ^= this.number.testBit(i);
            ++i;
        }
        if (!result) {
            return BIT_ZERO;
        }
        return BIT_ONE;
    }

    public BitVectorInt nbxor() {
        if (this.bxor() == BIT_ONE) {
            return BIT_ZERO;
        }
        return BIT_ONE;
    }

    public BitVectorInt bor() {
        int i = Math.min(this.left, this.right);
        boolean result = this.number.testBit(i);
        ++i;
        while (i < this.nofBits()) {
            if (result) {
                return BIT_ONE;
            }
            result |= this.number.testBit(i);
            ++i;
        }
        return BIT_ZERO;
    }

    public BitVectorInt nbor() {
        if (this.bor() == BIT_ONE) {
            return BIT_ZERO;
        }
        return BIT_ONE;
    }

    public boolean gte(BitVectorInt bs) {
        return this.equals(bs) || this.gt(bs);
    }

    public boolean gt(BitVectorInt bs) {
        boolean resultSign;
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean bl = resultSign = thisBS.hasSign() && otherBS.hasSign();
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        return thisBS.bigIntegerValue().compareTo(otherBS.bigIntegerValue()) > 0;
    }

    public boolean lte(BitVectorInt bs) {
        return this.equals(bs) || this.lt(bs);
    }

    public boolean lt(BitVectorInt bs) {
        boolean resultSign;
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = bs;
        boolean bl = resultSign = thisBS.hasSign() && otherBS.hasSign();
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        return thisBS.bigIntegerValue().compareTo(otherBS.bigIntegerValue()) < 0;
    }

    public BitVectorInt countBits(int bit) {
        if (this.left < 0 || this.right < 0) {
            throw new IllegalArgumentException(this.left < 0 ? "Left index is negative" : "Right index is negative");
        }
        if (bit != 1 && bit != 0) {
            return UNDEFINED;
        }
        int left = Integer.max(this.left, this.right);
        int right = Integer.min(this.left, this.right);
        int result = 0;
        int i = left;
        while (i >= right) {
            result += this.number.testBit(i) ^ bit == 1 ? 0 : 1;
            --i;
        }
        return new BitVectorInt(false, 31, 0, BigInteger.valueOf(result));
    }

    protected BitVectorInt getRange(int start, int end, boolean forceSign) {
        int min;
        int max;
        if (this.left > this.right && start < end) {
            throw new IllegalArgumentException("Range of part-select is reversed!");
        }
        if (this.left > this.right) {
            if (start > end) {
                max = start - this.right;
                min = end - this.right;
            } else {
                max = end - this.right;
                min = start - this.right;
            }
        } else if (start > end) {
            max = start - this.left;
            min = end - this.left;
        } else {
            max = end - this.left;
            min = start - this.left;
        }
        int resultSize = max - min;
        BitVectorInt result = new BitVectorInt(forceSign, this.left > this.right ? resultSize : 0, this.left > this.right ? 0 : resultSize);
        BigInteger mask = this.getPowerOfTwo(max + 1).subtract(BigInteger.ONE).subtract(this.getPowerOfTwo(min).subtract(BigInteger.ONE));
        result.number = this.number.and(mask).shiftRight(min);
        return result;
    }

    public BitVectorInt getRange(int start, int end) {
        return this.getRange(start, end, false);
    }

    public void setRange(BitVectorInt bs, int start, int end) {
        int min;
        int max;
        if (this.left > this.right && start < end) {
            throw new RuntimeException("Range of part-select is reversed!");
        }
        if (this.left > this.right) {
            max = start - this.right;
            min = end - this.right;
        } else {
            max = start - this.left;
            min = end - this.left;
        }
        int size = this.nofBits();
        BigInteger mask = this.getPowerOfTwo(size).subtract(BigInteger.ONE).subtract(this.getPowerOfTwo(max + 1).subtract(BigInteger.ONE)).add(this.getPowerOfTwo(min).subtract(BigInteger.ONE));
        this.number = this.number.and(mask);
        this.number = this.number.or(bs.number.shiftLeft(size - end - 1));
    }

    private void convertInRange() {
        BigInteger minValue;
        BigInteger maxValue;
        int size = this.nofBits();
        BigInteger modRange = this.getPowerOfTwo(size);
        if (this.hasSign()) {
            maxValue = this.getPowerOfTwo(size - 1).subtract(BigInteger.ONE);
            minValue = this.getPowerOfTwo(size - 1).negate();
        } else {
            maxValue = this.getPowerOfTwo(size).subtract(BigInteger.ONE);
            minValue = BigInteger.ZERO;
        }
        while (this.number.compareTo(minValue) < 0) {
            this.number = this.number.add(modRange);
        }
        while (this.number.compareTo(maxValue) > 0) {
            this.number = this.number.subtract(modRange);
        }
    }

    public BitVectorInt toUnsigned() {
        BitVectorInt result = this.from(this);
        int size = result.nofBits();
        BigInteger modRange = this.getPowerOfTwo(size);
        while (result.number.compareTo(BigInteger.ZERO) < 0) {
            result.number = result.number.add(modRange);
        }
        result.sign = false;
        return result;
    }

    private BigInteger getPowerOfTwo(int exponent) {
        if (exponent == 0) {
            return TWO_0;
        }
        if (exponent == 1) {
            return TWO_1;
        }
        if (exponent == 31) {
            return TWO_31;
        }
        if (exponent == 32) {
            return TWO_32;
        }
        if (exponent == 63) {
            return TWO_63;
        }
        if (exponent == 64) {
            return TWO_64;
        }
        return BIG_INTEGER_TWO.pow(exponent);
    }

    public boolean eq(BitVectorInt obj) {
        boolean resultSign;
        BitVectorInt thisBS = this;
        BitVectorInt otherBS = obj;
        boolean bl = resultSign = thisBS.hasSign() && otherBS.hasSign();
        if (!resultSign && thisBS.hasSign()) {
            thisBS = thisBS.toUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS = otherBS.toUnsigned();
        }
        return thisBS.bigIntegerValue().compareTo(otherBS.bigIntegerValue()) == 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isString ? 1231 : 1237);
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitVectorInt other = (BitVectorInt)obj;
        if (this.isString != other.isString) {
            return false;
        }
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }

    public String toString(int radix) {
        if (radix == 10 || radix < 2 || radix > 36) {
            return this.number.toString();
        }
        if (radix != 2 && radix != 16) {
            return this.number.toString();
        }
        StringBuilder bits = new StringBuilder();
        int left = Integer.max(this.left, this.right);
        int right = Integer.min(this.left, this.right);
        int i = left;
        while (i >= right) {
            bits.append(this.number.testBit(i) ? "1" : "0");
            --i;
        }
        if (radix == 16) {
            StringBuilder newBits = new StringBuilder();
            int i2 = bits.length() - 1;
            while (i2 >= 0) {
                String substr = bits.substring(Integer.max(i2 - 3, 0), i2 + 1);
                newBits.append(Integer.toString(Integer.parseInt(substr, 2), 16));
                i2 -= 4;
            }
            bits = newBits.reverse();
        }
        return bits.toString();
    }

    public String stringValue() {
        if (!this.isString) {
            return "";
        }
        return "\"" + new String(this.number.toByteArray(), IDVTConstants.ASCII) + "\"";
    }

    public String toString() {
        return this.isString ? this.stringValue() : this.toString(10);
    }

    public BitVectorInt setEnumItemName(String enumItemName) {
        this.enumItemName = enumItemName;
        return this;
    }

    public String getEnumItemName() {
        return this.enumItemName;
    }

    public boolean isFloat64() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    private static class UNDEFINED
    extends BitVectorInt {
        public UNDEFINED() {
            super(true, 31, 0, BigInteger.ZERO);
        }

        @Override
        public String toString(int radix) {
            return "[undefined]";
        }

        @Override
        public String toString() {
            return this.toString(10);
        }
    }
}

