/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.r2lparser;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfClassType;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedMethod;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.r2lparser.R2LCoverpointArg;
import ro.amiq.pssdt.r2lparser.R2LManager;
import ro.amiq.pssdt.r2lparser.R2LNoProposalElement;
import ro.amiq.pssdt.r2lparser.R2LParser;
import ro.amiq.pssdt.r2lparser.R2LResultContainer;
import ro.amiq.pssdt.r2lparser.R2LScopeContainer;
import ro.amiq.pssdt.r2lparser.R2LTokenizer;
import ro.amiq.pssdt.r2lparser.R2LUtils;
import ro.amiq.pssdt.r2lparser.R2LWalker;

public class R2LProposalManager
extends R2LManager {
    public static final int MAX_NOF_TOTAL_PROPOSALS = 50;
    private int fMatchType;

    public R2LProposalManager(RfProject rfProject, RfDefElement initialScope, IResource file, IDocument document, int documentOffset) {
        super(rfProject, initialScope, file, document, documentOffset, documentOffset);
        boolean ignoreCase = PSSPlugin.getDefault().getPreferenceStore().getBoolean("ca.ignore_case");
        boolean camelCase = PSSPlugin.getDefault().getPreferenceStore().getBoolean("ca.camel_case");
        boolean prefixMatch = PSSPlugin.getDefault().getPreferenceStore().getBoolean("ca.prefix_match");
        this.fMatchType = (ignoreCase ? 8 : 0) | (camelCase ? 4 : 0) | (prefixMatch || !camelCase ? 2 : 0);
    }

    public R2LProposalManager(RfProject rfProject, RfDefElement initialScope, IResource file, IDocument document, int offset, boolean wordDistanceSearch) {
        super(rfProject, initialScope, file, document, offset, offset);
        this.fMatchType = 48;
    }

    @Override
    public R2LResultContainer getProposals() {
        List<String> path;
        block6: {
            try {
                if (this.fInitialScope != null) break block6;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        R2LResultContainer result = null;
        R2LScopeContainer scopeContainer = new R2LScopeContainer(this.fInitialScope);
        R2LWalker walker = new R2LWalker(this);
        R2LTokenizer lexer = new R2LTokenizer(this.fDocument, this.fDocumentOffset, false);
        RfNamedElement namedElement = this.fInitialScope.getNamedElement();
        boolean enableFieldDecl = !(namedElement instanceof RfBlock) || !((RfBlock)namedElement).isConstraint();
        R2LParser parser = new R2LParser(lexer, enableFieldDecl, false);
        parser.rules();
        AST pAST = parser.getAST();
        if (pAST != null) {
            result = walker.rules(pAST, scopeContainer);
        }
        if (result == null || !result.isNumber && !result.hasProposals() && result.allowProposals()) {
            scopeContainer.accessKind = 0;
            path = result == null ? null : result.path;
            String prefix = result == null || result.prefix == null ? "" : result.prefix;
            result = new R2LResultContainer();
            result.candidates = this.getExprCandidates(scopeContainer, null, prefix);
            result.prefix = prefix;
            result.path = path;
        }
        if (!result.isNumber && !result.hasProposals()) {
            path = result.path;
            result = new R2LResultContainer();
            result.candidates = new RfNamedElement[]{new R2LNoProposalElement()};
            result.prefix = "";
            result.path = path;
        }
        result.initialScope = this.fInitialScope;
        return result;
    }

    @Override
    public List<RfWNamedElementAndScope> getElements() {
        return null;
    }

    public RfNamedElement[] getEnumCandidates(R2LScopeContainer scopeContainer, List<String> enums, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scope = scopeContainer.scope;
        if (!(scope instanceof RfEnumType)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                return candidate instanceof RfEnumItem;
            }

            public boolean allowEnumElement() {
                return true;
            }

            public int resultMaxSize() {
                return 50;
            }
        };
        ((RfEnumType)scope).getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, this.fMatchType, 1, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        if (candidates.isEmpty()) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        if (enums != null && !enums.isEmpty()) {
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                IRfNamedElement candidate = (IRfNamedElement)iterator.next();
                if (!enums.contains(candidate.getName())) continue;
                iterator.remove();
            }
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix));
        return sortedCandidates;
    }

    public RfNamedElement[] getEnumCandidates(R2LScopeContainer scopeContainer, String prefix) {
        return this.getEnumCandidates(scopeContainer, null, prefix);
    }

    public RfNamedElement[] getTypeCandidates(R2LScopeContainer scopeContainer, final String prefix, final boolean showCompAndPkg, final String typeKind, R2LScopeContainer likeContainer) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null) {
            scope = this.fRfProject.getMainPackage();
        }
        if (scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        final RfNamedElement likeStruct = this.getLikeStruct(likeContainer);
        HashSet<IRfNamedElement> candidates = new HashSet<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (candidate instanceof RfTemplateInstance) {
                    return false;
                }
                if (typeKind == null && (candidate instanceof RfMethod || candidate instanceof RfField) && candidate.getEnclosingScope() instanceof RfPackage) {
                    return true;
                }
                if (typeKind == null && candidate instanceof RfField && ((RfField)candidate).getFieldModifier() == FieldModifier.STATIC_CONST) {
                    return true;
                }
                if (typeKind == null && candidate instanceof RfEnumItem) {
                    return true;
                }
                if (candidate instanceof RfNamedElement && ((RfNamedElement)candidate).isNonStandard()) {
                    return false;
                }
                if (!showCompAndPkg && (candidate instanceof RfPackage || candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.COMPONENT)) {
                    return false;
                }
                if ("input".equals(typeKind) || "output".equals(typeKind)) {
                    return candidate instanceof RfStruct && (((RfStruct)candidate).getStructKind() == StructKind.STATE || ((RfStruct)candidate).getStructKind() == StructKind.BUFFER || ((RfStruct)candidate).getStructKind() == StructKind.STREAM);
                }
                if ("lock".equals(typeKind) || "share".equals(typeKind)) {
                    return candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.RESOURCE;
                }
                if (!(typeKind != null && ("enum".equals(typeKind) || "action".equals(typeKind) || "struct".equals(typeKind) || "buffer".equals(typeKind) || "stream".equals(typeKind) || "state".equals(typeKind) || "resource".equals(typeKind)) || !(candidate instanceof RfStruct) && !(candidate instanceof RfEnumType) && !(candidate instanceof RfCovergroup) && !(candidate instanceof RfTypeAlias) && !(candidate instanceof RfPackage) && !(candidate instanceof RfPredefinedType))) {
                    return true;
                }
                if (candidate instanceof RfTypeAlias) {
                    candidate = ((RfTypeAlias)candidate).getAssociatedType();
                }
                if (prefix.length() > 0 && candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.COMPONENT) {
                    return true;
                }
                if (prefix.length() > 0 && !"component".equals(typeKind) && candidate instanceof RfPackage) {
                    return true;
                }
                if (likeStruct instanceof RfClassType) {
                    if (!(candidate instanceof RfClassType)) {
                        return false;
                    }
                    return ((RfClassType)candidate).isLike((RfClassType)likeStruct);
                }
                if ("enum".equals(typeKind) && candidate instanceof RfEnumType) {
                    return true;
                }
                if ("action".equals(typeKind) && candidate instanceof RfStruct && (((RfStruct)candidate).getStructKind() == StructKind.ACTION || ((RfStruct)candidate).getStructKind() == StructKind.ACTION_ABSTRACT)) {
                    return true;
                }
                if ("struct".equals(typeKind) && candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.STRUCT) {
                    return true;
                }
                if ("buffer".equals(typeKind) && candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.BUFFER) {
                    return true;
                }
                if ("stream".equals(typeKind) && candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.STREAM) {
                    return true;
                }
                if ("state".equals(typeKind) && candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.STATE) {
                    return true;
                }
                return "resource".equals(typeKind) && candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.RESOURCE;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 50;
            }
        };
        if (showCompAndPkg) {
            scope.getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, this.fMatchType, 4, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        } else {
            scope.getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, this.fMatchType, 2, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
        return sortedCandidates;
    }

    private RfNamedElement getLikeStruct(R2LScopeContainer likeContainer) {
        if (likeContainer != null && likeContainer.scope instanceof RfAssociatedType) {
            return ((RfAssociatedType)likeContainer.scope).getAssociatedType();
        }
        if (likeContainer != null && likeContainer.scope instanceof RfStruct) {
            return (RfNamedElement)likeContainer.scope;
        }
        return null;
    }

    @Override
    public IRfNamedElement[] getExprCandidates(final R2LScopeContainer rightScopeContainer, R2LScopeContainer leftScopeContainer, String prefix) {
        IRfNamedElement[] result;
        boolean isFirstElement;
        if (rightScopeContainer == null || rightScopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = rightScopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope instanceof RfTypeAlias) {
            scope = ((RfTypeAlias)scope).getAssociatedType();
        }
        if (scope == null || !(scope instanceof RfMembersContainer)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        final RfNamedElement leftScope = leftScopeContainer != null && leftScopeContainer.scope != null ? ((IRfScope)leftScopeContainer.scope).getNamedElement() : null;
        boolean bl = isFirstElement = rightScopeContainer.path == null || rightScopeContainer.path.isEmpty();
        if (leftScope instanceof RfEnumType && isFirstElement && (result = this.getEnumCandidates(leftScopeContainer, prefix)) != null && result.length > 0 && !(result[0] instanceof R2LNoProposalElement)) {
            return result;
        }
        HashSet<IRfNamedElement> candidates = new HashSet<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                boolean isFirst;
                if (SemanticUtils.isPrevStateField(candidate)) {
                    if (SemanticUtils.isPrevStateField(rightScopeContainer.prevElement)) {
                        return false;
                    }
                    if (rightScopeContainer.prevElement instanceof RfField && ((RfField)rightScopeContainer.prevElement).isInput()) {
                        return false;
                    }
                }
                if (!(isFirst = isFirstElement) && candidate instanceof RfPredefinedField && "comp".equals(candidate.getName())) {
                    return false;
                }
                if (candidate instanceof RfPredefinedField && candidate.getEnclosingScope() instanceof RfCollectionType && ("sum".equals(candidate.getName()) || "size".equals(candidate.getName()))) {
                    return false;
                }
                if (!isFirst && rightScopeContainer.accessKind == 1 && candidate instanceof RfPredefinedMethod && candidate.getEnclosingScope() != rightScopeContainer.scope) {
                    return false;
                }
                if (rightScopeContainer.accessKind == 1 && !SemanticUtils.hasStaticAccess((RfNamedElement)candidate)) {
                    return false;
                }
                if (!isFirst && rightScopeContainer.accessKind != 1 && SemanticUtils.hasStaticAccess((RfNamedElement)candidate)) {
                    return false;
                }
                if (candidate instanceof RfMethod || candidate instanceof RfField || candidate instanceof RfBlock && !((RfBlock)candidate).isAnonymous()) {
                    if (leftScope instanceof RfEnumType && candidate instanceof IRfAssociatedType) {
                        IRfNamedElement assocType = ((IRfAssociatedType)candidate).getAssociatedType();
                        while (assocType instanceof RfTypeAlias) {
                            assocType = ((RfTypeAlias)assocType).getAssociatedType();
                        }
                        return assocType instanceof RfStruct || assocType instanceof RfEnumType;
                    }
                    return true;
                }
                return false;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 50;
            }
        };
        scope.getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, this.fMatchType, isFirstElement ? 4 : 2, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        IRfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
        return sortedCandidates;
    }

    @Override
    public IRfNamedElement[] getMappingCandidates(R2LScopeContainer scopeContainer, String prefix, String covergroupName, final Set<String> ports) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null || !(scope instanceof RfMembersContainer)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        if (!(scope instanceof RfCovergroup)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (candidate instanceof RfField && ((RfField)candidate).getFieldModifier() == FieldModifier.COVERGROUP_PORT) {
                    return !ports.contains(candidate.getName());
                }
                return false;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 50;
            }
        };
        scope.getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, this.fMatchType, 1, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        IRfNamedElement[] sortedCandidates = candidates.toArray(new IRfNamedElement[candidates.size()]);
        int i = 0;
        while (i < candidates.size()) {
            IRfNamedElement candidate = (IRfNamedElement)candidates.get(i);
            sortedCandidates[i] = new R2LCoverpointArg((RfField)candidate);
            ++i;
        }
        this.fRfProject.getMixedLangProjectParent().getSortCandidatesForContentAssist((IRfSingleLangProject)this.fRfProject, sortedCandidates, prefix);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
        return sortedCandidates;
    }

    @Override
    public IRfNamedElement[] getOptionCandidates(R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        List<RfField> candidates = RfCovergroup.getOptionsWithPrefix(this.fRfProject, prefix, this.fMatchType);
        IRfNamedElement[] sortedCandidates = candidates.toArray(new IRfNamedElement[candidates.size()]);
        int i = 0;
        while (i < candidates.size()) {
            IRfNamedElement candidate = candidates.get(i);
            sortedCandidates[i] = new R2LCoverpointArg((RfField)candidate);
            ++i;
        }
        this.fRfProject.getMixedLangProjectParent().getSortCandidatesForContentAssist((IRfSingleLangProject)this.fRfProject, sortedCandidates, prefix);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
        return sortedCandidates;
    }

    @Override
    public IRfNamedElement[] getMatchBlockEnumCandidates(R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement enumType = null;
        if (scope instanceof RfBlock) {
            enumType = ((RfBlock)scope).getMatchScope();
        }
        if (enumType == null) {
            return this.getExprCandidates(scopeContainer, null, prefix);
        }
        scopeContainer.scope = enumType;
        return this.getEnumCandidates(scopeContainer, prefix);
    }
}

