/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.r2lparser;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.pssdt.r2lparser.R2LToken;

public class R2LTokenizer
implements TokenStream {
    private IDocumentExtension3 fDocument;
    private int fInitialOffset;
    private DVTCharacterScanner fScanner;
    private boolean fFirstToken = true;
    private Map<String, Integer> fTokensMap = new HashMap<String, Integer>();
    private boolean fIsMethodProposal;
    private boolean fIsLabelProposal;
    private boolean fStopTokenizer;

    public R2LTokenizer(IDocument document, int offset, boolean enableLeftScan) {
        this.fDocument = (IDocumentExtension3)document;
        this.fInitialOffset = this.adjustTooltipOffset(document, enableLeftScan, offset);
        if (this.fInitialOffset < 0) {
            return;
        }
        this.fScanner = new DVTCharacterScanner(100, document, Math.max(0, this.fInitialOffset - 1), false);
        this.fStopTokenizer = false;
        this.fTokensMap.put("covergroup", 138);
        this.fTokensMap.put("component", 115);
        this.fTokensMap.put("action", 116);
        this.fTokensMap.put("struct", 117);
        this.fTokensMap.put("buffer", 117);
        this.fTokensMap.put("stream", 117);
        this.fTokensMap.put("state", 117);
        this.fTokensMap.put("resource", 117);
        this.fTokensMap.put("extend", 118);
        this.fTokensMap.put("activity", 119);
        this.fTokensMap.put("constraint", 120);
        this.fTokensMap.put("bind", 121);
        this.fTokensMap.put("do", 122);
        this.fTokensMap.put("coverspec", 123);
        this.fTokensMap.put("coverpoint", 124);
        this.fTokensMap.put("covercross", 125);
        this.fTokensMap.put("package", 127);
        this.fTokensMap.put("typedef", 128);
        this.fTokensMap.put("enum", 130);
        this.fTokensMap.put("select", 131);
        this.fTokensMap.put("function", 132);
        this.fTokensMap.put("symbol", 132);
        this.fTokensMap.put("import", 126);
        this.fTokensMap.put("instance", 135);
        this.fTokensMap.put("type", 129);
        this.fTokensMap.put("with", 136);
        this.fTokensMap.put("rand", 133);
        this.fTokensMap.put("inout", 133);
        this.fTokensMap.put("pool", 133);
        this.fTokensMap.put("private", 133);
        this.fTokensMap.put("protected", 133);
        this.fTokensMap.put("input", 141);
        this.fTokensMap.put("output", 141);
        this.fTokensMap.put("lock", 141);
        this.fTokensMap.put("share", 141);
        this.fTokensMap.put("in", 137);
        this.fTokensMap.put("option", 140);
    }

    public boolean getIsMethodProposal() {
        return this.fIsMethodProposal;
    }

    public boolean getIsLabelProposal() {
        return this.fIsLabelProposal;
    }

    private int adjustTooltipOffset(IDocument document, boolean enableLeftScan, int offset) {
        block16: {
            this.fScanner = new DVTCharacterScanner(20, document, offset, true);
            String content = this.fDocument.getContentType("__pss_partitioning", this.fScanner.getOffset(), false);
            if (content.equals("__dftl_partition_content_type") || content.equals("__pss_expansion")) break block16;
            return -1;
        }
        try {
            int mark = offset;
            char ch = '0';
            while (ch != '\uffff') {
                if (enableLeftScan) {
                    mark = this.mark();
                }
                if (!Character.isJavaIdentifierPart(ch = this.readChar())) break;
            }
            while (Character.isWhitespace(ch) && ch != '\uffff') {
                ch = this.readChar();
            }
            while (ch != '\uffff') {
                if (ch == '(') {
                    this.fIsMethodProposal = true;
                    int nested = 1;
                    while (ch != '\uffff') {
                        ch = this.readChar();
                        if (ch == ')') {
                            if (--nested != 0) continue;
                            ch = this.readChar();
                            break;
                        }
                        if (ch != 40) continue;
                        ++nested;
                    }
                } else if (ch == ')') {
                    ch = this.readChar();
                }
                while ((Character.isWhitespace(ch) || ch == ')') && ch != '\uffff') {
                    ch = this.readChar();
                }
                if (ch == ':') {
                    ch = this.readChar();
                    if (ch == 58) break;
                    this.fIsLabelProposal = true;
                    break;
                }
                if (ch != '(') break;
            }
            while (Character.isWhitespace(ch) && ch != '\uffff') {
                ch = this.readChar();
            }
            if (!enableLeftScan) {
                return offset;
            }
            return mark;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return offset;
        }
    }

    private char readChar() {
        try {
            while (this.fScanner.getOffset() > 0 && this.fScanner.getOffset() <= ((IDocument)this.fDocument).getLength()) {
                String content;
                if (this.fDocument.getDocumentPartitioner("__pss_partitioning") != null && !(content = this.fDocument.getContentType("__pss_partitioning", this.fScanner.getOffset() - 1, false)).equals("__dftl_partition_content_type") && !content.equals("__pss_expansion")) {
                    this.fScanner.read();
                    continue;
                }
                char ch = (char)this.fScanner.read();
                return ch;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return '\uffff';
        }
        return '\uffff';
    }

    public Token nextToken() throws TokenStreamException {
        if (this.fInitialOffset < 0) {
            return new R2LToken(1, "");
        }
        Token result = this.internalNextToken();
        this.fFirstToken = false;
        if (this.fStopTokenizer) {
            return new R2LToken(1, "");
        }
        if (result != null && result.getText() != null && result.getText().length() > 20000) {
            this.fStopTokenizer = true;
        }
        return result;
    }

    private Token internalNextToken() throws TokenStreamException {
        try {
            char ch;
            boolean startsWithWS = false;
            boolean idStartsWithWS = false;
            DVTStringBuilder charBuff = new DVTStringBuilder();
            do {
                ch = this.readChar();
                if (this.fFirstToken && Character.isWhitespace(ch)) {
                    startsWithWS = true;
                }
                if (!startsWithWS || !Character.isJavaIdentifierPart(ch)) continue;
                idStartsWithWS = true;
            } while (Character.isWhitespace(ch));
            if (ch == '.') {
                return new R2LToken(101, ".");
            }
            if (ch == ':') {
                int offset = this.mark();
                if (this.readChar() != ':') {
                    this.rewind(offset);
                    return new R2LToken(102, ":");
                }
                return new R2LToken(134, "::");
            }
            if (ch == ';') {
                return new R2LToken(105, ";");
            }
            if (ch == '?') {
                return new R2LToken(106, "?");
            }
            if (Character.isJavaIdentifierPart(ch)) {
                int offset = this.mark();
                do {
                    charBuff.prepend(ch);
                    offset = this.mark();
                } while (Character.isJavaIdentifierPart(ch = this.readChar()));
                this.rewind(offset);
                String text = charBuff.toString();
                if ((startsWithWS || !this.fFirstToken) && this.fTokensMap.containsKey(text)) {
                    return new R2LToken(this.fTokensMap.get(text), text);
                }
                return new R2LToken(idStartsWithWS ? 104 : 103, text);
            }
            if (ch == '=') {
                int offset = this.mark();
                do {
                    charBuff.prepend(ch);
                    offset = this.mark();
                } while ((ch = this.readChar()) == '=' || ch == '!');
                this.rewind(offset);
                return new R2LToken(107, charBuff.toString());
            }
            if (ch == ',') {
                return new R2LToken(110, ",");
            }
            if (ch == ']') {
                int nested = 0;
                boolean ended = false;
                do {
                    charBuff.prepend(ch);
                    ch = this.readChar();
                    if (this.mark() == 0) {
                        return new R2LToken(100, "" + ch);
                    }
                    if (ch == '[' && nested < 0) {
                        ++nested;
                        continue;
                    }
                    if (ch == '[' && nested == 0) {
                        ended = true;
                        continue;
                    }
                    if (ch != ']') continue;
                    --nested;
                } while (ch != '[' || !ended);
                charBuff.prepend(ch);
                return new R2LToken(108, charBuff.toString());
            }
            if (ch == ')') {
                int nested = 0;
                boolean ended = false;
                do {
                    charBuff.prepend(ch);
                    ch = this.readChar();
                    if (this.mark() == 0) {
                        return new R2LToken(100, "" + ch);
                    }
                    if (ch == '(' && nested < 0) {
                        ++nested;
                        continue;
                    }
                    if (ch == '(' && nested == 0) {
                        ended = true;
                        continue;
                    }
                    if (ch != ')') continue;
                    --nested;
                } while (ch != '(' || !ended);
                charBuff.prepend(ch);
                return new R2LToken(109, charBuff.toString());
            }
            if (ch == '}') {
                int nested = 0;
                boolean ended = false;
                do {
                    charBuff.prepend(ch);
                    ch = this.readChar();
                    if (this.mark() == 0) {
                        return new R2LToken(100, "" + ch);
                    }
                    if (ch == '{' && nested < 0) {
                        ++nested;
                        continue;
                    }
                    if (ch == '{' && nested == 0) {
                        ended = true;
                        continue;
                    }
                    if (ch != '}') continue;
                    --nested;
                } while (ch != '{' || !ended);
                charBuff.prepend(ch);
                return new R2LToken(139, charBuff.toString());
            }
            if (ch == '(') {
                return new R2LToken(112, "(");
            }
            if (ch == '[') {
                return new R2LToken(113, "[");
            }
            if (ch == '{') {
                return new R2LToken(114, "{");
            }
            return new R2LToken(100, "" + ch);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new R2LToken(1, "");
        }
    }

    protected int mark() {
        return this.fScanner.getOffset();
    }

    protected void rewind(int offset) {
        if (offset == -1) {
            offset = this.fInitialOffset;
            this.fFirstToken = true;
        }
        while (this.fScanner.getOffset() < offset) {
            this.fScanner.unread();
        }
        if (this.fScanner.getOffset() == this.fInitialOffset) {
            this.fFirstToken = true;
        }
    }
}

