/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.r2lparser;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.r2lparser.R2LManager;
import ro.amiq.pssdt.r2lparser.R2LNoProposalElement;
import ro.amiq.pssdt.r2lparser.R2LParser;
import ro.amiq.pssdt.r2lparser.R2LResultContainer;
import ro.amiq.pssdt.r2lparser.R2LScopeContainer;
import ro.amiq.pssdt.r2lparser.R2LTokenizer;
import ro.amiq.pssdt.r2lparser.R2LWalker;

public class R2LTooltipManager
extends R2LManager {
    public R2LTooltipManager(RfProject rfProject, RfDefElement initialScope, IResource file, IDocument document, int documentOffset) {
        super(rfProject, initialScope, file, document, documentOffset, documentOffset);
    }

    @Override
    public R2LResultContainer getProposals() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RfWNamedElementAndScope> getElements() {
        try {
            List<String> path;
            if (this.fInitialScope == null) {
                return null;
            }
            if (this.fDocumentOffset <= 0) return null;
            if (this.fDocument.getLength() <= this.fDocumentOffset - 1) {
                return null;
            }
            if (!Character.isJavaIdentifierPart(this.fDocument.getChar(this.fDocumentOffset - 1))) {
                if (this.fDocumentOffset == this.fDocument.getLength()) return null;
                if (!Character.isJavaIdentifierPart(this.fDocument.getChar(this.fDocumentOffset))) {
                    return null;
                }
                ++this.fDocumentOffset;
            }
            R2LResultContainer result = null;
            R2LScopeContainer scopeContainer = new R2LScopeContainer(this.fInitialScope);
            R2LWalker walker = new R2LWalker(this);
            R2LTokenizer lexer = new R2LTokenizer(this.fDocument, this.fDocumentOffset, true);
            RfNamedElement namedElement = this.fInitialScope.getNamedElement();
            boolean enableFieldDecl = !(namedElement instanceof RfBlock) || !((RfBlock)namedElement).isConstraint();
            R2LParser parser = new R2LParser(lexer, enableFieldDecl, true);
            parser.rules();
            AST pAST = parser.getAST();
            if (pAST != null) {
                result = walker.rules(pAST, scopeContainer);
            }
            if (result == null || !result.isNumber && !result.hasProposals() && result.allowProposals()) {
                scopeContainer.accessKind = 0;
                path = result == null ? null : result.path;
                String prefix = result == null || result.prefix == null ? "" : result.prefix;
                result = new R2LResultContainer();
                result.candidates = this.getExprCandidates(scopeContainer, null, prefix);
                result.prefix = prefix;
                result.path = path;
            }
            if (!result.isNumber && !result.hasProposals()) {
                path = result.path;
                result = new R2LResultContainer();
                result.candidates = null;
                result.prefix = "";
                result.path = path;
            }
            result.initialScope = this.fInitialScope;
            ArrayList<String> instancePath = new ArrayList<String>();
            if (result.path != null) {
                instancePath.addAll(result.path);
            }
            if (result.prefix != null) {
                instancePath.add(result.prefix);
            }
            if (result.candidates == null) return null;
            if (result.candidates.length == 0) return null;
            ArrayList<RfWNamedElementAndScope> allElements = new ArrayList<RfWNamedElementAndScope>();
            IRfNamedElement[] iRfNamedElementArray = result.candidates;
            int n = result.candidates.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return allElements;
                }
                IRfNamedElement candidate = iRfNamedElementArray[n2];
                allElements.add(new RfWNamedElementAndScope(candidate, result.initialScope));
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    @Override
    public IRfNamedElement[] getEnumCandidates(R2LScopeContainer scopeContainer, List<String> enums, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scope = scopeContainer.scope;
        if (!(scope instanceof RfEnumType)) {
            return null;
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                return candidate instanceof RfEnumItem;
            }

            public boolean allowEnumElement() {
                return true;
            }

            public int resultMaxSize() {
                return 1;
            }
        };
        ((RfEnumType)scope).getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, 1, 1, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.toArray(new IRfNamedElement[candidates.size()]);
    }

    @Override
    public IRfNamedElement[] getEnumCandidates(R2LScopeContainer scopeContainer, String prefix) {
        return this.getEnumCandidates(scopeContainer, null, prefix);
    }

    @Override
    public IRfNamedElement[] getTypeCandidates(R2LScopeContainer scopeContainer, String prefix, boolean showCompAndPkg, String typeKind, R2LScopeContainer likeContainer) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null || !(scope instanceof RfMembersContainer)) {
            return null;
        }
        HashSet<IRfNamedElement> candidates = new HashSet<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                return candidate instanceof RfEnumType || candidate instanceof RfTypeAlias || candidate instanceof RfPackage || candidate instanceof RfStruct || candidate instanceof RfCovergroup;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 1;
            }
        };
        scope.getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, 1, 4, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.toArray(new IRfNamedElement[candidates.size()]);
    }

    @Override
    public IRfNamedElement[] getExprCandidates(R2LScopeContainer rightScopeContainer, R2LScopeContainer leftScopeContainer, String prefix) {
        IRfNamedElement[] result;
        RfNamedElement leftScope;
        if (rightScopeContainer == null || rightScopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = rightScopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null || !(scope instanceof RfMembersContainer)) {
            return null;
        }
        RfNamedElement rfNamedElement = leftScope = leftScopeContainer != null && leftScopeContainer.scope != null ? ((IRfScope)leftScopeContainer.scope).getNamedElement() : null;
        if (leftScope instanceof RfEnumType && (rightScopeContainer.path == null || rightScopeContainer.path.isEmpty()) && (result = this.getEnumCandidates(leftScopeContainer, prefix)) != null && result.length > 0 && !(result[0] instanceof R2LNoProposalElement)) {
            return result;
        }
        HashSet<IRfNamedElement> candidates = new HashSet<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (candidate instanceof RfMethod || candidate instanceof RfField || candidate instanceof RfBlock && !((RfBlock)candidate).isAnonymous()) {
                    if (leftScope instanceof RfEnumType && candidate instanceof IRfAssociatedType) {
                        IRfNamedElement assocType = ((IRfAssociatedType)candidate).getAssociatedType();
                        while (assocType instanceof RfTypeAlias) {
                            assocType = ((RfTypeAlias)assocType).getAssociatedType();
                        }
                        return assocType instanceof RfStruct || assocType instanceof RfEnumType;
                    }
                    return true;
                }
                return false;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 1;
            }
        };
        scope.getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, 1, 4, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.toArray(new IRfNamedElement[candidates.size()]);
    }

    @Override
    public IRfNamedElement[] getMappingCandidates(R2LScopeContainer scopeContainer, String prefix, String covergroupName, final Set<String> ports) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null || !(scope instanceof RfMembersContainer)) {
            return null;
        }
        if (!(scope instanceof RfCovergroup)) {
            return null;
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (candidate instanceof RfField && ((RfField)candidate).getFieldModifier() == FieldModifier.COVERGROUP_PORT) {
                    return !ports.contains(candidate.getName());
                }
                return false;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 1;
            }
        };
        scope.getElementsWithPrefix(candidates, this.fInitialScope, this.fDeterminant, prefix, 1, 1, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.toArray(new IRfNamedElement[candidates.size()]);
    }

    @Override
    public IRfNamedElement[] getOptionCandidates(R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        List<RfField> candidates = RfCovergroup.getOptionsWithPrefix(this.fRfProject, prefix, 1);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        return candidates.toArray(new IRfNamedElement[candidates.size()]);
    }

    @Override
    public IRfNamedElement[] getMatchBlockEnumCandidates(R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return null;
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null) {
            return null;
        }
        RfNamedElement enumType = null;
        if (scope instanceof RfBlock) {
            enumType = ((RfBlock)scope).getMatchScope();
        }
        if (enumType == null) {
            return this.getExprCandidates(scopeContainer, null, prefix);
        }
        scopeContainer.scope = enumType;
        return this.getEnumCandidates(scopeContainer, prefix);
    }
}

