/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.statistics.FileInfo;
import ro.amiq.dvt.statistics.Info;
import ro.amiq.dvt.statistics.Metric;
import ro.amiq.dvt.statistics.RelevantInfo;
import ro.amiq.dvt.statistics.StatisticsUtilProviderBase;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;

public class StatisticsUtilProvider
extends StatisticsUtilProviderBase {
    private PSSInfo architecturesInfo;
    private PSSInfo entitiesInfo;
    private PSSInfo configurationsInfo;
    private PSSInfo componentsInfo;
    private PSSInfo functionsInfo;
    private PSSInfo proceduresInfo;
    private PSSInfo packagesInfo;

    public void clean() {
        super.clean();
        this.architecturesInfo = null;
        this.entitiesInfo = null;
        this.configurationsInfo = null;
        this.componentsInfo = null;
        this.functionsInfo = null;
        this.proceduresInfo = null;
        this.packagesInfo = null;
    }

    public void init() {
        super.init();
        this.architecturesInfo = new PSSArchitectureInfo();
        this.entitiesInfo = new PSSEntityInfo();
        this.configurationsInfo = new PSSConfigurationInfo();
        this.componentsInfo = new PSSComponentInfo();
        this.functionsInfo = new PSSFunctionInfo();
        this.proceduresInfo = new PSSProcedureInfo();
        this.packagesInfo = new PSSPackageInfo();
    }

    protected void collectSpecificStatistics(IProject project, IProgressMonitor progressMonitor) {
        super.collectSpecificStatistics(project, progressMonitor);
        if (!this.setCurrentTask("Collecting type statistics ...", true)) {
            return;
        }
        this.addSeparator();
        this.createAndAddMetric("Nof Architectures", this.architecturesInfo.counter);
        this.createAndAddMetric("Nof Entities", this.entitiesInfo.counter);
        this.createAndAddMetric("Nof Configurations", this.configurationsInfo.counter);
        this.createAndAddMetric("Nof Components", this.componentsInfo.counter);
        this.createAndAddMetric("Nof Functions", this.functionsInfo.counter);
        this.createAndAddMetric("Nof Procedures", this.proceduresInfo.counter);
        this.createAndAddMetric("Nof Packages", this.packagesInfo.counter);
        if (this.architecturesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.architecturesInfo);
        }
        if (this.entitiesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.entitiesInfo);
        }
        if (this.configurationsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.configurationsInfo);
        }
        if (this.componentsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.componentsInfo);
        }
        if (this.functionsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.functionsInfo);
        }
        if (this.proceduresInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.proceduresInfo);
        }
        if (this.packagesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.packagesInfo);
        }
        this.fProgressMonitor = null;
    }

    protected boolean isFiltered(Object o) {
        if (!(o instanceof RfNamedElement) && o instanceof String) {
            return this.fSpm.isFiltered((String)o);
        }
        return false;
    }

    protected FileInfo computeFileInfo(String fileName) {
        FileInfo result;
        block18: {
            result = new FileInfo(fileName);
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(fileName));
                    String line = null;
                    boolean inComment = false;
                    while ((line = in.readLine()) != null) {
                        ++result.totalNofLines;
                        if ((line = line.trim()).startsWith("/*")) {
                            inComment = true;
                        }
                        if (line.contains("*/")) {
                            inComment = false;
                        }
                        if (line.startsWith("--")) {
                            ++result.commentNofLines;
                            continue;
                        }
                        if (line.length() == 0) {
                            ++result.emptyNofLines;
                            continue;
                        }
                        if (inComment) {
                            ++result.commentNofLines;
                            continue;
                        }
                        ++result.codeNofLines;
                        result.codeNofChars += line.length();
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (in == null) break block18;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private PSSInfo computeElementInfo(RfNamedElement rfNamedElement) {
        PSSInfo result = new PSSInfo(rfNamedElement.getName());
        RfDefElement declaration = rfNamedElement.getDeclaration();
        if (declaration != null) {
            result.nofDefinitionLines.counter = declaration.getEndLine() - declaration.getStartLine() + 1;
        }
        return result;
    }

    public String getNature() {
        return "ro.amiq.pssdt.pssnature";
    }

    protected String heading() {
        return "PSS statistics";
    }

    protected IRfSingleLangProject getRfProject(IProject project) {
        return RfManager.getInstance().getRfProject(project);
    }

    protected List<ParserPath> getCompiledParserPaths(IRfSingleLangProject rfProject) {
        RfProject pssRfProject = (RfProject)rfProject;
        Collection<RfFileDef> allFiles = pssRfProject.getFiles();
        return allFiles.stream().map(x -> x.getParserPath()).distinct().collect(Collectors.toList());
    }

    private static class PSSArchitectureInfo
    extends PSSInfo {
        public PSSArchitectureInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Architectures Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class PSSComponentInfo
    extends PSSInfo {
        public PSSComponentInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Components Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class PSSConfigurationInfo
    extends PSSInfo {
        public PSSConfigurationInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Configuration Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class PSSEntityInfo
    extends PSSInfo {
        public PSSEntityInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Entities Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class PSSFunctionInfo
    extends PSSInfo {
        public PSSFunctionInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Functions Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class PSSInfo
    extends Info {
        public RelevantInfo nofDefinitionLines;

        protected PSSInfo(String elementName) {
            this.nofDefinitionLines = new RelevantInfo(elementName);
        }

        public void update(PSSInfo info) {
            ++this.counter;
            this.nofDefinitionLines.update(info.nofDefinitionLines);
        }
    }

    private static class PSSPackageInfo
    extends PSSInfo {
        public PSSPackageInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Packages Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class PSSProcedureInfo
    extends PSSInfo {
        public PSSProcedureInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Procedures Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }
}

