/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.ui.editor.PSSEditor;
import ro.amiq.pssdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class BaseRfAction
extends TextEditorAction {
    public BaseRfAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected RfNamedElementActionHyperlink getRfNamedElementActionHyperlink() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return null;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return null;
        }
        if (!(textEditor instanceof PSSEditor)) {
            return null;
        }
        int offset = ((PSSEditor)textEditor).getCursor();
        if (!(textEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)textEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(file.getProject());
        if (rfProject == null) {
            return null;
        }
        RfFileDef rfFileDef = rfProject.getFile((IResource)file);
        if (rfFileDef == null) {
            return null;
        }
        return RfUtils.getCustomRfNamedElementActionHyperlink(textEditor, project, document, offset, rfFileDef.getParserPath());
    }
}

