/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.pssdt.ui.editor.PSSPreprocessingRule;
import ro.amiq.pssdt.ui.editor.PSSStyle;
import ro.amiq.pssdt.ui.editor.rules.PSSFoldingZoneMarker;
import ro.amiq.pssdt.ui.editor.rules.PSSKeyWordRule;
import ro.amiq.pssdt.ui.editor.rules.PSSNumericRule;
import ro.amiq.pssdt.ui.editor.rules.PSSWhitespaceDetector;
import ro.amiq.pssdt.ui.preferences.PrefConst;

public class PSSCodeScanner
extends DVTBaseScanner {
    private PSSKeyWordRule fPSSKeyWordRule;

    public PSSCodeScanner(PSSStyle style, int nofLinesFolding) {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new PSSWhitespaceDetector()));
        this.fPSSKeyWordRule = new PSSKeyWordRule(PrefConst.getPSSKeywords(), PrefConst.getPSSTypes(), style, nofLinesFolding);
        DVTHlUtils.addListener((IHighlightListener)this.fPSSKeyWordRule);
        rules.add(this.fPSSKeyWordRule);
        rules.add(new PSSFoldingZoneMarker(nofLinesFolding));
        rules.add(new PSSNumericRule(style.getToken("highlight.number")));
        rules.add(new PSSPreprocessingRule(style.getToken("highlight.preproc")));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setNofLinesFolding(int nofLines) {
        if (this.fRules != null) {
            IRule[] iRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                IRule rule = iRuleArray[n2];
                if (rule instanceof PSSFoldingZoneMarker) {
                    ((PSSFoldingZoneMarker)rule).setNofLinesFolding(nofLines);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        DVTHlUtils.removeListener((IHighlightListener)this.fPSSKeyWordRule);
        super.dispose();
    }
}

