/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUtils;
import ro.amiq.dvt.ui.custompragma.ICustomPragmaStyleListener;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.rules.CommentHtmlHyperlinkRule;
import ro.amiq.dvt.ui.editor.rules.CommentPragmaRule;
import ro.amiq.dvt.ui.editor.rules.CustomPragmaRule;
import ro.amiq.dvt.ui.editor.rules.InspectViewHyperlinkRule;
import ro.amiq.dvt.ui.editor.rules.JavadocTagsRule;
import ro.amiq.pssdt.ui.editor.PSSStyle;
import ro.amiq.pssdt.ui.editor.rules.PSSCommentTaskRule;
import ro.amiq.pssdt.ui.editor.rules.PSSCommentUserFoldingRule;
import ro.amiq.pssdt.ui.editor.rules.PSSWhitespaceDetector;
import ro.amiq.pssdt.ui.editor.rules.PSSWordDetector;

public class PSSCommentScanner
extends DVTBaseScanner {
    private CustomPragmaRule customPragmaRule;

    public PSSCommentScanner(PSSStyle style, boolean enable, int nofLinesFolding, boolean addInspectViewScanner, IProject project) {
        ArrayList<Object> rules = new ArrayList<Object>();
        if (addInspectViewScanner) {
            rules.add(new InspectViewHyperlinkRule(style.getToken("highlight.comment_hyperlink"), enable));
        }
        rules.add(new WhitespaceRule((IWhitespaceDetector)new PSSWhitespaceDetector()));
        rules.add(new CommentHtmlHyperlinkRule(style.getToken("highlight.comment_hyperlink"), enable));
        rules.add((Object)new PSSCommentTaskRule(style.getToken("highlight.comment_task"), enable));
        this.customPragmaRule = new CustomPragmaRule(style.getToken("highlight.comment_pragma"), project);
        rules.add(this.customPragmaRule);
        rules.add(new JavadocTagsRule(style.getToken("highlight.javadoc_tags"), enable));
        rules.add(new CommentPragmaRule(style.getToken("highlight.comment_pragma"), enable));
        rules.add(new PSSCommentUserFoldingRule(style.getToken("highlight.comment_task"), !enable ? 0 : nofLinesFolding));
        rules.add(new WordRule((IWordDetector)new PSSWordDetector(), style.getToken("highlight.comment")));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setNofLinesManualFolding(int manualFoldingEnabled) {
        if (this.fRules != null) {
            IRule[] iRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                IRule rule = iRuleArray[n2];
                if (rule instanceof PSSCommentUserFoldingRule) {
                    ((PSSCommentUserFoldingRule)rule).setNofLinesFolding(manualFoldingEnabled);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        CustomPragmaUtils.removeListener((ICustomPragmaStyleListener)this.customPragmaRule);
        super.dispose();
    }
}

