/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import ro.amiq.dvt.ui.editor.DVTPositionUpdater;
import ro.amiq.dvt.ui.editor.IDVTDocumentSetupParticipant;
import ro.amiq.pssdt.ui.editor.PSSPartitionScanner;

public abstract class PSSDocumentSetupParticipantCommon
implements IDVTDocumentSetupParticipant {
    protected FastPartitioner partitioner;

    public void setup(IDocument document) {
        if (document == null) {
            return;
        }
        this.addPositionCategories(document);
    }

    public void addPositionCategories(IDocument document) {
        DVTPositionUpdater semanticUpdater = new DVTPositionUpdater("SEMANTIC_HIGHLIGHT");
        DVTPositionUpdater reflectionUpdater = new DVTPositionUpdater("REFLECTION");
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            this.partitioner = new FastPartitioner((IPartitionTokenScanner)new PSSPartitionScanner(), new String[]{"__pss_sl_comment", "__pss_ml_comment", "__pss_literal", "__pss_expansion", "__pss_escaped_id", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__pss_partitioning", (IDocumentPartitioner)this.partitioner);
            this.partitioner.connect(document);
        }
        document.addPositionCategory("SEMANTIC_HIGHLIGHT");
        document.addPositionUpdater((IPositionUpdater)semanticUpdater);
        document.addPositionCategory("REFLECTION");
        document.addPositionUpdater((IPositionUpdater)reflectionUpdater);
        document.addPositionCategory("__dvt_macro_position");
    }

    public void disconnect() {
        if (this.partitioner != null) {
            this.partitioner.disconnect();
        }
        this.partitioner = null;
    }
}

