/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.CopyFileInfoAction;
import ro.amiq.dvt.ui.actions.CopyFileInfoKind;
import ro.amiq.dvt.ui.actions.DVTQuickMenuCreator;
import ro.amiq.dvt.ui.dnd.RfNamedElementTransfer;
import ro.amiq.dvt.ui.editor.DVTContentAssistAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPairMatcher;
import ro.amiq.dvt.ui.editor.DVTPairMatcherAccessor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.DVTTextOperationAction;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.actions.ToggleMarkOccurrencesAction;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTContentAssistConstants;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationAction;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationContributionItem;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.search.ui.IBaseShowConstraintsAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowEmittersAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowInstancesAction;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.IPSSModule;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.model.reflection.views.PSSQuickViewersUtil;
import ro.amiq.pssdt.templates.TemplateMessages;
import ro.amiq.pssdt.ui.actions.OpenDeclarationAction;
import ro.amiq.pssdt.ui.editor.PSSDocumentSetupParticipant;
import ro.amiq.pssdt.ui.editor.PSSEditorMessages;
import ro.amiq.pssdt.ui.editor.PSSFileDocumentProvider;
import ro.amiq.pssdt.ui.editor.PSSPairMatcherAccessor;
import ro.amiq.pssdt.ui.editor.PSSScopeBreadcrumbUtils;
import ro.amiq.pssdt.ui.editor.PSSSourceViewerConfiguration;
import ro.amiq.pssdt.ui.editor.PSSWordFinder;
import ro.amiq.pssdt.ui.editor.ToggleCommentAction;
import ro.amiq.pssdt.ui.editor.actions.PSSRenameRefactorAction;
import ro.amiq.pssdt.ui.editor.actions.ReferencesInFileAction;
import ro.amiq.pssdt.ui.editor.actions.ReferencesInProjectAction;
import ro.amiq.pssdt.ui.editor.actions.ReferencesInWorkingSetAction;
import ro.amiq.pssdt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.pssdt.ui.editor.actions.ShowActivityDiagramAction;
import ro.amiq.pssdt.ui.editor.actions.ShowInstancesAction;
import ro.amiq.pssdt.ui.editor.actions.ShowScenarioDiagramAction;
import ro.amiq.pssdt.ui.editor.highlight.PSSSemanticHighlighter;
import ro.amiq.pssdt.ui.editor.hover.PSSHoverSourceInformationPresenter;
import ro.amiq.pssdt.ui.editor.hyperlink.RfHyperlinkDetector;
import ro.amiq.pssdt.ui.editor.lazy.outline.PSSLazyOutlinePage;
import ro.amiq.pssdt.ui.editor.lazy.outline.PSSQuickLazyOutlineView;

public class PSSEditor
extends DVTEditor {
    public static final String ID = "ro.amiq.pssdt.ui.editor.PSSEditor";
    private static final String TEMPLATE_PROPOSALS = "template_proposals_action";
    public static final String TOGGLE_COMMENT = "ro.amiq.pssdt.ui.editor.ToggleComment";
    public static final String FORMAT_SOURCE = "ro.amiq.pssdt.ui.editor.FormatSource";
    public static final String OPEN_HELP_SEARCH = "ro.amiq.pssdt.ui.editor.OpenHelpSearch";
    public static final String TOGGLE_MARK_OCCURRENCES = "ro.amiq.pssdt.ui.editor.ToggleMarkOccurrences";
    public static final String DEFINE_FOLDING_REGION = "ro.amiq.pssdt.ui.editor.DefineFoldingRegion";
    public static final String EXPAND_FIRST_LEVEL = "ro.amiq.pssdt.ui.editor.ExpandFirstLevel";
    public static final String EXPAND_ALL_LEVELS = "ro.amiq.pssdt.ui.editor.ExpandAllLevels";
    public static final String COLLAPSE_ALL_LEVELS = "ro.amiq.pssdt.ui.editor.CollapseAllLevels";
    public static final String FORWARD_END_OF_WORD = "ro.amiq.pssdt.ui.editor.ForwardEndOfWord";
    public static final String BACKWARD_START_OF_WORD = "ro.amiq.pssdt.ui.editor.BackwardStartOfWord";
    public static final String GOTO_PAIR_BRACKET = "ro.amiq.pssdt.ui.editor.GoToPairBracket";
    public static final String TOGGLE_COLLAPSE_LINE = "ro.amiq.pssdt.ui.editor.ToggleCollapseLine";
    public static final String TOGGLE_EXPAND_SCOPE = "ro.amiq.edt.ui.editor.ToggleExpandScope";
    public static final String SOURCE_SUBMENU = "ro.amiq.pssdt.ui.editor.SourceSubMenu";
    public static final String SHOW_ACTIVITY_DIAGRAM = "ro.amiq.pssdt.ui.editor.ShowActivityDiagram";
    public static final String SHOW_SCENARIO_DIAGRAM = "ro.amiq.pssdt.ui.editor.ShowScenarioDiagram";
    public static final String QUICK_OUTLINE = "ro.amiq.pssdt.ui.editor.QuickOutline";
    public static final String OPEN_DECLARATION = "ro.amiq.pssdt.ui.editor.OpenDeclaration";
    public static final String REFERENCES_IN_WORKSPACE = "ro.amiq.pssdt.ui.editor.actions.ReferencesInWorkspace";
    public static final String REFERENCES_IN_PROJECT = "ro.amiq.pssdt.ui.editor.actions.ReferencesInProject";
    public static final String REFERENCES_IN_FILE = "ro.amiq.pssdt.ui.editor.actions.ReferencesInFile";
    public static final String REFERENCES_IN_WORKING_SET = "ro.amiq.pssdt.ui.editor.actions.ReferencesInWorkingSet";
    public static final String REFERENCES_SUBMENU_COMMAND_ID = "ro.amiq.pssdt.ui.editor.ReferencesSubMenu";
    public static final String REFACTOR_RENAME = "ro.amiq.pssdt.ui.editor.actions.RefactorRename";
    public static final String REFACTOR_ADD_PORT = "ro.amiq.pssdt.ui.editor.actions.RefactorAddPort";
    public static final String REFACTOR_ADD_GENERIC = "ro.amiq.pssdt.ui.editor.actions.RefactorAddGeneric";
    public static final String REFACTOR_SUBMENU = "ro.amiq.pssdt.ui.editor.RefactorSubMenu";
    public static final String SELECT_ENCLOSING_ELEMENT = "ro.amiq.pssdt.ui.editor.SelectEnclosingElement";
    public static final String RESTORE_LAST_SELECTION = "ro.amiq.pssdt.ui.editor.RestoreLastSelection";
    public static final String COPY_FULL_PATH = "ro.amiq.pssdt.ui.editor.CopyFullPath";
    public static final String COPY_FILE_NAME = "ro.amiq.pssdt.ui.editor.CopyFileName";
    public static final String SHOW_INSTANCES = "ro.amiq.dvt.ui.views.commands.ShowInstances";
    private PSSLazyOutlinePage fOutlinePage;

    public PSSEditor() {
        PSSSourceViewerConfiguration configuration = new PSSSourceViewerConfiguration(this);
        configuration.setBracketMatcher((ICharacterPairMatcher)DVTPairMatcher.makePairMatcher((LanguageKind)LanguageKind.PSS, (char[])BRACKETS, (DVTPairMatcherAccessor)new PSSPairMatcherAccessor()));
        this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
        PSSPlugin.getDefault().getWorkbench().getDecoratorManager().addListener((ILabelProviderListener)this);
        this.setHelpContextId("ro.amiq.pssdt.help.editor");
    }

    protected void initializeEditor() {
        this.setDocumentProvider((IDocumentProvider)new PSSFileDocumentProvider());
        super.initializeEditor();
    }

    public void dispose() {
        try {
            try {
                ProjectionViewer viewer;
                PSSSourceViewerConfiguration configuration = (PSSSourceViewerConfiguration)this.getSourceViewerConfiguration();
                if (configuration != null) {
                    configuration.dispose();
                }
                if ((viewer = (ProjectionViewer)this.getSourceViewer()) != null) {
                    viewer.unconfigure();
                    viewer.setProjectionSummary(null);
                }
                DVTAutoIndentDetectionManager.INSTANCE.removeDetectedIndendationDocument(this.getDocument());
                this.disconnectFileFromDocument();
                TextEditorAction action = (TextEditorAction)this.getAction("ToggleMarkOccurrences");
                if (action != null) {
                    action.setEditor(null);
                }
                if ((action = (TextEditorAction)this.getAction("ToggleComment")) != null) {
                    action.setEditor(null);
                }
                if (this.fOutlinePage != null) {
                    this.fOutlinePage.dispose();
                    this.fOutlinePage = null;
                }
                RfUtils.clearCaches();
                this.disposeListeners();
                PSSDocumentSetupParticipant setupParticipant = (PSSDocumentSetupParticipant)((PSSFileDocumentProvider)this.getDocumentProvider()).getDocumentSetupParticipant();
                setupParticipant.disconnect();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void disposeListeners() {
        PSSPlugin.getDefault().getWorkbench().getDecoratorManager().removeListener((ILabelProviderListener)this);
        super.disposeListeners();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setupEditorDropTarget();
    }

    private void setupEditorDropTarget() {
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        DropTarget dropTarget = (DropTarget)textWidget.getData("DropTarget");
        if (dropTarget == null) {
            dropTarget = new DropTarget((Control)textWidget, 1);
        }
        Transfer[] currentTransfers = dropTarget.getTransfer();
        int currentLength = currentTransfers.length;
        Transfer[] newTransfers = new Transfer[currentLength + 1];
        System.arraycopy(currentTransfers, 0, newTransfers, 0, currentLength);
        newTransfers[currentLength] = RfNamedElementTransfer.getInstance();
        dropTarget.setTransfer(newTransfers);
        dropTarget.addDropListener((DropTargetListener)new StyledTextDropTargetEffect(textWidget){

            public void dragEnter(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.detail = 1;
                event.feedback |= 9;
                super.dragEnter(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.detail = 1;
                event.feedback |= 9;
                super.dragOperationChanged(event);
            }

            public void dragOver(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.feedback |= 9;
                event.detail = 1;
                super.dragOver(event);
            }

            public void drop(DropTargetEvent event) {
            }
        });
    }

    public void configureProjectionSupport(ProjectionSupport projectionSupport) {
        projectionSupport.addSummarizableAnnotationType(PSSProblemCategories.PSS_SYNTAX.getMarkerId());
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.bookmark");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.task");
        projectionSupport.addSummarizableAnnotationType("ro.amiq.dvt.ui.occurrences");
        projectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DVTInformationControl(shell, (DefaultInformationControl.IInformationPresenter)new PSSHoverSourceInformationPresenter());
            }
        });
    }

    public void configureSourceViewerConfiguration(ProjectionAnnotationModel annotationModel) {
        PSSSourceViewerConfiguration configuration = (PSSSourceViewerConfiguration)this.getSourceViewerConfiguration();
        configuration.setProjectionAnnotationModel(annotationModel);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setMatchingCharacterPainterPreferenceKeys("matchingBracketsPSSEnable", "matchingBracketsPSSColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new PSSLazyOutlinePage(this);
            }
            if (this.fOutlinePage.getEditor() == null) {
                this.fOutlinePage.setEditor(this);
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            super.doSave(monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void doSaveAs() {
        try {
            super.doSaveAs();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        try {
            super.doSetInput(input);
            PSSDocumentSetupParticipant setupParticipant = (PSSDocumentSetupParticipant)((PSSFileDocumentProvider)this.getDocumentProvider()).getDocumentSetupParticipant();
            IDocumentExtension3 extension3 = (IDocumentExtension3)this.getDocument();
            if (extension3.getDocumentPartitioner("__pss_partitioning") == null) {
                setupParticipant.setup(this.getDocument());
            }
            this.setPrefStore(PSSPlugin.getDefault().getPreferenceStore());
            this.connectFileToDocument(false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfProject getRfProject() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return RfManager.getInstance().getRfProject(project);
    }

    public Image getTitleImage() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        Image image = super.getTitleImage();
        try {
            if (file == null) {
                image = DVTImages.imageCache.getImage(DVTImages.DESC_PSS_MODULE_GRAY);
            } else {
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        image = DVTImages.imageCache.getImage(DVTImages.DESC_PSS_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
                Image newImage = ProjectColorUtils.transformImage((ImageDescriptor)DVTImages.DESC_PSS_MODULE_BLACK_TRANSPARENT, (String)file.getProject().getName());
                image = newImage == null ? image : newImage;
            }
            ILabelDecorator decorator = PSSPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
            if (decorator != null) {
                return decorator.decorateImage(image, (Object)this);
            }
        }
        catch (Exception exception) {}
        return image;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
    }

    protected void createActions() {
        super.createActions();
        Object a = new DVTEditor.CollapseAllLevelsAction((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "CollapseAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(COLLAPSE_ALL_LEVELS);
        this.setAction("CollapseAllLevels", (IAction)a);
        a = new DVTEditor.ExpandAllLevelsAction((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "ExpandAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(EXPAND_ALL_LEVELS);
        this.setAction("ExpandAllLevels", (IAction)a);
        a = new DVTEditor.ShowFirstLevelAction((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "ExpandFirstLevel.", (ITextEditor)this);
        a.setActionDefinitionId(EXPAND_FIRST_LEVEL);
        this.setAction("ExpandFirstLevel", (IAction)a);
        a = new DVTEditor.DefineFoldingRegionAction((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "DefineFoldingRegion.", (ITextEditor)this);
        a.setActionDefinitionId(DEFINE_FOLDING_REGION);
        this.setAction("DefineFoldingRegion", (IAction)a);
        a = new DVTEditor.OpenHelpSearch((DVTEditor)this);
        a.setActionDefinitionId(OPEN_HELP_SEARCH);
        this.setAction("OpenHelpSearch", (IAction)a);
        a = new ToggleMarkOccurrencesAction(PSSEditorMessages.getResourceBundle(), "ToggleMarkOccurrences.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_MARK_OCCURRENCES);
        this.setAction("ToggleMarkOccurrences", (IAction)a);
        this.getEditorSite().getActionBars().setGlobalActionHandler(TOGGLE_MARK_OCCURRENCES, (IAction)a);
        a = new DVTEditor.ForwardEndOfWord((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(FORWARD_END_OF_WORD);
        this.setAction("ForwardEndOfWord", (IAction)a);
        a = new DVTEditor.BackwardStartOfWord((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(BACKWARD_START_OF_WORD);
        this.setAction("BackwardStartOfWord", (IAction)a);
        a = new DVTEditor.SelectEnclosingElement((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(SELECT_ENCLOSING_ELEMENT);
        this.setAction("SelectEnclosingElement", (IAction)a);
        a = new DVTEditor.RestoreLastSelection((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(RESTORE_LAST_SELECTION);
        this.setAction("RestoreLastSelection", (IAction)a);
        a = new DVTEditor.GoToPairMatchingBeginEndBlockOrPairBracket((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "GoToPairBracket.", (ITextEditor)this);
        a.setActionDefinitionId(GOTO_PAIR_BRACKET);
        this.setAction("GoToPairBracket", (IAction)a);
        a = new DVTEditor.ToggleCollapseLineAction((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "ToggleCollapseLine.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_COLLAPSE_LINE);
        this.setAction("ToggleCollapseLine", (IAction)a);
        a = new DVTEditor.ToggleExpandScopeAction((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "ToggleExpandScope.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_EXPAND_SCOPE);
        this.setAction("ToggleExpandScope", (IAction)a);
        a = new DVTContentAssistAction(PSSEditorMessages.getResourceBundle(), "ContentAssistProposal", (ITextEditor)this);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        a = new DVTTextOperationAction(TemplateMessages.getResourceBundle(), "Editor.template_proposals_action.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(TEMPLATE_PROPOSALS, (IAction)a);
        this.markAsStateDependentAction(TEMPLATE_PROPOSALS, true);
        a = new DVTEditor.FormatSourceAction((DVTEditor)this, PSSEditorMessages.getResourceBundle(), "FormatSource.", (ITextEditor)this);
        a.setActionDefinitionId(FORMAT_SOURCE);
        this.setAction("FormatSource", (IAction)a);
        a = new ToggleCommentAction(PSSEditorMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_COMMENT);
        this.setAction("ToggleComment", (IAction)a);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        a = new OpenDeclarationAction(PSSEditorMessages.getResourceBundle(), "OpenDeclaration.", (ITextEditor)this);
        a.setActionDefinitionId(OPEN_DECLARATION);
        this.setAction("OpenDeclaration", (IAction)a);
        a = new ShowActivityDiagramAction(PSSEditorMessages.getResourceBundle(), "ShowActivityDiagram.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_ACTIVITY_DIAGRAM);
        this.setAction("ShowActivityDiagram", (IAction)a);
        a = new ShowScenarioDiagramAction(PSSEditorMessages.getResourceBundle(), "ShowScenarioDiagram.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_SCENARIO_DIAGRAM);
        this.setAction("ShowScenarioDiagram", (IAction)a);
        a = new ReferencesInWorkspaceAction(PSSEditorMessages.getResourceBundle(), "ReferencesInWorkspace.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_WORKSPACE);
        this.setAction("ReferencesInWorkspace", (IAction)a);
        a = new ReferencesInProjectAction(PSSEditorMessages.getResourceBundle(), "ReferencesInProject.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_PROJECT);
        this.setAction("ReferencesInProject", (IAction)a);
        a = new ReferencesInFileAction(PSSEditorMessages.getResourceBundle(), "ReferencesInFile.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_FILE);
        this.setAction("ReferencesInFile", (IAction)a);
        a = new ShowInstancesAction(PSSEditorMessages.getResourceBundle(), "ShowInstances.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_INSTANCES);
        this.setAction("ShowInstances", (IAction)a);
        a = new ReferencesInProjectAction(PSSEditorMessages.getResourceBundle(), "Usages.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_PROJECT);
        this.setAction("Usages", (IAction)a);
        a = new ReferencesInWorkingSetAction(PSSEditorMessages.getResourceBundle(), "ReferencesInWorkingSet.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_WORKING_SET);
        this.setAction("ReferencesInWorkingSet", (IAction)a);
        a = new PSSRenameRefactorAction(PSSEditorMessages.getResourceBundle(), "RefactorRename.", this);
        a.setActionDefinitionId(REFACTOR_RENAME);
        this.setAction("RefactorRename", (IAction)a);
        a = new CopyFileInfoAction(PSSEditorMessages.getResourceBundle(), "CopyFullPath.", (ITextEditor)this, CopyFileInfoKind.COPY_FULL_PATH);
        a.setActionDefinitionId(COPY_FULL_PATH);
        this.setAction("CopyFullPath", (IAction)a);
        a = new CopyFileInfoAction(PSSEditorMessages.getResourceBundle(), "CopyFileName.", (ITextEditor)this, CopyFileInfoKind.COPY_FILE_NAME);
        a.setActionDefinitionId(COPY_FILE_NAME);
        this.setAction("CopyFileName", (IAction)a);
    }

    private String getSourceMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(SOURCE_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)PSSEditorMessages.getString("SourceSubmenu.label"), (Object)keyBinding);
    }

    private String getReferencesMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(REFERENCES_SUBMENU_COMMAND_ID);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)PSSEditorMessages.getString("ReferencesSubmenu.label"), (Object)keyBinding);
    }

    private String getRefactorMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(REFACTOR_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)PSSEditorMessages.getString("RefactorSubMenu.label"), (Object)keyBinding);
    }

    protected void addSourceSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "QuickAssist");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "GoToPairBracket");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "FormatSource");
        this.addAction(menu, "ToggleComment");
    }

    protected void addReferencesSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "ReferencesInWorkspace");
        this.addAction(menu, "ReferencesInProject");
        this.addAction(menu, "ReferencesInFile");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "ReferencesInWorkingSet");
    }

    protected void addRefactorSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "RefactorRename");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorAddPort");
        this.addAction(menu, "RefactorAddGeneric");
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        MenuManager submenu = new MenuManager("Edit", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.CUT);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.COPY);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.PASTE);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.UNDO);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.REDO);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "CopyFileName");
        this.addAction((IMenuManager)submenu, "CopyFullPath");
        submenu.add((IContributionItem)new Separator());
        submenu.add((IContributionItem)new EditorEmulationContributionItem(new EditorEmulationAction(false)));
        submenu = new MenuManager("Folding", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "CollapseAllLevels");
        this.addAction((IMenuManager)submenu, "ShowActivePreprocessing");
        this.addAction((IMenuManager)submenu, "ExpandFirstLevel");
        this.addAction((IMenuManager)submenu, "ExpandAllLevels");
        this.addAction((IMenuManager)submenu, "ToggleExpandScope");
        this.addAction((IMenuManager)submenu, "ToggleCollapseLine");
        this.addAction((IMenuManager)submenu, "DefineFoldingRegion");
        submenu = new MenuManager(this.getSourceMenuLabel(), null, null);
        menu.add((IContributionItem)submenu);
        this.addSourceSubmenuItems((IMenuManager)submenu);
        submenu = new MenuManager("Show", null, "ro.amiq.dvt.ui.editor.menu.show");
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "OpenDeclaration");
        submenu.add((IContributionItem)new Separator());
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group1"));
        this.addAction((IMenuManager)submenu, "ShowActivityDiagram");
        this.addAction((IMenuManager)submenu, "ShowScenarioDiagram");
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group2"));
        this.addAction((IMenuManager)submenu, "QuickOutline");
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group3"));
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "ShowInstances");
        this.addAction((IMenuManager)submenu, "Usages");
        menu.add((IContributionItem)new Separator());
        submenu = new MenuManager(this.getReferencesMenuLabel(), null, "ro.amiq.dvt.ui.editor.ReferencesSubMenu");
        menu.add((IContributionItem)submenu);
        this.addReferencesSubmenuItems((IMenuManager)submenu);
        submenu = new MenuManager(this.getRefactorMenuLabel());
        menu.add((IContributionItem)submenu);
        this.addRefactorSubmenuItems((IMenuManager)submenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("ro.amiq.dvt.ui.editor.menu.debug"));
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"ro.amiq.pssdt.pssEditorScope", "ro.amiq.dvt.ui.vlogVhdlEditorScope", "ro.amiq.dvt.ui.trace.connections.actions.context"});
    }

    public void setFocus() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        if (styledText.isFocusControl()) {
            return;
        }
        super.setFocus();
        if (this.fPropertyChangedEvent) {
            sourceViewer.invalidateTextPresentation();
            this.fPropertyChangedEvent = false;
        }
        PSSQuickViewersUtil.getInstance().scheduleReparseIfNonTop((ITextEditor)this);
        this.connectFileToDocument(true);
        this.switchPerspective();
        this.detectIndentation();
    }

    private void switchPerspective() {
        try {
            boolean disableSwitchPerspective = DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.DISABLE_SWITCH_PERSPECTIVE");
            if (disableSwitchPerspective) {
                return;
            }
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IWorkbenchPage activePage = DVTPlugin.getActivePage();
            if (activePage == null) {
                return;
            }
            IPerspectiveDescriptor perspective = activePage.getPerspective();
            if (perspective == null) {
                return;
            }
            if (perspective.getId().equals("ro.amiq.pssdt.ui.perspectives.PSSPerspective")) {
                return;
            }
            if (project.hasNature("ro.amiq.pssdt.pssnature") && (perspective.getId().equals("ro.amiq.pssdt.ui.perspectives.PSSPerspective") || perspective.getId().equals("ro.amiq.edt.ui.perspectives.EDTPerspective"))) {
                PlatformUI.getWorkbench().showPerspective("ro.amiq.pssdt.ui.perspectives.PSSPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void connectFileToDocument(boolean connectPositionsAfterEditorFocus) {
        try {
            IProject project = this.getProject();
            if (project == null) {
                DVTHlUtils.startHighlight(null, (DVTEditor)this, (DVTSemanticHighlighter)new PSSSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)PSSPlugin.getDefault(), (String)"highlight.semantic");
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            IDocument document = this.getDocument();
            if (document == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            if (rfProject != null) {
                rfProject.connectFileToDocument(parserPath, this, connectPositionsAfterEditorFocus);
            } else {
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            }
            DVTHlUtils.startHighlight((IRfFileDef)(rfProject != null ? rfProject.getFileDefUsingParserPath(parserPath) : null), (DVTEditor)this, (DVTSemanticHighlighter)new PSSSemanticHighlighter(document), (AbstractUIPlugin)PSSPlugin.getDefault(), (String)"highlight.semantic");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void disconnectFileFromDocument() {
        try {
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return;
            }
            rfProject.disconnectFileFromDocument(parserPath);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyListeners(int eventType, Event event) {
        this.getSourceViewer().getTextWidget().notifyListeners(eventType, event);
    }

    protected void scheduleReparse(IDocument document, IFile file) {
        IPSSModule module = PSSModelManager.getInstance().getPSSModel().getOrCreatePSSFile(file);
        if (module == null) {
            return;
        }
        boolean shouldIncrementalBuild = DVTFileUtils.getInstance().shouldIncrementalBuild(this.getDocument(), null, this.getProject());
        if (shouldIncrementalBuild) {
            int buildAutoTime = DVTPlugin.getDefault().getPreferenceStore().getInt("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE");
            module.scheduleReparse(false, false, (long)buildAutoTime * 1000L, document, false);
        }
    }

    public DVTWordFinder getWordFinder() {
        return PSSWordFinder.getDefault();
    }

    public ISourceViewer testGetSourceViewer() {
        return this.getSourceViewer();
    }

    public PSSSourceViewerConfiguration testGetSourceViewerConfiguration() {
        return (PSSSourceViewerConfiguration)this.getSourceViewerConfiguration();
    }

    public IHyperlinkDetector testGetRfHyperlinkDetector() {
        IHyperlinkDetector[] detectors = this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
        int i = 0;
        while (i < detectors.length) {
            if (detectors[i] instanceof RfHyperlinkDetector) {
                return detectors[i];
            }
            ++i;
        }
        return null;
    }

    public IHyperlinkDetector[] testGetAllHyperlinkDetectors() {
        return this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
    }

    public int testGetCurrentLine() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText styledText = sourceViewer.getTextWidget();
        return styledText.getLineAtOffset(styledText.getCaretOffset());
    }

    public TextEditorAction testGetReferencesInWorkspaceAction() {
        return new ReferencesInWorkspaceAction(PSSEditorMessages.getResourceBundle(), "ReferencesInWorkspace.", (ITextEditor)this);
    }

    public TextEditorAction testGetReferencesInFileAction() {
        return new ReferencesInFileAction(PSSEditorMessages.getResourceBundle(), "ReferencesInFile.", (ITextEditor)this);
    }

    public IRfNamedElementAndScope testGetNamedElementAndScopeAtPosition(int line, int column) {
        IDocument document;
        block3: {
            try {
                document = this.getDocument();
                if (document != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        int offset = document.getLineOffset(line) + column;
        return RfUtils.getRfElement((ITextEditor)this, document, offset);
    }

    protected boolean c() {
        return DVTPlugin.getDefault().collect().c(this.getProject(), "F707373");
    }

    public IRfScopeElement getCursorScope() {
        return null;
    }

    public IRfNamedElement getCursorScopeForBreadcrumb(boolean overrideCache) {
        IRfBreadcrumbElement scopeForBreadcrumb = ((ScopeBreadcrumbUtils)this.getBreadcrumbUtils(ScopeBreadcrumbViewer.class)).getScopeForBreadcrumb((ITextEditor)this, this.getCursor(), overrideCache);
        if (scopeForBreadcrumb instanceof RfDefElement) {
            return ((RfDefElement)scopeForBreadcrumb).getNamedElement();
        }
        return (IRfNamedElement)scopeForBreadcrumb;
    }

    public IRfNamedElementAndScope getCursorElement() {
        return this.getCursorElementNonUi(this.getCursor());
    }

    public IRfNamedElementAndScope getCursorElementNonUi(int cursor) {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement((ITextEditor)this, this.getDocument(), cursor);
        return namedElementAndScope;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    protected IPreferenceStore getPluginSpecificPreferenceStore() {
        return PSSPlugin.getDefault().getPreferenceStore();
    }

    public IBaseShowConstraintsAction testGetShowConstraintsAction() {
        return null;
    }

    public IBaseShowEmittersAction testGetShowEmittersAction() {
        return null;
    }

    public DVTSourceViewerConfiguration makeSourceViewerConfiguration() {
        return new PSSSourceViewerConfiguration(null);
    }

    public void showContentAssistProposalsForCreatedFile() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((PSSSourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            ((PSSSourceViewerConfiguration)this.getSourceViewerConfiguration()).getSourceProcessorManager().showContentAssistPage(IDVTContentAssistConstants.ContentAssistProposalsPage.TEMPLATES.getCode());
            contAss.showPossibleCompletions();
        });
    }

    public boolean isHoverDisabled() {
        return PSSPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_tool_tips");
    }

    public void installSubmenuActions() {
        this.fHandlerService = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            IHandler handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    PSSEditor.this.addSourceSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(SOURCE_SUBMENU, this.fHandlerService.activateHandler(SOURCE_SUBMENU, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    PSSEditor.this.addReferencesSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(REFERENCES_SUBMENU_COMMAND_ID, this.fHandlerService.activateHandler(REFERENCES_SUBMENU_COMMAND_ID, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    PSSEditor.this.addRefactorSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(REFACTOR_SUBMENU, this.fHandlerService.activateHandler(REFACTOR_SUBMENU, handler));
        }
    }

    public AbstractBreadcrumbUtils getBreadcrumbUtils(Class<?> breadcrumbType) {
        if (breadcrumbType == ScopeBreadcrumbViewer.class) {
            return PSSScopeBreadcrumbUtils.getInstance();
        }
        if (breadcrumbType == FSBreadcrumbViewer.class) {
            return FSBreadcrumbUtils.getInstance();
        }
        return null;
    }

    public String getEditorID() {
        return ID;
    }

    public IBaseShowInstancesAction testGetShowInstancesAction() {
        return new ShowInstancesAction(PSSEditorMessages.getResourceBundle(), "ShowInstances.", (ITextEditor)this);
    }

    public void recomputeHighlightPositionsAndInvalidateEditor() {
        try {
            IProject project = this.getProject();
            if (project == null) {
                DVTHlUtils.startHighlight(null, (DVTEditor)this, (DVTSemanticHighlighter)new PSSSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)PSSPlugin.getDefault(), (String)"highlight.semantic");
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            DVTHlUtils.startHighlight((IRfFileDef)rfProject.getFileDefUsingParserPath(parserPath), (DVTEditor)this, (DVTSemanticHighlighter)new PSSSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)PSSPlugin.getDefault(), (String)"highlight.semantic");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getCodePartition() {
        return "__pss_partitioning";
    }

    public QuickLazyOutlineView createQuickOutlineView() {
        return new PSSQuickLazyOutlineView(this);
    }

    public DVTLazyOutlinePage getOutlinePage() {
        return this.fOutlinePage;
    }
}

